/*
 * Decompiled with CFR 0.152.
 */
package org.apache.impala.catalog;

import com.google.common.base.Preconditions;
import java.util.Map;
import org.apache.hadoop.hive.metastore.api.StorageDescriptor;
import org.apache.impala.analysis.StringLiteral;
import org.apache.impala.thrift.TTableRowFormat;

public class RowFormat {
    public static final RowFormat DEFAULT_ROW_FORMAT = new RowFormat(null, null, null);
    private final String fieldDelimiter_;
    private final String lineDelimiter_;
    private final String escapeChar_;

    private RowFormat(String fieldDelimiter, String lineDelimiter, String escapeChar, boolean unescape) {
        if (unescape) {
            this.fieldDelimiter_ = RowFormat.getUnescapedValueOrNull(fieldDelimiter);
            this.lineDelimiter_ = RowFormat.getUnescapedValueOrNull(lineDelimiter);
            this.escapeChar_ = RowFormat.getUnescapedValueOrNull(escapeChar);
        } else {
            this.fieldDelimiter_ = fieldDelimiter;
            this.lineDelimiter_ = lineDelimiter;
            this.escapeChar_ = escapeChar;
        }
    }

    public RowFormat(String fieldDelimiter, String lineDelimiter, String escapeChar) {
        this(fieldDelimiter, lineDelimiter, escapeChar, true);
    }

    public String getFieldDelimiter() {
        return this.fieldDelimiter_;
    }

    public String getLineDelimiter() {
        return this.lineDelimiter_;
    }

    public String getEscapeChar() {
        return this.escapeChar_;
    }

    public boolean isDefault() {
        return this.fieldDelimiter_ == null && this.lineDelimiter_ == null && this.escapeChar_ == null;
    }

    private static String getUnescapedValueOrNull(String value) {
        return value == null ? null : new StringLiteral(value).getUnescapedValue();
    }

    public TTableRowFormat toThrift() {
        TTableRowFormat tableRowFormat = new TTableRowFormat();
        tableRowFormat.setField_terminator(this.getFieldDelimiter());
        tableRowFormat.setLine_terminator(this.getLineDelimiter());
        tableRowFormat.setEscaped_by(this.getEscapeChar());
        return tableRowFormat;
    }

    public static RowFormat fromThrift(TTableRowFormat tableRowFormat) {
        if (tableRowFormat == null) {
            return DEFAULT_ROW_FORMAT;
        }
        return new RowFormat(tableRowFormat.getField_terminator(), tableRowFormat.getLine_terminator(), tableRowFormat.getEscaped_by(), false);
    }

    public static RowFormat fromStorageDescriptor(StorageDescriptor sd) {
        Preconditions.checkNotNull((Object)sd);
        Map params = sd.getSerdeInfo().getParameters();
        return new RowFormat((String)params.get("field.delim"), (String)params.get("line.delim"), (String)params.get("escape.delim"));
    }
}

