/*
 * Decompiled with CFR 0.152.
 */
package org.apache.impala.catalog;

import com.google.common.base.Preconditions;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.impala.catalog.PrincipalPrivilege;
import org.apache.impala.thrift.TPrivilege;
import org.apache.impala.thrift.TPrivilegeScope;

public class PrincipalPrivilegeTree {
    Node<PrincipalPrivilege> tableRoot_ = new Node();
    Node<PrincipalPrivilege> uriRoot_ = new Node();
    Node<PrincipalPrivilege> serverRoot_ = new Node();

    public void add(PrincipalPrivilege privilege) {
        TPrivilege priv = privilege.toThrift();
        List<String> path = PrincipalPrivilegeTree.toPath(priv);
        Node<PrincipalPrivilege> root = this.getRootForScope(priv.getScope());
        root.add(privilege.getName(), privilege, path);
    }

    public void remove(PrincipalPrivilege privilege) {
        TPrivilege priv = privilege.toThrift();
        List<String> path = PrincipalPrivilegeTree.toPath(priv);
        Node<PrincipalPrivilege> root = this.getRootForScope(priv.getScope());
        root.remove(privilege.getName(), privilege, path);
    }

    public List<PrincipalPrivilege> getFilteredList(Filter filter) {
        List path = filter.toPath();
        ArrayList<PrincipalPrivilege> results = new ArrayList<PrincipalPrivilege>();
        ArrayList<Node<PrincipalPrivilege>> roots = new ArrayList<Node<PrincipalPrivilege>>();
        roots.add(this.serverRoot_);
        if (filter.isUri_ || path.size() == 1) {
            roots.add(this.uriRoot_);
        }
        if (!filter.isUri_) {
            roots.add(this.tableRoot_);
        }
        for (Node node : roots) {
            node.getAllMatchingValues(results, path);
        }
        return results;
    }

    private Node<PrincipalPrivilege> getRootForScope(TPrivilegeScope scope) {
        switch (scope) {
            case URI: {
                return this.uriRoot_;
            }
            case SERVER: {
                return this.serverRoot_;
            }
        }
        return this.tableRoot_;
    }

    private static List<String> toPath(TPrivilege priv) {
        ArrayList<String> path = new ArrayList<String>();
        String server = priv.getServer_name();
        String db = priv.getDb_name();
        String table = priv.getTable_name();
        if (server == null) {
            return path;
        }
        path.add(server.toLowerCase());
        if (db == null) {
            return path;
        }
        path.add(db.toLowerCase());
        if (table != null) {
            path.add(table.toLowerCase());
        }
        return path;
    }

    private static class Node<T> {
        Map<String, T> values_ = null;
        Map<String, Node<T>> children_ = null;

        private Node() {
        }

        boolean isEmpty() {
            return this.values_ == null && this.children_ == null;
        }

        public void add(String key, T value, List<String> path) {
            this.add(key, value, path, 0);
        }

        public void remove(String key, T value, List<String> path) {
            this.remove(key, value, path, 0);
        }

        public void getAllMatchingValues(List<T> results, List<String> path) {
            this.getAllMatchingValues(results, path, 0);
        }

        public void getAllValues(List<T> results) {
            if (this.values_ != null) {
                results.addAll(this.values_.values());
            }
            if (this.children_ != null) {
                for (Map.Entry<String, Node<T>> entry : this.children_.entrySet()) {
                    entry.getValue().getAllValues(results);
                }
            }
        }

        private void add(String key, T value, List<String> path, int depth) {
            if (path.size() <= depth) {
                if (this.values_ == null) {
                    this.values_ = new HashMap<String, T>(1);
                }
                this.values_.put(key, value);
            } else {
                if (this.children_ == null) {
                    this.children_ = new HashMap<String, Node<T>>();
                }
                String child_name = path.get(depth);
                Node next = this.children_.computeIfAbsent(child_name, k -> new Node());
                next.add(key, value, path, depth + 1);
            }
        }

        private void remove(String key, T value, List<String> path, int depth) {
            if (path.size() <= depth) {
                Preconditions.checkNotNull(this.values_);
                T found = this.values_.remove(key);
                Preconditions.checkNotNull(found);
                if (this.values_.isEmpty()) {
                    this.values_ = null;
                }
            } else {
                Preconditions.checkNotNull(this.children_);
                String child_name = path.get(depth);
                Node<T> next = this.children_.get(child_name);
                Preconditions.checkNotNull(next);
                super.remove(key, value, path, depth + 1);
                if (next.isEmpty()) {
                    this.children_.remove(child_name);
                }
                if (this.children_.isEmpty()) {
                    this.children_ = null;
                }
            }
        }

        private void getAllMatchingValues(List<T> results, List<String> path, int depth) {
            if (path.size() <= depth) {
                this.getAllValues(results);
                return;
            }
            if (this.values_ != null) {
                results.addAll(this.values_.values());
            }
            if (this.children_ == null) {
                return;
            }
            String child_name = path.get(depth);
            Preconditions.checkNotNull((Object)child_name);
            Node<T> next = this.children_.get(child_name);
            if (next != null) {
                super.getAllMatchingValues(results, path, depth + 1);
            }
        }
    }

    public static class Filter {
        String server_;
        String db_;
        String table_;
        boolean isUri_ = false;

        public void setServer(String server) {
            this.server_ = server;
        }

        public void setDb(String db) {
            this.db_ = db;
        }

        public void setTable(String table) {
            this.table_ = table;
        }

        public void setIsUri(boolean isUri) {
            this.isUri_ = isUri;
        }

        private List<String> toPath() {
            ArrayList<String> path = new ArrayList<String>();
            if (this.server_ == null) {
                return path;
            }
            path.add(this.server_);
            if (this.db_ == null) {
                return path;
            }
            Preconditions.checkState((!this.isUri_ ? 1 : 0) != 0);
            path.add(this.db_);
            if (this.table_ != null) {
                path.add(this.table_);
            }
            return path;
        }
    }
}

