/*
 * Decompiled with CFR 0.152.
 */
package org.apache.impala.catalog;

import com.google.common.base.Preconditions;
import org.apache.impala.authorization.AuthorizationPolicy;
import org.apache.impala.catalog.CatalogObjectImpl;
import org.apache.impala.thrift.TCatalogObject;
import org.apache.impala.thrift.TCatalogObjectType;
import org.apache.impala.thrift.TPrincipalType;
import org.apache.impala.thrift.TPrivilege;
import org.apache.impala.thrift.TPrivilegeLevel;
import org.apache.impala.thrift.TPrivilegeScope;
import org.apache.log4j.Logger;

public class PrincipalPrivilege
extends CatalogObjectImpl {
    private static final Logger LOG = Logger.getLogger(AuthorizationPolicy.class);
    private static final String AUTHORIZABLE_SEPARATOR = "->";
    private static final String KV_SEPARATOR = "=";
    private final TPrivilege privilege_;
    private final String name_;

    private PrincipalPrivilege(TPrivilege privilege) {
        this.privilege_ = (TPrivilege)Preconditions.checkNotNull((Object)privilege);
        this.name_ = PrincipalPrivilege.buildPrivilegeName(this.privilege_);
    }

    public TPrivilege toThrift() {
        return this.privilege_;
    }

    public static PrincipalPrivilege fromThrift(TPrivilege privilege) {
        return new PrincipalPrivilege(privilege);
    }

    public static String buildPrivilegeName(TPrivilege privilege) {
        StringBuilder privilegeName = new StringBuilder();
        Preconditions.checkNotNull((Object)privilege);
        TPrivilegeScope scope = privilege.getScope();
        Preconditions.checkNotNull((Object)((Object)scope));
        switch (scope) {
            case SERVER: {
                privilegeName.append("server").append(KV_SEPARATOR).append(privilege.getServer_name().toLowerCase());
                break;
            }
            case URI: {
                privilegeName.append("server").append(KV_SEPARATOR).append(privilege.getServer_name().toLowerCase());
                privilegeName.append(AUTHORIZABLE_SEPARATOR);
                privilegeName.append("uri").append(KV_SEPARATOR).append(privilege.getUri());
                break;
            }
            case DATABASE: {
                privilegeName.append("server").append(KV_SEPARATOR).append(privilege.getServer_name().toLowerCase());
                privilegeName.append(AUTHORIZABLE_SEPARATOR);
                privilegeName.append("db").append(KV_SEPARATOR).append(privilege.getDb_name().toLowerCase());
                break;
            }
            case TABLE: {
                privilegeName.append("server").append(KV_SEPARATOR).append(privilege.getServer_name().toLowerCase());
                privilegeName.append(AUTHORIZABLE_SEPARATOR);
                privilegeName.append("db").append(KV_SEPARATOR).append(privilege.getDb_name().toLowerCase());
                privilegeName.append(AUTHORIZABLE_SEPARATOR);
                privilegeName.append("table").append(KV_SEPARATOR).append(privilege.getTable_name().toLowerCase());
                break;
            }
            case COLUMN: {
                privilegeName.append("server").append(KV_SEPARATOR).append(privilege.getServer_name().toLowerCase());
                privilegeName.append(AUTHORIZABLE_SEPARATOR);
                privilegeName.append("db").append(KV_SEPARATOR).append(privilege.getDb_name().toLowerCase());
                privilegeName.append(AUTHORIZABLE_SEPARATOR);
                privilegeName.append("table").append(KV_SEPARATOR).append(privilege.getTable_name().toLowerCase());
                privilegeName.append(AUTHORIZABLE_SEPARATOR);
                privilegeName.append("column").append(KV_SEPARATOR).append(privilege.getColumn_name().toLowerCase());
                break;
            }
            default: {
                throw new UnsupportedOperationException("Unknown privilege scope: " + scope.toString());
            }
        }
        if (privilege.getPrivilege_level() != TPrivilegeLevel.ALL) {
            privilegeName.append(AUTHORIZABLE_SEPARATOR);
            privilegeName.append("action").append(KV_SEPARATOR).append(privilege.getPrivilege_level().toString().toLowerCase());
        }
        privilegeName.append(AUTHORIZABLE_SEPARATOR);
        privilegeName.append("grantoption").append(KV_SEPARATOR).append(privilege.isHas_grant_opt());
        return privilegeName.toString();
    }

    public static TPrivilege copyPrivilegeWithGrant(TPrivilege privilege, boolean hasGrantOption) {
        TPrivilege copy = privilege.deepCopy();
        return copy.setHas_grant_opt(hasGrantOption);
    }

    @Override
    public TCatalogObjectType getCatalogObjectType() {
        return TCatalogObjectType.PRIVILEGE;
    }

    @Override
    public String getName() {
        return this.name_;
    }

    public int getPrincipalId() {
        return this.privilege_.getPrincipal_id();
    }

    public TPrincipalType getPrincipalType() {
        return this.privilege_.getPrincipal_type();
    }

    @Override
    protected void setTCatalogObject(TCatalogObject catalogObject) {
        catalogObject.setPrivilege(this.toThrift());
    }

    public long getCreateTimeMs() {
        return this.privilege_.isSetCreate_time_ms() ? this.privilege_.getCreate_time_ms() : -1L;
    }
}

