/*
 * Decompiled with CFR 0.152.
 */
package org.apache.impala.catalog;

import com.google.common.base.Preconditions;
import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import org.apache.impala.catalog.CatalogObjectCache;
import org.apache.impala.catalog.CatalogObjectImpl;
import org.apache.impala.catalog.PrincipalPrivilege;
import org.apache.impala.catalog.PrincipalPrivilegeTree;
import org.apache.impala.catalog.Role;
import org.apache.impala.catalog.User;
import org.apache.impala.thrift.TCatalogObject;
import org.apache.impala.thrift.TCatalogObjectType;
import org.apache.impala.thrift.TPrincipal;
import org.apache.impala.thrift.TPrincipalType;

public abstract class Principal
extends CatalogObjectImpl {
    private final TPrincipal principal_;
    private static AtomicInteger principalId_ = new AtomicInteger(0);
    private final CatalogObjectCache<PrincipalPrivilege> principalPrivileges_ = new CatalogObjectCache(false);
    private final PrincipalPrivilegeTree privilegeTree_ = new PrincipalPrivilegeTree();
    private final ReentrantReadWriteLock rwLock_ = new ReentrantReadWriteLock(true);

    protected Principal(String principalName, TPrincipalType type, Set<String> grantGroups) {
        this.principal_ = new TPrincipal();
        this.principal_.setPrincipal_name(principalName);
        this.principal_.setPrincipal_type(type);
        this.principal_.setPrincipal_id(principalId_.incrementAndGet());
        this.principal_.setGrant_groups(Lists.newArrayList(grantGroups));
    }

    protected Principal(TPrincipal principal) {
        this.principal_ = principal;
    }

    public boolean addPrivilege(PrincipalPrivilege privilege) {
        try {
            this.rwLock_.writeLock().lock();
            if (!this.principalPrivileges_.add(privilege)) {
                boolean bl = false;
                return bl;
            }
            this.privilegeTree_.add(privilege);
        }
        finally {
            this.rwLock_.writeLock().unlock();
        }
        return true;
    }

    public List<PrincipalPrivilege> getPrivileges() {
        return new ArrayList<PrincipalPrivilege>(this.principalPrivileges_.getValues());
    }

    public Set<String> getPrivilegeNames() {
        return new HashSet<String>(this.principalPrivileges_.keySet());
    }

    public Set<String> getFilteredPrivilegeNames(PrincipalPrivilegeTree.Filter filter) {
        List<PrincipalPrivilege> privileges;
        if (filter == null) {
            return this.getPrivilegeNames();
        }
        try {
            this.rwLock_.readLock().lock();
            privileges = this.privilegeTree_.getFilteredList(filter);
        }
        finally {
            this.rwLock_.readLock().unlock();
        }
        HashSet<String> results = new HashSet<String>();
        for (PrincipalPrivilege priv : privileges) {
            results.add(priv.getName());
        }
        return results;
    }

    public PrincipalPrivilege getPrivilege(String privilegeName) {
        return this.principalPrivileges_.get(privilegeName);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public PrincipalPrivilege removePrivilege(String privilegeName) {
        try {
            this.rwLock_.writeLock().lock();
            PrincipalPrivilege privilege = this.principalPrivileges_.remove(privilegeName);
            if (privilege != null) {
                this.privilegeTree_.remove(privilege);
            }
            PrincipalPrivilege principalPrivilege = privilege;
            return principalPrivilege;
        }
        finally {
            this.rwLock_.writeLock().unlock();
        }
    }

    public synchronized void addGrantGroup(String groupName) {
        if (this.principal_.getGrant_groups().contains(groupName)) {
            return;
        }
        this.principal_.addToGrant_groups(groupName);
    }

    public synchronized void removeGrantGroup(String groupName) {
        this.principal_.getGrant_groups().remove(groupName);
        Preconditions.checkState((!this.principal_.getGrant_groups().contains(groupName) ? 1 : 0) != 0);
    }

    public TPrincipal toThrift() {
        return this.principal_;
    }

    public static Principal fromThrift(TPrincipal thriftPrincipal) {
        return thriftPrincipal.getPrincipal_type() == TPrincipalType.ROLE ? new Role(thriftPrincipal) : new User(thriftPrincipal);
    }

    public static Principal newInstance(String principalName, TPrincipalType type, Set<String> grantGroups) {
        return type == TPrincipalType.ROLE ? new Role(principalName, grantGroups) : new User(principalName, grantGroups);
    }

    public Set<String> getGrantGroups() {
        return Sets.newHashSet(this.principal_.getGrant_groups());
    }

    @Override
    public TCatalogObjectType getCatalogObjectType() {
        return TCatalogObjectType.PRINCIPAL;
    }

    @Override
    public String getName() {
        return this.principal_.getPrincipal_name();
    }

    public int getId() {
        return this.principal_.getPrincipal_id();
    }

    @Override
    protected void setTCatalogObject(TCatalogObject catalogObject) {
        catalogObject.setPrincipal(this.toThrift());
    }

    public TPrincipalType getPrincipalType() {
        return this.principal_.getPrincipal_type();
    }

    public static String toString(TPrincipalType type) {
        String principal;
        switch (type) {
            case ROLE: {
                principal = "Role";
                break;
            }
            case USER: {
                principal = "User";
                break;
            }
            case GROUP: {
                principal = "Group";
                break;
            }
            default: {
                throw new IllegalStateException(String.format("Unsupported principal type %s.", new Object[]{type}));
            }
        }
        return principal;
    }
}

