/*
 * Decompiled with CFR 0.152.
 */
package org.apache.impala.catalog;

import com.google.common.base.Preconditions;
import java.util.ArrayList;
import java.util.Base64;
import java.util.List;
import java.util.Map;
import org.apache.impala.catalog.FeFsPartition;
import org.apache.impala.catalog.HdfsPartition;
import org.apache.impala.common.ImpalaException;
import org.apache.impala.common.ImpalaRuntimeException;
import org.apache.impala.common.JniUtil;
import org.apache.impala.common.Reference;
import org.apache.impala.thrift.TPartitionStats;
import org.apache.impala.util.CompressionUtil;
import org.apache.thrift.TBase;
import org.apache.thrift.TException;
import org.apache.thrift.TSerializer;
import org.apache.thrift.protocol.TCompactProtocol;
import org.apache.thrift.protocol.TProtocolFactory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PartitionStatsUtil {
    public static final String INCREMENTAL_STATS_NUM_CHUNKS = "impala_intermediate_stats_num_chunks";
    public static final String INCREMENTAL_STATS_CHUNK_PREFIX = "impala_intermediate_stats_chunk";
    private static final Logger LOG = LoggerFactory.getLogger(PartitionStatsUtil.class);

    public static TPartitionStats partStatsFromCompressedBytes(byte[] compressedStats, FeFsPartition part) throws ImpalaException {
        if (compressedStats == null) {
            return null;
        }
        TCompactProtocol.Factory protocolFactory = new TCompactProtocol.Factory();
        TPartitionStats ret = new TPartitionStats();
        byte[] decompressed = CompressionUtil.deflateDecompress(compressedStats);
        if (decompressed == null) {
            String partitionName = part == null ? "N/A" : part.getPartitionName();
            LOG.warn("Error decompressing partition stats for partition: " + partitionName);
            return null;
        }
        JniUtil.deserializeThrift(protocolFactory, ret, decompressed);
        return ret;
    }

    public static TPartitionStats getPartStatsOrWarn(FeFsPartition part) {
        try {
            byte[] compressedStats = part.getPartitionStatsCompressed();
            return PartitionStatsUtil.partStatsFromCompressedBytes(compressedStats, part);
        }
        catch (ImpalaException e) {
            LOG.warn("Bad partition stats for " + part.getPartitionName(), (Throwable)e);
            return null;
        }
    }

    public static byte[] partStatsBytesFromParameters(Map<String, String> hmsParameters, Reference<Boolean> hasIncrStats) throws ImpalaException {
        if (hmsParameters == null) {
            return null;
        }
        String numChunksStr = hmsParameters.get(INCREMENTAL_STATS_NUM_CHUNKS);
        if (numChunksStr == null) {
            return null;
        }
        int numChunks = Integer.parseInt(numChunksStr);
        if (numChunks == 0) {
            return null;
        }
        Preconditions.checkState((numChunks >= 0 ? 1 : 0) != 0);
        StringBuilder encodedStats = new StringBuilder();
        for (int i = 0; i < numChunks; ++i) {
            String chunk = hmsParameters.get(INCREMENTAL_STATS_CHUNK_PREFIX + i);
            if (chunk == null) {
                throw new ImpalaRuntimeException("Missing stats chunk: " + i);
            }
            encodedStats.append(chunk);
        }
        byte[] decodedBytes = Base64.getDecoder().decode(encodedStats.toString());
        TPartitionStats stats = new TPartitionStats();
        JniUtil.deserializeThrift(new TCompactProtocol.Factory(), stats, decodedBytes);
        hasIncrStats.setRef(stats.isSetIntermediate_col_stats());
        return CompressionUtil.deflateCompress(decodedBytes);
    }

    public static byte[] partStatsToCompressedBytes(TPartitionStats stats) throws TException {
        if (stats == null) {
            return null;
        }
        TCompactProtocol.Factory protocolFactory = new TCompactProtocol.Factory();
        TSerializer serializer = new TSerializer((TProtocolFactory)protocolFactory);
        byte[] serialized = CompressionUtil.deflateCompress(serializer.serialize((TBase)stats));
        return serialized;
    }

    public static void partStatsToPartition(TPartitionStats partStats, HdfsPartition.Builder partition) throws ImpalaException {
        if (partStats == null) {
            partition.setPartitionStatsBytes(null, false);
            return;
        }
        try {
            partition.setPartitionStatsBytes(PartitionStatsUtil.partStatsToCompressedBytes(partStats), partStats.isSetIntermediate_col_stats());
        }
        catch (TException e) {
            String debugString = String.format("Error saving partition stats: table %s, partition %s", partition.getTable().getFullName(), partition.getPartitionName());
            LOG.error(debugString, (Throwable)e);
            throw new ImpalaRuntimeException(debugString, e);
        }
    }

    public static void partStatsToParams(HdfsPartition partition, Map<String, String> params) {
        byte[] compressedStats = partition.getPartitionStatsCompressed();
        if (compressedStats == null) {
            return;
        }
        byte[] decompressed = CompressionUtil.deflateDecompress(compressedStats);
        if (decompressed == null) {
            LOG.error("Error decompressing partition stats for " + partition.getPartitionName());
            return;
        }
        String base64 = new String(Base64.getEncoder().encode(decompressed));
        List<String> chunks = PartitionStatsUtil.chunkStringForHms(base64, 4000);
        params.put(INCREMENTAL_STATS_NUM_CHUNKS, Integer.toString(chunks.size()));
        for (int i = 0; i < chunks.size(); ++i) {
            params.put(INCREMENTAL_STATS_CHUNK_PREFIX + i, chunks.get(i));
        }
    }

    private static List<String> chunkStringForHms(String data, int chunkLen) {
        int chunkSize;
        ArrayList<String> ret = new ArrayList<String>();
        for (int idx = 0; idx < data.length(); idx += chunkSize) {
            int remaining = data.length() - idx;
            chunkSize = chunkLen > remaining ? remaining : chunkLen;
            ret.add(data.substring(idx, idx + chunkSize));
        }
        return ret;
    }
}

