/*
 * Decompiled with CFR 0.152.
 */
package org.apache.impala.catalog;

import com.google.common.collect.Iterables;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;
import org.apache.impala.service.BackendConfig;

public class PartitionMetaSummary {
    private static final String ORIGINAL_SIZE_METRIC = "original-size";
    private static final String ACTUAL_SIZE_METRIC = "actual-size";
    private static final String V1 = "v1";
    private static final String V2 = "v2";
    private final boolean inCatalogd_;
    private final String fullTableName_;
    private final boolean hasV1Updates_;
    private final boolean hasV2Updates_;
    private int numUpdatedParts_;
    private int numDeletedParts_;
    private final String[] updatedPartNames_ = new String[3];
    private final String[] deletedPartNames_ = new String[3];
    private final Set<Long> updateVersions_ = new TreeSet<Long>();
    private final Set<Long> deleteVersions_ = new TreeSet<Long>();
    private final Map<String, Map<String, Metrics>> updateMetrics_ = new HashMap<String, Map<String, Metrics>>();
    private final Map<String, Map<String, Metrics>> deleteMetrics_ = new HashMap<String, Map<String, Metrics>>();

    public PartitionMetaSummary(String fullTableName, boolean inCatalogd, boolean hasV1Updates, boolean hasV2Updates) {
        this.fullTableName_ = fullTableName;
        this.inCatalogd_ = inCatalogd;
        this.hasV1Updates_ = hasV1Updates;
        this.hasV2Updates_ = hasV2Updates;
        this.updateMetrics_.put(V1, this.newMetrics());
        this.updateMetrics_.put(V2, this.newMetrics());
        this.deleteMetrics_.put(V1, this.newMetrics());
        this.deleteMetrics_.put(V2, this.newMetrics());
    }

    private Map<String, Metrics> newMetrics() {
        HashMap<String, Metrics> res = new HashMap<String, Metrics>();
        res.put(ORIGINAL_SIZE_METRIC, new Metrics());
        res.put(ACTUAL_SIZE_METRIC, new Metrics());
        return res;
    }

    public void update(boolean isV1Key, boolean delete, String partName, long version, int originalSize, int actualSize) {
        String[] partNames;
        boolean isFirst;
        if (delete) {
            this.deleteVersions_.add(version);
        } else {
            this.updateVersions_.add(version);
        }
        Map<String, Metrics> metrics = delete ? this.deleteMetrics_.get(isV1Key ? V1 : V2) : this.updateMetrics_.get(isV1Key ? V1 : V2);
        metrics.get(ORIGINAL_SIZE_METRIC).update(originalSize);
        metrics.get(ACTUAL_SIZE_METRIC).update(actualSize);
        if (!isV1Key && this.hasV1Updates_) {
            return;
        }
        if (delete) {
            isFirst = this.numDeletedParts_ == 0;
            ++this.numDeletedParts_;
            partNames = this.deletedPartNames_;
        } else {
            isFirst = this.numUpdatedParts_ == 0;
            ++this.numUpdatedParts_;
            partNames = this.updatedPartNames_;
        }
        if (isFirst) {
            partNames[0] = partName;
            partNames[1] = null;
            partNames[2] = partName;
        } else {
            if (partName.compareTo(partNames[0]) < 0) {
                partNames[1] = partNames[0];
                partNames[0] = partName;
            } else if (partNames[1] == null || partName.compareTo(partNames[1]) < 0) {
                partNames[1] = partName;
            }
            if (partNames[2].compareTo(partName) < 0) {
                partNames[2] = partName;
            }
        }
    }

    private void appendSummary(String mode, boolean isDelete, StringBuilder res) {
        Set<Long> versions;
        Map<String, Metrics> metrics;
        String[] partNames;
        int numParts;
        if (isDelete) {
            numParts = this.numDeletedParts_;
            partNames = this.deletedPartNames_;
            metrics = this.deleteMetrics_.get(mode);
            versions = this.deleteVersions_;
        } else {
            numParts = this.numUpdatedParts_;
            partNames = this.updatedPartNames_;
            metrics = this.updateMetrics_.get(mode);
            versions = this.updateVersions_;
        }
        if (numParts == 0) {
            return;
        }
        if (res.length() > 0) {
            res.append("\n");
        }
        if (this.inCatalogd_) {
            res.append(String.format("Collected %d partition %s(s): ", numParts, isDelete ? "deletion" : "update"));
            res.append(V1.equals(mode) ? "1:" : "2:");
        } else {
            res.append(isDelete ? "Deleting " : "Adding ").append(numParts).append(" partition(s): ");
        }
        res.append("HDFS_PARTITION:").append(this.fullTableName_).append(":");
        if (numParts > 1) {
            res.append("(");
        }
        res.append(partNames[0]);
        if (numParts > 1) {
            res.append(",").append(partNames[1]);
        }
        if (numParts > 3) {
            res.append(",...");
        }
        if (numParts > 2) {
            res.append(",").append(partNames[2]);
        }
        if (numParts > 1) {
            res.append(")");
        }
        if (versions.size() == 1) {
            res.append(", version=").append(Iterables.getOnlyElement(versions));
        } else {
            res.append(", versions=").append(versions);
        }
        res.append(this.inCatalogd_ ? ", original size=" : ", size=").append(metrics.get(ORIGINAL_SIZE_METRIC));
        if (this.inCatalogd_ && BackendConfig.INSTANCE.isCompactCatalogTopic()) {
            res.append(", compressed size=").append(metrics.get(ACTUAL_SIZE_METRIC));
        }
    }

    public boolean hasUpdates() {
        return this.numUpdatedParts_ > 0 || this.numDeletedParts_ > 0;
    }

    public String toString() {
        StringBuilder res = new StringBuilder();
        if (this.hasV1Updates_) {
            this.appendSummary(V1, false, res);
        }
        if (this.hasV2Updates_) {
            this.appendSummary(V2, false, res);
        }
        if (this.hasV1Updates_) {
            this.appendSummary(V1, true, res);
        }
        if (this.hasV2Updates_) {
            this.appendSummary(V2, true, res);
        }
        return res.toString();
    }

    static class Metrics {
        private long min;
        private long max;
        private long sum;
        private long count;

        Metrics() {
        }

        public void update(int value) {
            if (this.count == 0L) {
                this.max = this.sum = (long)value;
                this.min = this.sum;
            } else {
                this.sum += (long)value;
                this.max = Math.max(this.max, (long)value);
                this.min = Math.min(this.min, (long)value);
            }
            ++this.count;
        }

        public long getMean() {
            return (long)((double)this.sum * 1.0 / (double)this.count);
        }

        public long getMin() {
            return this.min;
        }

        public long getMax() {
            return this.max;
        }

        public long getSum() {
            return this.sum;
        }

        public long getCount() {
            return this.count;
        }

        public String toString() {
            if (this.count == 0L) {
                return "";
            }
            if (this.count == 1L) {
                return Long.toString(this.sum);
            }
            return String.format("(avg=%d, min=%d, max=%d, sum=%d)", this.getMean(), this.min, this.max, this.sum);
        }
    }
}

