/*
 * Decompiled with CFR 0.152.
 */
package org.apache.impala.catalog;

import com.google.common.base.Preconditions;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import org.apache.hadoop.hive.metastore.IMetaStoreClient;
import org.apache.hadoop.hive.metastore.api.Table;
import org.apache.impala.analysis.QueryStmt;
import org.apache.impala.analysis.TableName;
import org.apache.impala.authorization.AuthorizationChecker;
import org.apache.impala.authorization.TableMask;
import org.apache.impala.authorization.User;
import org.apache.impala.catalog.Column;
import org.apache.impala.catalog.Db;
import org.apache.impala.catalog.FeCatalog;
import org.apache.impala.catalog.FeDb;
import org.apache.impala.catalog.FeTable;
import org.apache.impala.catalog.HdfsTable;
import org.apache.impala.catalog.TableLoadingException;
import org.apache.impala.catalog.View;
import org.apache.impala.common.InternalException;
import org.apache.impala.thrift.TTable;
import org.apache.impala.util.EventSequence;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MaterializedViewHdfsTable
extends HdfsTable {
    private static final Logger LOG = LoggerFactory.getLogger(MaterializedViewHdfsTable.class);
    private QueryStmt queryStmt_;
    private List<TableName> srcTblNames_ = new ArrayList<TableName>();

    public MaterializedViewHdfsTable(Table msTable, Db db, String name, String owner) {
        super(msTable, db, name, owner);
    }

    public QueryStmt getQueryStmt() {
        return this.queryStmt_;
    }

    public boolean isReferencesMaskedTables(AuthorizationChecker authChecker, FeCatalog catalog, User user) throws InternalException {
        for (TableName srcTblName : this.srcTblNames_) {
            FeDb db = catalog.getDb(srcTblName.getDb());
            Preconditions.checkNotNull((Object)db);
            FeTable srcTbl = db.getTable(srcTblName.getTbl());
            if (srcTbl == null) continue;
            Preconditions.checkArgument((boolean)srcTbl.isLoaded());
            List<Column> columns = srcTbl.getColumnsInHiveOrder();
            TableMask tableMask = new TableMask(authChecker, db.getName(), srcTblName.getTbl(), columns, user);
            if (!tableMask.needsMaskingOrFiltering()) continue;
            return true;
        }
        return false;
    }

    public void addSrcTables(Set<TableName> srcTableNames) {
        this.srcTblNames_.addAll(srcTableNames);
    }

    public List<TableName> getSrcTables() {
        return this.srcTblNames_;
    }

    @Override
    public void load(boolean reuseMetadata, IMetaStoreClient client, Table msTbl, String reason, EventSequence catalogTimeline) throws TableLoadingException {
        super.load(reuseMetadata, client, msTbl, reason, catalogTimeline);
        this.initQueryStmt();
    }

    @Override
    protected void loadFromThrift(TTable thriftTable) throws TableLoadingException {
        super.loadFromThrift(thriftTable);
        this.initQueryStmt();
    }

    private void initQueryStmt() throws TableLoadingException {
        Table msTbl = this.getMetaStoreTable();
        this.queryStmt_ = View.parseViewDef(new View(msTbl, this.getDb(), msTbl.getTableName(), msTbl.getOwner()));
    }
}

