/*
 * Decompiled with CFR 0.152.
 */
package org.apache.impala.catalog;

import com.google.common.base.Preconditions;
import java.util.Objects;
import org.apache.commons.lang3.StringUtils;
import org.apache.impala.catalog.Type;
import org.apache.impala.thrift.TColumnType;
import org.apache.impala.thrift.TTypeNode;
import org.apache.impala.thrift.TTypeNodeType;

public class MapType
extends Type {
    private final Type keyType_;
    private final Type valueType_;

    public MapType(Type keyType, Type valueType) {
        Preconditions.checkNotNull((Object)keyType);
        Preconditions.checkNotNull((Object)valueType);
        this.keyType_ = keyType;
        this.valueType_ = valueType;
    }

    public Type getKeyType() {
        return this.keyType_;
    }

    public Type getValueType() {
        return this.valueType_;
    }

    @Override
    public boolean equals(Object other) {
        if (!(other instanceof MapType)) {
            return false;
        }
        MapType otherMapType = (MapType)other;
        return otherMapType.keyType_.equals(this.keyType_) && otherMapType.valueType_.equals(this.valueType_);
    }

    @Override
    public int hashCode() {
        return Objects.hash(this.keyType_, this.valueType_);
    }

    @Override
    public String toSql(int depth) {
        if (depth >= MAX_NESTING_DEPTH) {
            return "MAP<...>";
        }
        return String.format("MAP<%s,%s>", this.keyType_.toSql(depth + 1), this.valueType_.toSql(depth + 1));
    }

    @Override
    protected String prettyPrint(int lpad) {
        String leftPadding = StringUtils.repeat((char)' ', (int)lpad);
        if (this.valueType_.isScalarType()) {
            return leftPadding + this.toSql();
        }
        String structStr = this.valueType_.prettyPrint(lpad);
        structStr = structStr.substring(lpad);
        return String.format("%sMAP<%s,%s>", leftPadding, this.keyType_.toSql(), structStr);
    }

    @Override
    public void toThrift(TColumnType container) {
        TTypeNode node = new TTypeNode();
        container.types.add(node);
        Preconditions.checkNotNull((Object)this.keyType_);
        Preconditions.checkNotNull((Object)this.valueType_);
        node.setType(TTypeNodeType.MAP);
        this.keyType_.toThrift(container);
        this.valueType_.toThrift(container);
    }
}

