/*
 * Decompiled with CFR 0.152.
 */
package org.apache.impala.catalog;

import com.codahale.metrics.Timer;
import com.google.common.base.Joiner;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Lists;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.apache.hadoop.hive.metastore.IMetaStoreClient;
import org.apache.hadoop.hive.metastore.TableType;
import org.apache.hadoop.hive.metastore.api.FieldSchema;
import org.apache.impala.analysis.ColumnDef;
import org.apache.impala.analysis.KuduPartitionParam;
import org.apache.impala.catalog.Column;
import org.apache.impala.catalog.Db;
import org.apache.impala.catalog.FeKuduTable;
import org.apache.impala.catalog.KuduColumn;
import org.apache.impala.catalog.Table;
import org.apache.impala.catalog.TableLoadingException;
import org.apache.impala.common.ImpalaRuntimeException;
import org.apache.impala.service.BackendConfig;
import org.apache.impala.thrift.TCatalogObjectType;
import org.apache.impala.thrift.TKuduPartitionByHashParam;
import org.apache.impala.thrift.TKuduPartitionByRangeParam;
import org.apache.impala.thrift.TKuduPartitionParam;
import org.apache.impala.thrift.TKuduTable;
import org.apache.impala.thrift.TTable;
import org.apache.impala.thrift.TTableDescriptor;
import org.apache.impala.thrift.TTableType;
import org.apache.impala.util.EventSequence;
import org.apache.impala.util.KuduUtil;
import org.apache.kudu.ColumnSchema;
import org.apache.kudu.Schema;
import org.apache.kudu.client.HiveMetastoreConfig;
import org.apache.kudu.client.KuduClient;
import org.apache.kudu.client.KuduException;
import org.apache.thrift.TException;

public class KuduTable
extends Table
implements FeKuduTable {
    private static boolean ENABLE_KUDU_IMPALA_HMS_CHECK = BackendConfig.INSTANCE.getBackendCfg().enable_kudu_impala_hms_check;
    public static final String KEY_STORAGE_HANDLER = "storage_handler";
    public static final String KEY_TABLE_NAME = "kudu.table_name";
    public static final String KEY_TABLE_ID = "kudu.table_id";
    public static final String KEY_KEY_COLUMNS = "kudu.key_columns";
    public static final String KEY_MASTER_HOSTS = "kudu.master_addresses";
    public static final String KUDU_LEGACY_STORAGE_HANDLER = "com.cloudera.kudu.hive.KuduStorageHandler";
    public static final String KUDU_STORAGE_HANDLER = "org.apache.hadoop.hive.kudu.KuduStorageHandler";
    public static final String KEY_TABLET_REPLICAS = "kudu.num_tablet_replicas";
    private String kuduTableName_;
    private String kuduMasters_;
    private boolean isPrimaryKeyUnique_ = true;
    private boolean hasAutoIncrementingColumn_ = false;
    private final List<String> primaryKeyColumnNames_ = new ArrayList<String>();
    private List<KuduPartitionParam> partitionBy_;
    private Schema kuduSchema_;

    protected KuduTable(org.apache.hadoop.hive.metastore.api.Table msTable, Db db, String name, String owner) {
        super(msTable, db, name, owner);
        this.kuduTableName_ = (String)msTable.getParameters().get(KEY_TABLE_NAME);
        this.kuduMasters_ = (String)msTable.getParameters().get(KEY_MASTER_HOSTS);
    }

    public static boolean isSynchronizedTable(org.apache.hadoop.hive.metastore.api.Table msTbl) {
        Preconditions.checkState((boolean)KuduTable.isKuduTable(msTbl));
        return KuduTable.isManagedTable(msTbl) || KuduTable.isExternalPurgeTable(msTbl);
    }

    private static boolean isManagedTable(org.apache.hadoop.hive.metastore.api.Table msTbl) {
        return msTbl.getTableType().equalsIgnoreCase(TableType.MANAGED_TABLE.toString());
    }

    @Override
    public TCatalogObjectType getCatalogObjectType() {
        return TCatalogObjectType.TABLE;
    }

    @Override
    public String getStorageHandlerClassName() {
        return KUDU_STORAGE_HANDLER;
    }

    @Override
    public List<Column> getColumnsInHiveOrder() {
        return this.filterColumnsNotStoredInHms(this.getColumns());
    }

    public static boolean isKuduStorageHandler(String handler) {
        return handler != null && (handler.equals(KUDU_LEGACY_STORAGE_HANDLER) || handler.equals(KUDU_STORAGE_HANDLER));
    }

    public static boolean isKuduTable(org.apache.hadoop.hive.metastore.api.Table msTbl) {
        return KuduTable.isKuduStorageHandler((String)msTbl.getParameters().get(KEY_STORAGE_HANDLER));
    }

    @Override
    public String getKuduTableName() {
        return this.kuduTableName_;
    }

    @Override
    public String getKuduMasterHosts() {
        return this.kuduMasters_;
    }

    public Schema getKuduSchema() {
        return this.kuduSchema_;
    }

    @Override
    public boolean isPrimaryKeyUnique() {
        return this.isPrimaryKeyUnique_;
    }

    @Override
    public boolean hasAutoIncrementingColumn() {
        return this.hasAutoIncrementingColumn_;
    }

    @Override
    public List<String> getPrimaryKeyColumnNames() {
        return ImmutableList.copyOf(this.primaryKeyColumnNames_);
    }

    @Override
    public List<KuduPartitionParam> getPartitionBy() {
        Preconditions.checkState((this.partitionBy_ != null ? 1 : 0) != 0);
        return ImmutableList.copyOf(this.partitionBy_);
    }

    private static HiveMetastoreConfig getHiveMetastoreConfig(String kuduMasters) throws ImpalaRuntimeException {
        HiveMetastoreConfig hmsConfig;
        Preconditions.checkNotNull((Object)kuduMasters);
        Preconditions.checkArgument((!kuduMasters.isEmpty() ? 1 : 0) != 0);
        KuduClient kuduClient = KuduUtil.getKuduClient(kuduMasters);
        try {
            hmsConfig = kuduClient.getHiveMetastoreConfig();
        }
        catch (KuduException e) {
            throw new ImpalaRuntimeException(String.format("Error determining if Kudu's integration with the Hive Metastore is enabled: %s", e.getMessage()));
        }
        return hmsConfig;
    }

    public static boolean isHMSIntegrationEnabled(String kuduMasters) throws ImpalaRuntimeException {
        return KuduTable.getHiveMetastoreConfig(kuduMasters) != null;
    }

    public static boolean isHMSIntegrationEnabledAndValidate(String kuduMasters, String hmsUris) throws ImpalaRuntimeException {
        Set<String> kuduHmsHosts;
        Set<String> hmsHosts;
        if (hmsUris == null || hmsUris.isEmpty()) {
            return false;
        }
        HiveMetastoreConfig hmsConfig = KuduTable.getHiveMetastoreConfig(kuduMasters);
        if (hmsConfig == null) {
            return false;
        }
        String kuduHmsUris = hmsConfig.getHiveMetastoreUris();
        try {
            hmsHosts = KuduTable.parseHosts(hmsUris);
            kuduHmsHosts = KuduTable.parseHosts(kuduHmsUris);
        }
        catch (URISyntaxException e) {
            throw new ImpalaRuntimeException(String.format("Error parsing URI: %s", e.getMessage()));
        }
        if (hmsHosts != null && kuduHmsHosts != null && (hmsHosts.equals(kuduHmsHosts) || !ENABLE_KUDU_IMPALA_HMS_CHECK)) {
            return true;
        }
        throw new ImpalaRuntimeException(String.format("Kudu is integrated with a different Hive Metastore than that used by Impala, Kudu is configured to use the HMS: %s, while Impala is configured to use the HMS: %s", kuduHmsUris, hmsUris));
    }

    private static Set<String> parseHosts(String uris) throws URISyntaxException {
        String[] urisString = uris.split(",");
        HashSet<String> parsedHosts = new HashSet<String>();
        for (String s : urisString) {
            s.trim();
            URI tmpUri = new URI(s);
            parsedHosts.add(tmpUri.getHost());
        }
        return parsedHosts;
    }

    public void loadSchemaFromKudu(EventSequence catalogTimeline) throws ImpalaRuntimeException {
        this.numClusteringCols_ = 0;
        org.apache.kudu.client.KuduTable kuduTable = null;
        KuduClient kuduClient = KuduUtil.getKuduClient(this.getKuduMasterHosts(), catalogTimeline);
        try {
            kuduTable = kuduClient.openTable(this.kuduTableName_);
            catalogTimeline.markEvent("Opened Kudu table");
        }
        catch (KuduException e) {
            throw new ImpalaRuntimeException(String.format("Error opening Kudu table '%s', Kudu error: %s", this.kuduTableName_, e.getMessage()));
        }
        Preconditions.checkNotNull((Object)kuduTable);
        this.loadSchema(kuduTable);
        Preconditions.checkState((!this.colsByPos_.isEmpty() ? 1 : 0) != 0);
        this.partitionBy_ = FeKuduTable.Utils.loadPartitionByParams(kuduTable);
        catalogTimeline.markEvent("Loaded Kudu table schema");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void load(boolean dummy, IMetaStoreClient msClient, org.apache.hadoop.hive.metastore.api.Table msTbl, String reason, EventSequence catalogTimeline) throws TableLoadingException {
        Timer.Context context = this.getMetrics().getTimer("load-duration").time();
        Table.LOADING_TABLES.incrementAndGet();
        try {
            this.msTable_ = msTbl.deepCopy();
            this.kuduTableName_ = (String)this.msTable_.getParameters().get(KEY_TABLE_NAME);
            this.kuduMasters_ = (String)this.msTable_.getParameters().get(KEY_MASTER_HOSTS);
            if (this.kuduMasters_ == null || this.kuduMasters_.isEmpty()) {
                throw new TableLoadingException("No kudu.master_addresses property found for Kudu table " + this.kuduTableName_);
            }
            this.setTableStats(this.msTable_);
            Timer.Context ctxStorageLdTime = this.getMetrics().getTimer("load-duration.storage-metadata").time();
            try {
                this.loadSchemaFromKudu(catalogTimeline);
            }
            catch (ImpalaRuntimeException e) {
                throw new TableLoadingException("Error loading metadata for Kudu table " + this.kuduTableName_, e);
            }
            finally {
                this.storageMetadataLoadTime_ = ctxStorageLdTime.stop();
            }
            this.loadAllColumnStats(msClient, catalogTimeline);
            this.refreshLastUsedTime();
            if (this.msTable_.equals(msTbl)) {
                return;
            }
            try {
                KuduTable.updateTimestampProperty(this.msTable_, "transient_lastDdlTime");
                this.msTable_.putToParameters("DO_NOT_UPDATE_STATS", "true");
                msClient.alter_table(this.msTable_.getDbName(), this.msTable_.getTableName(), this.msTable_);
                catalogTimeline.markEvent("Updated table schema in Metastore");
            }
            catch (TException e) {
                throw new TableLoadingException(e.getMessage());
            }
        }
        finally {
            Table.LOADING_TABLES.decrementAndGet();
            context.stop();
        }
    }

    private void loadSchema(org.apache.kudu.client.KuduTable kuduTable) throws ImpalaRuntimeException {
        Preconditions.checkNotNull((Object)kuduTable);
        this.clearColumns();
        this.primaryKeyColumnNames_.clear();
        boolean isHMSIntegrationEnabled = KuduTable.isHMSIntegrationEnabled(this.kuduMasters_);
        List cols = this.msTable_.getSd().getCols();
        if (!isHMSIntegrationEnabled) {
            cols.clear();
        }
        int pos = 0;
        this.kuduSchema_ = kuduTable.getSchema();
        this.isPrimaryKeyUnique_ = this.kuduSchema_.isPrimaryKeyUnique();
        this.hasAutoIncrementingColumn_ = this.kuduSchema_.hasAutoIncrementingColumn();
        Preconditions.checkState((!this.isPrimaryKeyUnique_ || !this.hasAutoIncrementingColumn_ ? 1 : 0) != 0);
        for (ColumnSchema colSchema : this.kuduSchema_.getColumns()) {
            KuduColumn kuduCol = KuduColumn.fromColumnSchema(colSchema, pos);
            Preconditions.checkNotNull((Object)kuduCol);
            if (!isHMSIntegrationEnabled) {
                cols.add(new FieldSchema(kuduCol.getName(), kuduCol.getType().toSql().toLowerCase(), null));
            }
            if (kuduCol.isKey()) {
                this.primaryKeyColumnNames_.add(kuduCol.getName());
            }
            this.addColumn(kuduCol);
            ++pos;
        }
    }

    public static KuduTable createCtasTarget(Db db, org.apache.hadoop.hive.metastore.api.Table msTbl, List<ColumnDef> columnDefs, boolean isPrimaryKeyUnique, List<ColumnDef> primaryKeyColumnDefs, List<KuduPartitionParam> partitionParams) throws ImpalaRuntimeException {
        KuduTable tmpTable = new KuduTable(msTbl, db, msTbl.getTableName(), msTbl.getOwner());
        tmpTable.isPrimaryKeyUnique_ = isPrimaryKeyUnique;
        int pos = 0;
        for (ColumnDef colDef : columnDefs) {
            tmpTable.addColumn(KuduColumn.fromThrift(colDef.toThrift(), pos++));
            if (isPrimaryKeyUnique || pos != primaryKeyColumnDefs.size()) continue;
            tmpTable.addColumn(KuduColumn.createAutoIncrementingColumn(pos++));
            tmpTable.hasAutoIncrementingColumn_ = true;
        }
        for (ColumnDef pkColDef : primaryKeyColumnDefs) {
            tmpTable.primaryKeyColumnNames_.add(pkColDef.getColName());
        }
        if (!isPrimaryKeyUnique) {
            tmpTable.primaryKeyColumnNames_.add(Schema.getAutoIncrementingColumnName());
        }
        tmpTable.partitionBy_ = ImmutableList.copyOf(partitionParams);
        return tmpTable;
    }

    @Override
    public TTable toThrift() {
        TTable table = super.toThrift();
        table.setTable_type(TTableType.KUDU_TABLE);
        table.setKudu_table(this.getTKuduTable());
        return table;
    }

    @Override
    protected void loadFromThrift(TTable thriftTable) throws TableLoadingException {
        super.loadFromThrift(thriftTable);
        TKuduTable tkudu = thriftTable.getKudu_table();
        this.kuduTableName_ = tkudu.getTable_name();
        this.kuduMasters_ = Joiner.on((char)',').join(tkudu.getMaster_addresses());
        this.primaryKeyColumnNames_.clear();
        this.primaryKeyColumnNames_.addAll(tkudu.getKey_columns());
        this.isPrimaryKeyUnique_ = tkudu.isIs_primary_key_unique();
        this.hasAutoIncrementingColumn_ = tkudu.isHas_auto_incrementing();
        this.partitionBy_ = KuduTable.loadPartitionByParamsFromThrift(tkudu.getPartition_by());
    }

    private static List<KuduPartitionParam> loadPartitionByParamsFromThrift(List<TKuduPartitionParam> params) {
        ArrayList<KuduPartitionParam> ret = new ArrayList<KuduPartitionParam>();
        for (TKuduPartitionParam param : params) {
            if (param.isSetBy_hash_param()) {
                TKuduPartitionByHashParam hashParam = param.getBy_hash_param();
                ret.add(KuduPartitionParam.createHashParam(hashParam.getColumns(), hashParam.getNum_partitions()));
                continue;
            }
            Preconditions.checkState((boolean)param.isSetBy_range_param());
            TKuduPartitionByRangeParam rangeParam = param.getBy_range_param();
            ret.add(KuduPartitionParam.createRangeParam(rangeParam.getColumns(), null));
        }
        return ret;
    }

    @Override
    public TTableDescriptor toThriftDescriptor(int tableId, Set<Long> referencedPartitions) {
        TTableDescriptor desc = new TTableDescriptor(tableId, TTableType.KUDU_TABLE, this.getTColumnDescriptors(), this.numClusteringCols_, this.name_, this.db_.getName());
        desc.setKuduTable(this.getTKuduTable());
        return desc;
    }

    private TKuduTable getTKuduTable() {
        TKuduTable tbl = new TKuduTable();
        tbl.setKey_columns((List)Preconditions.checkNotNull(this.primaryKeyColumnNames_));
        tbl.setIs_primary_key_unique(this.isPrimaryKeyUnique_);
        tbl.setHas_auto_incrementing(this.hasAutoIncrementingColumn_);
        tbl.setMaster_addresses(Lists.newArrayList((Object[])this.kuduMasters_.split(",")));
        tbl.setTable_name(this.kuduTableName_);
        Preconditions.checkNotNull(this.partitionBy_);
        tbl.partition_by = new ArrayList<TKuduPartitionParam>();
        for (KuduPartitionParam partitionParam : this.partitionBy_) {
            tbl.addToPartition_by(partitionParam.toThrift());
        }
        return tbl;
    }
}

