/*
 * Decompiled with CFR 0.152.
 */
package org.apache.impala.catalog;

import com.google.common.base.Joiner;
import com.google.common.base.Preconditions;
import com.google.common.base.Throwables;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import org.apache.hadoop.hive.metastore.IMetaStoreClient;
import org.apache.hadoop.hive.metastore.api.MetaException;
import org.apache.impala.catalog.Db;
import org.apache.impala.catalog.FeIncompleteTable;
import org.apache.impala.catalog.Table;
import org.apache.impala.catalog.TableLoadingException;
import org.apache.impala.common.ImpalaException;
import org.apache.impala.common.JniUtil;
import org.apache.impala.thrift.TCatalogObjectType;
import org.apache.impala.thrift.TErrorCode;
import org.apache.impala.thrift.TGetPartialCatalogObjectRequest;
import org.apache.impala.thrift.TGetPartialCatalogObjectResponse;
import org.apache.impala.thrift.TImpalaTableType;
import org.apache.impala.thrift.TStatus;
import org.apache.impala.thrift.TTable;
import org.apache.impala.thrift.TTableDescriptor;
import org.apache.impala.thrift.TTableType;
import org.apache.impala.util.EventSequence;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class IncompleteTable
extends Table
implements FeIncompleteTable {
    public static final Logger LOG = LoggerFactory.getLogger(IncompleteTable.class);
    private ImpalaException cause_;
    private TImpalaTableType tableType_;
    private String comment_;

    private IncompleteTable(Db db, String name, TImpalaTableType type, String comment, ImpalaException cause) {
        super(null, db, name, null);
        this.cause_ = cause;
        this.tableType_ = type;
        this.comment_ = comment;
        LOG.trace("Created IncompleteTable for {}.{}: type={}, comment={}", new Object[]{db.getName(), name, type, comment});
    }

    @Override
    public TImpalaTableType getTableType() {
        return this.tableType_;
    }

    @Override
    public String getTableComment() {
        return this.comment_;
    }

    @Override
    public ImpalaException getCause() {
        return this.cause_;
    }

    @Override
    public boolean isLoadFailedByRecoverableError() {
        if (this.cause_ instanceof TableLoadingException) {
            String metastoreConnectionError = "Could not connect to meta store";
            if (this.cause_.getMessage().contains(metastoreConnectionError) || this.cause_.getCause() instanceof MetaException && this.cause_.getCause().getMessage().contains(metastoreConnectionError)) {
                return true;
            }
        }
        return false;
    }

    @Override
    public boolean isLoaded() {
        return this.cause_ != null;
    }

    @Override
    public TCatalogObjectType getCatalogObjectType() {
        if (this.tableType_ == TImpalaTableType.VIEW) {
            return TCatalogObjectType.VIEW;
        }
        return TCatalogObjectType.TABLE;
    }

    @Override
    public TTableDescriptor toThriftDescriptor(int tableId, Set<Long> referencedPartitions) {
        throw new IllegalStateException(this.cause_);
    }

    @Override
    public void load(boolean reuseMetadata, IMetaStoreClient client, org.apache.hadoop.hive.metastore.api.Table msTbl, String reason, EventSequence catalogTimeline) throws TableLoadingException {
        if (this.cause_ instanceof TableLoadingException) {
            throw (TableLoadingException)this.cause_;
        }
        throw new TableLoadingException("Table metadata incomplete: ", this.cause_);
    }

    @Override
    public TTable toThrift() {
        TTable table = new TTable(this.db_.getName(), this.name_);
        if (this.cause_ != null) {
            table.setLoad_status(new TStatus(TErrorCode.INTERNAL_ERROR, Lists.newArrayList((Object[])new String[]{JniUtil.throwableToString(this.cause_), JniUtil.throwableToStackTrace(this.cause_)})));
        }
        if (this.tableType_ == TImpalaTableType.VIEW) {
            table.setTable_type(TTableType.VIEW);
        } else if (this.tableType_ == TImpalaTableType.MATERIALIZED_VIEW) {
            table.setTable_type(TTableType.MATERIALIZED_VIEW);
        } else {
            table.setTable_type(TTableType.UNLOADED_TABLE);
        }
        if (this.comment_ != null) {
            LOG.trace("Setting comment of {}: {}", (Object)this.getFullName(), (Object)this.comment_);
            table.setTbl_comment(this.comment_);
        }
        return table;
    }

    @Override
    protected void loadFromThrift(TTable thriftTable) {
        if (thriftTable.isSetTbl_comment()) {
            this.comment_ = thriftTable.getTbl_comment();
            LOG.trace("Loaded comment from thriftTable of {}: {}", (Object)this.getFullName(), (Object)this.comment_);
        }
        if (thriftTable.isSetLoad_status()) {
            List<String> errorMsgs = thriftTable.getLoad_status().getError_msgs();
            String callStackStr = "<None available>";
            if (errorMsgs.size() > 1) {
                callStackStr = errorMsgs.remove(errorMsgs.size() - 1);
            }
            String errorMsg = Joiner.on((String)"\n").join(errorMsgs);
            errorMsg = errorMsg.replaceFirst("^TableLoadingException: ", "");
            TableLoadingException loadingException = new TableLoadingException(errorMsg);
            ArrayList stackTrace = Lists.newArrayList((Object[])loadingException.getStackTrace());
            stackTrace.add(new StackTraceElement("========", "<Remote stack trace on catalogd>: " + callStackStr, "", -1));
            loadingException.setStackTrace(stackTrace.toArray(new StackTraceElement[stackTrace.size()]));
            this.cause_ = loadingException;
        }
    }

    public static IncompleteTable createUninitializedTable(Db db, String name, TImpalaTableType tableType, String tableComment, long createEventId) {
        IncompleteTable tbl = new IncompleteTable(db, name, tableType, tableComment, null);
        tbl.setCreateEventId(createEventId, true);
        return tbl;
    }

    public static IncompleteTable createFailedMetadataLoadTable(Db db, String name, ImpalaException e) {
        return new IncompleteTable(db, name, TImpalaTableType.UNKNOWN, null, e);
    }

    public static IncompleteTable createUninitializedTableForRemove(Db db, String name) {
        return new IncompleteTable(db, name, null, null, null);
    }

    @Override
    public TGetPartialCatalogObjectResponse getPartialInfo(TGetPartialCatalogObjectRequest req) throws TableLoadingException {
        Preconditions.checkNotNull((Object)this.cause_);
        Throwables.propagateIfPossible((Throwable)this.cause_, TableLoadingException.class);
        throw new TableLoadingException(this.cause_.getMessage());
    }
}

