/*
 * Decompiled with CFR 0.152.
 */
package org.apache.impala.catalog;

import com.google.common.base.Joiner;
import com.google.common.base.Preconditions;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import java.util.Random;
import org.apache.impala.analysis.TableName;
import org.apache.impala.common.JniUtil;
import org.apache.impala.service.BackendConfig;
import org.apache.impala.service.FeSupport;
import org.apache.impala.thrift.TErrorCode;
import org.apache.impala.thrift.TTableName;
import org.apache.impala.thrift.TTableUsage;
import org.apache.impala.thrift.TUpdateTableUsageRequest;
import org.apache.impala.thrift.TUpdateTableUsageResponse;
import org.apache.log4j.Logger;
import org.apache.thrift.TBase;
import org.apache.thrift.TSerializer;
import org.apache.thrift.protocol.TBinaryProtocol;

public class ImpaladTableUsageTracker {
    private static final Logger LOG = Logger.getLogger(ImpaladTableUsageTracker.class);
    private static final long REPORT_INTERVAL_MS = 10000L;
    private Map<TTableName, TTableUsage> unreportedUsages;
    private Thread reportThread_;

    private ImpaladTableUsageTracker(boolean enabled) {
        if (!enabled) {
            return;
        }
        this.unreportedUsages = new HashMap<TTableName, TTableUsage>();
        this.reportThread_ = new Thread(new Runnable(){

            @Override
            public void run() {
                ImpaladTableUsageTracker.this.report();
            }
        });
        this.reportThread_.setDaemon(true);
        this.reportThread_.setName("ImpaladTableUsageTracker daemon thread");
        this.reportThread_.start();
    }

    public static ImpaladTableUsageTracker createFromConfig(BackendConfig config) {
        boolean invalidateTableOnMemoryPressure = config.invalidateTablesOnMemoryPressure();
        int unusedTableTtlSec = config.getInvalidateTablesTimeoutS();
        Preconditions.checkArgument((unusedTableTtlSec >= 0 ? 1 : 0) != 0, (Object)"unused_table_ttl_sec flag must be a non-negative integer.");
        return new ImpaladTableUsageTracker(unusedTableTtlSec > 0 || invalidateTableOnMemoryPressure);
    }

    public synchronized void recordTableUsage(Collection<TableName> tableNames) {
        if (this.reportThread_ == null) {
            return;
        }
        for (TableName tableName : tableNames) {
            TTableName tTableName = tableName.toThrift();
            if (this.unreportedUsages.containsKey(tTableName)) {
                ++this.unreportedUsages.get((Object)tTableName).num_usages;
                continue;
            }
            this.unreportedUsages.put(tTableName, new TTableUsage(tTableName, 1));
        }
        this.notify();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void report() {
        Random random = new Random();
        String updateFailureMessage = "Unable to report table usage information to catalog server. ";
        while (true) {
            try {
                while (true) {
                    TUpdateTableUsageRequest reqToSend;
                    Thread.sleep((long)(10000.0 * (0.5 + random.nextDouble())));
                    ImpaladTableUsageTracker impaladTableUsageTracker = this;
                    synchronized (impaladTableUsageTracker) {
                        if (this.unreportedUsages.isEmpty()) {
                            continue;
                        }
                        reqToSend = new TUpdateTableUsageRequest();
                        reqToSend.setUsages(new ArrayList<TTableUsage>(this.unreportedUsages.values()));
                        this.unreportedUsages.clear();
                    }
                    byte[] byteResp = FeSupport.NativeUpdateTableUsage(new TSerializer().serialize((TBase)reqToSend));
                    TUpdateTableUsageResponse resp = new TUpdateTableUsageResponse();
                    JniUtil.deserializeThrift(new TBinaryProtocol.Factory(), resp, byteResp);
                    if (!resp.isSetStatus() || resp.status.status_code.equals((Object)TErrorCode.OK)) continue;
                    LOG.warn((Object)(updateFailureMessage + Joiner.on((String)"\n").join(resp.status.getError_msgs())));
                }
            }
            catch (Exception e) {
                LOG.warn((Object)updateFailureMessage, (Throwable)e);
                continue;
            }
            break;
        }
    }
}

