/*
 * Decompiled with CFR 0.152.
 */
package org.apache.impala.catalog;

import com.google.common.base.Preconditions;
import java.nio.ByteBuffer;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.atomic.AtomicLong;
import java.util.concurrent.atomic.AtomicReference;
import javax.annotation.Nullable;
import org.apache.impala.analysis.TableName;
import org.apache.impala.authorization.AuthorizationChecker;
import org.apache.impala.authorization.AuthorizationPolicy;
import org.apache.impala.catalog.AuthzCacheInvalidation;
import org.apache.impala.catalog.BuiltinsDb;
import org.apache.impala.catalog.Catalog;
import org.apache.impala.catalog.CatalogDeltaLog;
import org.apache.impala.catalog.CatalogException;
import org.apache.impala.catalog.CatalogObjectImpl;
import org.apache.impala.catalog.CatalogObjectVersionSet;
import org.apache.impala.catalog.DataSource;
import org.apache.impala.catalog.Db;
import org.apache.impala.catalog.FeCatalog;
import org.apache.impala.catalog.FeDb;
import org.apache.impala.catalog.Function;
import org.apache.impala.catalog.HdfsCachePool;
import org.apache.impala.catalog.HdfsPartition;
import org.apache.impala.catalog.HdfsTable;
import org.apache.impala.catalog.PartitionMetaSummary;
import org.apache.impala.catalog.Principal;
import org.apache.impala.catalog.PrincipalPrivilege;
import org.apache.impala.catalog.PrunablePartition;
import org.apache.impala.catalog.Table;
import org.apache.impala.catalog.TableLoadingException;
import org.apache.impala.common.InternalException;
import org.apache.impala.common.Pair;
import org.apache.impala.service.BackendConfig;
import org.apache.impala.service.FeSupport;
import org.apache.impala.thrift.TAuthzCacheInvalidation;
import org.apache.impala.thrift.TCatalogObject;
import org.apache.impala.thrift.TCatalogObjectType;
import org.apache.impala.thrift.TDataSource;
import org.apache.impala.thrift.TDatabase;
import org.apache.impala.thrift.TFunction;
import org.apache.impala.thrift.TGetPartitionStatsResponse;
import org.apache.impala.thrift.THdfsPartition;
import org.apache.impala.thrift.THdfsTable;
import org.apache.impala.thrift.TTable;
import org.apache.impala.thrift.TUniqueId;
import org.apache.impala.thrift.TUpdateCatalogCacheRequest;
import org.apache.impala.thrift.TUpdateCatalogCacheResponse;
import org.apache.impala.util.PatternMatcher;
import org.apache.impala.util.TByteBuffer;
import org.apache.impala.util.TUniqueIdUtil;
import org.apache.thrift.TConfiguration;
import org.apache.thrift.TException;
import org.apache.thrift.protocol.TBinaryProtocol;
import org.apache.thrift.protocol.TProtocol;
import org.apache.thrift.transport.TTransport;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ImpaladCatalog
extends Catalog
implements FeCatalog {
    private static final Logger LOG = LoggerFactory.getLogger(ImpaladCatalog.class);
    private TUniqueId catalogServiceId_ = Catalog.INITIAL_CATALOG_SERVICE_ID;
    private AtomicLong lastSyncedCatalogVersion_ = new AtomicLong(0L);
    private final CatalogDeltaLog catalogDeltaLog_ = new CatalogDeltaLog();
    private final Object catalogUpdateEventNotifier_ = new Object();
    private final AtomicReference<? extends AuthorizationChecker> authzChecker_;

    public ImpaladCatalog(AtomicReference<? extends AuthorizationChecker> authzChecker) {
        this.authzChecker_ = authzChecker;
        this.addDb(BuiltinsDb.getInstance());
        CatalogObjectVersionSet.INSTANCE.clear();
    }

    private void setCatalogServiceId(TUniqueId catalogServiceId) throws CatalogException {
        if (!this.catalogServiceId_.equals(catalogServiceId)) {
            boolean firstRun = this.catalogServiceId_.equals(INITIAL_CATALOG_SERVICE_ID);
            TUniqueId oldCatalogServiceId = this.catalogServiceId_;
            this.catalogServiceId_ = catalogServiceId;
            if (!firstRun) {
                throw new CatalogException("Detected catalog service ID changes from " + TUniqueIdUtil.PrintId(oldCatalogServiceId) + " to " + TUniqueIdUtil.PrintId(catalogServiceId) + ". Aborting updateCatalog()");
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized TUpdateCatalogCacheResponse updateCatalog(TUpdateCatalogCacheRequest req) throws CatalogException, TException {
        Pair<Boolean, ByteBuffer> update;
        if (req.isSetCatalog_service_id()) {
            this.setCatalogServiceId(req.catalog_service_id);
        }
        ObjectUpdateSequencer sequencer = new ObjectUpdateSequencer();
        HashMap<TableName, List<THdfsPartition>> newPartitionsByTable = new HashMap<TableName, List<THdfsPartition>>();
        HashMap<TableName, PartitionMetaSummary> partUpdates = new HashMap<TableName, PartitionMetaSummary>();
        long newCatalogVersion = this.lastSyncedCatalogVersion_.get();
        int maxMessageSize = BackendConfig.INSTANCE.getThriftRpcMaxMessageSize();
        TConfiguration config = new TConfiguration(maxMessageSize, 0xFA0000, 64);
        while ((update = FeSupport.NativeGetNextCatalogObjectUpdate(req.native_iterator_ptr)) != null) {
            boolean isDelete = (Boolean)update.first;
            TCatalogObject obj = new TCatalogObject();
            obj.read((TProtocol)new TBinaryProtocol((TTransport)new TByteBuffer(config, (ByteBuffer)update.second)));
            String key = Catalog.toCatalogObjectKey(obj);
            int len = ((ByteBuffer)update.second).capacity();
            if (len > 0x6400000) {
                LOG.info("Received large catalog object(>100mb): " + key + " is " + len + "bytes");
            }
            if (!key.contains("HDFS_PARTITION")) {
                LOG.info((isDelete ? "Deleting: " : "Adding: ") + key + " version: " + obj.catalog_version + " size: " + len);
            }
            if (obj.type == TCatalogObjectType.CATALOG) {
                this.setCatalogServiceId(obj.catalog.catalog_service_id);
                newCatalogVersion = obj.catalog_version;
                continue;
            }
            if (obj.type == TCatalogObjectType.HDFS_PARTITION) {
                TableName tblName = new TableName(obj.getHdfs_partition().db_name, obj.getHdfs_partition().tbl_name);
                partUpdates.computeIfAbsent(tblName, s -> new PartitionMetaSummary(tblName.toString(), false, true, false)).update(true, isDelete, obj.hdfs_partition.partition_name, obj.catalog_version, len, -1);
                if (isDelete) continue;
                newPartitionsByTable.computeIfAbsent(tblName, s -> new ArrayList()).add(obj.getHdfs_partition());
                continue;
            }
            sequencer.add(obj, isDelete);
        }
        for (PartitionMetaSummary summary : partUpdates.values()) {
            if (!summary.hasUpdates()) continue;
            LOG.info(summary.toString());
        }
        for (TCatalogObject catalogObject : sequencer.getUpdatedObjects()) {
            try {
                this.addCatalogObject(catalogObject, newPartitionsByTable);
            }
            catch (Exception e) {
                LOG.error("Error adding catalog object: " + e.getMessage(), (Throwable)e);
            }
        }
        for (TCatalogObject catalogObject : sequencer.getDeletedObjects()) {
            this.removeCatalogObject(catalogObject);
        }
        this.lastSyncedCatalogVersion_.set(newCatalogVersion);
        this.catalogDeltaLog_.garbageCollect(newCatalogVersion);
        Object object = this.catalogUpdateEventNotifier_;
        synchronized (object) {
            this.catalogUpdateEventNotifier_.notifyAll();
        }
        return new TUpdateCatalogCacheResponse(this.catalogServiceId_, CatalogObjectVersionSet.INSTANCE.getMinimumVersion(), newCatalogVersion);
    }

    @Override
    public void prioritizeLoad(Set<TableName> tableNames, @Nullable TUniqueId queryId) throws InternalException {
        FeSupport.PrioritizeLoad(tableNames, queryId);
    }

    @Override
    public TGetPartitionStatsResponse getPartitionStats(TableName table) throws InternalException {
        return FeSupport.GetPartitionStats(table);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void waitForCatalogUpdate(long timeoutMs) {
        Object object = this.catalogUpdateEventNotifier_;
        synchronized (object) {
            try {
                this.catalogUpdateEventNotifier_.wait(timeoutMs);
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void release() {
        Object object = this.catalogUpdateEventNotifier_;
        synchronized (object) {
            this.catalogUpdateEventNotifier_.notifyAll();
        }
    }

    private void addCatalogObject(TCatalogObject catalogObject, Map<TableName, List<THdfsPartition>> newPartitions) throws TableLoadingException {
        if (this.catalogDeltaLog_.wasObjectRemovedAfter(catalogObject)) {
            if (LOG.isTraceEnabled()) {
                LOG.trace(String.format("Skipping update because a matching object was removed in a later catalog version: %s", catalogObject));
            }
            return;
        }
        switch (catalogObject.getType()) {
            case DATABASE: {
                this.addDb(catalogObject.getDb(), catalogObject.getCatalog_version());
                break;
            }
            case TABLE: 
            case VIEW: {
                TTable table = catalogObject.getTable();
                TableName tblName = new TableName(table.getDb_name(), table.getTbl_name());
                this.addTable(table, newPartitions.getOrDefault(tblName, Collections.emptyList()), catalogObject.getCatalog_version(), catalogObject.getLast_modified_time_ms());
                break;
            }
            case FUNCTION: {
                this.removeFunction(catalogObject.getFn(), catalogObject.getCatalog_version());
                this.addFunction(catalogObject.getFn(), catalogObject.getCatalog_version());
                break;
            }
            case DATA_SOURCE: {
                this.addDataSource(catalogObject.getData_source(), catalogObject.getCatalog_version());
                break;
            }
            case PRINCIPAL: {
                Principal principal = Principal.fromThrift(catalogObject.getPrincipal());
                principal.setCatalogVersion(catalogObject.getCatalog_version());
                this.authPolicy_.addPrincipal(principal);
                break;
            }
            case PRIVILEGE: {
                PrincipalPrivilege privilege = PrincipalPrivilege.fromThrift(catalogObject.getPrivilege());
                privilege.setCatalogVersion(catalogObject.getCatalog_version());
                try {
                    this.authPolicy_.addPrivilege(privilege);
                }
                catch (CatalogException e) {
                    LOG.error("Error adding privilege: ", (Throwable)e);
                }
                break;
            }
            case HDFS_CACHE_POOL: {
                HdfsCachePool cachePool = new HdfsCachePool(catalogObject.getCache_pool());
                cachePool.setCatalogVersion(catalogObject.getCatalog_version());
                this.hdfsCachePools_.add(cachePool);
                break;
            }
            case AUTHZ_CACHE_INVALIDATION: {
                AuthzCacheInvalidation authzCacheInvalidation = new AuthzCacheInvalidation(catalogObject.getAuthz_cache_invalidation());
                authzCacheInvalidation.setCatalogVersion(catalogObject.getCatalog_version());
                this.authzCacheInvalidation_.add(authzCacheInvalidation);
                this.authzChecker_.get().invalidateAuthorizationCache();
                break;
            }
            default: {
                throw new IllegalStateException("Unexpected TCatalogObjectType: " + (Object)((Object)catalogObject.getType()));
            }
        }
    }

    private void removeCatalogObject(TCatalogObject catalogObject) {
        Preconditions.checkState((catalogObject.getCatalog_version() != 0L ? 1 : 0) != 0, (String)"Dropped catalog version is 0. type: %s", (Object)((Object)catalogObject.getType()));
        long dropCatalogVersion = catalogObject.getCatalog_version();
        switch (catalogObject.getType()) {
            case DATABASE: {
                this.removeDb(catalogObject.getDb(), dropCatalogVersion);
                break;
            }
            case TABLE: 
            case VIEW: {
                this.removeTable(catalogObject.getTable(), dropCatalogVersion);
                break;
            }
            case FUNCTION: {
                this.removeFunction(catalogObject.getFn(), dropCatalogVersion);
                break;
            }
            case DATA_SOURCE: {
                this.removeDataSource(catalogObject.getData_source(), dropCatalogVersion);
                break;
            }
            case PRINCIPAL: {
                this.authPolicy_.removePrincipalIfLowerVersion(catalogObject.getPrincipal(), dropCatalogVersion);
                break;
            }
            case PRIVILEGE: {
                this.authPolicy_.removePrivilegeIfLowerVersion(catalogObject.getPrivilege(), dropCatalogVersion);
                break;
            }
            case HDFS_CACHE_POOL: {
                HdfsCachePool existingItem = (HdfsCachePool)this.hdfsCachePools_.get(catalogObject.getCache_pool().getPool_name());
                if (existingItem.getCatalogVersion() > catalogObject.getCatalog_version()) break;
                this.hdfsCachePools_.remove(catalogObject.getCache_pool().getPool_name());
                break;
            }
            case AUTHZ_CACHE_INVALIDATION: {
                this.removeAuthzCacheInvalidation(catalogObject.getAuthz_cache_invalidation(), dropCatalogVersion);
                break;
            }
            case HDFS_PARTITION: {
                break;
            }
            default: {
                throw new IllegalStateException("Unexpected TCatalogObjectType: " + (Object)((Object)catalogObject.getType()));
            }
        }
        if (catalogObject.getCatalog_version() > this.lastSyncedCatalogVersion_.get()) {
            this.catalogDeltaLog_.addRemovedObject(catalogObject);
        }
    }

    private void addDb(TDatabase thriftDb, long catalogVersion) {
        FeDb existingDb = this.getDb(thriftDb.getDb_name());
        if (existingDb == null || ((CatalogObjectImpl)((Object)existingDb)).getCatalogVersion() < catalogVersion) {
            Db newDb = Db.fromTDatabase(thriftDb);
            newDb.setCatalogVersion(catalogVersion);
            if (existingDb != null) {
                CatalogObjectVersionSet.INSTANCE.updateVersions(((CatalogObjectImpl)((Object)existingDb)).getCatalogVersion(), catalogVersion);
                CatalogObjectVersionSet.INSTANCE.removeAll(((Db)existingDb).getTables());
                CatalogObjectVersionSet.INSTANCE.removeAll(((Db)existingDb).getFunctions(null, new PatternMatcher()));
                for (Table table : ((Db)existingDb).getTables()) {
                    newDb.addTable(table);
                }
                for (List list : ((Db)existingDb).getAllFunctions().values()) {
                    for (Function func : list) {
                        newDb.addFunction(func);
                    }
                }
            } else {
                CatalogObjectVersionSet.INSTANCE.addVersion(catalogVersion);
            }
            this.addDb(newDb);
        }
    }

    private void addTable(TTable thriftTable, List<THdfsPartition> newPartitions, long catalogVersion, long lastLoadedTime) throws TableLoadingException {
        FeDb db = this.getDb(thriftTable.db_name);
        if (db == null) {
            if (LOG.isTraceEnabled()) {
                LOG.trace("Parent database of table does not exist: " + thriftTable.db_name + "." + thriftTable.tbl_name);
            }
            return;
        }
        Preconditions.checkNotNull(newPartitions);
        Table existingTable = ((Db)db).getTable(thriftTable.tbl_name);
        Table newTable = Table.fromThrift((Db)db, thriftTable, true);
        newTable.setCatalogVersion(catalogVersion);
        newTable.setLastLoadedTimeMs(lastLoadedTime);
        if (existingTable != null && existingTable.getCatalogVersion() >= catalogVersion) {
            if (LOG.isTraceEnabled()) {
                LOG.trace("Ignore stale update on table {}: currentVersion={}, updateVersion={}", new Object[]{existingTable.getFullName(), existingTable.getCatalogVersion(), catalogVersion});
            }
            return;
        }
        if (newTable instanceof HdfsTable && !thriftTable.getHdfs_table().has_full_partitions) {
            THdfsTable tHdfsTable = thriftTable.getHdfs_table();
            int numExistingParts = 0;
            int numNewParts = 0;
            int numDeletedParts = 0;
            HdfsTable newHdfsTable = (HdfsTable)newTable;
            if (existingTable instanceof HdfsTable) {
                for (PrunablePartition prunablePartition : ((HdfsTable)existingTable).getPartitions()) {
                    ++numExistingParts;
                    if (tHdfsTable.partitions.containsKey(prunablePartition.getId())) {
                        HdfsPartition newPart = new HdfsPartition.Builder(newHdfsTable, prunablePartition.getId()).copyFromPartition((HdfsPartition)prunablePartition).build();
                        Preconditions.checkState((boolean)newHdfsTable.addPartitionNoThrow(newPart));
                        continue;
                    }
                    ++numDeletedParts;
                }
            }
            ArrayList<String> stalePartitionNames = new ArrayList<String>();
            for (THdfsPartition tPart : newPartitions) {
                if (!tHdfsTable.partitions.containsKey(tPart.id)) {
                    stalePartitionNames.add(tPart.partition_name);
                    LOG.warn("Stale partition: {}.{}:{} id={}", new Object[]{tPart.db_name, tPart.tbl_name, tPart.partition_name, tPart.id});
                    continue;
                }
                if (newHdfsTable.getPartitionMap().containsKey(tPart.id)) {
                    LOG.info("Skip adding existing partition (id:{}, name:{}) to table {}", new Object[]{tPart.id, tPart.partition_name, newHdfsTable.getFullName()});
                    continue;
                }
                HdfsPartition part = new HdfsPartition.Builder(newHdfsTable, tPart.id).fromThrift(tPart).build();
                Preconditions.checkState((boolean)newHdfsTable.addPartitionNoThrow(part), (String)"Failed adding new partition (id:{}, name:{}) to table {}", (Object)tPart.id, (Object)tPart.partition_name, (Object)newHdfsTable.getFullName());
                LOG.trace("Added partition (id:{}, name:{}) to table {}", new Object[]{tPart.id, tPart.partition_name, newHdfsTable.getFullName()});
                ++numNewParts;
            }
            if (!stalePartitionNames.isEmpty()) {
                LOG.warn("Received {} stale partitions of table {}.{} in the statestore update: {}. There are possible leaks in the catalog topic values. To resolve the leak, add them back and then drop them again.", new Object[]{stalePartitionNames.size(), thriftTable.db_name, thriftTable.tbl_name, String.join((CharSequence)",", stalePartitionNames)});
            }
            ((HdfsTable)newTable).validatePartitions(tHdfsTable.partitions.keySet());
            LOG.info("Applied incremental table updates on {} existing partitions of table {}.{}: added {} new partitions, deleted {} stale partitions.", new Object[]{numExistingParts, thriftTable.db_name, thriftTable.tbl_name, numNewParts, numDeletedParts});
        }
        ((Db)db).addTable(newTable);
    }

    private void addFunction(TFunction fn, long catalogVersion) {
        this.LibCacheSetNeedsRefresh(fn.hdfs_location);
        Function function = Function.fromThrift(fn);
        function.setCatalogVersion(catalogVersion);
        FeDb db = this.getDb(function.getFunctionName().getDb());
        if (db == null) {
            if (LOG.isTraceEnabled()) {
                LOG.trace("Parent database of function does not exist: " + function.getName());
            }
            return;
        }
        Function existingFn = ((Db)db).getFunction(fn.getSignature());
        if (existingFn == null || existingFn.getCatalogVersion() < catalogVersion) {
            ((Db)db).addFunction(function);
            if (existingFn != null) {
                CatalogObjectVersionSet.INSTANCE.updateVersions(existingFn.getCatalogVersion(), catalogVersion);
            } else {
                CatalogObjectVersionSet.INSTANCE.addVersion(catalogVersion);
            }
        }
    }

    private void addDataSource(TDataSource thrift, long catalogVersion) {
        this.LibCacheSetNeedsRefresh(thrift.hdfs_location);
        DataSource dataSource = DataSource.fromThrift(thrift);
        dataSource.setCatalogVersion(catalogVersion);
        this.addDataSource(dataSource);
    }

    private void removeDataSource(TDataSource thrift, long dropCatalogVersion) {
        DataSource src = (DataSource)this.dataSources_.get(thrift.name);
        if (src != null && src.getCatalogVersion() < dropCatalogVersion) {
            this.LibCacheRemoveEntry(src.getLocation());
        }
        this.removeDataSource(thrift.getName());
    }

    private void removeDb(TDatabase thriftDb, long dropCatalogVersion) {
        FeDb db = this.getDb(thriftDb.getDb_name());
        if (db != null && ((CatalogObjectImpl)((Object)db)).getCatalogVersion() < dropCatalogVersion) {
            this.removeDb(((Db)db).getName());
            CatalogObjectVersionSet.INSTANCE.removeVersion(((CatalogObjectImpl)((Object)db)).getCatalogVersion());
            CatalogObjectVersionSet.INSTANCE.removeAll(((Db)db).getTables());
            CatalogObjectVersionSet.INSTANCE.removeAll(((Db)db).getFunctions(null, new PatternMatcher()));
        }
    }

    private void removeTable(TTable thriftTable, long dropCatalogVersion) {
        FeDb db = this.getDb(thriftTable.db_name);
        if (db == null) {
            return;
        }
        Table table = ((Db)db).getTable(thriftTable.getTbl_name());
        if (table != null && table.getCatalogVersion() < dropCatalogVersion) {
            ((Db)db).removeTable(thriftTable.tbl_name);
        }
    }

    private void removeFunction(TFunction thriftFn, long dropCatalogVersion) {
        FeDb db = this.getDb(thriftFn.name.getDb_name());
        if (db == null) {
            return;
        }
        Function fn = ((Db)db).getFunction(thriftFn.getSignature());
        if (fn != null && fn.getCatalogVersion() < dropCatalogVersion) {
            this.LibCacheRemoveEntry(fn.getLocation().getLocation());
            ((Db)db).removeFunction(thriftFn.getSignature());
            CatalogObjectVersionSet.INSTANCE.removeVersion(fn.getCatalogVersion());
        }
    }

    private void removeAuthzCacheInvalidation(TAuthzCacheInvalidation authzCacheInvalidation, long dropCatalogVersion) {
        AuthzCacheInvalidation existingItem = (AuthzCacheInvalidation)this.authzCacheInvalidation_.get(authzCacheInvalidation.getMarker_name());
        if (existingItem != null && existingItem.getCatalogVersion() < dropCatalogVersion) {
            this.authzCacheInvalidation_.remove(authzCacheInvalidation.getMarker_name());
        }
    }

    @Override
    public boolean isReady() {
        return this.lastSyncedCatalogVersion_.get() > 0L;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setIsReady(boolean isReady) {
        this.lastSyncedCatalogVersion_.incrementAndGet();
        Object object = this.catalogUpdateEventNotifier_;
        synchronized (object) {
            this.catalogUpdateEventNotifier_.notifyAll();
        }
    }

    @Override
    public AuthorizationPolicy getAuthPolicy() {
        return this.authPolicy_;
    }

    private void LibCacheSetNeedsRefresh(String hdfsLocation) {
        if (!FeSupport.NativeLibCacheSetNeedsRefresh(hdfsLocation)) {
            LOG.error("NativeLibCacheSetNeedsRefresh(" + hdfsLocation + ") failed.");
        }
    }

    private void LibCacheRemoveEntry(String hdfsLibFile) {
        if (!FeSupport.NativeLibCacheRemoveEntry(hdfsLibFile)) {
            LOG.error("LibCacheRemoveEntry(" + hdfsLibFile + ") failed.");
        }
    }

    @Override
    public String getAcidUserId() {
        return String.format("Impala Catalog %s", TUniqueIdUtil.PrintId(this.getCatalogServiceId()));
    }

    @Override
    public TUniqueId getCatalogServiceId() {
        return this.catalogServiceId_;
    }

    public static class ObjectUpdateSequencer {
        private final ArrayDeque<TCatalogObject> updatedObjects = new ArrayDeque();
        private final ArrayDeque<TCatalogObject> deletedObjects = new ArrayDeque();

        public void add(TCatalogObject obj, boolean isDeleted) {
            if (!isDeleted) {
                if (ObjectUpdateSequencer.isTopLevelCatalogObject(obj)) {
                    this.updatedObjects.addFirst(obj);
                } else {
                    this.updatedObjects.addLast(obj);
                }
            } else if (ObjectUpdateSequencer.isTopLevelCatalogObject(obj)) {
                this.deletedObjects.addLast(obj);
            } else {
                this.deletedObjects.addFirst(obj);
            }
        }

        public Iterable<TCatalogObject> getUpdatedObjects() {
            return this.updatedObjects;
        }

        public Iterable<TCatalogObject> getDeletedObjects() {
            return this.deletedObjects;
        }

        private static boolean isTopLevelCatalogObject(TCatalogObject catalogObject) {
            return catalogObject.getType() == TCatalogObjectType.DATABASE || catalogObject.getType() == TCatalogObjectType.DATA_SOURCE || catalogObject.getType() == TCatalogObjectType.HDFS_CACHE_POOL || catalogObject.getType() == TCatalogObjectType.PRINCIPAL || catalogObject.getType() == TCatalogObjectType.AUTHZ_CACHE_INVALIDATION;
        }
    }
}

