/*
 * Decompiled with CFR 0.152.
 */
package org.apache.impala.catalog;

import com.codahale.metrics.Gauge;
import com.codahale.metrics.Timer;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.TreeMap;
import org.apache.hadoop.hive.metastore.IMetaStoreClient;
import org.apache.hadoop.hive.metastore.TableType;
import org.apache.iceberg.BaseTable;
import org.apache.iceberg.Snapshot;
import org.apache.iceberg.expressions.Expression;
import org.apache.impala.analysis.IcebergPartitionField;
import org.apache.impala.analysis.IcebergPartitionSpec;
import org.apache.impala.analysis.IcebergPartitionTransform;
import org.apache.impala.catalog.CatalogException;
import org.apache.impala.catalog.CatalogObject;
import org.apache.impala.catalog.Column;
import org.apache.impala.catalog.ColumnStats;
import org.apache.impala.catalog.Db;
import org.apache.impala.catalog.FeFsPartition;
import org.apache.impala.catalog.FeFsTable;
import org.apache.impala.catalog.FeIcebergTable;
import org.apache.impala.catalog.HdfsFileFormat;
import org.apache.impala.catalog.HdfsTable;
import org.apache.impala.catalog.IcebergColumn;
import org.apache.impala.catalog.IcebergContentFileStore;
import org.apache.impala.catalog.IcebergFileMetadataLoader;
import org.apache.impala.catalog.IcebergStructField;
import org.apache.impala.catalog.IcebergTableLoadingException;
import org.apache.impala.catalog.PuffinStatsLoader;
import org.apache.impala.catalog.StructType;
import org.apache.impala.catalog.Table;
import org.apache.impala.catalog.TableLoadingException;
import org.apache.impala.catalog.Type;
import org.apache.impala.catalog.VirtualColumn;
import org.apache.impala.catalog.iceberg.GroupedContentFiles;
import org.apache.impala.common.ImpalaRuntimeException;
import org.apache.impala.common.PrintUtils;
import org.apache.impala.service.BackendConfig;
import org.apache.impala.thrift.CatalogLookupStatus;
import org.apache.impala.thrift.TAlterTableUpdateStatsParams;
import org.apache.impala.thrift.TCatalogObjectType;
import org.apache.impala.thrift.TCompressionCodec;
import org.apache.impala.thrift.TGetPartialCatalogObjectRequest;
import org.apache.impala.thrift.TGetPartialCatalogObjectResponse;
import org.apache.impala.thrift.THdfsCompression;
import org.apache.impala.thrift.THdfsTable;
import org.apache.impala.thrift.TIcebergCatalog;
import org.apache.impala.thrift.TIcebergFileFormat;
import org.apache.impala.thrift.TIcebergPartitionField;
import org.apache.impala.thrift.TIcebergPartitionSpec;
import org.apache.impala.thrift.TIcebergPartitionStats;
import org.apache.impala.thrift.TIcebergTable;
import org.apache.impala.thrift.TPartialPartitionInfo;
import org.apache.impala.thrift.TSqlConstraints;
import org.apache.impala.thrift.TTable;
import org.apache.impala.thrift.TTableDescriptor;
import org.apache.impala.thrift.TTableType;
import org.apache.impala.util.EventSequence;
import org.apache.impala.util.IcebergSchemaConverter;
import org.apache.impala.util.IcebergUtil;

public class IcebergTable
extends Table
implements FeIcebergTable {
    public static final String KEY_STORAGE_HANDLER = "storage_handler";
    public static final String ICEBERG_STORAGE_HANDLER = "org.apache.iceberg.mr.hive.HiveIcebergStorageHandler";
    public static final String ICEBERG_FILE_FORMAT = "write.format.default";
    public static final String ICEBERG_CATALOG = "iceberg.catalog";
    public static final int ICEBERG_FORMAT_V1 = 1;
    public static final int ICEBERG_FORMAT_V2 = 2;
    public static final String ICEBERG_CATALOG_LOCATION = "iceberg.catalog_location";
    public static final String ICEBERG_TABLE_IDENTIFIER = "iceberg.table_identifier";
    public static final String ICEBERG_DISABLE_READING_PUFFIN_STATS = "impala.iceberg_read_puffin_stats";
    public static final String COMPUTE_STATS_SNAPSHOT_IDS = "impala.computeStatsSnapshotIds";
    public static final String METADATA_LOCATION = "metadata_location";
    public static final String PREVIOUS_METADATA_LOCATION = "previous_metadata_location";
    public static final String CURRENT_SCHEMA = "current-schema";
    public static final String SNAPSHOT_COUNT = "snapshot-count";
    public static final String CURRENT_SNAPSHOT_ID = "current-snapshot-id";
    public static final String CURRENT_SNAPSHOT_SUMMARY = "current-snapshot-summary";
    public static final String CURRENT_SNAPSHOT_TIMESTAMP_MS = "current-snapshot-timestamp-ms";
    public static final String DEFAULT_PARTITION_SPEC = "default-partition-spec";
    public static final String UUID = "uuid";
    public static final String PARQUET_COMPRESSION_CODEC = "write.parquet.compression-codec";
    public static final String PARQUET_COMPRESSION_LEVEL = "write.parquet.compression-level";
    public static final String MERGE_ON_READ = "merge-on-read";
    public static final THdfsCompression DEFAULT_PARQUET_COMPRESSION_CODEC = THdfsCompression.SNAPPY;
    public static final int DEFAULT_PARQUET_ZSTD_COMPRESSION_LEVEL = 3;
    public static final int MIN_PARQUET_COMPRESSION_LEVEL = 1;
    public static final int MAX_PARQUET_COMPRESSION_LEVEL = 22;
    public static final String PARQUET_ROW_GROUP_SIZE = "write.parquet.row-group-size-bytes";
    public static final long UNSET_PARQUET_ROW_GROUP_SIZE = 0L;
    public static final long MIN_PARQUET_ROW_GROUP_SIZE = 0x800000L;
    public static final long MAX_PARQUET_ROW_GROUP_SIZE = 0x7FF00000L;
    public static final String PARQUET_PLAIN_PAGE_SIZE = "write.parquet.page-size-bytes";
    public static final String PARQUET_DICT_PAGE_SIZE = "write.parquet.dict-size-bytes";
    public static final long UNSET_PARQUET_PAGE_SIZE = 0L;
    public static final long MIN_PARQUET_PAGE_SIZE = 65536L;
    public static final long MAX_PARQUET_PAGE_SIZE = 0x40000000L;
    public static final int V2_FILE_PATH_FIELD_ID = 2147483546;
    public static final int V2_POS_FIELD_ID = 0x7FFFFF99;
    public static final String METADATA_FOLDER_NAME = "metadata";
    private TIcebergCatalog icebergCatalog_;
    private TIcebergFileFormat icebergFileFormat_;
    private TCompressionCodec icebergParquetCompressionCodec_;
    private long icebergParquetRowGroupSize_;
    private long icebergParquetPlainPageSize_;
    private long icebergParquetDictPageSize_;
    private String icebergTableLocation_;
    private List<IcebergPartitionSpec> partitionSpecs_;
    private int defaultPartitionSpecId_;
    private IcebergContentFileStore fileStore_;
    private HdfsTable hdfsTable_;
    private org.apache.iceberg.Table icebergApiTable_;
    private String currentMetadataLocation_ = null;
    private long catalogSnapshotId_ = -1L;
    private Map<Integer, IcebergColumn> icebergFieldIdToCol_;
    private Map<String, TIcebergPartitionStats> partitionStats_;
    private final FeFsTable.FileMetadataStats fileMetadataStats_ = new FeFsTable.FileMetadataStats();

    protected IcebergTable(org.apache.hadoop.hive.metastore.api.Table msTable, Db db, String name, String owner) {
        super(msTable, db, name, owner);
        this.icebergTableLocation_ = msTable.getSd().getLocation();
        this.icebergCatalog_ = IcebergUtil.getTIcebergCatalog(msTable);
        this.icebergFileFormat_ = IcebergUtil.getIcebergFileFormat(msTable);
        this.icebergParquetCompressionCodec_ = FeIcebergTable.Utils.getIcebergParquetCompressionCodec(msTable);
        this.icebergParquetRowGroupSize_ = FeIcebergTable.Utils.getIcebergParquetRowGroupSize(msTable);
        this.icebergParquetPlainPageSize_ = FeIcebergTable.Utils.getIcebergParquetPlainPageSize(msTable);
        this.icebergParquetDictPageSize_ = FeIcebergTable.Utils.getIcebergParquetDictPageSize(msTable);
        this.hdfsTable_ = new HdfsTable(msTable, db, name, owner);
        this.icebergFieldIdToCol_ = new HashMap<Integer, IcebergColumn>();
    }

    public static boolean isSynchronizedTable(org.apache.hadoop.hive.metastore.api.Table msTbl) {
        Preconditions.checkState((boolean)IcebergTable.isIcebergTable(msTbl));
        return IcebergTable.isManagedTable(msTbl) || IcebergTable.isExternalPurgeTable(msTbl);
    }

    public static boolean isManagedTable(org.apache.hadoop.hive.metastore.api.Table msTbl) {
        return msTbl.getTableType().equalsIgnoreCase(TableType.MANAGED_TABLE.toString());
    }

    public HdfsTable getHdfsTable() {
        return this.hdfsTable_;
    }

    @Override
    public org.apache.iceberg.Table getIcebergApiTable() {
        return this.icebergApiTable_;
    }

    @Override
    public TCatalogObjectType getCatalogObjectType() {
        return TCatalogObjectType.TABLE;
    }

    @Override
    public void setCatalogVersion(long newVersion) {
        super.setCatalogVersion(newVersion);
        this.hdfsTable_.setCatalogVersion(newVersion);
    }

    @Override
    public String getStorageHandlerClassName() {
        return ICEBERG_STORAGE_HANDLER;
    }

    public static boolean isIcebergStorageHandler(String handler) {
        return handler != null && handler.equals(ICEBERG_STORAGE_HANDLER);
    }

    public static boolean isIcebergTable(org.apache.hadoop.hive.metastore.api.Table msTbl) {
        String inputFormat = msTbl.getSd().getInputFormat();
        HdfsFileFormat hdfsFileFormat = inputFormat != null ? HdfsFileFormat.fromHdfsInputFormatClass(inputFormat, null) : null;
        return IcebergTable.isIcebergStorageHandler((String)msTbl.getParameters().get(KEY_STORAGE_HANDLER)) || hdfsFileFormat == HdfsFileFormat.ICEBERG || hdfsFileFormat == null && "ICEBERG".equals(msTbl.getParameters().get("table_type"));
    }

    @Override
    public TIcebergCatalog getIcebergCatalog() {
        return this.icebergCatalog_;
    }

    @Override
    public String getIcebergCatalogLocation() {
        return FeIcebergTable.Utils.getIcebergCatalogLocation(this);
    }

    @Override
    public TIcebergFileFormat getIcebergFileFormat() {
        return this.icebergFileFormat_;
    }

    @Override
    public TCompressionCodec getIcebergParquetCompressionCodec() {
        return this.icebergParquetCompressionCodec_;
    }

    @Override
    public long getIcebergParquetRowGroupSize() {
        return this.icebergParquetRowGroupSize_;
    }

    @Override
    public long getIcebergParquetPlainPageSize() {
        return this.icebergParquetPlainPageSize_;
    }

    @Override
    public long getIcebergParquetDictPageSize() {
        return this.icebergParquetDictPageSize_;
    }

    @Override
    public String getIcebergTableLocation() {
        return this.icebergTableLocation_;
    }

    @Override
    public FeFsTable getFeFsTable() {
        return this.hdfsTable_;
    }

    @Override
    public List<IcebergPartitionSpec> getPartitionSpecs() {
        Preconditions.checkState((this.partitionSpecs_ != null ? 1 : 0) != 0);
        return ImmutableList.copyOf(this.partitionSpecs_);
    }

    @Override
    public IcebergPartitionSpec getDefaultPartitionSpec() {
        return FeIcebergTable.Utils.getDefaultPartitionSpec(this);
    }

    @Override
    public int getDefaultPartitionSpecId() {
        return this.defaultPartitionSpecId_;
    }

    @Override
    public long snapshotId() {
        return this.catalogSnapshotId_;
    }

    @Override
    public Map<String, TIcebergPartitionStats> getIcebergPartitionStats() {
        return this.partitionStats_;
    }

    public IcebergColumn getColumnByIcebergFieldId(int fieldId) {
        return this.icebergFieldIdToCol_.get(fieldId);
    }

    @Override
    public TTable toThrift() {
        TTable table = super.toThrift();
        table.setTable_type(TTableType.ICEBERG_TABLE);
        table.setIceberg_table(FeIcebergTable.Utils.getTIcebergTable(this));
        table.setHdfs_table(this.transformToTHdfsTable(true, CatalogObject.ThriftObjectType.FULL));
        return table;
    }

    @Override
    public TTable toHumanReadableThrift() {
        TTable table = super.toThrift();
        table.setTable_type(TTableType.ICEBERG_TABLE);
        table.setIceberg_table(FeIcebergTable.Utils.getTIcebergTable(this));
        table.setHdfs_table(this.transformToTHdfsTable(true, CatalogObject.ThriftObjectType.DESCRIPTOR_ONLY));
        return table;
    }

    @Override
    public void initMetrics() {
        super.initMetrics();
        this.metrics_.addGauge("num-files", new Gauge<Long>(){

            public Long getValue() {
                return ((IcebergTable)IcebergTable.this).fileMetadataStats_.numFiles;
            }
        });
        this.metrics_.addGauge("num-blocks", new Gauge<Long>(){

            public Long getValue() {
                return ((IcebergTable)IcebergTable.this).fileMetadataStats_.numBlocks;
            }
        });
        this.metrics_.addGauge("total-file-size-bytes", new Gauge<Long>(){

            public Long getValue() {
                return ((IcebergTable)IcebergTable.this).fileMetadataStats_.totalFileBytes;
            }
        });
        this.metrics_.addGauge("memory-estimate-bytes", new Gauge<Long>(){

            public Long getValue() {
                return IcebergTable.this.getEstimatedMetadataSize();
            }
        });
    }

    @Override
    public void load(boolean reuseMetadata, IMetaStoreClient msClient, org.apache.hadoop.hive.metastore.api.Table msTbl, String reason, EventSequence catalogTimeline) throws TableLoadingException {
        Timer.Context context = this.getMetrics().getTimer("load-duration").time();
        this.verifyTable(msTbl);
        try {
            this.loadTableMetadata(msClient, msTbl, catalogTimeline);
            this.loadFileMetadata(reuseMetadata, msClient, reason, catalogTimeline);
            this.setIcebergTableStats();
            this.refreshLastUsedTime();
        }
        catch (Exception e) {
            throw new IcebergTableLoadingException("Error loading metadata for Iceberg table " + this.icebergTableLocation_, e);
        }
        finally {
            context.stop();
        }
    }

    private void loadTableMetadata(IMetaStoreClient msClient, org.apache.hadoop.hive.metastore.api.Table msTbl, EventSequence catalogTimeline) throws TableLoadingException, ImpalaRuntimeException {
        this.msTable_ = msTbl.deepCopy();
        FeIcebergTable.setIcebergStorageDescriptor(this.msTable_);
        this.setTableStats(this.msTable_);
        this.icebergApiTable_ = IcebergUtil.loadTable(this);
        catalogTimeline.markEvent("Loaded Iceberg API table");
        this.catalogSnapshotId_ = FeIcebergTable.super.snapshotId();
        this.loadSchemaFromIceberg();
        catalogTimeline.markEvent("Loaded schema from Iceberg");
        this.icebergFileFormat_ = IcebergUtil.getIcebergFileFormat(msTbl);
        this.icebergParquetCompressionCodec_ = FeIcebergTable.Utils.getIcebergParquetCompressionCodec(msTbl);
        this.icebergParquetRowGroupSize_ = FeIcebergTable.Utils.getIcebergParquetRowGroupSize(msTbl);
        this.icebergParquetPlainPageSize_ = FeIcebergTable.Utils.getIcebergParquetPlainPageSize(msTbl);
        this.icebergParquetDictPageSize_ = FeIcebergTable.Utils.getIcebergParquetDictPageSize(msTbl);
        this.loadAllColumnStats(msClient, catalogTimeline);
        this.applyPuffinNdvStats(catalogTimeline);
    }

    private void loadFileMetadata(boolean reuseMetadata, IMetaStoreClient msClient, String reason, EventSequence catalogTimeline) throws IcebergTableLoadingException {
        if (reuseMetadata && this.canSkipReload()) {
            catalogTimeline.markEvent("Iceberg table reload skipped as no change detected");
            return;
        }
        Timer.Context ctxStorageLdTime = this.getMetrics().getTimer("load-duration.storage-metadata").time();
        try {
            this.currentMetadataLocation_ = ((BaseTable)this.icebergApiTable_).operations().current().metadataFileLocation();
            GroupedContentFiles icebergFiles = IcebergUtil.getIcebergFiles(this, new ArrayList<Expression>(), null);
            catalogTimeline.markEvent("Loaded Iceberg content file list");
            this.hdfsTable_.setSkipIcebergFileMetadataLoading(true);
            this.hdfsTable_.load(reuseMetadata, msClient, this.msTable_, reason, catalogTimeline);
            IcebergFileMetadataLoader loader = new IcebergFileMetadataLoader(this.icebergApiTable_, this.fileStore_ == null ? Collections.emptyList() : this.fileStore_.getAllFiles(), this.getHostIndex(), (GroupedContentFiles)Preconditions.checkNotNull((Object)icebergFiles), this.fileStore_ == null ? Collections.emptyList() : this.fileStore_.getPartitionList(), FeIcebergTable.Utils.requiresDataFilesInTableLocation(this));
            loader.load();
            catalogTimeline.markEvent("Loaded Iceberg file descriptors");
            this.fileStore_ = new IcebergContentFileStore(this.icebergApiTable_, loader.getLoadedIcebergFds(), icebergFiles, loader.getIcebergPartitions());
            this.partitionStats_ = FeIcebergTable.Utils.loadPartitionStats(this, icebergFiles);
            this.setAvroSchema(msClient, this.msTable_, this.fileStore_, catalogTimeline);
            this.updateMetrics(loader.getFileMetadataStats());
        }
        catch (Exception e) {
            throw new IcebergTableLoadingException("Error loading metadata for Iceberg table " + this.icebergTableLocation_, e);
        }
        finally {
            this.storageMetadataLoadTime_ = ctxStorageLdTime.stop();
        }
        LOG.info("Loaded file and block metadata for {}. Time taken: {}", (Object)this.getFullName(), (Object)PrintUtils.printTimeNs(this.storageMetadataLoadTime_));
    }

    private boolean canSkipReload() {
        if (this.icebergApiTable_ == null) {
            return false;
        }
        Preconditions.checkState((boolean)(this.icebergApiTable_ instanceof BaseTable));
        BaseTable newTable = (BaseTable)this.icebergApiTable_;
        return Objects.equals(this.currentMetadataLocation_, newTable.operations().current().metadataFileLocation());
    }

    private void updateMetrics(FeFsTable.FileMetadataStats stats) {
        long memUsageEstimate = stats.numFiles * 500L + stats.numBlocks * 150L;
        this.setEstimatedMetadataSize(memUsageEstimate);
        this.setNumFiles(stats.numFiles);
        this.fileMetadataStats_.set(stats);
    }

    private void applyPuffinNdvStats(EventSequence catalogTimeline) {
        if (!BackendConfig.INSTANCE.enableReadingPuffinStats()) {
            return;
        }
        if (!this.isPuffinStatsReadingEnabledForTable()) {
            return;
        }
        TreeMap<Integer, Long> fieldIdsWithHmsStats = this.getComputeStatsSnapshotMap(this.msTable_);
        Map<Integer, PuffinStatsLoader.PuffinStatsRecord> puffinNdvs = PuffinStatsLoader.loadPuffinStats(this.icebergApiTable_, this.getFullName(), fieldIdsWithHmsStats);
        for (Map.Entry<Integer, PuffinStatsLoader.PuffinStatsRecord> entry : puffinNdvs.entrySet()) {
            int fieldId = entry.getKey();
            long ndv = entry.getValue().ndv;
            long snapshotId = entry.getValue().snapshotId;
            Snapshot snapshot = this.icebergApiTable_.snapshot(snapshotId);
            Preconditions.checkNotNull((Object)snapshot);
            if (ndv < 0L) continue;
            IcebergColumn col = this.getColumnByIcebergFieldId(fieldId);
            Preconditions.checkNotNull((Object)col);
            Type colType = col.getType();
            if (!ColumnStats.supportsNdv(colType)) continue;
            col.getStats().setNumDistinctValues(ndv);
        }
        if (!puffinNdvs.isEmpty()) {
            catalogTimeline.markEvent("Loaded Puffin stats");
        }
    }

    private boolean isPuffinStatsReadingEnabledForTable() {
        String val = (String)this.msTable_.getParameters().get(ICEBERG_DISABLE_READING_PUFFIN_STATS);
        if (val == null) {
            return true;
        }
        return Boolean.parseBoolean(val);
    }

    private long getLastComputeStatsTimeMs() {
        String val = (String)this.msTable_.getParameters().get("impala.lastComputeStatsTime");
        try {
            return Long.parseLong(val) * 1000L;
        }
        catch (Exception e) {
            return -1L;
        }
    }

    private Set<Integer> collectFieldIdsWithNdvStats() {
        HashSet<Integer> res = new HashSet<Integer>();
        for (Column col : this.colsByPos_) {
            if (!col.getStats().hasNumDistinctValues()) continue;
            IcebergColumn iCol = (IcebergColumn)col;
            res.add(iCol.getFieldId());
        }
        return res;
    }

    private void verifyTable(org.apache.hadoop.hive.metastore.api.Table msTbl) throws TableLoadingException {
        Map params;
        String tableId;
        if (!(!IcebergUtil.isHiveCatalog(msTbl.getParameters()) || (tableId = IcebergUtil.getIcebergTableIdentifier(msTbl.getDbName(), msTbl.getTableName()).toString()).equalsIgnoreCase((params = msTbl.getParameters()).getOrDefault(ICEBERG_TABLE_IDENTIFIER, tableId)) && tableId.equalsIgnoreCase(params.getOrDefault("name", tableId)) && tableId.equalsIgnoreCase(params.getOrDefault("iceberg.mr.table.identifier", tableId)))) {
            throw new TableLoadingException(String.format("Table %s cannot be loaded because it is an EXTERNAL table in the HiveCatalog that points to another table. Query the original table instead.", this.getFullName()));
        }
    }

    public void loadSchemaFromIceberg() throws TableLoadingException, ImpalaRuntimeException {
        this.loadSchema();
        this.addVirtualColumns();
        this.partitionSpecs_ = FeIcebergTable.Utils.loadPartitionSpecByIceberg(this);
        this.defaultPartitionSpecId_ = this.icebergApiTable_.spec().specId();
    }

    private void loadSchema() throws TableLoadingException {
        this.clearColumns();
        try {
            this.msTable_.getSd().setCols(IcebergSchemaConverter.convertToHiveSchema(this.getIcebergSchema()));
            for (Column col : IcebergSchemaConverter.convertToImpalaSchema(this.getIcebergSchema())) {
                this.addColumn(col);
            }
        }
        catch (ImpalaRuntimeException e) {
            throw new TableLoadingException(e.getMessage(), e);
        }
    }

    private void setAvroSchema(IMetaStoreClient msClient, org.apache.hadoop.hive.metastore.api.Table msTbl, IcebergContentFileStore fileStore, EventSequence catalogTimeline) throws Exception {
        if (fileStore.hasAvro()) {
            this.hdfsTable_.setAvroSchemaInternal(msClient, msTbl, catalogTimeline);
        }
    }

    @Override
    public void addColumn(Column col) {
        Preconditions.checkState((boolean)(col instanceof IcebergColumn));
        IcebergColumn iCol = (IcebergColumn)col;
        this.icebergFieldIdToCol_.put(iCol.getFieldId(), iCol);
        this.colsByPos_.add(iCol);
        this.colsByName_.put(iCol.getName().toLowerCase(), col);
        ((StructType)this.type_.getItemType()).addField(new IcebergStructField(col.getName(), col.getType(), col.getComment(), iCol.getFieldId()));
    }

    @Override
    public void clearColumns() {
        super.clearColumns();
        this.icebergFieldIdToCol_.clear();
    }

    private void addVirtualColumns() {
        this.addVirtualColumn(VirtualColumn.INPUT_FILE_NAME);
        this.addVirtualColumn(VirtualColumn.FILE_POSITION);
        this.addVirtualColumn(VirtualColumn.PARTITION_SPEC_ID);
        this.addVirtualColumn(VirtualColumn.ICEBERG_PARTITION_SERIALIZED);
        this.addVirtualColumn(VirtualColumn.ICEBERG_DATA_SEQUENCE_NUMBER);
    }

    @Override
    protected void loadFromThrift(TTable thriftTable) throws TableLoadingException {
        super.loadFromThrift(thriftTable);
        TIcebergTable ticeberg = thriftTable.getIceberg_table();
        this.icebergTableLocation_ = ticeberg.getTable_location();
        this.icebergParquetCompressionCodec_ = ticeberg.getParquet_compression_codec();
        this.icebergParquetRowGroupSize_ = ticeberg.getParquet_row_group_size();
        this.icebergParquetPlainPageSize_ = ticeberg.getParquet_plain_page_size();
        this.icebergParquetDictPageSize_ = ticeberg.getParquet_dict_page_size();
        this.partitionSpecs_ = this.loadPartitionBySpecsFromThrift(ticeberg.getPartition_spec());
        this.defaultPartitionSpecId_ = ticeberg.getDefault_partition_spec_id();
        this.catalogSnapshotId_ = ticeberg.catalog_snapshot_id;
        this.icebergApiTable_ = IcebergUtil.loadTable(this);
        this.fileStore_ = IcebergContentFileStore.fromThrift(ticeberg.getContent_files(), null, null);
        this.hdfsTable_.loadFromThrift(thriftTable);
        this.partitionStats_ = ticeberg.getPartition_stats();
    }

    private List<IcebergPartitionSpec> loadPartitionBySpecsFromThrift(List<TIcebergPartitionSpec> params) {
        ArrayList<IcebergPartitionSpec> ret = new ArrayList<IcebergPartitionSpec>();
        for (TIcebergPartitionSpec param : params) {
            if (param.getPartition_fields() != null) {
                ArrayList<IcebergPartitionField> fields = new ArrayList<IcebergPartitionField>();
                for (TIcebergPartitionField field : param.getPartition_fields()) {
                    Integer transformParam = null;
                    if (field.getTransform().isSetTransform_param()) {
                        transformParam = field.getTransform().getTransform_param();
                    }
                    fields.add(new IcebergPartitionField(field.getSource_id(), field.getField_id(), field.getOrig_field_name(), field.getField_name(), new IcebergPartitionTransform(field.getTransform().getTransform_type(), transformParam), Type.fromTScalarType(field.getType())));
                }
                ret.add(new IcebergPartitionSpec(param.getSpec_id(), fields));
                continue;
            }
            ret.add(new IcebergPartitionSpec(param.getSpec_id(), null));
        }
        return ret;
    }

    @Override
    public TTableDescriptor toThriftDescriptor(int tableId, Set<Long> referencedPartitions) {
        TTableDescriptor desc = new TTableDescriptor(tableId, TTableType.ICEBERG_TABLE, this.getTColumnDescriptors(), this.numClusteringCols_, this.name_, this.db_.getName());
        desc.setIcebergTable(FeIcebergTable.Utils.getTIcebergTable(this, CatalogObject.ThriftObjectType.DESCRIPTOR_ONLY));
        desc.setHdfsTable(this.transformToTHdfsTable(false, CatalogObject.ThriftObjectType.DESCRIPTOR_ONLY));
        return desc;
    }

    @Override
    public THdfsTable transformToTHdfsTable(boolean updatePartitionFlag, CatalogObject.ThriftObjectType type) {
        THdfsTable hdfsTable = this.hdfsTable_.getTHdfsTable(type, null);
        if (updatePartitionFlag) {
            FeIcebergTable.Utils.updateIcebergPartitionFileFormat(this, hdfsTable);
        }
        return hdfsTable;
    }

    @Override
    public TGetPartialCatalogObjectResponse getPartialInfo(TGetPartialCatalogObjectRequest req) throws CatalogException {
        Preconditions.checkState((boolean)this.isLoaded(), (String)"unloaded table: %s", (Object)this.getFullName());
        TGetPartialCatalogObjectResponse resp = super.getPartialInfo(req);
        Preconditions.checkState((resp.table_info != null ? 1 : 0) != 0);
        boolean wantPartitionInfo = req.table_info_selector.want_partition_files || req.table_info_selector.want_partition_metadata || req.table_info_selector.want_partition_names || req.table_info_selector.want_partition_stats;
        Preconditions.checkState((!req.table_info_selector.want_hms_partition ? 1 : 0) != 0);
        List<Long> partIds = req.table_info_selector.partition_ids;
        if (partIds != null && partIds.isEmpty()) {
            resp.table_info.partitions = Lists.newArrayListWithCapacity((int)0);
        } else if (wantPartitionInfo || partIds != null) {
            Preconditions.checkState((partIds == null || partIds.size() == 1 ? 1 : 0) != 0);
            long partId = this.getPartitionMap().keySet().iterator().next();
            FeFsPartition part = (FeFsPartition)this.getPartitionMap().get(partId);
            if (part == null) {
                LOG.warn(String.format("Missing partition ID: %s, Table: %s", partId, this.getFullName()));
                return new TGetPartialCatalogObjectResponse().setLookup_status(CatalogLookupStatus.PARTITION_NOT_FOUND);
            }
            TPartialPartitionInfo partInfo = part.getDefaultPartialPartitionInfo(req);
            resp.table_info.partitions = Lists.newArrayList((Object[])new TPartialPartitionInfo[]{partInfo});
        }
        resp.table_info.setPartition_prefixes(this.hdfsTable_.partitionLocationCompressor_.getPrefixes());
        if (req.table_info_selector.want_partition_files) {
            resp.table_info.setNetwork_addresses(this.getHostIndex().getList());
        }
        if (req.table_info_selector.want_table_constraints) {
            TSqlConstraints sqlConstraints = new TSqlConstraints(this.getSqlConstraints().getPrimaryKeys(), this.getSqlConstraints().getForeignKeys());
            resp.table_info.setSql_constraints(sqlConstraints);
        }
        resp.table_info.setIs_marked_cached(this.isMarkedCached());
        for (VirtualColumn vCol : this.getVirtualColumns()) {
            resp.table_info.addToVirtual_columns(vCol.toThrift());
        }
        if (req.table_info_selector.want_iceberg_table) {
            resp.table_info.setIceberg_table(FeIcebergTable.Utils.getTIcebergTable(this));
            if (!resp.table_info.isSetNetwork_addresses()) {
                resp.table_info.setNetwork_addresses(this.getHostIndex().getList());
            }
            resp.table_info.iceberg_table.setCatalog_snapshot_id(this.catalogSnapshotId_);
        }
        return resp;
    }

    @Override
    public IcebergContentFileStore getContentFileStore() {
        return this.fileStore_;
    }

    public void updateComputeStatsIcebergSnapshotsProperty(org.apache.hadoop.hive.metastore.api.Table msTbl, TAlterTableUpdateStatsParams params) {
        TreeMap<Integer, Long> computeStatsMap = this.getComputeStatsSnapshotMap(msTbl);
        this.updateComputeStatsIcebergSnapshotMap(computeStatsMap, params);
        String property = IcebergUtil.ComputeStatsSnapshotPropertyConverter.mapToString(computeStatsMap);
        msTbl.putToParameters(COMPUTE_STATS_SNAPSHOT_IDS, property);
    }

    private TreeMap<Integer, Long> getComputeStatsSnapshotMap(org.apache.hadoop.hive.metastore.api.Table msTbl) {
        String snapshotIds = (String)msTbl.getParameters().get(COMPUTE_STATS_SNAPSHOT_IDS);
        return IcebergUtil.ComputeStatsSnapshotPropertyConverter.stringToMap(snapshotIds);
    }

    private void updateComputeStatsIcebergSnapshotMap(Map<Integer, Long> map, TAlterTableUpdateStatsParams params) {
        Preconditions.checkState((boolean)params.isSetSnapshot_id());
        long currentSnapshotId = params.snapshot_id;
        if (params.isSetColumn_stats()) {
            for (String colName : params.column_stats.keySet()) {
                int fieldId = this.getIcebergApiTable().schema().findField(colName).fieldId();
                map.put(fieldId, currentSnapshotId);
            }
        }
    }
}

