/*
 * Decompiled with CFR 0.152.
 */
package org.apache.impala.catalog;

import com.google.common.base.Preconditions;
import java.nio.ByteBuffer;
import java.util.List;
import org.apache.impala.catalog.FileDescriptor;
import org.apache.impala.fb.FbFileDesc;
import org.apache.impala.fb.FbFileMetadata;
import org.apache.impala.thrift.THdfsFileDesc;
import org.apache.impala.thrift.TNetworkAddress;
import org.apache.impala.util.ListMap;

public class IcebergFileDescriptor
extends FileDescriptor {
    private final FbFileMetadata fbFileMetadata_;

    public IcebergFileDescriptor(FbFileDesc fileDescData, FbFileMetadata fileMetadata) {
        super(fileDescData);
        Preconditions.checkNotNull((Object)((Object)fileMetadata));
        Preconditions.checkNotNull((Object)((Object)fileMetadata.icebergMetadata()));
        this.fbFileMetadata_ = fileMetadata;
    }

    public static IcebergFileDescriptor fromThrift(THdfsFileDesc desc) {
        Preconditions.checkState((boolean)desc.isSetFile_metadata());
        ByteBuffer bb = ByteBuffer.wrap(desc.getFile_desc_data());
        ByteBuffer bbMd = ByteBuffer.wrap(desc.getFile_metadata());
        return new IcebergFileDescriptor(FbFileDesc.getRootAsFbFileDesc(bb), FbFileMetadata.getRootAsFbFileMetadata(bbMd));
    }

    @Override
    public THdfsFileDesc toThrift() {
        THdfsFileDesc fd = super.toThrift();
        fd.setFile_metadata(this.fbFileMetadata_.getByteBuffer());
        return fd;
    }

    public static IcebergFileDescriptor cloneWithFileMetadata(FileDescriptor fd, FbFileMetadata fileMetadata) {
        return new IcebergFileDescriptor(fd.getFbFileDescriptor(), fileMetadata);
    }

    @Override
    public IcebergFileDescriptor cloneWithNewHostIndex(List<TNetworkAddress> origIndex, ListMap<TNetworkAddress> dstIndex) {
        return new IcebergFileDescriptor(this.fbFileDescWithNewHostIndex(origIndex, dstIndex), this.fbFileMetadata_);
    }

    public FbFileMetadata getFbFileMetadata() {
        return this.fbFileMetadata_;
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof IcebergFileDescriptor)) {
            return false;
        }
        IcebergFileDescriptor otherFD = (IcebergFileDescriptor)obj;
        Preconditions.checkNotNull((Object)((Object)this.getFbFileMetadata()));
        Preconditions.checkNotNull((Object)((Object)otherFD.getFbFileMetadata()));
        return this.getFbFileDescriptor().getByteBuffer().array() == otherFD.getFbFileDescriptor().getByteBuffer().array() && this.getFbFileMetadata().getByteBuffer().array() == otherFD.getFbFileMetadata().getByteBuffer().array();
    }

    public int hashCode() {
        return this.getAbsolutePath().hashCode();
    }
}

