/*
 * Decompiled with CFR 0.152.
 */
package org.apache.impala.catalog;

import java.util.Arrays;
import java.util.List;
import java.util.Set;
import org.apache.iceberg.types.Types;
import org.apache.impala.catalog.FeIcebergTable;
import org.apache.impala.catalog.IcebergColumn;
import org.apache.impala.catalog.IcebergDeleteTable;
import org.apache.impala.catalog.IcebergFileDescriptor;
import org.apache.impala.catalog.Type;
import org.apache.impala.catalog.VirtualColumn;
import org.apache.impala.common.ImpalaRuntimeException;
import org.apache.impala.util.IcebergSchemaConverter;

public class IcebergEqualityDeleteTable
extends IcebergDeleteTable {
    public IcebergEqualityDeleteTable(FeIcebergTable baseTable, String name, Set<IcebergFileDescriptor> deleteFiles, List<Integer> equalityIds, long deleteRecordsCount) throws ImpalaRuntimeException {
        super(baseTable, name, deleteFiles, deleteRecordsCount);
        int columnPos = 0;
        for (Integer eqId : equalityIds) {
            ++columnPos;
            Types.NestedField field = baseTable.getIcebergSchema().findField(eqId.intValue());
            Type colType = IcebergSchemaConverter.toImpalaType(field.type());
            if (colType.isComplexType()) {
                throw new ImpalaRuntimeException("Equality ID for nested types isn't supported: '" + field.name() + "'");
            }
            if (colType.isFloatingPointType()) {
                throw new ImpalaRuntimeException("Equality ID for floating point types isn't supported: '" + field.name() + "'");
            }
            IcebergColumn equalityCol = new IcebergColumn(field.name(), colType, field.doc(), columnPos, field.fieldId(), -1, -1, field.isOptional());
            this.addColumn(equalityCol);
        }
    }

    @Override
    public List<VirtualColumn> getVirtualColumns() {
        return Arrays.asList(VirtualColumn.ICEBERG_DATA_SEQUENCE_NUMBER);
    }
}

