/*
 * Decompiled with CFR 0.152.
 */
package org.apache.impala.catalog;

import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.commons.lang3.NotImplementedException;
import org.apache.iceberg.Table;
import org.apache.impala.analysis.IcebergPartitionSpec;
import org.apache.impala.catalog.CatalogObject;
import org.apache.impala.catalog.FeFsTable;
import org.apache.impala.catalog.FeIcebergTable;
import org.apache.impala.catalog.IcebergContentFileStore;
import org.apache.impala.catalog.IcebergFileDescriptor;
import org.apache.impala.catalog.VirtualTable;
import org.apache.impala.thrift.TCompressionCodec;
import org.apache.impala.thrift.THdfsTable;
import org.apache.impala.thrift.TIcebergCatalog;
import org.apache.impala.thrift.TIcebergFileFormat;
import org.apache.impala.thrift.TIcebergPartitionStats;
import org.apache.impala.thrift.TTableDescriptor;
import org.apache.impala.thrift.TTableStats;
import org.apache.impala.util.AvroSchemaConverter;

public abstract class IcebergDeleteTable
extends VirtualTable
implements FeIcebergTable {
    protected static final int INVALID_MAP_KEY_ID = -1;
    protected static final int INVALID_MAP_VALUE_ID = -1;
    protected FeIcebergTable baseTable_;
    protected Set<IcebergFileDescriptor> deleteFiles_;
    protected long deleteRecordsCount_;

    public IcebergDeleteTable(FeIcebergTable baseTable, String name, Set<IcebergFileDescriptor> deleteFiles, long deleteRecordsCount) {
        super(baseTable.getMetaStoreTable(), baseTable.getDb(), name, baseTable.getOwnerUser());
        this.baseTable_ = baseTable;
        this.deleteFiles_ = deleteFiles;
        this.deleteRecordsCount_ = deleteRecordsCount;
    }

    public FeIcebergTable getBaseTable() {
        return this.baseTable_;
    }

    @Override
    public long getNumRows() {
        return this.deleteRecordsCount_;
    }

    @Override
    public TTableStats getTTableStats() {
        long totalBytes = 0L;
        for (IcebergFileDescriptor df : this.deleteFiles_) {
            totalBytes += df.getFileLength();
        }
        TTableStats ret = new TTableStats(this.getNumRows());
        ret.setTotal_file_bytes(totalBytes);
        return ret;
    }

    @Override
    public TTableDescriptor toThriftDescriptor(int tableId, Set<Long> referencedPartitions) {
        TTableDescriptor desc = this.baseTable_.toThriftDescriptor(tableId, referencedPartitions);
        desc.setColumnDescriptors(this.getTColumnDescriptors());
        if (desc.hdfsTable.isSetAvroSchema()) {
            desc.hdfsTable.setAvroSchema(AvroSchemaConverter.convertColumns(this.getColumns(), this.getFullName().replaceAll("-", "_")).toString());
        }
        return desc;
    }

    @Override
    public IcebergContentFileStore getContentFileStore() {
        throw new NotImplementedException("This should never be called.");
    }

    @Override
    public Map<String, TIcebergPartitionStats> getIcebergPartitionStats() {
        return null;
    }

    @Override
    public FeFsTable getFeFsTable() {
        return this.baseTable_.getFeFsTable();
    }

    @Override
    public TIcebergCatalog getIcebergCatalog() {
        return null;
    }

    @Override
    public Table getIcebergApiTable() {
        return this.baseTable_.getIcebergApiTable();
    }

    @Override
    public String getIcebergCatalogLocation() {
        return null;
    }

    @Override
    public TIcebergFileFormat getIcebergFileFormat() {
        return this.baseTable_.getIcebergFileFormat();
    }

    @Override
    public TCompressionCodec getIcebergParquetCompressionCodec() {
        return null;
    }

    @Override
    public long getIcebergParquetRowGroupSize() {
        return this.baseTable_.getIcebergParquetRowGroupSize();
    }

    @Override
    public long getIcebergParquetPlainPageSize() {
        return this.baseTable_.getIcebergParquetPlainPageSize();
    }

    @Override
    public long getIcebergParquetDictPageSize() {
        return this.baseTable_.getIcebergParquetDictPageSize();
    }

    @Override
    public String getIcebergTableLocation() {
        return null;
    }

    @Override
    public List<IcebergPartitionSpec> getPartitionSpecs() {
        return this.baseTable_.getPartitionSpecs();
    }

    @Override
    public IcebergPartitionSpec getDefaultPartitionSpec() {
        return null;
    }

    @Override
    public int getDefaultPartitionSpecId() {
        return -1;
    }

    @Override
    public THdfsTable transformToTHdfsTable(boolean updatePartitionFlag, CatalogObject.ThriftObjectType type) {
        throw new IllegalStateException("not implemented here");
    }
}

