/*
 * Decompiled with CFR 0.152.
 */
package org.apache.impala.catalog;

import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Iterables;
import com.google.common.collect.Lists;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import org.apache.hadoop.fs.Path;
import org.apache.iceberg.ContentFile;
import org.apache.iceberg.DataFile;
import org.apache.iceberg.DeleteFile;
import org.apache.iceberg.Table;
import org.apache.impala.catalog.FileDescriptor;
import org.apache.impala.catalog.IcebergFileDescriptor;
import org.apache.impala.catalog.iceberg.GroupedContentFiles;
import org.apache.impala.common.Pair;
import org.apache.impala.fb.FbFileDesc;
import org.apache.impala.fb.FbFileMetadata;
import org.apache.impala.fb.FbIcebergMetadata;
import org.apache.impala.thrift.THdfsFileDesc;
import org.apache.impala.thrift.TIcebergContentFileStore;
import org.apache.impala.thrift.TIcebergPartition;
import org.apache.impala.thrift.TNetworkAddress;
import org.apache.impala.util.IcebergUtil;
import org.apache.impala.util.ListMap;

public class IcebergContentFileStore {
    private MapListContainer dataFilesWithoutDeletes_ = new MapListContainer();
    private MapListContainer dataFilesWithDeletes_ = new MapListContainer();
    private MapListContainer positionDeleteFiles_ = new MapListContainer();
    private MapListContainer equalityDeleteFiles_ = new MapListContainer();
    private Set<String> missingFiles_ = new HashSet<String>();
    private Map<TIcebergPartition, Integer> partitions_;
    private final ConcurrentMap<String, EncodedFileDescriptor> oldFileDescMap_ = new ConcurrentHashMap<String, EncodedFileDescriptor>();
    private final ConcurrentMap<TIcebergPartition, Integer> oldPartitionMap_ = new ConcurrentHashMap<TIcebergPartition, Integer>();
    private boolean hasAvro_ = false;
    private boolean hasOrc_ = false;
    private boolean hasParquet_ = false;

    protected static IcebergFileDescriptor decode(EncodedFileDescriptor encodedFd) {
        Preconditions.checkNotNull((Object)encodedFd.fileDesc_);
        Preconditions.checkNotNull((Object)encodedFd.fileMetadata_);
        return new IcebergFileDescriptor(FbFileDesc.getRootAsFbFileDesc(ByteBuffer.wrap(encodedFd.fileDesc_)), FbFileMetadata.getRootAsFbFileMetadata(ByteBuffer.wrap(encodedFd.fileMetadata_)));
    }

    protected static EncodedFileDescriptor encode(IcebergFileDescriptor fd) {
        return new EncodedFileDescriptor(IcebergContentFileStore.encodeFB(fd.getFbFileDescriptor()), IcebergContentFileStore.encodeFB(fd.getFbFileMetadata()));
    }

    private static byte[] encodeFB(com.google.flatbuffers.Table fbObject) {
        if (fbObject == null) {
            return null;
        }
        ByteBuffer bb = fbObject.getByteBuffer();
        byte[] arr = bb.array();
        Preconditions.checkState((bb.arrayOffset() == 0 && bb.remaining() == arr.length ? 1 : 0) != 0);
        return arr;
    }

    public IcebergContentFileStore() {
    }

    public IcebergContentFileStore(Table iceApiTable, List<IcebergFileDescriptor> fileDescriptors, GroupedContentFiles icebergFiles, Map<TIcebergPartition, Integer> partitions) {
        Preconditions.checkNotNull((Object)iceApiTable);
        Preconditions.checkNotNull(fileDescriptors);
        Preconditions.checkNotNull((Object)icebergFiles);
        Preconditions.checkNotNull(partitions);
        this.partitions_ = partitions;
        HashMap<String, IcebergFileDescriptor> fileDescMap = new HashMap<String, IcebergFileDescriptor>();
        for (IcebergFileDescriptor fileDesc : fileDescriptors) {
            Path path = new Path(fileDesc.getAbsolutePath(iceApiTable.location()));
            fileDescMap.put(path.toUri().getPath(), fileDesc);
        }
        for (DataFile dataFile : icebergFiles.dataFilesWithoutDeletes) {
            this.storeFile((ContentFile<?>)dataFile, (Map<String, IcebergFileDescriptor>)fileDescMap, this.dataFilesWithoutDeletes_);
        }
        for (DataFile dataFile : icebergFiles.dataFilesWithDeletes) {
            this.storeFile((ContentFile<?>)dataFile, (Map<String, IcebergFileDescriptor>)fileDescMap, this.dataFilesWithDeletes_);
        }
        for (DeleteFile deleteFile : icebergFiles.positionDeleteFiles) {
            this.storeFile((ContentFile<?>)deleteFile, (Map<String, IcebergFileDescriptor>)fileDescMap, this.positionDeleteFiles_);
        }
        for (DeleteFile deleteFile : icebergFiles.equalityDeleteFiles) {
            this.storeFile((ContentFile<?>)deleteFile, (Map<String, IcebergFileDescriptor>)fileDescMap, this.equalityDeleteFiles_);
        }
    }

    private void storeFile(ContentFile<?> contentFile, Map<String, IcebergFileDescriptor> fileDescMap, MapListContainer container) {
        Pair<String, EncodedFileDescriptor> pathHashAndFd = this.getPathHashAndFd(contentFile, fileDescMap);
        if (pathHashAndFd.second != null) {
            container.add((String)pathHashAndFd.first, (EncodedFileDescriptor)pathHashAndFd.second);
        } else {
            this.missingFiles_.add(contentFile.path().toString());
        }
    }

    public void addOldFileDescriptor(String pathHash, IcebergFileDescriptor desc) {
        this.oldFileDescMap_.put(pathHash, IcebergContentFileStore.encode(desc));
    }

    public void addOldPartition(TIcebergPartition partition, Integer id) {
        this.oldPartitionMap_.put(partition, id);
    }

    public IcebergFileDescriptor getDataFileDescriptor(String pathHash) {
        IcebergFileDescriptor desc = this.dataFilesWithoutDeletes_.get(pathHash);
        if (desc != null) {
            return desc;
        }
        return this.dataFilesWithDeletes_.get(pathHash);
    }

    public IcebergFileDescriptor getDeleteFileDescriptor(String pathHash) {
        IcebergFileDescriptor ret = this.positionDeleteFiles_.get(pathHash);
        if (ret != null) {
            return ret;
        }
        return this.equalityDeleteFiles_.get(pathHash);
    }

    public IcebergFileDescriptor getOldFileDescriptor(String pathHash) {
        if (!this.oldFileDescMap_.containsKey(pathHash)) {
            return null;
        }
        return IcebergContentFileStore.decode((EncodedFileDescriptor)this.oldFileDescMap_.get(pathHash));
    }

    public Integer getOldPartition(TIcebergPartition partition) {
        return (Integer)this.oldPartitionMap_.get(partition);
    }

    public int getOldPartitionsSize() {
        return this.oldPartitionMap_.size();
    }

    public List<IcebergFileDescriptor> getDataFilesWithoutDeletes() {
        return this.dataFilesWithoutDeletes_.getList();
    }

    public List<IcebergFileDescriptor> getDataFilesWithDeletes() {
        return this.dataFilesWithDeletes_.getList();
    }

    public List<IcebergFileDescriptor> getPositionDeleteFiles() {
        return this.positionDeleteFiles_.getList();
    }

    public List<IcebergFileDescriptor> getEqualityDeleteFiles() {
        return this.equalityDeleteFiles_.getList();
    }

    public boolean hasMissingFile() {
        return !this.missingFiles_.isEmpty();
    }

    public Set<String> getMissingFiles() {
        return this.missingFiles_;
    }

    public long getNumFiles() {
        return this.dataFilesWithoutDeletes_.getNumFiles() + this.dataFilesWithDeletes_.getNumFiles() + this.positionDeleteFiles_.getNumFiles() + this.equalityDeleteFiles_.getNumFiles();
    }

    public Iterable<IcebergFileDescriptor> getAllFiles() {
        return Iterables.concat(this.dataFilesWithoutDeletes_.getList(), this.dataFilesWithDeletes_.getList(), this.positionDeleteFiles_.getList(), this.equalityDeleteFiles_.getList());
    }

    public Iterable<IcebergFileDescriptor> getAllDataFiles() {
        return Iterables.concat(this.dataFilesWithoutDeletes_.getList(), this.dataFilesWithDeletes_.getList());
    }

    public Iterable<IcebergFileDescriptor> getAllDeleteFiles() {
        return Iterables.concat(this.positionDeleteFiles_.getList(), this.equalityDeleteFiles_.getList());
    }

    public Map<TIcebergPartition, Integer> getPartitionMap() {
        return this.partitions_;
    }

    public List<TIcebergPartition> getPartitionList() {
        return IcebergContentFileStore.convertPartitionMapToList(this.partitions_);
    }

    public int getNumPartitions() {
        return this.partitions_.size();
    }

    public boolean hasAvro() {
        return this.hasAvro_;
    }

    public boolean hasOrc() {
        return this.hasOrc_;
    }

    public boolean hasParquet() {
        return this.hasParquet_;
    }

    private void updateFileFormats(FbIcebergMetadata icebergMetadata) {
        Preconditions.checkNotNull((Object)((Object)icebergMetadata));
        byte fileFormat = icebergMetadata.fileFormat();
        if (fileFormat == 0) {
            this.hasParquet_ = true;
        } else if (fileFormat == 1) {
            this.hasOrc_ = true;
        } else if (fileFormat == 2) {
            this.hasAvro_ = true;
        }
    }

    private Pair<String, EncodedFileDescriptor> getPathHashAndFd(ContentFile<?> contentFile, Map<String, IcebergFileDescriptor> fileDescMap) {
        return new Pair<String, EncodedFileDescriptor>(IcebergUtil.getFilePathHash(contentFile), this.getIcebergFd(fileDescMap, contentFile));
    }

    private EncodedFileDescriptor getIcebergFd(Map<String, IcebergFileDescriptor> fileDescMap, ContentFile<?> contentFile) {
        Path path = new Path(contentFile.path().toString());
        IcebergFileDescriptor fileDesc = fileDescMap.get(path.toUri().getPath());
        if (fileDesc == null) {
            return null;
        }
        FbFileMetadata fileMetadata = fileDesc.getFbFileMetadata();
        Preconditions.checkState((fileMetadata != null ? 1 : 0) != 0);
        FbIcebergMetadata icebergMetadata = fileMetadata.icebergMetadata();
        Preconditions.checkState((icebergMetadata != null ? 1 : 0) != 0);
        this.updateFileFormats(icebergMetadata);
        return new EncodedFileDescriptor(IcebergContentFileStore.encodeFB(fileDesc.getFbFileDescriptor()), IcebergContentFileStore.encodeFB(icebergMetadata));
    }

    public TIcebergContentFileStore toThrift() {
        TIcebergContentFileStore ret = new TIcebergContentFileStore();
        ret.setPath_hash_to_data_file_without_deletes(this.dataFilesWithoutDeletes_.toThrift());
        ret.setPath_hash_to_data_file_with_deletes(this.dataFilesWithDeletes_.toThrift());
        ret.setPath_hash_to_position_delete_file(this.positionDeleteFiles_.toThrift());
        ret.setPath_hash_to_equality_delete_file(this.equalityDeleteFiles_.toThrift());
        ret.setHas_avro(this.hasAvro_);
        ret.setHas_orc(this.hasOrc_);
        ret.setHas_parquet(this.hasParquet_);
        ret.setMissing_files(new ArrayList<String>(this.missingFiles_));
        ret.setPartitions(IcebergContentFileStore.convertPartitionMapToList(this.partitions_));
        return ret;
    }

    public static IcebergContentFileStore fromThrift(TIcebergContentFileStore tFileStore, List<TNetworkAddress> networkAddresses, ListMap<TNetworkAddress> hostIndex) {
        IcebergContentFileStore ret = new IcebergContentFileStore();
        if (tFileStore.isSetPath_hash_to_data_file_without_deletes()) {
            ret.dataFilesWithoutDeletes_ = MapListContainer.fromThrift(tFileStore.getPath_hash_to_data_file_without_deletes(), networkAddresses, hostIndex);
        }
        if (tFileStore.isSetPath_hash_to_data_file_with_deletes()) {
            ret.dataFilesWithDeletes_ = MapListContainer.fromThrift(tFileStore.getPath_hash_to_data_file_with_deletes(), networkAddresses, hostIndex);
        }
        if (tFileStore.isSetPath_hash_to_position_delete_file()) {
            ret.positionDeleteFiles_ = MapListContainer.fromThrift(tFileStore.getPath_hash_to_position_delete_file(), networkAddresses, hostIndex);
        }
        if (tFileStore.isSetPath_hash_to_equality_delete_file()) {
            ret.equalityDeleteFiles_ = MapListContainer.fromThrift(tFileStore.getPath_hash_to_equality_delete_file(), networkAddresses, hostIndex);
        }
        ret.hasAvro_ = tFileStore.isSetHas_avro() ? tFileStore.isHas_avro() : false;
        ret.hasOrc_ = tFileStore.isSetHas_orc() ? tFileStore.isHas_orc() : false;
        ret.hasParquet_ = tFileStore.isSetHas_parquet() ? tFileStore.isHas_parquet() : false;
        ret.missingFiles_ = tFileStore.isSetMissing_files() ? new HashSet<String>(tFileStore.getMissing_files()) : Collections.emptySet();
        ret.partitions_ = tFileStore.isSetPartitions() ? IcebergContentFileStore.convertPartitionListToMap(tFileStore.getPartitions()) : new ImmutableMap<TIcebergPartition, Integer>();
        return ret;
    }

    static List<TIcebergPartition> convertPartitionMapToList(Map<TIcebergPartition, Integer> partitionMap) {
        ArrayList<TIcebergPartition> partitionList = new ArrayList<TIcebergPartition>(partitionMap.size());
        for (int i = 0; i < partitionMap.size(); ++i) {
            partitionList.add(null);
        }
        for (Map.Entry<TIcebergPartition, Integer> partition : partitionMap.entrySet()) {
            partitionList.set(partition.getValue(), partition.getKey());
        }
        return partitionList;
    }

    private static ImmutableMap<TIcebergPartition, Integer> convertPartitionListToMap(List<TIcebergPartition> partitionList) {
        Preconditions.checkState((partitionList != null ? 1 : 0) != 0);
        ImmutableMap.Builder builder = ImmutableMap.builder();
        for (int i = 0; i < partitionList.size(); ++i) {
            builder.put((Object)partitionList.get(i), (Object)i);
        }
        return builder.build();
    }

    private static class MapListContainer {
        private final Map<String, EncodedFileDescriptor> fileDescMap_ = new HashMap<String, EncodedFileDescriptor>();
        private final List<EncodedFileDescriptor> fileDescList_ = new ArrayList<EncodedFileDescriptor>();

        private MapListContainer() {
        }

        public boolean add(String pathHash, EncodedFileDescriptor desc) {
            if (this.fileDescMap_.put(pathHash, desc) == null) {
                this.fileDescList_.add(desc);
                return true;
            }
            return false;
        }

        public IcebergFileDescriptor get(String pathHash) {
            if (!this.fileDescMap_.containsKey(pathHash)) {
                return null;
            }
            return IcebergContentFileStore.decode(this.fileDescMap_.get(pathHash));
        }

        public long getNumFiles() {
            return this.fileDescList_.size();
        }

        List<IcebergFileDescriptor> getList() {
            return Lists.transform(this.fileDescList_, fd -> IcebergContentFileStore.decode(fd));
        }

        Map<String, THdfsFileDesc> toThrift() {
            HashMap<String, THdfsFileDesc> ret = new HashMap<String, THdfsFileDesc>();
            for (Map.Entry<String, EncodedFileDescriptor> entry : this.fileDescMap_.entrySet()) {
                ret.put(entry.getKey(), IcebergContentFileStore.decode(entry.getValue()).toThrift());
            }
            return ret;
        }

        static MapListContainer fromThrift(Map<String, THdfsFileDesc> thriftMap, List<TNetworkAddress> networkAddresses, ListMap<TNetworkAddress> hostIndex) {
            MapListContainer ret = new MapListContainer();
            for (Map.Entry<String, THdfsFileDesc> entry : thriftMap.entrySet()) {
                FileDescriptor fd = IcebergFileDescriptor.fromThrift(entry.getValue());
                Preconditions.checkNotNull((Object)fd);
                if (networkAddresses != null) {
                    Preconditions.checkNotNull(hostIndex);
                    fd = fd.cloneWithNewHostIndex((List)networkAddresses, (ListMap)hostIndex);
                }
                ret.add(entry.getKey(), IcebergContentFileStore.encode(fd));
            }
            return ret;
        }
    }

    private static class EncodedFileDescriptor {
        public final byte[] fileDesc_;
        public final byte[] fileMetadata_;

        public EncodedFileDescriptor(byte[] fDesc, byte[] fMeta) {
            this.fileDesc_ = fDesc;
            this.fileMetadata_ = fMeta;
        }
    }
}

