/*
 * Decompiled with CFR 0.152.
 */
package org.apache.impala.catalog;

import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.BitSet;
import java.util.Collections;
import java.util.EnumSet;
import java.util.Iterator;
import java.util.List;
import java.util.stream.Collectors;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hive.common.ValidReaderWriteIdList;
import org.apache.hadoop.hive.common.ValidTxnList;
import org.apache.hadoop.hive.common.ValidTxnWriteIdList;
import org.apache.hadoop.hive.common.ValidWriteIdList;
import org.apache.hadoop.hive.conf.HiveConf;
import org.apache.hadoop.hive.metastore.IMetaStoreClient;
import org.apache.hadoop.hive.metastore.LockRequestBuilder;
import org.apache.hadoop.hive.metastore.TableType;
import org.apache.hadoop.hive.metastore.Warehouse;
import org.apache.hadoop.hive.metastore.api.Database;
import org.apache.hadoop.hive.metastore.api.FieldSchema;
import org.apache.hadoop.hive.metastore.api.InvalidOperationException;
import org.apache.hadoop.hive.metastore.api.LockComponent;
import org.apache.hadoop.hive.metastore.api.LockRequest;
import org.apache.hadoop.hive.metastore.api.LockResponse;
import org.apache.hadoop.hive.metastore.api.LockState;
import org.apache.hadoop.hive.metastore.api.MetaException;
import org.apache.hadoop.hive.metastore.api.NoSuchLockException;
import org.apache.hadoop.hive.metastore.api.NoSuchTxnException;
import org.apache.hadoop.hive.metastore.api.Partition;
import org.apache.hadoop.hive.metastore.api.SQLForeignKey;
import org.apache.hadoop.hive.metastore.api.SQLPrimaryKey;
import org.apache.hadoop.hive.metastore.api.Table;
import org.apache.hadoop.hive.metastore.api.TableValidWriteIds;
import org.apache.hadoop.hive.metastore.api.TxnAbortedException;
import org.apache.hadoop.hive.metastore.conf.MetastoreConf;
import org.apache.hadoop.hive.metastore.utils.FileUtils;
import org.apache.hadoop.hive.metastore.utils.MetaStoreUtils;
import org.apache.hadoop.hive.ql.metadata.ForeignKeyInfo;
import org.apache.hadoop.hive.ql.metadata.PrimaryKeyInfo;
import org.apache.hive.service.rpc.thrift.TGetColumnsReq;
import org.apache.hive.service.rpc.thrift.TGetFunctionsReq;
import org.apache.hive.service.rpc.thrift.TGetSchemasReq;
import org.apache.hive.service.rpc.thrift.TGetTablesReq;
import org.apache.impala.authorization.User;
import org.apache.impala.common.ImpalaException;
import org.apache.impala.common.Pair;
import org.apache.impala.common.TransactionException;
import org.apache.impala.service.Frontend;
import org.apache.impala.service.MetadataOp;
import org.apache.impala.thrift.TImpalaTableType;
import org.apache.impala.thrift.TMetadataOpRequest;
import org.apache.impala.thrift.TResultSet;
import org.apache.impala.thrift.TValidWriteIdList;
import org.apache.impala.util.AcidUtils;
import org.apache.impala.util.HiveMetadataFormatUtils;
import org.apache.thrift.TException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Hive3MetastoreShimBase {
    private static final Logger LOG = LoggerFactory.getLogger(Hive3MetastoreShimBase.class);
    protected static final String EXTWRITE = "EXTWRITE";
    protected static final String EXTREAD = "EXTREAD";
    protected static final String HIVEBUCKET2 = "HIVEBUCKET2";
    protected static final String HIVEFULLACIDREAD = "HIVEFULLACIDREAD";
    protected static final String HIVEFULLACIDWRITE = "HIVEFULLACIDWRITE";
    protected static final String HIVEMANAGEDINSERTREAD = "HIVEMANAGEDINSERTREAD";
    protected static final String HIVEMANAGEDINSERTWRITE = "HIVEMANAGEDINSERTWRITE";
    protected static final String HIVEMANAGESTATS = "HIVEMANAGESTATS";
    protected static final String HIVEMQT = "HIVEMQT";
    protected static final String HIVESQL = "HIVESQL";
    protected static final long MAJOR_VERSION = 3L;
    protected static boolean capabilitiestSet_ = false;
    private static final long MAX_SLEEP_INTERVAL_MS = 30000L;
    protected static final String HMS_RPC_ERROR_FORMAT_STR = "Error making '%s' RPC to Hive Metastore: ";
    public static String TRANSACTION_USER_ID = "Impala";
    public static final String IMPALA_ENGINE = "impala";
    public static final EnumSet<TableType> IMPALA_SUPPORTED_TABLE_TYPES = EnumSet.of(TableType.EXTERNAL_TABLE, TableType.MANAGED_TABLE, TableType.VIRTUAL_VIEW, TableType.MATERIALIZED_VIEW);
    public static final List<String> HIVE_VIEW_TYPE = Collections.singletonList("VIRTUAL_VIEW");
    public static final ImmutableMap<String, TImpalaTableType> HMS_TO_IMPALA_TYPE = new ImmutableMap.Builder().put((Object)"EXTERNAL_TABLE", (Object)TImpalaTableType.TABLE).put((Object)"MANAGED_TABLE", (Object)TImpalaTableType.TABLE).put((Object)"INDEX_TABLE", (Object)TImpalaTableType.TABLE).put((Object)"VIRTUAL_VIEW", (Object)TImpalaTableType.VIEW).put((Object)"MATERIALIZED_VIEW", (Object)TImpalaTableType.MATERIALIZED_VIEW).build();
    private static final String DEFAULT_CATALOG_NAME = MetaStoreUtils.getDefaultCatalog((Configuration)MetastoreConf.newMetastoreConf());

    public static AcidUtils.TblTransaction createTblTransaction(IMetaStoreClient client, Table tbl, long txnId) throws TransactionException {
        AcidUtils.TblTransaction tblTxn = new AcidUtils.TblTransaction();
        try {
            if (txnId <= 0L) {
                txnId = Hive3MetastoreShimBase.openTransaction(client);
                tblTxn.ownsTxn = true;
            }
            tblTxn.txnId = txnId;
            tblTxn.writeId = Hive3MetastoreShimBase.allocateTableWriteId(client, txnId, tbl.getDbName(), tbl.getTableName());
            tblTxn.validWriteIds = Hive3MetastoreShimBase.getValidWriteIdListInTxn(client, tbl.getDbName(), tbl.getTableName(), txnId);
            return tblTxn;
        }
        catch (TException e) {
            if (tblTxn.ownsTxn) {
                Hive3MetastoreShimBase.abortTransactionNoThrow(client, tblTxn.txnId);
            }
            throw new TransactionException(String.format(HMS_RPC_ERROR_FORMAT_STR, "createTblTransaction"), e);
        }
    }

    public static void commitTblTransactionIfNeeded(IMetaStoreClient client, AcidUtils.TblTransaction tblTxn) throws TransactionException {
        if (tblTxn.ownsTxn) {
            Hive3MetastoreShimBase.commitTransaction(client, tblTxn.txnId);
        }
    }

    public static void abortTblTransactionIfNeeded(IMetaStoreClient client, AcidUtils.TblTransaction tblTxn) {
        if (tblTxn.ownsTxn) {
            Hive3MetastoreShimBase.abortTransactionNoThrow(client, tblTxn.txnId);
        }
    }

    public static boolean validateName(String name) {
        return MetaStoreUtils.validateName((String)name, null);
    }

    public static void alterPartition(IMetaStoreClient client, Partition partition) throws InvalidOperationException, MetaException, TException {
        client.alter_partition(partition.getDbName(), partition.getTableName(), partition, null);
    }

    public static void alterPartitions(IMetaStoreClient client, String dbName, String tableName, List<Partition> partitions) throws InvalidOperationException, MetaException, TException {
        client.alter_partitions(dbName, tableName, partitions, null);
    }

    public static void createTableWithConstraints(IMetaStoreClient client, Table newTbl, List<SQLPrimaryKey> primaryKeys, List<SQLForeignKey> foreignKeys) throws InvalidOperationException, MetaException, TException {
        client.createTableWithConstraints(newTbl, primaryKeys, foreignKeys, null, null, null, null);
    }

    public static void updatePartitionStatsFast(Partition partition, Table tbl, Warehouse warehouse) throws MetaException {
        MetaStoreUtils.updatePartitionStatsFast((Partition)partition, (Table)tbl, (Warehouse)warehouse, (boolean)false, (boolean)false, null, (boolean)false);
    }

    public static String metastoreBatchRetrieveObjectsMaxConfigKey() {
        return MetastoreConf.ConfVars.BATCH_RETRIEVE_OBJECTS_MAX.toString();
    }

    public static Pair<String, String> statsGeneratedViaStatsTaskParam() {
        return Pair.create("STATS_GENERATED", "TASK");
    }

    public static TResultSet execGetFunctions(Frontend frontend, TMetadataOpRequest request, User user) throws ImpalaException {
        TGetFunctionsReq req = request.getGet_functions_req();
        return MetadataOp.getFunctions(frontend, req.getCatalogName(), req.getSchemaName(), req.getFunctionName(), user);
    }

    public static TResultSet execGetColumns(Frontend frontend, TMetadataOpRequest request, User user) throws ImpalaException {
        TGetColumnsReq req = request.getGet_columns_req();
        return MetadataOp.getColumns(frontend, req.getCatalogName(), req.getSchemaName(), req.getTableName(), req.getColumnName(), user);
    }

    public static TResultSet execGetTables(Frontend frontend, TMetadataOpRequest request, User user) throws ImpalaException {
        TGetTablesReq req = request.getGet_tables_req();
        return MetadataOp.getTables(frontend, req.getCatalogName(), req.getSchemaName(), req.getTableName(), req.getTableTypes(), user);
    }

    public static TResultSet execGetSchemas(Frontend frontend, TMetadataOpRequest request, User user) throws ImpalaException {
        TGetSchemasReq req = request.getGet_schemas_req();
        return MetadataOp.getSchemas(frontend, req.getCatalogName(), req.getSchemaName(), user);
    }

    public static TImpalaTableType mapToInternalTableType(String typeStr) {
        TableType tType;
        TImpalaTableType defaultTableType = TImpalaTableType.TABLE;
        if (typeStr == null) {
            return defaultTableType;
        }
        try {
            tType = TableType.valueOf((String)typeStr.toUpperCase());
        }
        catch (Exception e) {
            return defaultTableType;
        }
        switch (tType) {
            case EXTERNAL_TABLE: 
            case MANAGED_TABLE: {
                return TImpalaTableType.TABLE;
            }
            case VIRTUAL_VIEW: {
                return TImpalaTableType.VIEW;
            }
            case MATERIALIZED_VIEW: {
                return TImpalaTableType.MATERIALIZED_VIEW;
            }
        }
        return defaultTableType;
    }

    public static String getDefaultCatalogName() {
        return DEFAULT_CATALOG_NAME;
    }

    public static boolean isDefaultCatalog(String catalogName) {
        return DEFAULT_CATALOG_NAME.equalsIgnoreCase(catalogName);
    }

    public static String makePartName(List<String> partitionColNames, List<String> values) {
        return FileUtils.makePartName(partitionColNames, values);
    }

    public static String getAllColumnsInformation(List<FieldSchema> tabCols, List<FieldSchema> partitionCols, boolean printHeader, boolean isOutputPadded, boolean showPartColsSeparately) {
        return HiveMetadataFormatUtils.getAllColumnsInformation(tabCols, partitionCols, printHeader, isOutputPadded, showPartColsSeparately);
    }

    public static String getPartitionTransformInformation(List<FieldSchema> partitionTransformCols) {
        return HiveMetadataFormatUtils.getPartitionTransformInformation(partitionTransformCols);
    }

    public static String getTableInformation(Table table) {
        return HiveMetadataFormatUtils.getTableInformation(table, false);
    }

    public static String getConstraintsInformation(PrimaryKeyInfo pkInfo, ForeignKeyInfo fkInfo) {
        return HiveMetadataFormatUtils.getConstraintsInformation(pkInfo, fkInfo);
    }

    public static String unescapeSQLString(String stringLiteral) {
        Character enclosure = null;
        StringBuilder sb = new StringBuilder(stringLiteral.length());
        for (int i = 0; i < stringLiteral.length(); ++i) {
            char currentChar = stringLiteral.charAt(i);
            if (enclosure == null) {
                if (currentChar != '\'' && stringLiteral.charAt(i) != '\"') continue;
                enclosure = Character.valueOf(currentChar);
                continue;
            }
            if (enclosure.equals(Character.valueOf(currentChar))) {
                enclosure = null;
                continue;
            }
            if (currentChar == '\\' && i + 6 < stringLiteral.length() && stringLiteral.charAt(i + 1) == 'u') {
                int code = 0;
                int base = i + 2;
                for (int j = 0; j < 4; ++j) {
                    int digit = Character.digit(stringLiteral.charAt(j + base), 16);
                    code = (code << 4) + digit;
                }
                sb.append((char)code);
                i += 5;
                continue;
            }
            if (currentChar == '\\' && i + 4 < stringLiteral.length()) {
                char i1 = stringLiteral.charAt(i + 1);
                char i2 = stringLiteral.charAt(i + 2);
                char i3 = stringLiteral.charAt(i + 3);
                if (i1 >= '0' && i1 <= '1' && i2 >= '0' && i2 <= '7' && i3 >= '0' && i3 <= '7') {
                    byte bVal = (byte)(i3 - 48 + (i2 - 48) * 8 + (i1 - 48) * 8 * 8);
                    byte[] bValArr = new byte[]{bVal};
                    String tmp = new String(bValArr);
                    sb.append(tmp);
                    i += 3;
                    continue;
                }
            }
            if (currentChar == '\\' && i + 2 < stringLiteral.length()) {
                char n = stringLiteral.charAt(i + 1);
                switch (n) {
                    case '0': {
                        sb.append("\u0000");
                        break;
                    }
                    case '\'': {
                        sb.append("'");
                        break;
                    }
                    case '\"': {
                        sb.append("\"");
                        break;
                    }
                    case 'b': {
                        sb.append("\b");
                        break;
                    }
                    case 'n': {
                        sb.append("\n");
                        break;
                    }
                    case 'r': {
                        sb.append("\r");
                        break;
                    }
                    case 't': {
                        sb.append("\t");
                        break;
                    }
                    case 'Z': {
                        sb.append("\u001a");
                        break;
                    }
                    case '\\': {
                        sb.append("\\");
                        break;
                    }
                    case '%': {
                        sb.append("\\%");
                        break;
                    }
                    case '_': {
                        sb.append("\\_");
                        break;
                    }
                    default: {
                        sb.append(n);
                    }
                }
                ++i;
                continue;
            }
            sb.append(currentChar);
        }
        return sb.toString();
    }

    public static ValidWriteIdList getValidWriteIdListFromString(String validWriteIds) {
        Preconditions.checkNotNull((Object)validWriteIds);
        return new ValidReaderWriteIdList(validWriteIds);
    }

    public static ValidWriteIdList getValidWriteIdListFromThrift(String tableName, TValidWriteIdList validWriteIds) {
        BitSet abortedBits;
        Preconditions.checkNotNull((Object)validWriteIds);
        if (validWriteIds.getAborted_indexesSize() > 0) {
            abortedBits = new BitSet(validWriteIds.getInvalid_write_idsSize());
            for (int aborted_index : validWriteIds.getAborted_indexes()) {
                abortedBits.set(aborted_index);
            }
        } else {
            abortedBits = new BitSet();
        }
        long highWatermark = validWriteIds.isSetHigh_watermark() ? validWriteIds.high_watermark : Long.MAX_VALUE;
        long minOpenWriteId = validWriteIds.isSetMin_open_write_id() ? validWriteIds.min_open_write_id : Long.MAX_VALUE;
        return new ValidReaderWriteIdList(tableName, validWriteIds.getInvalid_write_ids().stream().mapToLong(i -> i).toArray(), abortedBits, highWatermark, minOpenWriteId);
    }

    public static TValidWriteIdList convertToTValidWriteIdList(ValidWriteIdList validWriteIdList) {
        Preconditions.checkNotNull((Object)validWriteIdList);
        TValidWriteIdList ret = new TValidWriteIdList();
        long minOpenWriteId = validWriteIdList.getMinOpenWriteId() != null ? validWriteIdList.getMinOpenWriteId() : Long.MAX_VALUE;
        ret.setHigh_watermark(validWriteIdList.getHighWatermark());
        ret.setMin_open_write_id(minOpenWriteId);
        ret.setInvalid_write_ids(Arrays.stream(validWriteIdList.getInvalidWriteIds()).boxed().collect(Collectors.toList()));
        ArrayList<Integer> abortedIndexes = new ArrayList<Integer>();
        for (int i = 0; i < validWriteIdList.getInvalidWriteIds().length; ++i) {
            long writeId = validWriteIdList.getInvalidWriteIds()[i];
            if (!validWriteIdList.isWriteIdAborted(writeId)) continue;
            abortedIndexes.add(i);
        }
        ret.setAborted_indexes(abortedIndexes);
        return ret;
    }

    public static ValidTxnList getValidTxns(IMetaStoreClient client) throws TException {
        return client.getValidTxns();
    }

    private static String getValidWriteIdListInTxn(IMetaStoreClient client, String dbName, String tblName, long txnId) throws TException {
        ValidTxnList txns = client.getValidTxns(txnId);
        String tableFullName = dbName + "." + tblName;
        List writeIdsObj = client.getValidWriteIds((List)Lists.newArrayList((Object[])new String[]{tableFullName}), txns.toString());
        ValidTxnWriteIdList validTxnWriteIdList = new ValidTxnWriteIdList(Long.valueOf(txnId));
        for (TableValidWriteIds tableWriteIds : writeIdsObj) {
            validTxnWriteIdList.addTableValidWriteIdList((ValidWriteIdList)Hive3MetastoreShimBase.createValidReaderWriteIdList(tableWriteIds));
        }
        String validWriteIds = validTxnWriteIdList.getTableValidWriteIdList(tableFullName).writeToString();
        return validWriteIds;
    }

    public static long openTransaction(IMetaStoreClient client) throws TransactionException {
        try {
            return client.openTxn(TRANSACTION_USER_ID);
        }
        catch (Exception e) {
            throw new TransactionException(e.getMessage());
        }
    }

    public static void commitTransaction(IMetaStoreClient client, long txnId) throws TransactionException {
        try {
            client.commitTxn(txnId);
        }
        catch (Exception e) {
            throw new TransactionException(e.getMessage());
        }
    }

    public static void abortTransaction(IMetaStoreClient client, long txnId) throws TransactionException {
        try {
            client.abortTxns(Arrays.asList(txnId));
        }
        catch (Exception e) {
            throw new TransactionException(e.getMessage());
        }
    }

    public static boolean heartbeat(IMetaStoreClient client, long txnId, long lockId) throws TransactionException {
        String errorMsg = "Caught exception during heartbeating transaction " + String.valueOf(txnId) + " lock " + String.valueOf(lockId);
        LOG.info("Sending heartbeat for transaction " + String.valueOf(txnId) + " lock " + String.valueOf(lockId));
        try {
            client.heartbeat(txnId, lockId);
        }
        catch (NoSuchLockException e) {
            LOG.info(errorMsg, (Throwable)e);
            return false;
        }
        catch (NoSuchTxnException e) {
            LOG.info(errorMsg, (Throwable)e);
            return false;
        }
        catch (TxnAbortedException e) {
            LOG.info(errorMsg, (Throwable)e);
            return false;
        }
        catch (TException e) {
            throw new TransactionException(e.getMessage());
        }
        return true;
    }

    public static long acquireLock(IMetaStoreClient client, long txnId, List<LockComponent> lockComponents, int maxWaitTimeInSeconds) throws TransactionException {
        LockRequestBuilder lockRequestBuilder = new LockRequestBuilder();
        lockRequestBuilder.setUser(TRANSACTION_USER_ID);
        if (txnId > 0L) {
            lockRequestBuilder.setTransactionId(txnId);
        }
        for (LockComponent lockComponent : lockComponents) {
            lockRequestBuilder.addLockComponent(lockComponent);
        }
        LockRequest lockRequest = lockRequestBuilder.build();
        try {
            long startTime = System.currentTimeMillis();
            long timeoutTime = startTime + (long)(maxWaitTimeInSeconds * 1000);
            long sleepIntervalMs = 100L;
            LockResponse lockResponse = client.lock(lockRequest);
            long lockId = lockResponse.getLockid();
            while (lockResponse.getState() == LockState.WAITING && System.currentTimeMillis() < timeoutTime) {
                try {
                    long sleepMs = Math.min(sleepIntervalMs, Math.abs(timeoutTime - System.currentTimeMillis()));
                    LOG.debug("Waiting " + String.valueOf(sleepMs) + " milliseconds for lock " + String.valueOf(lockId) + " of transaction " + Long.toString(txnId));
                    Thread.sleep(sleepMs);
                    sleepIntervalMs = Math.min(30000L, sleepIntervalMs * 2L);
                    lockResponse = client.checkLock(lockId);
                }
                catch (InterruptedException sleepMs) {}
            }
            LockState lockState = lockResponse.getState();
            LOG.info("It took " + String.valueOf(System.currentTimeMillis() - startTime) + " ms to wait for lock " + String.valueOf(lockId) + " of transaction " + String.valueOf(txnId) + ". Final lock state is " + lockState.name());
            if (lockState == LockState.ACQUIRED) {
                return lockId;
            }
            if (lockId > 0L) {
                try {
                    Hive3MetastoreShimBase.releaseLock(client, lockId);
                }
                catch (TransactionException te) {
                    LOG.error("Failed to release lock as a cleanup step after acquiring a lock has failed: " + lockId + " " + te.getMessage());
                }
            }
            throw new TransactionException("Failed to acquire lock for transaction " + String.valueOf(txnId));
        }
        catch (TException e) {
            throw new TransactionException(e.getMessage());
        }
    }

    public static void releaseLock(IMetaStoreClient client, long lockId) throws TransactionException {
        try {
            client.unlock(lockId);
        }
        catch (Exception e) {
            throw new TransactionException(e.getMessage());
        }
    }

    public static void abortTransactionNoThrow(IMetaStoreClient client, long txnId) {
        try {
            client.abortTxns(Arrays.asList(txnId));
        }
        catch (Exception e) {
            LOG.error("Error in abortTxns.", (Throwable)e);
        }
    }

    public static long allocateTableWriteId(IMetaStoreClient client, long txnId, String dbName, String tableName) throws TransactionException {
        try {
            return client.allocateTableWriteId(txnId, dbName, tableName);
        }
        catch (Exception e) {
            throw new TransactionException(e.getMessage());
        }
    }

    public static long getMajorVersion() {
        return 3L;
    }

    private static ValidReaderWriteIdList createValidReaderWriteIdList(TableValidWriteIds tableWriteIds) {
        String fullTableName = tableWriteIds.getFullTableName();
        long highWater = tableWriteIds.getWriteIdHighWaterMark();
        List invalids = tableWriteIds.getInvalidWriteIds();
        BitSet abortedBits = BitSet.valueOf(tableWriteIds.getAbortedBits());
        long[] exceptions = new long[invalids.size()];
        int i = 0;
        Iterator iterator = invalids.iterator();
        while (iterator.hasNext()) {
            long writeId = (Long)iterator.next();
            exceptions[i++] = writeId;
        }
        if (tableWriteIds.isSetMinOpenWriteId()) {
            return new ValidReaderWriteIdList(fullTableName, exceptions, abortedBits, highWater, tableWriteIds.getMinOpenWriteId());
        }
        return new ValidReaderWriteIdList(fullTableName, exceptions, abortedBits, highWater);
    }

    public static String getPathForNewTable(Database db, Table tbl) throws MetaException {
        Warehouse wh = new Warehouse((Configuration)new HiveConf());
        boolean isExternal = !AcidUtils.isTransactionalTable(tbl.getParameters());
        return wh.getDefaultTablePath(db, tbl.getTableName().toLowerCase(), isExternal).toString();
    }

    public static boolean validateColumnName(String name) {
        return MetaStoreUtils.validateColumnName((String)name);
    }

    public static class AlterPartitionsInfo {
        private final Table msTable;
        private final List<Partition> partitions;
        private final boolean isTruncate;

        public AlterPartitionsInfo(Table msTable, List<Partition> partitions, boolean isTruncate) {
            this.msTable = msTable;
            this.partitions = partitions;
            this.isTruncate = isTruncate;
        }

        public Table getMsTable() {
            return this.msTable;
        }

        public List<Partition> getPartitions() {
            return this.partitions;
        }

        public boolean isTruncate() {
            return this.isTruncate;
        }
    }
}

