/*
 * Decompiled with CFR 0.152.
 */
package org.apache.impala.catalog;

import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Interner;
import com.google.common.collect.Interners;
import com.google.errorprone.annotations.Immutable;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import org.apache.hadoop.hive.metastore.api.SerDeInfo;
import org.apache.hadoop.hive.metastore.api.StorageDescriptor;
import org.apache.impala.catalog.CatalogException;
import org.apache.impala.catalog.HdfsFileFormat;
import org.apache.impala.thrift.THdfsStorageDescriptor;
import org.apache.impala.thrift.TJsonBinaryFormat;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Immutable
public class HdfsStorageDescriptor {
    public static final char DEFAULT_LINE_DELIM = '\n';
    public static final char DEFAULT_FIELD_DELIM = '\u0001';
    public static final char DEFAULT_ESCAPE_CHAR = '\u0000';
    private static final String BLOCK_SIZE = "blocksize";
    public static final String JSON_BINARY_FORMAT = "json.binary.format";
    static final ImmutableList<String> DELIMITER_KEYS = ImmutableList.of((Object)"line.delim", (Object)"field.delim", (Object)"collection.delim", (Object)"mapkey.delim", (Object)"escape.delim", (Object)"quote.delim");
    static final ImmutableList<String> COMPATIBLE_SERDES = ImmutableList.of((Object)"org.apache.hadoop.hive.serde2.lazy.LazySimpleSerDe", (Object)"org.apache.hadoop.hive.serde2.avro.AvroSerDe", (Object)"org.apache.hadoop.hive.serde2.columnar.ColumnarSerDe", (Object)"org.apache.hadoop.hive.ql.io.orc.OrcSerde", (Object)"parquet.hive.serde.ParquetHiveSerDe", (Object)"org.apache.hadoop.hive.ql.io.parquet.serde.ParquetHiveSerDe", (Object)"org.apache.iceberg.mr.hive.HiveIcebergSerDe", (Object)"org.apache.hadoop.hive.serde2.JsonSerDe", (Object)"org.apache.paimon.hive.PaimonSerDe");
    private static final Logger LOG = LoggerFactory.getLogger(HdfsStorageDescriptor.class);
    private static final Interner<HdfsStorageDescriptor> INTERNER = Interners.newWeakInterner();
    private final HdfsFileFormat fileFormat_;
    private final byte lineDelim_;
    private final byte fieldDelim_;
    private final byte collectionDelim_;
    private final byte mapKeyDelim_;
    private final byte escapeChar_;
    private final byte quoteChar_;
    private final int blockSize_;
    private final TJsonBinaryFormat jsonBinaryFormat_;
    private String encodingValue_ = null;

    private static Map<String, Byte> extractDelimiters(SerDeInfo serdeInfo) throws InvalidStorageDescriptorException {
        HashMap<String, Byte> delimMap = new HashMap<String, Byte>();
        for (String delimKey : DELIMITER_KEYS) {
            String delimValue = (String)serdeInfo.getParameters().get(delimKey);
            if (delimValue == null) {
                if (delimKey.equals("field.delim")) {
                    delimMap.put(delimKey, (byte)1);
                    continue;
                }
                if (delimKey.equals("escape.delim")) {
                    delimMap.put(delimKey, (byte)0);
                    continue;
                }
                if (delimKey.equals("line.delim")) {
                    delimMap.put(delimKey, (byte)10);
                    continue;
                }
                delimMap.put(delimKey, (Byte)delimMap.get("field.delim"));
                continue;
            }
            Byte delimByteValue = HdfsStorageDescriptor.parseDelim(delimValue);
            if (delimByteValue == null) {
                throw new InvalidStorageDescriptorException("Invalid delimiter: '" + delimValue + "'. Delimiter must be specified as a single character or as a decimal value in the range [-128:127]");
            }
            delimMap.put(delimKey, HdfsStorageDescriptor.parseDelim(delimValue));
        }
        return delimMap;
    }

    public static Byte parseDelim(String delimVal) {
        Preconditions.checkNotNull((Object)delimVal);
        try {
            return Byte.parseByte(delimVal);
        }
        catch (NumberFormatException e) {
            int cp;
            if (delimVal.length() == 1 && (cp = Character.codePointAt(delimVal, 0)) >= 0 && cp <= 255) {
                return (byte)cp;
            }
            return null;
        }
    }

    private HdfsStorageDescriptor(String tblName, HdfsFileFormat fileFormat, byte lineDelim, byte fieldDelim, byte collectionDelim, byte mapKeyDelim, byte escapeChar, byte quoteChar, int blockSize, TJsonBinaryFormat jsonBinaryFormat, String encodingValue) {
        this.fileFormat_ = fileFormat;
        this.lineDelim_ = lineDelim;
        this.fieldDelim_ = fieldDelim;
        this.collectionDelim_ = collectionDelim;
        this.mapKeyDelim_ = mapKeyDelim;
        this.quoteChar_ = quoteChar;
        this.blockSize_ = blockSize;
        this.jsonBinaryFormat_ = jsonBinaryFormat;
        this.encodingValue_ = encodingValue;
        if (escapeChar == fieldDelim || escapeChar == lineDelim || escapeChar == collectionDelim) {
            this.escapeChar_ = 0;
            LOG.warn("Escape character for table, " + tblName + " is set to the same character as one of the delimiters.  Ignoring escape character.");
        } else {
            this.escapeChar_ = escapeChar;
        }
    }

    public static HdfsStorageDescriptor fromStorageDescriptor(String tblName, StorageDescriptor sd) throws InvalidStorageDescriptorException {
        String specificFormat;
        Map<String, Byte> delimMap = HdfsStorageDescriptor.extractDelimiters(sd.getSerdeInfo());
        if (!COMPATIBLE_SERDES.contains((Object)sd.getSerdeInfo().getSerializationLib())) {
            throw new InvalidStorageDescriptorException(String.format("Impala does not support tables of this type. REASON: SerDe library '%s' is not supported.", sd.getSerdeInfo().getSerializationLib()));
        }
        Map parameters = sd.getSerdeInfo().getParameters();
        int blockSize = 0;
        String blockValue = (String)parameters.get(BLOCK_SIZE);
        if (blockValue != null) {
            blockSize = Integer.parseInt(blockValue);
        }
        TJsonBinaryFormat jsonBinaryFormat = (specificFormat = (String)parameters.get(JSON_BINARY_FORMAT)) == null ? TJsonBinaryFormat.NONE : ("base64".equalsIgnoreCase(specificFormat) ? TJsonBinaryFormat.BASE64 : ("rawstring".equalsIgnoreCase(specificFormat) ? TJsonBinaryFormat.RAWSTRING : null));
        String encodingValue = (String)parameters.get("serialization.encoding");
        try {
            return (HdfsStorageDescriptor)INTERNER.intern((Object)new HdfsStorageDescriptor(tblName, HdfsFileFormat.fromJavaClassName(sd.getInputFormat(), sd.getSerdeInfo().getSerializationLib()), delimMap.get("line.delim"), delimMap.get("field.delim"), delimMap.get("collection.delim"), delimMap.get("mapkey.delim"), delimMap.get("escape.delim"), delimMap.get("quote.delim"), blockSize, jsonBinaryFormat, encodingValue));
        }
        catch (IllegalArgumentException ex) {
            throw new InvalidStorageDescriptorException(ex);
        }
    }

    public static HdfsStorageDescriptor fromThrift(THdfsStorageDescriptor tDesc, String tableName) {
        return (HdfsStorageDescriptor)INTERNER.intern((Object)new HdfsStorageDescriptor(tableName, HdfsFileFormat.fromThrift(tDesc.getFileFormat()), tDesc.lineDelim, tDesc.fieldDelim, tDesc.collectionDelim, tDesc.mapKeyDelim, tDesc.escapeChar, tDesc.quoteChar, tDesc.blockSize, tDesc.isSetJsonBinaryFormat() ? tDesc.getJsonBinaryFormat() : null, tDesc.encodingValue));
    }

    public THdfsStorageDescriptor toThrift() {
        THdfsStorageDescriptor tHdfsStorageDescriptor = new THdfsStorageDescriptor(this.lineDelim_, this.fieldDelim_, this.collectionDelim_, this.mapKeyDelim_, this.escapeChar_, this.quoteChar_, this.fileFormat_.toThrift(), this.blockSize_);
        if (this.encodingValue_ != null) {
            tHdfsStorageDescriptor.setEncodingValue(this.encodingValue_);
        }
        tHdfsStorageDescriptor.setJsonBinaryFormat(this.jsonBinaryFormat_);
        return tHdfsStorageDescriptor;
    }

    public HdfsStorageDescriptor cloneWithChangedFileFormat(HdfsFileFormat newFormat) {
        return (HdfsStorageDescriptor)INTERNER.intern((Object)new HdfsStorageDescriptor("<unknown>", newFormat, this.lineDelim_, this.fieldDelim_, this.collectionDelim_, this.mapKeyDelim_, this.escapeChar_, this.quoteChar_, this.blockSize_, this.jsonBinaryFormat_, this.encodingValue_));
    }

    public byte getLineDelim() {
        return this.lineDelim_;
    }

    public byte getFieldDelim() {
        return this.fieldDelim_;
    }

    public byte getCollectionDelim() {
        return this.collectionDelim_;
    }

    public byte getMapKeyDelim() {
        return this.mapKeyDelim_;
    }

    public byte getEscapeChar() {
        return this.escapeChar_;
    }

    public HdfsFileFormat getFileFormat() {
        return this.fileFormat_;
    }

    public int getBlockSize() {
        return this.blockSize_;
    }

    public TJsonBinaryFormat getJsonBinaryFormat() {
        return this.jsonBinaryFormat_;
    }

    public String getEncodingValue() {
        return this.encodingValue_;
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.blockSize_, this.collectionDelim_, this.escapeChar_, this.fieldDelim_, this.fileFormat_, this.lineDelim_, this.mapKeyDelim_, this.quoteChar_, this.jsonBinaryFormat_, this.encodingValue_});
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        HdfsStorageDescriptor other = (HdfsStorageDescriptor)obj;
        if (this.blockSize_ != other.blockSize_) {
            return false;
        }
        if (this.collectionDelim_ != other.collectionDelim_) {
            return false;
        }
        if (this.escapeChar_ != other.escapeChar_) {
            return false;
        }
        if (this.fieldDelim_ != other.fieldDelim_) {
            return false;
        }
        if (this.fileFormat_ != other.fileFormat_) {
            return false;
        }
        if (this.lineDelim_ != other.lineDelim_) {
            return false;
        }
        if (this.mapKeyDelim_ != other.mapKeyDelim_) {
            return false;
        }
        if (this.quoteChar_ != other.quoteChar_) {
            return false;
        }
        if (this.jsonBinaryFormat_ != other.jsonBinaryFormat_) {
            return false;
        }
        return this.encodingValue_ == other.encodingValue_;
    }

    public static class InvalidStorageDescriptorException
    extends CatalogException {
        private static final long serialVersionUID = -555234913768134760L;

        public InvalidStorageDescriptorException(String s) {
            super(s);
        }

        public InvalidStorageDescriptorException(Exception ex) {
            super(ex.getMessage(), ex);
        }
    }
}

