/*
 * Decompiled with CFR 0.152.
 */
package org.apache.impala.catalog;

import com.google.common.base.Preconditions;
import java.util.List;
import org.apache.impala.common.Pair;
import org.apache.impala.thrift.THdfsPartitionLocation;
import org.apache.impala.util.ListMap;

public class HdfsPartitionLocationCompressor {
    int numClusteringColumns_;
    private final ListMap<String> prefixMap_ = new ListMap();

    public HdfsPartitionLocationCompressor(int numClusteringColumns) {
        this.numClusteringColumns_ = numClusteringColumns;
    }

    public HdfsPartitionLocationCompressor(int numClusteringColumns, List<String> prefixes) {
        this.numClusteringColumns_ = numClusteringColumns;
        this.prefixMap_.populate(prefixes);
    }

    public void setClusteringColumns(int numClusteringColumns) {
        this.numClusteringColumns_ = numClusteringColumns;
    }

    public List<String> getPrefixes() {
        return this.prefixMap_.getList();
    }

    private String indexToPrefix(int i) {
        if (i == -1) {
            return "";
        }
        Preconditions.checkElementIndex((int)i, (int)this.prefixMap_.size());
        return this.prefixMap_.getEntry(i);
    }

    private int prefixToIndex(String s) {
        return this.prefixMap_.getOrAddIndex(s);
    }

    public class Location {
        private final int prefix_index_;
        private final String suffix_;

        public Location(String location) {
            Preconditions.checkNotNull((Object)location);
            Pair<String, String> locationParts = this.decompose(location);
            this.prefix_index_ = HdfsPartitionLocationCompressor.this.prefixToIndex((String)locationParts.first);
            this.suffix_ = (String)locationParts.second;
        }

        public Location(THdfsPartitionLocation thrift) {
            Preconditions.checkNotNull((Object)thrift);
            this.prefix_index_ = thrift.prefix_index;
            this.suffix_ = thrift.getSuffix();
        }

        public THdfsPartitionLocation toThrift() {
            return new THdfsPartitionLocation(this.prefix_index_, this.suffix_);
        }

        public String toString() {
            return HdfsPartitionLocationCompressor.this.indexToPrefix(this.prefix_index_) + this.suffix_;
        }

        public int hashCode() {
            return this.toString().hashCode();
        }

        public boolean equals(Object obj) {
            return obj instanceof Location && this.toString() == obj.toString();
        }

        private Pair<String, String> decompose(String s) {
            Preconditions.checkNotNull((Object)s);
            int numClusteringColumns = HdfsPartitionLocationCompressor.this.numClusteringColumns_;
            if (numClusteringColumns == 0) {
                return new Pair<String, String>(s, "");
            }
            int i = s.length() - 1;
            if (i >= 0 && s.charAt(i) == '/') {
                --i;
            }
            while (numClusteringColumns > 0 && i >= 0) {
                if (s.charAt(i) == '/') {
                    --numClusteringColumns;
                }
                --i;
            }
            if (0 == numClusteringColumns) {
                ++i;
            }
            return new Pair<String, String>(s.substring(0, i + 1), s.substring(i + 1));
        }
    }
}

