/*
 * Decompiled with CFR 0.152.
 */
package org.apache.impala.catalog;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.MoreObjects;
import com.google.common.base.Preconditions;
import com.google.common.base.Predicate;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.atomic.AtomicLong;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.hive.common.ValidWriteIdList;
import org.apache.hadoop.hive.metastore.api.FieldSchema;
import org.apache.hadoop.hive.metastore.api.Order;
import org.apache.hadoop.hive.metastore.api.Partition;
import org.apache.hadoop.hive.metastore.api.SerDeInfo;
import org.apache.hadoop.hive.metastore.api.StorageDescriptor;
import org.apache.impala.analysis.Expr;
import org.apache.impala.analysis.LiteralExpr;
import org.apache.impala.analysis.PartitionKeyValue;
import org.apache.impala.catalog.CatalogException;
import org.apache.impala.catalog.CatalogInterners;
import org.apache.impala.catalog.CatalogObject;
import org.apache.impala.catalog.CatalogObjectImpl;
import org.apache.impala.catalog.Column;
import org.apache.impala.catalog.FeCatalogUtils;
import org.apache.impala.catalog.FeFsPartition;
import org.apache.impala.catalog.FeFsTable;
import org.apache.impala.catalog.FileDescriptor;
import org.apache.impala.catalog.HdfsFileFormat;
import org.apache.impala.catalog.HdfsPartitionLocationCompressor;
import org.apache.impala.catalog.HdfsStorageDescriptor;
import org.apache.impala.catalog.HdfsTable;
import org.apache.impala.catalog.PartitionStatsUtil;
import org.apache.impala.catalog.events.InFlightEvents;
import org.apache.impala.catalog.events.MetastoreEvents;
import org.apache.impala.common.FileSystemUtil;
import org.apache.impala.common.ImpalaException;
import org.apache.impala.common.Pair;
import org.apache.impala.common.Reference;
import org.apache.impala.compat.MetastoreShim;
import org.apache.impala.thrift.TAccessLevel;
import org.apache.impala.thrift.TCatalogObject;
import org.apache.impala.thrift.TCatalogObjectType;
import org.apache.impala.thrift.TExpr;
import org.apache.impala.thrift.TExprNode;
import org.apache.impala.thrift.TGetPartialCatalogObjectRequest;
import org.apache.impala.thrift.THdfsFileDesc;
import org.apache.impala.thrift.THdfsPartition;
import org.apache.impala.thrift.THdfsPartitionLocation;
import org.apache.impala.thrift.TNetworkAddress;
import org.apache.impala.thrift.TPartialPartitionInfo;
import org.apache.impala.thrift.TPartitionStats;
import org.apache.impala.util.AcidUtils;
import org.apache.impala.util.HdfsCachingUtil;
import org.apache.impala.util.ListMap;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class HdfsPartition
extends CatalogObjectImpl
implements FeFsPartition {
    private static final Logger LOG = LoggerFactory.getLogger(HdfsPartition.class);
    private static Predicate<String> IS_INCREMENTAL_STATS_KEY = new Predicate<String>(){

        public boolean apply(String key) {
            return key.startsWith("impala_intermediate_stats_num_chunks") || key.startsWith("impala_intermediate_stats_chunk");
        }
    };
    public static final long INITIAL_PARTITION_ID = 0L;
    private static final AtomicLong partitionIdCounter_ = new AtomicLong();
    private final HdfsTable table_;
    private final ImmutableList<LiteralExpr> partitionKeyValues_;
    private final String partName_;
    private final long numRows_;
    private final long id_;
    private final long prevId_;
    private final HdfsStorageDescriptor fileFormatDescriptor_;
    @Nonnull
    private final ImmutableList<byte[]> encodedFileDescriptors_;
    private final ImmutableList<byte[]> encodedInsertFileDescriptors_;
    private final ImmutableList<byte[]> encodedDeleteFileDescriptors_;
    private final HdfsPartitionLocationCompressor.Location location_;
    private final boolean isMarkedCached_;
    private final TAccessLevel accessLevel_;
    private final ImmutableMap<String, String> hmsParameters_;
    private final CachedHmsPartitionDescriptor cachedMsPartitionDescriptor_;
    private final byte[] partitionStats_;
    private final boolean hasIncrementalStats_;
    private final long writeId_;
    private final InFlightEvents inFlightEvents_;
    private final long createEventId_;
    private final long lastCompactionId_;
    private final long lastRefreshEventId_;
    private final FeFsTable.FileMetadataStats fileMetadataStats_;
    public static final KeyValueComparator KV_COMPARATOR = new KeyValueComparator();

    protected HdfsPartition(HdfsTable table, long prevId, String partName, List<LiteralExpr> partitionKeyValues, HdfsStorageDescriptor fileFormatDescriptor, @Nonnull ImmutableList<byte[]> encodedFileDescriptors, ImmutableList<byte[]> encodedInsertFileDescriptors, ImmutableList<byte[]> encodedDeleteFileDescriptors, HdfsPartitionLocationCompressor.Location location, boolean isMarkedCached, TAccessLevel accessLevel, Map<String, String> hmsParameters, CachedHmsPartitionDescriptor cachedMsPartitionDescriptor, byte[] partitionStats, boolean hasIncrementalStats, long numRows, long writeId, InFlightEvents inFlightEvents) {
        this(table, partitionIdCounter_.getAndIncrement(), prevId, partName, partitionKeyValues, fileFormatDescriptor, encodedFileDescriptors, encodedInsertFileDescriptors, encodedDeleteFileDescriptors, location, isMarkedCached, accessLevel, hmsParameters, cachedMsPartitionDescriptor, partitionStats, hasIncrementalStats, numRows, writeId, inFlightEvents, -1L, -1L, -1L, new FeFsTable.FileMetadataStats());
    }

    protected HdfsPartition(HdfsTable table, long id, long prevId, String partName, List<LiteralExpr> partitionKeyValues, HdfsStorageDescriptor fileFormatDescriptor, @Nonnull ImmutableList<byte[]> encodedFileDescriptors, ImmutableList<byte[]> encodedInsertFileDescriptors, ImmutableList<byte[]> encodedDeleteFileDescriptors, HdfsPartitionLocationCompressor.Location location, boolean isMarkedCached, TAccessLevel accessLevel, Map<String, String> hmsParameters, CachedHmsPartitionDescriptor cachedMsPartitionDescriptor, byte[] partitionStats, boolean hasIncrementalStats, long numRows, long writeId, InFlightEvents inFlightEvents, long createEventId, long lastCompactionId) {
        this(table, partitionIdCounter_.getAndIncrement(), prevId, partName, partitionKeyValues, fileFormatDescriptor, encodedFileDescriptors, encodedInsertFileDescriptors, encodedDeleteFileDescriptors, location, isMarkedCached, accessLevel, hmsParameters, cachedMsPartitionDescriptor, partitionStats, hasIncrementalStats, numRows, writeId, inFlightEvents, -1L, -1L, -1L, new FeFsTable.FileMetadataStats());
    }

    protected HdfsPartition(HdfsTable table, long id, long prevId, String partName, List<LiteralExpr> partitionKeyValues, HdfsStorageDescriptor fileFormatDescriptor, @Nonnull ImmutableList<byte[]> encodedFileDescriptors, ImmutableList<byte[]> encodedInsertFileDescriptors, ImmutableList<byte[]> encodedDeleteFileDescriptors, HdfsPartitionLocationCompressor.Location location, boolean isMarkedCached, TAccessLevel accessLevel, Map<String, String> hmsParameters, CachedHmsPartitionDescriptor cachedMsPartitionDescriptor, byte[] partitionStats, boolean hasIncrementalStats, long numRows, long writeId, InFlightEvents inFlightEvents, long createEventId, long lastCompactionId, FeFsTable.FileMetadataStats fileMetadataStats) {
        this(table, partitionIdCounter_.getAndIncrement(), prevId, partName, partitionKeyValues, fileFormatDescriptor, encodedFileDescriptors, encodedInsertFileDescriptors, encodedDeleteFileDescriptors, location, isMarkedCached, accessLevel, hmsParameters, cachedMsPartitionDescriptor, partitionStats, hasIncrementalStats, numRows, writeId, inFlightEvents, -1L, -1L, -1L, fileMetadataStats);
    }

    protected HdfsPartition(HdfsTable table, long id, long prevId, String partName, List<LiteralExpr> partitionKeyValues, HdfsStorageDescriptor fileFormatDescriptor, @Nonnull ImmutableList<byte[]> encodedFileDescriptors, ImmutableList<byte[]> encodedInsertFileDescriptors, ImmutableList<byte[]> encodedDeleteFileDescriptors, HdfsPartitionLocationCompressor.Location location, boolean isMarkedCached, TAccessLevel accessLevel, Map<String, String> hmsParameters, CachedHmsPartitionDescriptor cachedMsPartitionDescriptor, byte[] partitionStats, boolean hasIncrementalStats, long numRows, long writeId, InFlightEvents inFlightEvents, long createEventId, long lastCompactionId, long lastRefreshEventId, FeFsTable.FileMetadataStats fileMetadataStats) {
        Preconditions.checkArgument((fileMetadataStats != null ? 1 : 0) != 0);
        this.table_ = table;
        this.id_ = id;
        this.prevId_ = prevId;
        this.partitionKeyValues_ = ImmutableList.copyOf(partitionKeyValues);
        this.fileFormatDescriptor_ = fileFormatDescriptor;
        this.encodedFileDescriptors_ = encodedFileDescriptors;
        this.encodedInsertFileDescriptors_ = encodedInsertFileDescriptors;
        this.encodedDeleteFileDescriptors_ = encodedDeleteFileDescriptors;
        this.location_ = location;
        this.isMarkedCached_ = isMarkedCached;
        this.accessLevel_ = accessLevel;
        this.hmsParameters_ = ImmutableMap.copyOf(hmsParameters);
        this.cachedMsPartitionDescriptor_ = cachedMsPartitionDescriptor;
        this.partitionStats_ = partitionStats;
        this.hasIncrementalStats_ = hasIncrementalStats;
        this.numRows_ = numRows;
        this.writeId_ = writeId;
        this.inFlightEvents_ = inFlightEvents;
        this.createEventId_ = createEventId;
        this.lastCompactionId_ = lastCompactionId;
        this.lastRefreshEventId_ = lastRefreshEventId;
        this.partName_ = partName == null && this.id_ != -1L ? FeCatalogUtils.getPartitionName(this) : partName;
        this.fileMetadataStats_ = fileMetadataStats;
    }

    public long getCreateEventId() {
        return this.createEventId_;
    }

    public long getLastRefreshEventId() {
        return this.lastRefreshEventId_;
    }

    @Override
    public HdfsStorageDescriptor getInputFormatDescriptor() {
        return this.fileFormatDescriptor_;
    }

    @Override
    public boolean isCacheable() {
        return FileSystemUtil.isPathCacheable(new Path(this.getLocation()));
    }

    @Override
    public String getPartitionName() {
        return this.partName_;
    }

    public String getValuesAsString() {
        StringBuilder partDescription = new StringBuilder();
        for (int i = 0; i < this.getTable().getNumClusteringCols(); ++i) {
            String columnName = this.getTable().getColumns().get(i).getName();
            String value = PartitionKeyValue.getPartitionKeyValueString(this.getPartitionValues().get(i), this.getTable().getNullPartitionKeyValue());
            partDescription.append(columnName + "=" + value);
            if (i == this.getTable().getNumClusteringCols() - 1) continue;
            partDescription.append("/");
        }
        return partDescription.toString();
    }

    @Override
    public String getLocation() {
        return this.location_ != null ? this.location_.toString() : null;
    }

    @Override
    public THdfsPartitionLocation getLocationAsThrift() {
        return this.location_ != null ? this.location_.toThrift() : null;
    }

    @Override
    public Path getLocationPath() {
        Preconditions.checkNotNull((Object)this.getLocation(), (Object)"HdfsPartition location is null");
        return new Path(this.getLocation());
    }

    @Override
    public long getId() {
        return this.id_;
    }

    @Override
    public HdfsTable getTable() {
        return this.table_;
    }

    @Override
    public ListMap<TNetworkAddress> getHostIndex() {
        return this.table_.getHostIndex();
    }

    @Override
    public FileSystemUtil.FsType getFsType() {
        Path location = this.getLocationPath();
        Preconditions.checkNotNull((Object)location.toUri().getScheme(), (Object)("Cannot get scheme from path " + location));
        return FileSystemUtil.FsType.getFsType(location.toUri().getScheme());
    }

    @Override
    public long getNumRows() {
        return this.numRows_;
    }

    @Override
    public boolean isMarkedCached() {
        return this.isMarkedCached_;
    }

    @Override
    public HdfsFileFormat getFileFormat() {
        return this.fileFormatDescriptor_.getFileFormat();
    }

    @Override
    public TPartitionStats getPartitionStats() {
        return PartitionStatsUtil.getPartStatsOrWarn(this);
    }

    @Override
    public byte[] getPartitionStatsCompressed() {
        return this.partitionStats_;
    }

    @Override
    public boolean hasIncrementalStats() {
        return this.hasIncrementalStats_;
    }

    @Override
    public TAccessLevel getAccessLevel() {
        return this.accessLevel_;
    }

    @Override
    public Map<String, String> getParameters() {
        Preconditions.checkState((boolean)Maps.filterKeys(this.hmsParameters_, IS_INCREMENTAL_STATS_KEY).isEmpty());
        return this.hmsParameters_;
    }

    public boolean removeFromVersionsForInflightEvents(boolean isInsertEvent, long versionNumber) {
        Preconditions.checkState((boolean)this.table_.isWriteLockedByCurrentThread(), (Object)("removeFromVersionsForInflightEvents called without holding the table lock on partition " + this.getPartitionName() + " of table " + this.table_.getFullName()));
        boolean ret = this.inFlightEvents_.remove(isInsertEvent, versionNumber);
        if (!ret) {
            LOG.trace("Failed to remove in-flight version number {}: in-flight events: {}", (Object)versionNumber, (Object)this.inFlightEvents_.print());
        }
        return ret;
    }

    public void addToVersionsForInflightEvents(boolean isInsertEvent, long versionNumber) {
        Preconditions.checkState((boolean)this.table_.isWriteLockedByCurrentThread(), (Object)("addToVersionsForInflightEvents called without holding the table lock on partition " + this.getPartitionName() + " of table " + this.table_.getFullName()));
        boolean added = this.inFlightEvents_.add(isInsertEvent, versionNumber);
        if (!added) {
            LOG.warn(String.format("Could not add %s version to the partition %s of table %s. This could cause unnecessary refresh of the partition when the event isreceived by the Events processor.", versionNumber, this.getPartitionName(), this.getTable().getFullName()));
        }
        LOG.trace("{} {} to in-flight list {}", new Object[]{added ? "Added" : "Could not add", versionNumber, this.inFlightEvents_.print()});
    }

    @Override
    public List<LiteralExpr> getPartitionValues() {
        return this.partitionKeyValues_;
    }

    @Override
    public LiteralExpr getPartitionValue(int i) {
        return (LiteralExpr)this.partitionKeyValues_.get(i);
    }

    @Override
    public List<FileDescriptor> getFileDescriptors() {
        ArrayList<FileDescriptor> ret = new ArrayList<FileDescriptor>();
        ret.addAll(Lists.transform(this.encodedFileDescriptors_, FileDescriptor.FROM_BYTES));
        ret.addAll(Lists.transform(this.encodedInsertFileDescriptors_, FileDescriptor.FROM_BYTES));
        ret.addAll(Lists.transform(this.encodedDeleteFileDescriptors_, FileDescriptor.FROM_BYTES));
        return ret;
    }

    @Override
    public List<FileDescriptor> getInsertFileDescriptors() {
        return Lists.transform(this.encodedInsertFileDescriptors_, FileDescriptor.FROM_BYTES);
    }

    @Override
    public List<FileDescriptor> getDeleteFileDescriptors() {
        return Lists.transform(this.encodedDeleteFileDescriptors_, FileDescriptor.FROM_BYTES);
    }

    public long getLastCompactionId() {
        return this.lastCompactionId_;
    }

    public Set<String> getFileNames() {
        List<FileDescriptor> fdList = this.getFileDescriptors();
        HashSet<String> fileNames = new HashSet<String>(fdList.size());
        for (FileDescriptor fd : fdList) {
            fileNames.add(fd.getAbsolutePath(this.getLocation()));
        }
        return fileNames;
    }

    @Override
    public int getNumFileDescriptors() {
        return this.encodedFileDescriptors_.size() + this.encodedInsertFileDescriptors_.size() + this.encodedDeleteFileDescriptors_.size();
    }

    public static int getNumFds(TPartialPartitionInfo partInfo) {
        return partInfo.getFile_descriptorsSize() + partInfo.getInsert_file_descriptorsSize() + partInfo.getDelete_file_descriptorsSize();
    }

    public Pair<TPartialPartitionInfo, Integer> getPartialPartitionInfo(TGetPartialCatalogObjectRequest req, ValidWriteIdList reqWriteIdList) {
        TPartialPartitionInfo partInfo = FeFsPartition.super.getDefaultPartialPartitionInfo(req);
        if (req.table_info_selector.want_hms_partition) {
            partInfo.hms_partition = this.toHmsPartition();
        }
        if (req.table_info_selector.want_partition_metadata && this.table_.isPartitioned() && this.id_ != -1L) {
            partInfo.hms_parameters = this.getParameters();
            partInfo.write_id = this.writeId_;
            partInfo.hdfs_storage_descriptor = this.fileFormatDescriptor_.toThrift();
            partInfo.location = this.getLocationAsThrift();
        }
        int numFilesFiltered = 0;
        if (req.table_info_selector.want_partition_files) {
            partInfo.setLast_compaction_id(this.getLastCompactionId());
            if (this.table_.isHiveAcid()) {
                try {
                    if (!this.getInsertFileDescriptors().isEmpty()) {
                        numFilesFiltered += this.addFilteredFds(this.getInsertFileDescriptors(), partInfo.insert_file_descriptors, reqWriteIdList);
                        numFilesFiltered += this.addFilteredFds(this.getDeleteFileDescriptors(), partInfo.delete_file_descriptors, reqWriteIdList);
                    } else {
                        numFilesFiltered += this.addFilteredFds(this.getFileDescriptors(), partInfo.file_descriptors, reqWriteIdList);
                    }
                }
                catch (CatalogException ex) {
                    if (LOG.isDebugEnabled()) {
                        LOG.debug("Could not use cached file descriptors of partition {} of table {} for writeIdList {}", new Object[]{this.getPartitionName(), this.getTable().getFullName(), reqWriteIdList, ex});
                    }
                    return new Pair<TPartialPartitionInfo, Object>(partInfo, null);
                }
            }
        }
        return new Pair<TPartialPartitionInfo, Integer>(partInfo, numFilesFiltered);
    }

    private int addFilteredFds(List<FileDescriptor> fds, List<THdfsFileDesc> thriftFds, ValidWriteIdList writeIdList) throws CatalogException {
        ArrayList<FileDescriptor> filteredFds = new ArrayList<FileDescriptor>(fds);
        int numFilesFiltered = AcidUtils.filterFdsForAcidState(filteredFds, writeIdList);
        for (FileDescriptor fd : filteredFds) {
            thriftFds.add(fd.toThrift());
        }
        return numFilesFiltered;
    }

    public FeFsTable.FileMetadataStats getFileMetadataStats() {
        return this.fileMetadataStats_;
    }

    @Override
    public boolean hasFileDescriptors() {
        return !this.encodedFileDescriptors_.isEmpty() || !this.encodedInsertFileDescriptors_.isEmpty();
    }

    public CachedHmsPartitionDescriptor getCachedMsPartitionDescriptor() {
        return this.cachedMsPartitionDescriptor_;
    }

    public Partition toHmsPartition() {
        StorageDescriptor storageDescriptor = this.getStorageDescriptor();
        if (storageDescriptor == null) {
            return null;
        }
        HashMap hmsParams = Maps.newHashMap(this.getParameters());
        PartitionStatsUtil.partStatsToParams(this, hmsParams);
        Partition partition = new Partition(this.getPartitionValuesAsStrings(true), this.getTable().getDb().getName(), this.getTable().getName(), this.cachedMsPartitionDescriptor_.msCreateTime, this.cachedMsPartitionDescriptor_.msLastAccessTime, storageDescriptor, (Map)hmsParams);
        return partition;
    }

    public StorageDescriptor getStorageDescriptor() {
        if (this.cachedMsPartitionDescriptor_ == null) {
            return null;
        }
        Preconditions.checkNotNull(this.table_.getNonPartitionFieldSchemas());
        StorageDescriptor storageDescriptor = new StorageDescriptor(new ArrayList<FieldSchema>(this.table_.getNonPartitionFieldSchemas()), this.getLocation(), this.cachedMsPartitionDescriptor_.sdInputFormat, this.cachedMsPartitionDescriptor_.sdOutputFormat, this.cachedMsPartitionDescriptor_.sdCompressed, this.cachedMsPartitionDescriptor_.sdNumBuckets, this.cachedMsPartitionDescriptor_.sdSerdeInfo, this.cachedMsPartitionDescriptor_.sdBucketCols, this.cachedMsPartitionDescriptor_.sdSortCols, this.cachedMsPartitionDescriptor_.sdParameters);
        return storageDescriptor;
    }

    public boolean compareSd(StorageDescriptor hmsSd) {
        Preconditions.checkNotNull((Object)hmsSd);
        StorageDescriptor sd = this.getStorageDescriptor();
        if (sd == null) {
            return false;
        }
        if (!sd.getCols().equals(hmsSd.getCols())) {
            return false;
        }
        if (!sd.getLocation().equals(hmsSd.getLocation())) {
            return false;
        }
        if (!sd.getInputFormat().equals(hmsSd.getInputFormat())) {
            return false;
        }
        if (!sd.getOutputFormat().equals(hmsSd.getOutputFormat())) {
            return false;
        }
        if (sd.isCompressed() != hmsSd.isCompressed()) {
            return false;
        }
        if (sd.getNumBuckets() != hmsSd.getNumBuckets()) {
            return false;
        }
        if (!sd.getSerdeInfo().equals(hmsSd.getSerdeInfo())) {
            return false;
        }
        if (!sd.getBucketCols().equals(hmsSd.getBucketCols())) {
            return false;
        }
        if (!sd.getSortCols().equals(hmsSd.getSortCols())) {
            return false;
        }
        return sd.getParameters().equals(hmsSd.getParameters());
    }

    public static HdfsPartition prototypePartition(HdfsTable table, HdfsStorageDescriptor storageDescriptor) {
        return new Builder(table, -1L).setFileFormatDescriptor(storageDescriptor).build();
    }

    @Override
    public long getSize() {
        if (this.fileMetadataStats_.numFiles > 0L) {
            return this.fileMetadataStats_.totalFileBytes;
        }
        long result = 0L;
        for (FileDescriptor fileDescriptor : this.getFileDescriptors()) {
            result += fileDescriptor.getFileLength();
        }
        return result;
    }

    @Override
    public long getWriteId() {
        return this.writeId_;
    }

    @Override
    public HdfsPartition genInsertDeltaPartition() {
        ImmutableList<byte[]> fileDescriptors = !this.encodedInsertFileDescriptors_.isEmpty() ? this.encodedInsertFileDescriptors_ : this.encodedFileDescriptors_;
        return new Builder(this).setId(this.id_).clearFileDescriptors().setFileDescriptors(fileDescriptors).build();
    }

    @Override
    public HdfsPartition genDeleteDeltaPartition() {
        if (this.encodedDeleteFileDescriptors_.isEmpty()) {
            return null;
        }
        return new Builder(this).setId(this.id_).clearFileDescriptors().setFileDescriptors(this.encodedDeleteFileDescriptors_).build();
    }

    public String toString() {
        return MoreObjects.toStringHelper((Object)this).add("fileDescriptors", this.getFileDescriptors()).toString();
    }

    @Override
    public final long getCatalogVersion() {
        throw new UnsupportedOperationException("Catalog version of the partition should not be used");
    }

    @Override
    public final void setCatalogVersion(long version) {
        throw new UnsupportedOperationException("Catalog version of the partition should not be set");
    }

    @Override
    protected void setTCatalogObject(TCatalogObject catalogObject) {
        catalogObject.setHdfs_partition(FeCatalogUtils.fsPartitionToThrift(this, CatalogObject.ThriftObjectType.FULL));
        catalogObject.getHdfs_partition().setDb_name(this.table_.getDb().getName());
        catalogObject.getHdfs_partition().setTbl_name(this.table_.getName());
        catalogObject.getHdfs_partition().setPartition_name(this.partName_);
        catalogObject.getHdfs_partition().setId(this.id_);
        if (this.prevId_ != -1L) {
            catalogObject.getHdfs_partition().setPrev_id(this.prevId_);
        }
    }

    @Override
    public TCatalogObjectType getCatalogObjectType() {
        return TCatalogObjectType.HDFS_PARTITION;
    }

    public TCatalogObject toMinimalTCatalogObject() {
        TCatalogObject catalogPart = new TCatalogObject(TCatalogObjectType.HDFS_PARTITION, this.table_.getCatalogVersion());
        catalogPart.setHdfs_partition(this.toMinimalTHdfsPartition());
        return catalogPart;
    }

    public THdfsPartition toMinimalTHdfsPartition() {
        THdfsPartition part = new THdfsPartition();
        part.setDb_name(this.table_.getDb().getName());
        part.setTbl_name(this.table_.getName());
        part.setPartition_name(this.partName_);
        part.setId(this.id_);
        if (this.prevId_ != -1L) {
            part.setPrev_id(this.prevId_);
        }
        return part;
    }

    public HdfsPartition genMinimalPartition() {
        return new Builder(this.table_, this.id_).setPartitionName(this.partName_).setIsMinimalMode(true).build();
    }

    protected HdfsPartitionLocationCompressor.Location getLocationStruct() {
        return this.location_;
    }

    @VisibleForTesting
    public static int comparePartitionKeyValues(List<LiteralExpr> lhs, List<LiteralExpr> rhs) {
        int sizeDiff = lhs.size() - rhs.size();
        if (sizeDiff != 0) {
            return sizeDiff;
        }
        for (int i = 0; i < lhs.size(); ++i) {
            int cmp = lhs.get(i).compareTo(rhs.get(i));
            if (cmp == 0) continue;
            return cmp;
        }
        return 0;
    }

    public static class KeyValueComparator
    implements Comparator<FeFsPartition> {
        @Override
        public int compare(FeFsPartition o1, FeFsPartition o2) {
            return HdfsPartition.comparePartitionKeyValues(o1.getPartitionValues(), o2.getPartitionValues());
        }
    }

    public static class Builder {
        private HdfsTable table_;
        private long id_;
        private long prevId_ = -1L;
        private String partName_ = null;
        private List<LiteralExpr> partitionKeyValues_;
        private HdfsStorageDescriptor fileFormatDescriptor_ = null;
        private ImmutableList<byte[]> encodedFileDescriptors_;
        private ImmutableList<byte[]> encodedInsertFileDescriptors_;
        private ImmutableList<byte[]> encodedDeleteFileDescriptors_;
        private HdfsPartitionLocationCompressor.Location location_ = null;
        private boolean isMarkedCached_ = false;
        private TAccessLevel accessLevel_ = TAccessLevel.READ_WRITE;
        private Map<String, String> hmsParameters_;
        private CachedHmsPartitionDescriptor cachedMsPartitionDescriptor_;
        private byte[] partitionStats_ = null;
        private boolean hasIncrementalStats_ = false;
        private long numRows_ = -1L;
        private long writeId_ = -1L;
        private long createEventId_ = -1L;
        private long lastCompactionId_ = -1L;
        private long lastRefreshEventId_ = -1L;
        private InFlightEvents inFlightEvents_ = new InFlightEvents();
        private FeFsTable.FileMetadataStats fileMetadataStats_ = new FeFsTable.FileMetadataStats();
        @Nullable
        private HdfsPartition oldInstance_ = null;
        private boolean isMinimalMode_ = false;

        public Builder(HdfsTable table, long id) {
            Preconditions.checkNotNull((Object)table);
            this.table_ = table;
            this.id_ = id;
        }

        public Builder(HdfsTable table) {
            this(table, partitionIdCounter_.getAndIncrement());
        }

        public Builder(HdfsPartition partition) {
            this(partition.table_);
            this.oldInstance_ = partition;
            this.prevId_ = this.oldInstance_.id_;
            this.copyFromPartition(partition);
        }

        public Builder copyFromPartition(HdfsPartition partition) {
            this.partitionKeyValues_ = partition.partitionKeyValues_;
            this.fileFormatDescriptor_ = partition.fileFormatDescriptor_;
            this.setFileDescriptors(partition);
            this.location_ = partition.location_;
            this.isMarkedCached_ = partition.isMarkedCached_;
            this.accessLevel_ = partition.accessLevel_;
            this.hmsParameters_ = Maps.newHashMap((Map)partition.hmsParameters_);
            this.partitionStats_ = partition.partitionStats_;
            this.hasIncrementalStats_ = partition.hasIncrementalStats_;
            this.numRows_ = partition.numRows_;
            this.writeId_ = partition.writeId_;
            if (partition.cachedMsPartitionDescriptor_ != null) {
                this.cachedMsPartitionDescriptor_ = new CachedHmsPartitionDescriptor(partition.cachedMsPartitionDescriptor_);
            }
            this.inFlightEvents_ = partition.inFlightEvents_;
            this.createEventId_ = partition.createEventId_;
            this.lastCompactionId_ = partition.lastCompactionId_;
            this.lastRefreshEventId_ = partition.lastRefreshEventId_;
            return this;
        }

        public HdfsPartition build() {
            if (this.partitionKeyValues_ == null) {
                this.partitionKeyValues_ = Collections.emptyList();
            }
            if (this.encodedFileDescriptors_ == null) {
                this.setFileDescriptors(Collections.emptyList());
            }
            if (this.encodedInsertFileDescriptors_ == null) {
                this.setInsertFileDescriptors(Collections.emptyList());
            }
            if (this.encodedDeleteFileDescriptors_ == null) {
                this.setDeleteFileDescriptors(Collections.emptyList());
            }
            if (this.hmsParameters_ == null) {
                this.hmsParameters_ = Collections.emptyMap();
            }
            if (this.location_ == null) {
                Preconditions.checkState((this.id_ == -1L || this.isMinimalMode_ ? 1 : 0) != 0);
            }
            return new HdfsPartition(this.table_, this.id_, this.prevId_, this.partName_, this.partitionKeyValues_, this.fileFormatDescriptor_, this.encodedFileDescriptors_, this.encodedInsertFileDescriptors_, this.encodedDeleteFileDescriptors_, this.location_, this.isMarkedCached_, this.accessLevel_, this.hmsParameters_, this.cachedMsPartitionDescriptor_, this.partitionStats_, this.hasIncrementalStats_, this.numRows_, this.writeId_, this.inFlightEvents_, this.createEventId_, this.lastCompactionId_, this.lastRefreshEventId_, this.fileMetadataStats_);
        }

        public Builder setId(long id) {
            this.id_ = id;
            return this;
        }

        public Builder setCreateEventId(long eventId) {
            this.createEventId_ = eventId;
            return this;
        }

        public Builder setLastRefreshEventId(long eventId) {
            this.lastRefreshEventId_ = eventId;
            return this;
        }

        public Builder setPrevId(long prevId) {
            this.prevId_ = prevId;
            return this;
        }

        public Builder setPartitionName(String partName) {
            this.partName_ = partName;
            return this;
        }

        public Builder setIsMinimalMode(boolean isMinimalMode) {
            this.isMinimalMode_ = isMinimalMode;
            return this;
        }

        public Builder setMsPartition(Partition msPartition) throws CatalogException {
            if (msPartition == null) {
                this.setLocation(this.table_.getLocation());
                this.cachedMsPartitionDescriptor_ = null;
                this.hmsParameters_ = Collections.emptyMap();
                this.partitionKeyValues_ = Collections.emptyList();
                return this;
            }
            this.setPartitionKeyValues(FeCatalogUtils.parsePartitionKeyValues(this.table_, msPartition.getValues()));
            this.setLocation(msPartition.getSd().getLocation());
            this.cachedMsPartitionDescriptor_ = new CachedHmsPartitionDescriptor(msPartition);
            if (msPartition.getParameters() != null) {
                this.isMarkedCached_ = HdfsCachingUtil.getCacheDirectiveId(msPartition.getParameters()) != null;
                this.numRows_ = FeCatalogUtils.getRowCount(msPartition.getParameters());
                if (this.table_.getDebugMetadataScale() > -1.0 && this.numRows_ > 0L) {
                    this.numRows_ = (long)((double)this.numRows_ * this.table_.getDebugMetadataScale());
                }
                this.hmsParameters_ = msPartition.getParameters();
                this.extractAndCompressPartStats();
                this.hmsParameters_ = CatalogInterners.internParameters(this.hmsParameters_);
            }
            if (MetastoreShim.getMajorVersion() > 2L) {
                this.writeId_ = MetastoreShim.getWriteIdFromMSPartition(msPartition);
            }
            if (this.oldInstance_ == null) {
                this.addInflightVersionsFromParameters();
            }
            return this;
        }

        private void extractAndCompressPartStats() {
            try {
                Reference<Boolean> hasIncrStats = new Reference<Boolean>(false);
                byte[] partitionStats = PartitionStatsUtil.partStatsBytesFromParameters(this.hmsParameters_, hasIncrStats);
                this.setPartitionStatsBytes(partitionStats, hasIncrStats.getRef());
            }
            catch (ImpalaException e) {
                LOG.warn(String.format("Failed to set partition stats for table %s partition %s", this.getTable().getFullName(), this.getPartitionName()), (Throwable)e);
            }
            finally {
                Maps.filterKeys(this.hmsParameters_, (Predicate)IS_INCREMENTAL_STATS_KEY).clear();
            }
        }

        public Builder setFileFormat(HdfsFileFormat fileFormat) {
            Preconditions.checkNotNull((Object)this.fileFormatDescriptor_);
            Preconditions.checkNotNull((Object)this.cachedMsPartitionDescriptor_);
            this.fileFormatDescriptor_ = this.fileFormatDescriptor_.cloneWithChangedFileFormat(fileFormat);
            this.cachedMsPartitionDescriptor_.sdInputFormat = fileFormat.inputFormat();
            this.cachedMsPartitionDescriptor_.sdOutputFormat = fileFormat.outputFormat();
            this.cachedMsPartitionDescriptor_.sdSerdeInfo.setSerializationLib(this.fileFormatDescriptor_.getFileFormat().serializationLib());
            return this;
        }

        public void putToParameters(Pair<String, String> kv) {
            this.putToParameters((String)kv.first, (String)kv.second);
        }

        public void putToParameters(String k, String v) {
            Preconditions.checkArgument((!IS_INCREMENTAL_STATS_KEY.apply((Object)k) ? 1 : 0) != 0);
            Preconditions.checkNotNull(this.hmsParameters_);
            this.hmsParameters_.put(k, v);
        }

        public Map<String, String> getParameters() {
            return this.hmsParameters_;
        }

        public SerDeInfo getSerdeInfo() {
            Preconditions.checkNotNull((Object)this.cachedMsPartitionDescriptor_);
            return this.cachedMsPartitionDescriptor_.sdSerdeInfo;
        }

        public Builder setFileFormatDescriptor(HdfsStorageDescriptor fileFormatDescriptor) {
            this.fileFormatDescriptor_ = fileFormatDescriptor;
            return this;
        }

        public Builder setPartitionKeyValues(List<LiteralExpr> partitionKeyValues) {
            this.partitionKeyValues_ = partitionKeyValues;
            return this;
        }

        public Builder setAccessLevel(TAccessLevel accessLevel) {
            this.accessLevel_ = accessLevel;
            return this;
        }

        public Builder setNumRows(long numRows) {
            this.numRows_ = numRows;
            return this;
        }

        public Builder setRowCountParam(long numRows) {
            this.numRows_ = numRows;
            this.putToParameters("numRows", String.valueOf(numRows));
            return this;
        }

        public Builder removeRowCountParam() {
            this.numRows_ = -1L;
            this.getParameters().remove("numRows");
            return this;
        }

        public Builder dropPartitionStats() {
            return this.setPartitionStatsBytes(null, false);
        }

        public Builder setPartitionStatsBytes(byte[] partitionStats, boolean hasIncrStats) {
            if (hasIncrStats) {
                Preconditions.checkNotNull((Object)partitionStats);
            }
            this.partitionStats_ = partitionStats;
            this.hasIncrementalStats_ = hasIncrStats;
            return this;
        }

        public Builder setLocation(HdfsPartitionLocationCompressor.Location location) {
            this.location_ = location;
            return this;
        }

        public Builder setLocation(String place) {
            HdfsPartitionLocationCompressor hdfsPartitionLocationCompressor = this.table_.getPartitionLocationCompressor();
            hdfsPartitionLocationCompressor.getClass();
            this.location_ = new HdfsPartitionLocationCompressor.Location(hdfsPartitionLocationCompressor, place);
            return this;
        }

        public String getLocation() {
            return this.location_ != null ? this.location_.toString() : null;
        }

        public List<FileDescriptor> getFileDescriptors() {
            if (this.encodedFileDescriptors_ == null) {
                this.setFileDescriptors(new ArrayList<FileDescriptor>());
            }
            return Lists.transform(this.encodedFileDescriptors_, FileDescriptor.FROM_BYTES);
        }

        public List<FileDescriptor> getInsertFileDescriptors() {
            if (this.encodedInsertFileDescriptors_ == null) {
                this.setFileDescriptors(new ArrayList<FileDescriptor>());
            }
            return Lists.transform(this.encodedInsertFileDescriptors_, FileDescriptor.FROM_BYTES);
        }

        public List<FileDescriptor> getDeleteFileDescriptors() {
            if (this.encodedDeleteFileDescriptors_ == null) {
                this.setFileDescriptors(new ArrayList<FileDescriptor>());
            }
            return Lists.transform(this.encodedDeleteFileDescriptors_, FileDescriptor.FROM_BYTES);
        }

        public Builder clearFileDescriptors() {
            this.encodedFileDescriptors_ = ImmutableList.of();
            this.encodedInsertFileDescriptors_ = ImmutableList.of();
            this.encodedDeleteFileDescriptors_ = ImmutableList.of();
            return this;
        }

        public Builder setFileDescriptors(List<FileDescriptor> descriptors) {
            this.encodedFileDescriptors_ = ImmutableList.copyOf((Collection)Lists.transform(descriptors, FileDescriptor.TO_BYTES));
            return this;
        }

        public Builder setFileDescriptors(HdfsPartition partition) {
            this.fileMetadataStats_.set(partition.getFileMetadataStats());
            this.encodedFileDescriptors_ = partition.encodedFileDescriptors_;
            this.encodedInsertFileDescriptors_ = partition.encodedInsertFileDescriptors_;
            this.encodedDeleteFileDescriptors_ = partition.encodedDeleteFileDescriptors_;
            return this;
        }

        public Builder setInsertFileDescriptors(List<FileDescriptor> descriptors) {
            this.encodedInsertFileDescriptors_ = ImmutableList.copyOf((Collection)Lists.transform(descriptors, FileDescriptor.TO_BYTES));
            return this;
        }

        public Builder setDeleteFileDescriptors(List<FileDescriptor> descriptors) {
            this.encodedDeleteFileDescriptors_ = ImmutableList.copyOf((Collection)Lists.transform(descriptors, FileDescriptor.TO_BYTES));
            return this;
        }

        public Builder setFileDescriptors(ImmutableList<byte[]> encodedDescriptors) {
            this.encodedFileDescriptors_ = encodedDescriptors;
            return this;
        }

        public void setFileMetadataStats(FeFsTable.FileMetadataStats fileMetadataStats) {
            this.fileMetadataStats_ = fileMetadataStats;
        }

        public HdfsFileFormat getFileFormat() {
            return this.fileFormatDescriptor_.getFileFormat();
        }

        public boolean isMarkedCached() {
            return this.isMarkedCached_;
        }

        public Builder setIsMarkedCached(boolean isCached) {
            this.isMarkedCached_ = isCached;
            return this;
        }

        public HdfsTable getTable() {
            return this.table_;
        }

        public String getPartitionName() {
            return FeCatalogUtils.getPartitionName(this);
        }

        public Builder setLastCompactionId(long compactionId) {
            this.lastCompactionId_ = compactionId;
            return this;
        }

        public long getLastCompactionId() {
            return this.lastCompactionId_;
        }

        public void addToVersionsForInflightEvents(boolean isInsertEvent, long versionNumber) {
            Preconditions.checkState((boolean)this.table_.isWriteLockedByCurrentThread(), (Object)("addToVersionsForInflightEvents called without holding the table lock on partition " + this.getPartitionName() + " of table " + this.table_.getFullName()));
            if (!this.inFlightEvents_.add(isInsertEvent, versionNumber)) {
                LOG.warn("Could not add {} version to the partition {} of table {}. This could cause unnecessary refresh of the partition when the event is received by the Events processor.", new Object[]{versionNumber, this.getPartitionName(), this.getTable().getFullName()});
            }
        }

        private void addInflightVersionsFromParameters() {
            Preconditions.checkNotNull(this.hmsParameters_);
            Preconditions.checkState((this.inFlightEvents_.size(false) == 0 ? 1 : 0) != 0);
            if (!this.hmsParameters_.containsKey(MetastoreEvents.MetastoreEventPropertyKey.CATALOG_VERSION.getKey())) {
                return;
            }
            boolean added = this.inFlightEvents_.add(false, Long.parseLong(this.hmsParameters_.get(MetastoreEvents.MetastoreEventPropertyKey.CATALOG_VERSION.getKey())));
            LOG.trace("{} {} to inflight events {}", new Object[]{added ? "Added" : "Could not add", Long.parseLong(this.hmsParameters_.get(MetastoreEvents.MetastoreEventPropertyKey.CATALOG_VERSION.getKey())), this.inFlightEvents_.print()});
        }

        private List<FileDescriptor> fdsFromThrift(List<THdfsFileDesc> tFileDescs) {
            ArrayList<FileDescriptor> ret = new ArrayList<FileDescriptor>();
            for (THdfsFileDesc desc : tFileDescs) {
                ret.add(FileDescriptor.fromThrift(desc));
            }
            return ret;
        }

        public List<LiteralExpr> getPartitionValues() {
            return this.partitionKeyValues_;
        }

        public HdfsPartition getOldInstance() {
            return this.oldInstance_;
        }

        public long getOldId() {
            return ((HdfsPartition)Preconditions.checkNotNull((Object)this.oldInstance_)).id_;
        }

        public Partition toHmsPartition() {
            return this.build().toHmsPartition();
        }

        public Builder fromThrift(THdfsPartition thriftPartition) {
            HdfsPartitionLocationCompressor.Location location;
            List<FileDescriptor> fds;
            this.fileFormatDescriptor_ = HdfsStorageDescriptor.fromThrift(thriftPartition.hdfs_storage_descriptor, this.table_.getName());
            this.partitionKeyValues_ = new ArrayList<LiteralExpr>();
            if (this.id_ != -1L) {
                List<Column> clusterCols = this.table_.getClusteringColumns();
                ArrayList<TExprNode> exprNodes = new ArrayList<TExprNode>();
                for (TExpr expr : thriftPartition.getPartitionKeyExprs()) {
                    exprNodes.addAll(expr.getNodes());
                }
                Preconditions.checkState((clusterCols.size() == exprNodes.size() ? 1 : 0) != 0, (Object)String.format("Number of partition columns (%d) does not match number of partition key expressions (%d)", clusterCols.size(), exprNodes.size()));
                for (int i = 0; i < exprNodes.size(); ++i) {
                    this.partitionKeyValues_.add(LiteralExpr.fromThrift((TExprNode)exprNodes.get(i), clusterCols.get(i).getType()));
                }
            }
            if (thriftPartition.isSetFile_desc()) {
                fds = this.fdsFromThrift(thriftPartition.getFile_desc());
                this.setFileDescriptors(fds);
                for (FileDescriptor fd : fds) {
                    this.fileMetadataStats_.accumulate(fd);
                }
            }
            if (thriftPartition.isSetInsert_file_desc()) {
                fds = this.fdsFromThrift(thriftPartition.getInsert_file_desc());
                this.setInsertFileDescriptors(fds);
                for (FileDescriptor fd : fds) {
                    this.fileMetadataStats_.accumulate(fd);
                }
            }
            if (thriftPartition.isSetDelete_file_desc()) {
                fds = this.fdsFromThrift(thriftPartition.getDelete_file_desc());
                this.setDeleteFileDescriptors(fds);
                for (FileDescriptor fd : fds) {
                    this.fileMetadataStats_.accumulate(fd);
                }
            }
            TAccessLevel tAccessLevel = this.accessLevel_ = thriftPartition.isSetAccess_level() ? thriftPartition.getAccess_level() : TAccessLevel.READ_WRITE;
            if (thriftPartition.isSetLocation()) {
                HdfsPartitionLocationCompressor hdfsPartitionLocationCompressor = this.table_.getPartitionLocationCompressor();
                hdfsPartitionLocationCompressor.getClass();
                location = new HdfsPartitionLocationCompressor.Location(hdfsPartitionLocationCompressor, thriftPartition.getLocation());
            } else {
                location = this.location_ = null;
            }
            if (thriftPartition.isSetStats()) {
                this.numRows_ = thriftPartition.getStats().getNum_rows();
            }
            this.hasIncrementalStats_ = thriftPartition.has_incremental_stats;
            if (thriftPartition.isSetPartition_stats()) {
                this.partitionStats_ = thriftPartition.getPartition_stats();
            }
            if (thriftPartition.isSetIs_marked_cached()) {
                this.isMarkedCached_ = thriftPartition.isIs_marked_cached();
            }
            this.hmsParameters_ = thriftPartition.isSetHms_parameters() ? CatalogInterners.internParameters(thriftPartition.getHms_parameters()) : new HashMap<String, String>();
            this.writeId_ = thriftPartition.isSetWrite_id() ? thriftPartition.getWrite_id() : -1L;
            return this;
        }

        public void checkWellFormed() throws CatalogException {
            try {
                Expr.treesToThrift(this.getPartitionValues());
            }
            catch (Exception e) {
                throw new CatalogException("Partition (" + this.getPartitionName() + ") has invalid partition column values: ", e);
            }
        }

        public boolean equalsToOriginal(HdfsPartition oldInstance) {
            return oldInstance == this.oldInstance_ && this.encodedFileDescriptors_ == oldInstance.encodedFileDescriptors_ && this.encodedInsertFileDescriptors_ == oldInstance.encodedInsertFileDescriptors_ && this.encodedDeleteFileDescriptors_ == oldInstance.encodedDeleteFileDescriptors_ && this.fileFormatDescriptor_ == oldInstance.fileFormatDescriptor_ && this.location_ == oldInstance.location_ && this.isMarkedCached_ == oldInstance.isMarkedCached_ && this.accessLevel_ == oldInstance.accessLevel_ && this.hmsParameters_.equals(oldInstance.hmsParameters_) && this.partitionStats_ == oldInstance.partitionStats_ && this.hasIncrementalStats_ == oldInstance.hasIncrementalStats_ && this.numRows_ == oldInstance.numRows_ && this.writeId_ == oldInstance.writeId_ && this.lastCompactionId_ == oldInstance.lastCompactionId_ && this.lastRefreshEventId_ == this.oldInstance_.lastRefreshEventId_;
        }
    }

    private static class CachedHmsPartitionDescriptor {
        public String sdInputFormat;
        public String sdOutputFormat;
        public final boolean sdCompressed;
        public final int sdNumBuckets;
        public final SerDeInfo sdSerdeInfo;
        public final ImmutableList<String> sdBucketCols;
        public final ImmutableList<Order> sdSortCols;
        public final ImmutableMap<String, String> sdParameters;
        public final int msCreateTime;
        public final int msLastAccessTime;

        public CachedHmsPartitionDescriptor(Partition msPartition) {
            StorageDescriptor sd = null;
            if (msPartition != null) {
                sd = msPartition.getSd();
                CatalogInterners.internFieldsInPlace(sd);
                this.msCreateTime = msPartition.getCreateTime();
                this.msLastAccessTime = msPartition.getLastAccessTime();
            } else {
                this.msLastAccessTime = 0;
                this.msCreateTime = 0;
            }
            if (sd != null) {
                this.sdInputFormat = sd.getInputFormat();
                this.sdOutputFormat = sd.getOutputFormat();
                this.sdCompressed = sd.isCompressed();
                this.sdNumBuckets = sd.getNumBuckets();
                this.sdSerdeInfo = sd.getSerdeInfo();
                this.sdBucketCols = ImmutableList.copyOf((Collection)sd.getBucketCols());
                this.sdSortCols = ImmutableList.copyOf((Collection)sd.getSortCols());
                this.sdParameters = ImmutableMap.copyOf(CatalogInterners.internParameters(sd.getParameters()));
            } else {
                this.sdInputFormat = "";
                this.sdOutputFormat = "";
                this.sdCompressed = false;
                this.sdNumBuckets = 0;
                this.sdSerdeInfo = null;
                this.sdBucketCols = ImmutableList.of();
                this.sdSortCols = ImmutableList.of();
                this.sdParameters = ImmutableMap.of();
            }
        }

        private CachedHmsPartitionDescriptor(CachedHmsPartitionDescriptor other) {
            this.sdInputFormat = other.sdInputFormat;
            this.sdOutputFormat = other.sdOutputFormat;
            this.sdCompressed = other.sdCompressed;
            this.sdNumBuckets = other.sdNumBuckets;
            this.sdSerdeInfo = new SerDeInfo(other.sdSerdeInfo);
            this.sdBucketCols = other.sdBucketCols;
            this.sdSortCols = other.sdSortCols;
            this.sdParameters = ImmutableMap.copyOf(other.sdParameters);
            this.msCreateTime = other.msCreateTime;
            this.msLastAccessTime = other.msLastAccessTime;
        }
    }
}

