/*
 * Decompiled with CFR 0.152.
 */
package org.apache.impala.catalog;

import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableMap;
import org.apache.impala.catalog.HdfsFileFormat;
import org.apache.impala.thrift.THdfsCompression;

public enum HdfsCompression {
    NONE,
    DEFLATE,
    GZIP,
    BZIP2,
    SNAPPY_BLOCKED,
    LZO,
    LZO_INDEX,
    LZ4,
    ZSTD;

    public static final ImmutableMap<String, HdfsCompression> SUFFIX_MAP;

    public static HdfsCompression fromFileName(String fileName) {
        int index = fileName.lastIndexOf(".");
        if (index == -1) {
            return NONE;
        }
        String suffix = fileName.substring(index + 1);
        HdfsCompression compression = (HdfsCompression)((Object)SUFFIX_MAP.get((Object)suffix.toLowerCase()));
        return compression == null ? NONE : compression;
    }

    public THdfsCompression toThrift() {
        switch (this) {
            case NONE: {
                return THdfsCompression.NONE;
            }
            case DEFLATE: {
                return THdfsCompression.DEFLATE;
            }
            case GZIP: {
                return THdfsCompression.GZIP;
            }
            case BZIP2: {
                return THdfsCompression.BZIP2;
            }
            case SNAPPY_BLOCKED: {
                return THdfsCompression.SNAPPY_BLOCKED;
            }
            case LZO: {
                return THdfsCompression.LZO;
            }
            case LZ4: {
                return THdfsCompression.LZ4;
            }
            case ZSTD: {
                return THdfsCompression.ZSTD;
            }
        }
        throw new IllegalStateException("Unexpected codec: " + (Object)((Object)this));
    }

    public byte toFb() {
        switch (this) {
            case NONE: {
                return 0;
            }
            case DEFLATE: {
                return 3;
            }
            case GZIP: {
                return 2;
            }
            case BZIP2: {
                return 4;
            }
            case SNAPPY_BLOCKED: {
                return 6;
            }
            case LZO: {
                return 7;
            }
            case LZ4: {
                return 8;
            }
            case ZSTD: {
                return 10;
            }
        }
        throw new IllegalStateException("Unexpected codec: " + (Object)((Object)this));
    }

    public static HdfsCompression fromHdfsInputFormatClass(String inputFormatClass) {
        Preconditions.checkNotNull((Object)inputFormatClass);
        if (inputFormatClass.equals(HdfsFileFormat.LZO_TEXT.inputFormat())) {
            return LZO;
        }
        return NONE;
    }

    static {
        SUFFIX_MAP = ImmutableMap.builder().put((Object)"deflate", (Object)DEFLATE).put((Object)"gz", (Object)GZIP).put((Object)"bz2", (Object)BZIP2).put((Object)"snappy", (Object)SNAPPY_BLOCKED).put((Object)"lzo", (Object)LZO).put((Object)"index", (Object)LZO_INDEX).put((Object)"lz4", (Object)LZ4).put((Object)"zst", (Object)ZSTD).build();
    }
}

