/*
 * Decompiled with CFR 0.152.
 */
package org.apache.impala.catalog;

import org.apache.impala.catalog.CatalogInterners;
import org.apache.impala.catalog.Column;
import org.apache.impala.catalog.Type;
import org.apache.impala.thrift.TColumn;

public class HBaseColumn
extends Column
implements Comparable<HBaseColumn> {
    private final String columnFamily_;
    private final String columnQualifier_;
    private final boolean binaryEncoded_;

    public HBaseColumn(String name, String columnFamily, String columnQualifier, boolean binaryEncoded, Type type, String comment, int position) {
        super(name, type, comment, position);
        this.columnFamily_ = CatalogInterners.internString(columnFamily);
        this.columnQualifier_ = columnQualifier;
        this.binaryEncoded_ = binaryEncoded;
    }

    public String getColumnFamily() {
        return this.columnFamily_;
    }

    public String getColumnQualifier() {
        return this.columnQualifier_;
    }

    public boolean isBinaryEncoded() {
        return this.binaryEncoded_;
    }

    public boolean isKeyColumn() {
        return this.columnFamily_.equals(":key");
    }

    @Override
    public int compareTo(HBaseColumn o) {
        int familyCmp = this.columnFamily_.compareTo(o.columnFamily_);
        if (familyCmp != 0) {
            return familyCmp;
        }
        int qualifierCmp = this.columnQualifier_.compareTo(o.columnQualifier_);
        return qualifierCmp;
    }

    @Override
    public TColumn toThrift() {
        TColumn colDesc = new TColumn(this.name_, this.type_.toThrift());
        if (this.comment_ != null) {
            colDesc.setComment(this.comment_);
        }
        colDesc.setCol_stats(this.getStats().toThrift());
        colDesc.setPosition(this.position_);
        colDesc.setIs_hbase_column(true);
        colDesc.setColumn_family(this.columnFamily_);
        colDesc.setColumn_qualifier(this.columnQualifier_);
        colDesc.setIs_binary(this.binaryEncoded_);
        return colDesc;
    }
}

