/*
 * Decompiled with CFR 0.152.
 */
package org.apache.impala.catalog;

import com.google.common.base.MoreObjects;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Maps;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicLong;
import javax.annotation.Nullable;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.BlockLocation;
import org.apache.hadoop.fs.FileStatus;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.LocatedFileStatus;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.fs.RemoteIterator;
import org.apache.hadoop.hive.common.ValidTxnList;
import org.apache.hadoop.hive.common.ValidWriteIdList;
import org.apache.impala.catalog.CatalogException;
import org.apache.impala.catalog.FeFsTable;
import org.apache.impala.catalog.FileDescriptor;
import org.apache.impala.catalog.HdfsFileFormat;
import org.apache.impala.common.FileSystemUtil;
import org.apache.impala.thrift.TNetworkAddress;
import org.apache.impala.util.AcidUtils;
import org.apache.impala.util.HudiUtil;
import org.apache.impala.util.ListMap;
import org.apache.impala.util.ThreadNameAnnotator;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FileMetadataLoader {
    private static final Logger LOG = LoggerFactory.getLogger(FileMetadataLoader.class);
    private static final Configuration CONF = new Configuration();
    public static final AtomicInteger TOTAL_TASKS = new AtomicInteger();
    protected final String partDir_;
    protected final boolean recursive_;
    protected final ImmutableMap<String, ? extends FileDescriptor> oldFdsByPath_;
    private final ListMap<TNetworkAddress> hostIndex_;
    @Nullable
    private final ValidWriteIdList writeIds_;
    @Nullable
    private final ValidTxnList validTxnList_;
    @Nullable
    private final HdfsFileFormat fileFormat_;
    protected boolean forceRefreshLocations = false;
    protected List<FileDescriptor> loadedFds_;
    private List<FileDescriptor> loadedInsertDeltaFds_;
    private List<FileDescriptor> loadedDeleteDeltaFds_;
    protected LoadStats loadStats_;
    protected String debugAction_;
    protected FeFsTable.FileMetadataStats fileMetadataStats_ = null;

    public FileMetadataLoader(String partDir, boolean recursive, Iterable<? extends FileDescriptor> oldFds, ListMap<TNetworkAddress> hostIndex, @Nullable ValidTxnList validTxnList, @Nullable ValidWriteIdList writeIds, @Nullable HdfsFileFormat fileFormat) {
        Preconditions.checkState((validTxnList == null && writeIds == null || validTxnList != null && writeIds != null ? 1 : 0) != 0);
        this.partDir_ = (String)Preconditions.checkNotNull((Object)partDir);
        this.recursive_ = recursive;
        this.hostIndex_ = (ListMap)Preconditions.checkNotNull(hostIndex);
        this.oldFdsByPath_ = Maps.uniqueIndex(oldFds, FileDescriptor::getPath);
        this.writeIds_ = writeIds;
        this.validTxnList_ = validTxnList;
        this.fileFormat_ = fileFormat;
        if (this.writeIds_ != null) {
            Preconditions.checkArgument((boolean)this.recursive_, (Object)"ACID tables must be listed recursively");
        }
        TOTAL_TASKS.incrementAndGet();
    }

    public FileMetadataLoader(String partDir, boolean recursive, Iterable<? extends FileDescriptor> oldFds, ListMap<TNetworkAddress> hostIndex, @Nullable ValidTxnList validTxnList, @Nullable ValidWriteIdList writeIds) {
        this(partDir, recursive, oldFds, hostIndex, validTxnList, writeIds, null);
    }

    public void setForceRefreshBlockLocations(boolean refresh) {
        this.forceRefreshLocations = refresh;
    }

    public List<FileDescriptor> getLoadedFds() {
        Preconditions.checkState((this.loadedFds_ != null ? 1 : 0) != 0, (Object)"Must have successfully loaded first");
        return this.loadedFds_;
    }

    public List<FileDescriptor> getLoadedInsertDeltaFds() {
        return this.loadedInsertDeltaFds_;
    }

    public List<FileDescriptor> getLoadedDeleteDeltaFds() {
        return this.loadedDeleteDeltaFds_;
    }

    public LoadStats getStats() {
        Preconditions.checkState((this.loadedFds_ != null ? 1 : 0) != 0, (Object)"Must have successfully loaded first");
        return this.loadStats_;
    }

    String getPartDir() {
        return this.partDir_;
    }

    public void load() throws CatalogException, IOException {
        try {
            this.loadInternal();
        }
        finally {
            TOTAL_TASKS.decrementAndGet();
        }
    }

    private void loadInternal() throws CatalogException, IOException {
        Preconditions.checkState((this.loadStats_ == null ? 1 : 0) != 0, (Object)"already loaded");
        Path partPath = FileSystemUtil.createFullyQualifiedPath(new Path(this.partDir_));
        this.loadStats_ = new LoadStats(this.partDir_);
        this.fileMetadataStats_ = new FeFsTable.FileMetadataStats();
        FileSystem fs = partPath.getFileSystem(CONF);
        boolean listWithLocations = FileSystemUtil.supportsStorageIds(fs) && (this.oldFdsByPath_.isEmpty() || this.forceRefreshLocations);
        String msg = String.format("%s file metadata%s from path %s", this.oldFdsByPath_.isEmpty() ? "Loading" : "Refreshing", listWithLocations ? " with eager location-fetching" : "", this.partDir_);
        LOG.trace(msg);
        try (ThreadNameAnnotator tna = new ThreadNameAnnotator(msg);){
            List<FileStatus> fileStatuses = this.getFileStatuses(fs, partPath, listWithLocations);
            this.loadedFds_ = new ArrayList<FileDescriptor>();
            if (fileStatuses == null) {
                return;
            }
            AtomicLong numUnknownDiskIds = new AtomicLong(0L);
            if (this.writeIds_ != null) {
                fileStatuses = AcidUtils.filterFilesForAcidState(fileStatuses, partPath, this.validTxnList_, this.writeIds_, this.loadStats_);
            }
            if (this.fileFormat_ == HdfsFileFormat.HUDI_PARQUET) {
                fileStatuses = HudiUtil.filterFilesForHudiROPath(fileStatuses);
            }
            for (FileStatus fileStatus : fileStatuses) {
                if (fileStatus.isDirectory()) continue;
                if (!FileSystemUtil.isValidDataFile(fileStatus)) {
                    ++this.loadStats_.hiddenFiles;
                    continue;
                }
                FileDescriptor fd = this.getFileDescriptor(fs, listWithLocations, numUnknownDiskIds, fileStatus, partPath);
                this.loadedFds_.add((FileDescriptor)Preconditions.checkNotNull((Object)fd));
                this.fileMetadataStats_.accumulate(fd);
            }
            if (this.writeIds_ != null) {
                this.loadedInsertDeltaFds_ = new ArrayList<FileDescriptor>();
                this.loadedDeleteDeltaFds_ = new ArrayList<FileDescriptor>();
                for (FileDescriptor fd : this.loadedFds_) {
                    if (AcidUtils.isDeleteDeltaFd(fd)) {
                        this.loadedDeleteDeltaFds_.add(fd);
                        continue;
                    }
                    this.loadedInsertDeltaFds_.add(fd);
                }
            }
            this.loadStats_.unknownDiskIds = (int)((long)this.loadStats_.unknownDiskIds + numUnknownDiskIds.get());
            if (LOG.isTraceEnabled()) {
                LOG.trace(this.loadStats_.debugString());
            }
        }
    }

    public FeFsTable.FileMetadataStats getFileMetadataStats() {
        return this.fileMetadataStats_;
    }

    protected FileDescriptor getFileDescriptor(FileSystem fs, boolean listWithLocations, AtomicLong numUnknownDiskIds, FileStatus fileStatus, Path partPath) throws IOException {
        String relPath = FileSystemUtil.relativizePath(fileStatus.getPath(), partPath);
        FileDescriptor fd = (FileDescriptor)this.oldFdsByPath_.get((Object)relPath);
        if (listWithLocations || this.forceRefreshLocations || fd == null || fd.isChanged(fileStatus)) {
            fd = this.createFd(fs, fileStatus, relPath, numUnknownDiskIds);
            ++this.loadStats_.loadedFiles;
        } else {
            ++this.loadStats_.skippedFiles;
        }
        return fd;
    }

    protected List<FileStatus> getFileStatuses(FileSystem fs, Path partPath, boolean listWithLocations) throws IOException {
        RemoteIterator<? extends FileStatus> fileStatuses = listWithLocations ? FileSystemUtil.listFiles(fs, partPath, this.recursive_, this.debugAction_) : FileSystemUtil.listStatus(fs, partPath, this.recursive_, this.debugAction_);
        if (fileStatuses == null) {
            return null;
        }
        ArrayList<FileStatus> stats = new ArrayList<FileStatus>();
        while (fileStatuses.hasNext()) {
            stats.add((FileStatus)fileStatuses.next());
        }
        return stats;
    }

    protected FileDescriptor createFd(FileSystem fs, FileStatus fileStatus, String relPath, AtomicLong numUnknownDiskIds, @Nullable String absPath) throws IOException {
        if (!FileSystemUtil.supportsStorageIds(fs)) {
            return FileDescriptor.createWithNoBlocks(fileStatus, relPath, absPath);
        }
        BlockLocation[] locations = fileStatus instanceof LocatedFileStatus ? ((LocatedFileStatus)fileStatus).getBlockLocations() : fs.getFileBlockLocations(fileStatus, 0L, fileStatus.getLen());
        return FileDescriptor.create(fileStatus, relPath, locations, this.hostIndex_, fileStatus.isEncrypted(), fileStatus.isErasureCoded(), numUnknownDiskIds, absPath);
    }

    private FileDescriptor createFd(FileSystem fs, FileStatus fileStatus, String relPath, AtomicLong numUnknownDiskIds) throws IOException {
        return this.createFd(fs, fileStatus, relPath, numUnknownDiskIds, null);
    }

    public boolean hasFilesChangedCompareTo(List<FileDescriptor> oldFds) {
        if (oldFds.size() != this.loadedFds_.size()) {
            return true;
        }
        ImmutableMap oldFdsByRelPath = Maps.uniqueIndex(oldFds, FileDescriptor::getPath);
        for (FileDescriptor fd : this.loadedFds_) {
            FileDescriptor oldFd;
            if (!fd.isChanged(oldFd = (FileDescriptor)oldFdsByRelPath.get((Object)fd.getPath()))) continue;
            return true;
        }
        return false;
    }

    public void setDebugAction(String debugAction) {
        this.debugAction_ = debugAction;
    }

    public static class LoadStats {
        private final String partDir_;
        public int uncommittedAcidFilesSkipped = 0;
        public int filesSupersededByAcidState = 0;
        public int loadedFiles = 0;
        public int hiddenFiles = 0;
        public int skippedFiles = 0;
        public int unknownDiskIds = 0;

        LoadStats(String partDir) {
            this.partDir_ = (String)Preconditions.checkNotNull((Object)partDir);
        }

        public String debugString() {
            return MoreObjects.toStringHelper((String)"").add("path", (Object)this.partDir_).add("loaded files", this.loadedFiles).add("hidden files", (Object)this.nullIfZero(this.hiddenFiles)).add("skipped files", (Object)this.nullIfZero(this.skippedFiles)).add("uncommited files", (Object)this.nullIfZero(this.uncommittedAcidFilesSkipped)).add("superceded files", (Object)this.nullIfZero(this.filesSupersededByAcidState)).add("unknown diskIds", (Object)this.nullIfZero(this.unknownDiskIds)).omitNullValues().toString();
        }

        private Integer nullIfZero(int x) {
            return x > 0 ? Integer.valueOf(x) : null;
        }
    }
}

