/*
 * Decompiled with CFR 0.152.
 */
package org.apache.impala.catalog;

import com.google.common.base.Function;
import com.google.common.base.Joiner;
import com.google.common.base.MoreObjects;
import com.google.common.base.Preconditions;
import com.google.common.collect.Lists;
import com.google.flatbuffers.FlatBufferBuilder;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.concurrent.atomic.AtomicLong;
import javax.annotation.Nullable;
import org.apache.commons.lang3.StringUtils;
import org.apache.hadoop.fs.BlockLocation;
import org.apache.hadoop.fs.FileStatus;
import org.apache.impala.catalog.FileBlock;
import org.apache.impala.catalog.HdfsCompression;
import org.apache.impala.fb.FbCompression;
import org.apache.impala.fb.FbFileBlock;
import org.apache.impala.fb.FbFileDesc;
import org.apache.impala.thrift.THdfsFileDesc;
import org.apache.impala.thrift.TNetworkAddress;
import org.apache.impala.util.ListMap;

public class FileDescriptor
implements Comparable<FileDescriptor> {
    private static final TNetworkAddress REMOTE_NETWORK_ADDRESS = new TNetworkAddress("remote*addr", 0);
    public static final long MIN_SYNTHETIC_BLOCK_SIZE = 0x100000L;
    private final FbFileDesc fbFileDescriptor_;
    public static final Function<byte[], FileDescriptor> FROM_BYTES = new Function<byte[], FileDescriptor>(){

        public FileDescriptor apply(byte[] input) {
            ByteBuffer bb = ByteBuffer.wrap(input);
            return new FileDescriptor(FbFileDesc.getRootAsFbFileDesc(bb));
        }
    };
    public static final Function<FileDescriptor, byte[]> TO_BYTES = new Function<FileDescriptor, byte[]>(){

        public byte[] apply(FileDescriptor fd) {
            ByteBuffer bb = fd.fbFileDescriptor_.getByteBuffer();
            byte[] arr = bb.array();
            assert (bb.arrayOffset() == 0 && bb.remaining() == arr.length);
            return arr;
        }
    };

    protected FileDescriptor(FbFileDesc fileDescData) {
        this.fbFileDescriptor_ = fileDescData;
    }

    public static FileDescriptor fromThrift(THdfsFileDesc desc) {
        ByteBuffer bb = ByteBuffer.wrap(desc.getFile_desc_data());
        Preconditions.checkState((!desc.isSetFile_metadata() ? 1 : 0) != 0);
        return new FileDescriptor(FbFileDesc.getRootAsFbFileDesc(bb));
    }

    public THdfsFileDesc toThrift() {
        THdfsFileDesc fd = new THdfsFileDesc();
        ByteBuffer bb = this.fbFileDescriptor_.getByteBuffer();
        fd.setFile_desc_data(bb);
        return fd;
    }

    public FileDescriptor cloneWithNewHostIndex(List<TNetworkAddress> origIndex, ListMap<TNetworkAddress> dstIndex) {
        return new FileDescriptor(this.fbFileDescWithNewHostIndex(origIndex, dstIndex));
    }

    protected FbFileDesc fbFileDescWithNewHostIndex(List<TNetworkAddress> origIndex, ListMap<TNetworkAddress> dstIndex) {
        ByteBuffer oldBuf = this.fbFileDescriptor_.getByteBuffer();
        ByteBuffer newBuf = ByteBuffer.allocate(oldBuf.remaining());
        newBuf.put(oldBuf.array(), oldBuf.position(), oldBuf.remaining());
        newBuf.rewind();
        FbFileDesc cloned = FbFileDesc.getRootAsFbFileDesc(newBuf);
        FbFileBlock it = new FbFileBlock();
        for (int i = 0; i < cloned.fileBlocksLength(); ++i) {
            it = cloned.fileBlocks(it, i);
            for (int j = 0; j < it.replicaHostIdxsLength(); ++j) {
                int origHostIdx = FileBlock.getReplicaHostIdx(it, j);
                boolean isCached = FileBlock.isReplicaCached(it, j);
                TNetworkAddress origHost = origIndex.get(origHostIdx);
                int newHostIdx = dstIndex.getOrAddIndex(origHost);
                it.mutateReplicaHostIdxs(j, FileBlock.makeReplicaIdx(isCached, newHostIdx));
            }
        }
        return cloned;
    }

    public static FileDescriptor create(FileStatus fileStatus, String relPath, BlockLocation[] blockLocations, ListMap<TNetworkAddress> hostIndex, boolean isEncrypted, boolean isEc, AtomicLong numUnknownDiskIds, @Nullable String absPath) throws IOException {
        int[] fbFileBlockOffsets;
        FlatBufferBuilder fbb = new FlatBufferBuilder(1);
        if (blockLocations == null) {
            Preconditions.checkState((fileStatus.getLen() == 0L ? 1 : 0) != 0);
            fbFileBlockOffsets = new int[]{};
        } else {
            fbFileBlockOffsets = new int[blockLocations.length];
            int blockIdx = 0;
            for (BlockLocation loc : blockLocations) {
                fbFileBlockOffsets[blockIdx++] = isEc ? FileBlock.createFbFileBlock(fbb, loc.getOffset(), loc.getLength(), (short)hostIndex.getOrAddIndex(REMOTE_NETWORK_ADDRESS)) : FileBlock.createFbFileBlock(fbb, loc, hostIndex, numUnknownDiskIds);
            }
        }
        return new FileDescriptor(FileDescriptor.createFbFileDesc(fbb, fileStatus, relPath, fbFileBlockOffsets, isEncrypted, isEc, absPath));
    }

    public static FileDescriptor createWithNoBlocks(FileStatus fileStatus, String relPath, @Nullable String absPath) {
        FlatBufferBuilder fbb = new FlatBufferBuilder(1);
        return new FileDescriptor(FileDescriptor.createFbFileDesc(fbb, fileStatus, relPath, null, false, false, absPath));
    }

    private static FbFileDesc createFbFileDesc(FlatBufferBuilder fbb, FileStatus fileStatus, String relPath, int[] fbFileBlockOffsets, boolean isEncrypted, boolean isEc, @Nullable String absPath) {
        int relPathOffset = fbb.createString((CharSequence)(relPath == null ? "" : relPath));
        int blockVectorOffset = -1;
        if (fbFileBlockOffsets != null) {
            blockVectorOffset = FbFileDesc.createFileBlocksVector(fbb, fbFileBlockOffsets);
        }
        int absPathOffset = -1;
        if (StringUtils.isNotEmpty((CharSequence)absPath)) {
            absPathOffset = fbb.createString((CharSequence)absPath);
        }
        FbFileDesc.startFbFileDesc(fbb);
        FbFileDesc.addRelativePath(fbb, relPathOffset);
        FbFileDesc.addLength(fbb, fileStatus.getLen());
        FbFileDesc.addLastModificationTime(fbb, fileStatus.getModificationTime());
        FbFileDesc.addIsEncrypted(fbb, isEncrypted);
        FbFileDesc.addIsEc(fbb, isEc);
        HdfsCompression comp = HdfsCompression.fromFileName(fileStatus.getPath().getName());
        FbFileDesc.addCompression(fbb, comp.toFb());
        if (blockVectorOffset >= 0) {
            FbFileDesc.addFileBlocks(fbb, blockVectorOffset);
        }
        if (absPathOffset >= 0) {
            FbFileDesc.addAbsolutePath(fbb, absPathOffset);
        }
        fbb.finish(FbFileDesc.endFbFileDesc(fbb));
        ByteBuffer bb = fbb.dataBuffer().slice();
        ByteBuffer compressedBb = ByteBuffer.allocate(bb.capacity());
        compressedBb.put(bb);
        return FbFileDesc.getRootAsFbFileDesc((ByteBuffer)compressedBb.flip());
    }

    public String getRelativePath() {
        return this.fbFileDescriptor_.relativePath();
    }

    public String getAbsolutePath() {
        return StringUtils.isEmpty((CharSequence)this.fbFileDescriptor_.absolutePath()) ? "" : this.fbFileDescriptor_.absolutePath();
    }

    public String getAbsolutePath(String rootPath) {
        if (StringUtils.isEmpty((CharSequence)this.fbFileDescriptor_.relativePath()) && StringUtils.isNotEmpty((CharSequence)this.fbFileDescriptor_.absolutePath())) {
            return this.fbFileDescriptor_.absolutePath();
        }
        return rootPath + "/" + this.fbFileDescriptor_.relativePath();
    }

    public String getPath() {
        if (StringUtils.isEmpty((CharSequence)this.fbFileDescriptor_.relativePath()) && StringUtils.isNotEmpty((CharSequence)this.fbFileDescriptor_.absolutePath())) {
            return this.fbFileDescriptor_.absolutePath();
        }
        return this.fbFileDescriptor_.relativePath();
    }

    public long getFileLength() {
        return this.fbFileDescriptor_.length();
    }

    public static long computeTotalFileLength(Collection<FileDescriptor> fileDescs) {
        long totalLength = 0L;
        for (FileDescriptor fileDesc : fileDescs) {
            totalLength += fileDesc.getFileLength();
        }
        return totalLength;
    }

    public HdfsCompression getFileCompression() {
        return HdfsCompression.valueOf(FbCompression.name(this.fbFileDescriptor_.compression()));
    }

    public long getModificationTime() {
        return this.fbFileDescriptor_.lastModificationTime();
    }

    public int getNumFileBlocks() {
        return this.fbFileDescriptor_.fileBlocksLength();
    }

    public boolean getIsEncrypted() {
        return this.fbFileDescriptor_.isEncrypted();
    }

    public boolean getIsEc() {
        return this.fbFileDescriptor_.isEc();
    }

    public FbFileBlock getFbFileBlock(int idx) {
        return this.fbFileDescriptor_.fileBlocks(idx);
    }

    public FbFileDesc getFbFileDescriptor() {
        return this.fbFileDescriptor_;
    }

    public String toString() {
        int numFileBlocks = this.getNumFileBlocks();
        ArrayList blocks = Lists.newArrayListWithCapacity((int)numFileBlocks);
        for (int i = 0; i < numFileBlocks; ++i) {
            blocks.add(FileBlock.debugString(this.getFbFileBlock(i)));
        }
        MoreObjects.ToStringHelper stringHelper = MoreObjects.toStringHelper((Object)this).add("RelativePath", (Object)this.getRelativePath()).add("Length", this.getFileLength()).add("Compression", (Object)this.getFileCompression()).add("ModificationTime", this.getModificationTime()).add("Blocks", (Object)Joiner.on((String)", ").join((Iterable)blocks));
        if (StringUtils.isNotEmpty((CharSequence)this.getAbsolutePath())) {
            stringHelper.add("AbsolutePath", (Object)this.getAbsolutePath());
        }
        return stringHelper.toString();
    }

    @Override
    public int compareTo(FileDescriptor otherFd) {
        return this.getPath().compareTo(otherFd.getPath());
    }

    public boolean isChanged(FileStatus latestStatus) {
        return latestStatus == null || this.getFileLength() != latestStatus.getLen() || this.getModificationTime() != latestStatus.getModificationTime();
    }

    public boolean isChanged(FileDescriptor latestFd) {
        return latestFd == null || this.getFileLength() != latestFd.getFileLength() || this.getModificationTime() != latestFd.getModificationTime();
    }
}

