/*
 * Decompiled with CFR 0.152.
 */
package org.apache.impala.catalog;

import com.google.common.base.Joiner;
import com.google.common.base.Preconditions;
import com.google.common.base.Strings;
import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import com.google.flatbuffers.FlatBufferBuilder;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.concurrent.atomic.AtomicLong;
import org.apache.hadoop.fs.BlockLocation;
import org.apache.impala.catalog.BlockReplica;
import org.apache.impala.catalog.DiskIdMapper;
import org.apache.impala.fb.FbFileBlock;
import org.apache.impala.thrift.TNetworkAddress;
import org.apache.impala.util.ListMap;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FileBlock {
    private static final Logger LOG = LoggerFactory.getLogger(FileBlock.class);
    private static final short REPLICA_HOST_IDX_MASK = Short.MAX_VALUE;

    public static int createFbFileBlock(FlatBufferBuilder fbb, BlockLocation loc, ListMap<TNetworkAddress> hostIndex, AtomicLong numUnknownDiskIds) throws IOException {
        Preconditions.checkNotNull((Object)fbb);
        Preconditions.checkNotNull((Object)loc);
        Preconditions.checkNotNull(hostIndex);
        FbFileBlock.startReplicaHostIdxsVector(fbb, loc.getNames().length);
        HashSet cachedHosts = Sets.newHashSet((Object[])loc.getCachedHosts());
        for (int i = 0; i < loc.getNames().length; ++i) {
            TNetworkAddress networkAddress = BlockReplica.parseLocation(loc.getNames()[i]);
            short replicaIdx = (short)hostIndex.getOrAddIndex(networkAddress);
            boolean isReplicaCached = cachedHosts.contains(loc.getHosts()[i]);
            replicaIdx = FileBlock.makeReplicaIdx(isReplicaCached, replicaIdx);
            fbb.addShort(replicaIdx);
        }
        int fbReplicaHostIdxOffset = fbb.endVector();
        short[] diskIds = FileBlock.createDiskIds(loc, numUnknownDiskIds);
        Preconditions.checkState((diskIds.length == loc.getNames().length ? 1 : 0) != 0, (Object)("Mismatch detected between number of diskIDs and block locations for block: " + loc.toString()));
        int fbDiskIdsOffset = FbFileBlock.createDiskIdsVector(fbb, diskIds);
        FbFileBlock.startFbFileBlock(fbb);
        FbFileBlock.addOffset(fbb, loc.getOffset());
        FbFileBlock.addLength(fbb, loc.getLength());
        FbFileBlock.addReplicaHostIdxs(fbb, fbReplicaHostIdxOffset);
        FbFileBlock.addDiskIds(fbb, fbDiskIdsOffset);
        return FbFileBlock.endFbFileBlock(fbb);
    }

    public static short makeReplicaIdx(boolean isReplicaCached, int hostIdx) {
        Preconditions.checkArgument(((hostIdx & Short.MAX_VALUE) == hostIdx ? 1 : 0) != 0, (String)"invalid hostIdx: %s", (int)hostIdx);
        return isReplicaCached ? (short)(hostIdx | Short.MIN_VALUE) : (short)hostIdx;
    }

    public static int createFbFileBlock(FlatBufferBuilder fbb, long offset, long length, short replicaIdx) {
        Preconditions.checkNotNull((Object)fbb);
        FbFileBlock.startReplicaHostIdxsVector(fbb, 1);
        fbb.addShort(replicaIdx);
        int fbReplicaHostIdxOffset = fbb.endVector();
        FbFileBlock.startFbFileBlock(fbb);
        FbFileBlock.addOffset(fbb, offset);
        FbFileBlock.addLength(fbb, length);
        FbFileBlock.addReplicaHostIdxs(fbb, fbReplicaHostIdxOffset);
        return FbFileBlock.endFbFileBlock(fbb);
    }

    private static short[] createDiskIds(BlockLocation location, AtomicLong numUnknownDiskIds) throws IOException {
        String[] hosts;
        String[] storageIds = location.getStorageIds();
        if (storageIds.length != (hosts = location.getHosts()).length) {
            if (LOG.isTraceEnabled()) {
                LOG.trace(String.format("Number of storage IDs and number of hosts for block %s mismatch (storageIDs:hosts) %d:%d. Skipping disk ID loading for this block.", location.toString(), storageIds.length, hosts.length));
            }
            storageIds = new String[hosts.length];
        }
        short[] diskIDs = new short[storageIds.length];
        for (int i = 0; i < storageIds.length; ++i) {
            if (Strings.isNullOrEmpty((String)storageIds[i])) {
                diskIDs[i] = -1;
                numUnknownDiskIds.incrementAndGet();
                continue;
            }
            diskIDs[i] = DiskIdMapper.INSTANCE.getDiskId(hosts[i], storageIds[i]);
        }
        return diskIDs;
    }

    public static long getOffset(FbFileBlock fbFileBlock) {
        return fbFileBlock.offset();
    }

    public static long getLength(FbFileBlock fbFileBlock) {
        return fbFileBlock.length();
    }

    public static boolean hasCachedReplica(FbFileBlock fbFileBlock) {
        boolean hasCachedReplica = false;
        for (int i = 0; i < fbFileBlock.replicaHostIdxsLength(); ++i) {
            hasCachedReplica |= FileBlock.isReplicaCached(fbFileBlock, i);
        }
        return hasCachedReplica;
    }

    public static int getNumReplicaHosts(FbFileBlock fbFileBlock) {
        return fbFileBlock.replicaHostIdxsLength();
    }

    public static int getReplicaHostIdx(FbFileBlock fbFileBlock, int pos) {
        int idx = fbFileBlock.replicaHostIdxs(pos);
        return idx & Short.MAX_VALUE;
    }

    public static boolean isReplicaCached(FbFileBlock fbFileBlock, int replicaIdx) {
        int idx = fbFileBlock.replicaHostIdxs(replicaIdx);
        return (idx & Short.MIN_VALUE) != 0;
    }

    public static int getDiskId(FbFileBlock fbFileBlock, int hostIndex) {
        if (fbFileBlock.diskIdsLength() == 0) {
            return -1;
        }
        return fbFileBlock.diskIds(hostIndex);
    }

    public static String debugString(FbFileBlock fbFileBlock) {
        int numReplicaHosts = FileBlock.getNumReplicaHosts(fbFileBlock);
        ArrayList diskIds = Lists.newArrayListWithCapacity((int)numReplicaHosts);
        ArrayList replicaHosts = Lists.newArrayListWithCapacity((int)numReplicaHosts);
        ArrayList isBlockCached = Lists.newArrayListWithCapacity((int)numReplicaHosts);
        for (int i = 0; i < numReplicaHosts; ++i) {
            diskIds.add(FileBlock.getDiskId(fbFileBlock, i));
            replicaHosts.add(FileBlock.getReplicaHostIdx(fbFileBlock, i));
            isBlockCached.add(FileBlock.isReplicaCached(fbFileBlock, i));
        }
        StringBuilder builder = new StringBuilder();
        return builder.append("Offset: " + FileBlock.getOffset(fbFileBlock)).append("Length: " + FileBlock.getLength(fbFileBlock)).append("IsCached: " + FileBlock.hasCachedReplica(fbFileBlock)).append("ReplicaHosts: " + Joiner.on((String)", ").join((Iterable)replicaHosts)).append("DiskIds: " + Joiner.on((String)", ").join((Iterable)diskIds)).append("Caching: " + Joiner.on((String)", ").join((Iterable)isBlockCached)).toString();
    }
}

