/*
 * Decompiled with CFR 0.152.
 */
package org.apache.impala.catalog;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import org.apache.hadoop.hive.common.ValidWriteIdList;
import org.apache.hadoop.hive.metastore.api.SQLForeignKey;
import org.apache.hadoop.hive.metastore.api.SQLPrimaryKey;
import org.apache.hadoop.hive.metastore.api.Table;
import org.apache.impala.analysis.TableName;
import org.apache.impala.catalog.ArrayType;
import org.apache.impala.catalog.Column;
import org.apache.impala.catalog.FeDb;
import org.apache.impala.catalog.SqlConstraints;
import org.apache.impala.catalog.VirtualColumn;
import org.apache.impala.thrift.TCatalogObjectType;
import org.apache.impala.thrift.TColumnDescriptor;
import org.apache.impala.thrift.TImpalaTableType;
import org.apache.impala.thrift.TTableDescriptor;
import org.apache.impala.thrift.TTableStats;
import org.apache.impala.util.AcidUtils;

public interface FeTable {
    public static final Comparator<FeTable> NAME_COMPARATOR = new Comparator<FeTable>(){

        @Override
        public int compare(FeTable t1, FeTable t2) {
            return t1.getFullName().compareTo(t2.getFullName());
        }
    };
    public static final String NUM_ROWS = "numRows";
    public static final String LAST_MODIFIED_BY = "last_modified_by";
    public static final String LAST_MODIFIED_TIME = "last_modified_time";
    public static final String CATALOG_SERVICE_ID = "impala.events.catalogServiceId";
    public static final String CATALOG_VERSION = "impala.events.catalogVersion";

    public boolean isLoaded();

    public Table getMetaStoreTable();

    public String getStorageHandlerClassName();

    public TCatalogObjectType getCatalogObjectType();

    public String getName();

    public String getFullName();

    public TableName getTableName();

    public TImpalaTableType getTableType();

    public String getTableComment();

    public List<Column> getColumns();

    default public List<VirtualColumn> getVirtualColumns() {
        return Collections.emptyList();
    }

    public List<Column> getColumnsInHiveOrder();

    public List<String> getColumnNames();

    default public SqlConstraints getSqlConstraints() {
        return new SqlConstraints(new ArrayList<SQLPrimaryKey>(), new ArrayList<SQLForeignKey>());
    }

    public List<Column> getClusteringColumns();

    public List<Column> getNonClusteringColumns();

    default public List<Column> filterColumnsNotStoredInHms(List<Column> columns) {
        boolean isFullAcid;
        Table tbl = this.getMetaStoreTable();
        boolean bl = isFullAcid = tbl != null && AcidUtils.isFullAcidTable(tbl.getParameters());
        if (!isFullAcid) {
            return columns;
        }
        return columns.stream().filter(c -> !c.getName().equals("row__id")).collect(Collectors.toList());
    }

    public int getNumClusteringCols();

    public boolean isClusteringColumn(Column var1);

    default public boolean isComputedPartitionColumn(Column c) {
        return false;
    }

    public Column getColumn(String var1);

    public ArrayType getType();

    public FeDb getDb();

    public long getNumRows();

    public TTableStats getTTableStats();

    public TTableDescriptor toThriftDescriptor(int var1, Set<Long> var2);

    public long getWriteId();

    public ValidWriteIdList getValidWriteIds();

    public String getOwnerUser();

    public long getCatalogVersion();

    public long getLastLoadedTimeMs();

    default public List<TColumnDescriptor> getTColumnDescriptors() {
        ArrayList<TColumnDescriptor> colDescs = new ArrayList<TColumnDescriptor>();
        for (Column col : this.getColumns()) {
            colDescs.add(col.toDescriptor());
        }
        return colDescs;
    }
}

