/*
 * Decompiled with CFR 0.152.
 */
package org.apache.impala.catalog;

import com.google.common.base.Preconditions;
import com.google.common.base.Strings;
import com.google.common.collect.Lists;
import com.google.common.primitives.Ints;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Random;
import java.util.Set;
import java.util.TreeMap;
import java.util.concurrent.atomic.AtomicLong;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;
import org.apache.hadoop.fs.BlockLocation;
import org.apache.hadoop.fs.FileStatus;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.LocatedFileStatus;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.hive.metastore.api.FieldSchema;
import org.apache.hadoop.hive.metastore.api.Table;
import org.apache.iceberg.BaseTable;
import org.apache.iceberg.ContentFile;
import org.apache.iceberg.FileContent;
import org.apache.iceberg.PartitionField;
import org.apache.iceberg.PartitionSpec;
import org.apache.iceberg.Schema;
import org.apache.iceberg.Snapshot;
import org.apache.iceberg.expressions.Expression;
import org.apache.iceberg.util.PropertyUtil;
import org.apache.iceberg.util.SnapshotUtil;
import org.apache.impala.analysis.IcebergPartitionField;
import org.apache.impala.analysis.IcebergPartitionSpec;
import org.apache.impala.analysis.LiteralExpr;
import org.apache.impala.analysis.TimeTravelSpec;
import org.apache.impala.catalog.CatalogObject;
import org.apache.impala.catalog.Column;
import org.apache.impala.catalog.FeFsPartition;
import org.apache.impala.catalog.FeFsTable;
import org.apache.impala.catalog.FileBlock;
import org.apache.impala.catalog.FileDescriptor;
import org.apache.impala.catalog.HdfsFileFormat;
import org.apache.impala.catalog.IcebergColumn;
import org.apache.impala.catalog.IcebergContentFileStore;
import org.apache.impala.catalog.IcebergTable;
import org.apache.impala.catalog.PrunablePartition;
import org.apache.impala.catalog.TableLoadingException;
import org.apache.impala.catalog.Type;
import org.apache.impala.catalog.iceberg.GroupedContentFiles;
import org.apache.impala.common.AnalysisException;
import org.apache.impala.common.FileSystemUtil;
import org.apache.impala.common.ImpalaRuntimeException;
import org.apache.impala.common.PrintUtils;
import org.apache.impala.fb.FbFileBlock;
import org.apache.impala.service.BackendConfig;
import org.apache.impala.thrift.TColumn;
import org.apache.impala.thrift.TCompressionCodec;
import org.apache.impala.thrift.THdfsCompression;
import org.apache.impala.thrift.THdfsFileDesc;
import org.apache.impala.thrift.THdfsPartition;
import org.apache.impala.thrift.THdfsTable;
import org.apache.impala.thrift.TIcebergCatalog;
import org.apache.impala.thrift.TIcebergFileFormat;
import org.apache.impala.thrift.TIcebergPartitionStats;
import org.apache.impala.thrift.TIcebergPartitionTransformType;
import org.apache.impala.thrift.TIcebergTable;
import org.apache.impala.thrift.TNetworkAddress;
import org.apache.impala.thrift.TResultRow;
import org.apache.impala.thrift.TResultSet;
import org.apache.impala.thrift.TResultSetMetadata;
import org.apache.impala.util.HdfsCachingUtil;
import org.apache.impala.util.IcebergSchemaConverter;
import org.apache.impala.util.IcebergUtil;
import org.apache.impala.util.ListMap;
import org.apache.impala.util.TResultRowBuilder;
import org.apache.thrift.TException;
import org.json.simple.JSONValue;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public interface FeIcebergTable
extends FeFsTable {
    public static final Logger LOG = LoggerFactory.getLogger(FeIcebergTable.class);

    public IcebergContentFileStore getContentFileStore();

    public Map<String, TIcebergPartitionStats> getIcebergPartitionStats();

    public FeFsTable getFeFsTable();

    public TIcebergCatalog getIcebergCatalog();

    public org.apache.iceberg.Table getIcebergApiTable();

    public String getIcebergCatalogLocation();

    public TIcebergFileFormat getIcebergFileFormat();

    public TCompressionCodec getIcebergParquetCompressionCodec();

    public long getIcebergParquetRowGroupSize();

    public long getIcebergParquetPlainPageSize();

    public long getIcebergParquetDictPageSize();

    public String getIcebergTableLocation();

    public List<IcebergPartitionSpec> getPartitionSpecs();

    public IcebergPartitionSpec getDefaultPartitionSpec();

    public int getDefaultPartitionSpecId();

    default public IcebergPartitionSpec getPartitionSpec(int specId) {
        for (IcebergPartitionSpec spec : this.getPartitionSpecs()) {
            if (spec.getSpecId() != specId) continue;
            return spec;
        }
        return null;
    }

    default public int getFormatVersion() {
        return ((BaseTable)this.getIcebergApiTable()).operations().current().formatVersion();
    }

    default public Schema getIcebergSchema() {
        return this.getIcebergApiTable().schema();
    }

    @Override
    default public List<String> getPrimaryKeyColumnNames() throws TException {
        return Lists.newArrayList((Iterable)this.getIcebergSchema().identifierFieldNames());
    }

    @Override
    default public boolean isCacheable() {
        return this.getFeFsTable().isCacheable();
    }

    @Override
    default public boolean isLocationCacheable() {
        return this.getFeFsTable().isLocationCacheable();
    }

    @Override
    default public boolean isMarkedCached() {
        return this.getFeFsTable().isMarkedCached();
    }

    @Override
    default public String getLocation() {
        return this.getFeFsTable().getLocation();
    }

    @Override
    default public String getNullPartitionKeyValue() {
        return this.getFeFsTable().getNullPartitionKeyValue();
    }

    @Override
    default public String getHdfsBaseDir() {
        return this.getFeFsTable().getHdfsBaseDir();
    }

    @Override
    default public FileSystemUtil.FsType getFsType() {
        return this.getFeFsTable().getFsType();
    }

    @Override
    default public long getTotalHdfsBytes() {
        return this.getTTableStats().getTotal_file_bytes();
    }

    @Override
    default public boolean usesAvroSchemaOverride() {
        return this.getFeFsTable().usesAvroSchemaOverride();
    }

    @Override
    default public Set<HdfsFileFormat> getFileFormats() {
        return this.getFeFsTable().getFileFormats();
    }

    @Override
    default public boolean hasWriteAccessToBaseDir() {
        return this.getFeFsTable().hasWriteAccessToBaseDir();
    }

    @Override
    default public String getFirstLocationWithoutWriteAccess() {
        return this.getFeFsTable().getFirstLocationWithoutWriteAccess();
    }

    @Override
    default public TResultSet getTableStats() {
        return this.getFeFsTable().getTableStats();
    }

    @Override
    default public Collection<? extends PrunablePartition> getPartitions() {
        return this.getFeFsTable().getPartitions();
    }

    @Override
    default public Set<Long> getPartitionIds() {
        return this.getFeFsTable().getPartitionIds();
    }

    @Override
    default public Map<Long, ? extends PrunablePartition> getPartitionMap() {
        return this.getFeFsTable().getPartitionMap();
    }

    @Override
    default public TreeMap<LiteralExpr, Set<Long>> getPartitionValueMap(int col) {
        return this.getFeFsTable().getPartitionValueMap(col);
    }

    @Override
    default public Set<Long> getNullPartitionIds(int colIdx) {
        return this.getFeFsTable().getNullPartitionIds(colIdx);
    }

    @Override
    default public List<? extends FeFsPartition> loadPartitions(Collection<Long> ids) {
        return this.getFeFsTable().loadPartitions(ids);
    }

    @Override
    default public ListMap<TNetworkAddress> getHostIndex() {
        return this.getFeFsTable().getHostIndex();
    }

    @Override
    default public boolean isPartitioned() {
        for (IcebergPartitionSpec spec : this.getPartitionSpecs()) {
            if (spec.getIcebergPartitionFieldsSize() == 0) continue;
            for (IcebergPartitionField partField : spec.getIcebergPartitionFields()) {
                if (partField.getTransformType() == TIcebergPartitionTransformType.VOID) continue;
                return true;
            }
        }
        return false;
    }

    @Override
    default public boolean isComputedPartitionColumn(Column col) {
        Preconditions.checkState((boolean)(col instanceof IcebergColumn));
        IcebergColumn iceCol = (IcebergColumn)col;
        IcebergPartitionSpec spec = this.getDefaultPartitionSpec();
        if (spec == null || !spec.hasPartitionFields()) {
            return false;
        }
        for (IcebergPartitionField partField : spec.getIcebergPartitionFields()) {
            if (iceCol.getFieldId() != partField.getSourceId()) continue;
            return true;
        }
        return false;
    }

    @Override
    default public Map<Long, List<FileDescriptor>> getFilesSample(long percentBytes, long minSampleBytes, long randomSeed) {
        Map<Long, List<FileDescriptor>> dataFilesWithoutDeletesSample = Utils.getFilesSample(this, this.getContentFileStore().getDataFilesWithoutDeletes(), false, percentBytes, minSampleBytes, randomSeed);
        Map<Long, List<FileDescriptor>> dataFilesWithDeletesSample = Utils.getFilesSample(this, this.getContentFileStore().getDataFilesWithDeletes(), false, percentBytes, minSampleBytes, randomSeed);
        HashMap<Long, List<FileDescriptor>> mergedResult = new HashMap<Long, List<FileDescriptor>>();
        mergedResult.putAll(dataFilesWithoutDeletesSample);
        for (Map.Entry<Long, List<FileDescriptor>> entry : dataFilesWithDeletesSample.entrySet()) {
            List fds = (List)mergedResult.get(entry.getKey());
            if (fds != null) {
                fds.addAll((Collection)entry.getValue());
                continue;
            }
            mergedResult.put(entry.getKey(), entry.getValue());
        }
        if (mergedResult.isEmpty()) {
            return mergedResult;
        }
        Preconditions.checkState((mergedResult.size() == 1 ? 1 : 0) != 0);
        for (Map.Entry<Long, List<FileDescriptor>> entry : mergedResult.entrySet()) {
            for (FileDescriptor fileDescriptor : this.getContentFileStore().getAllDeleteFiles()) {
                entry.getValue().add(fileDescriptor);
            }
        }
        return mergedResult;
    }

    public THdfsTable transformToTHdfsTable(boolean var1, CatalogObject.ThriftObjectType var2);

    default public long snapshotId() {
        if (this.getIcebergApiTable() != null && this.getIcebergApiTable().currentSnapshot() != null) {
            return this.getIcebergApiTable().currentSnapshot().snapshotId();
        }
        return -1L;
    }

    default public TIcebergFileFormat getWriteFileFormat() {
        return IcebergUtil.getIcebergFileFormat(this.getIcebergApiTable().properties().getOrDefault("write.format.default", "parquet"));
    }

    default public TIcebergFileFormat getDeleteFileFormat() {
        String deleteFormat = (String)this.getIcebergApiTable().properties().get("write.delete.format.default");
        if (deleteFormat != null) {
            return IcebergUtil.getIcebergFileFormat(deleteFormat);
        }
        return this.getWriteFileFormat();
    }

    default public void setIcebergTableStats() {
        Preconditions.checkState((this.getTTableStats() != null ? 1 : 0) != 0);
        Preconditions.checkState((this.getIcebergPartitionStats() != null ? 1 : 0) != 0);
        if (this.getTTableStats().getNum_rows() < 0L) {
            this.getTTableStats().setNum_rows(Utils.calculateNumRows(this));
        }
        if (this.getTTableStats().getTotal_file_bytes() <= 0L) {
            this.getTTableStats().setTotal_file_bytes(Utils.calculateFileSizeInBytes(this));
        }
    }

    public static void setIcebergStorageDescriptor(Table hmsTable) {
        hmsTable.getSd().setInputFormat(HdfsFileFormat.ICEBERG.inputFormat());
        hmsTable.getSd().setOutputFormat(HdfsFileFormat.ICEBERG.outputFormat());
        hmsTable.getSd().getSerdeInfo().setSerializationLib(HdfsFileFormat.ICEBERG.serializationLib());
    }

    public static void resetIcebergStorageDescriptor(Table modifiedTable, Table originalTable) {
        modifiedTable.getSd().setInputFormat(originalTable.getSd().getInputFormat());
        modifiedTable.getSd().setOutputFormat(originalTable.getSd().getOutputFormat());
        modifiedTable.getSd().getSerdeInfo().setSerializationLib(originalTable.getSd().getSerdeInfo().getSerializationLib());
    }

    public static abstract class Utils {
        private static final int DEFAULT_MODIFICATION_TIME = 1;

        public static boolean isColumnar(FeIcebergTable table) {
            HdfsFileFormat format = IcebergUtil.toHdfsFileFormat(table.getIcebergFileFormat());
            return format == HdfsFileFormat.PARQUET || format == HdfsFileFormat.ORC;
        }

        public static TResultSet getIcebergTableFiles(FeIcebergTable table, TResultSet result) {
            ArrayList orderedFds = Lists.newArrayList(table.getContentFileStore().getAllFiles());
            Collections.sort(orderedFds);
            for (FileDescriptor fd : orderedFds) {
                TResultRowBuilder rowBuilder = new TResultRowBuilder();
                String absPath = fd.getAbsolutePath(table.getLocation());
                rowBuilder.add(absPath);
                rowBuilder.add(PrintUtils.printBytes(fd.getFileLength()));
                rowBuilder.add("");
                rowBuilder.add(FileSystemUtil.getErasureCodingPolicy(new Path(absPath)));
                result.addToRows(rowBuilder.get());
            }
            return result;
        }

        public static TResultSet getPartitionStats(FeIcebergTable table) {
            TResultSet result = new TResultSet();
            TResultSetMetadata resultSchema = new TResultSetMetadata();
            result.setSchema(resultSchema);
            result.setRows(new ArrayList<TResultRow>());
            resultSchema.addToColumns(new TColumn("Partition", Type.STRING.toThrift()));
            resultSchema.addToColumns(new TColumn("Number Of Rows", Type.BIGINT.toThrift()));
            resultSchema.addToColumns(new TColumn("Number Of Files", Type.BIGINT.toThrift()));
            Map<String, TIcebergPartitionStats> nameToStats = Utils.getOrderedPartitionStats(table);
            for (Map.Entry<String, TIcebergPartitionStats> partitionInfo : nameToStats.entrySet()) {
                TResultRowBuilder builder = new TResultRowBuilder();
                builder.add(partitionInfo.getKey());
                builder.add(partitionInfo.getValue().getNum_rows());
                builder.add(partitionInfo.getValue().getNum_files());
                result.addToRows(builder.get());
            }
            return result;
        }

        private static Map<String, TIcebergPartitionStats> getOrderedPartitionStats(FeIcebergTable table) {
            return table.getIcebergPartitionStats().entrySet().stream().sorted(Map.Entry.comparingByKey()).collect(Collectors.toMap(Map.Entry::getKey, Map.Entry::getValue, (oldValue, newValue) -> oldValue, LinkedHashMap::new));
        }

        public static TResultSet getTableStats(FeIcebergTable table) {
            TResultSet result = new TResultSet();
            TResultSetMetadata resultSchema = new TResultSetMetadata();
            resultSchema.addToColumns(new TColumn("#Rows", Type.BIGINT.toThrift()));
            resultSchema.addToColumns(new TColumn("#Files", Type.BIGINT.toThrift()));
            resultSchema.addToColumns(new TColumn("Size", Type.STRING.toThrift()));
            resultSchema.addToColumns(new TColumn("Bytes Cached", Type.STRING.toThrift()));
            resultSchema.addToColumns(new TColumn("Cache Replication", Type.STRING.toThrift()));
            resultSchema.addToColumns(new TColumn("Format", Type.STRING.toThrift()));
            resultSchema.addToColumns(new TColumn("Incremental stats", Type.STRING.toThrift()));
            resultSchema.addToColumns(new TColumn("Location", Type.STRING.toThrift()));
            resultSchema.addToColumns(new TColumn("EC Policy", Type.STRING.toThrift()));
            result.setSchema(resultSchema);
            TResultRowBuilder rowBuilder = new TResultRowBuilder();
            rowBuilder.add(table.getNumRows());
            rowBuilder.add(table.getContentFileStore().getNumFiles());
            rowBuilder.addBytes(table.getTTableStats().getTotal_file_bytes());
            if (!table.isMarkedCached()) {
                rowBuilder.add("NOT CACHED");
                rowBuilder.add("NOT CACHED");
            } else {
                long cachedBytes = 0L;
                for (FileDescriptor fileDescriptor : table.getContentFileStore().getAllFiles()) {
                    int numBlocks = fileDescriptor.getNumFileBlocks();
                    for (int i = 0; i < numBlocks; ++i) {
                        FbFileBlock block = fileDescriptor.getFbFileBlock(i);
                        if (!FileBlock.hasCachedReplica(block)) continue;
                        cachedBytes += FileBlock.getLength(block);
                    }
                }
                rowBuilder.addBytes(cachedBytes);
                Short rep = HdfsCachingUtil.getCachedCacheReplication(table.getMetaStoreTable().getParameters());
                rowBuilder.add(rep.toString());
            }
            rowBuilder.add(table.getIcebergFileFormat().toString());
            rowBuilder.add(Boolean.FALSE.toString());
            rowBuilder.add(table.getLocation());
            rowBuilder.add(FileSystemUtil.getErasureCodingPolicy(new Path(table.getLocation())));
            result.addToRows(rowBuilder.get());
            return result;
        }

        public static long calculateNumRows(FeIcebergTable table) {
            return table.getIcebergPartitionStats().values().stream().mapToLong(TIcebergPartitionStats::getNum_rows).sum();
        }

        public static long calculateFileSizeInBytes(FeIcebergTable table) {
            return table.getIcebergPartitionStats().values().stream().mapToLong(TIcebergPartitionStats::getFile_size_in_bytes).sum();
        }

        public static List<FieldSchema> getPartitionTransformKeys(FeIcebergTable table) throws ImpalaRuntimeException {
            org.apache.iceberg.Table icebergTable = table.getIcebergApiTable();
            if (icebergTable.specs().isEmpty()) {
                return null;
            }
            PartitionSpec latestSpec = icebergTable.spec();
            Map<String, Integer> transformParams = IcebergUtil.getPartitionTransformParams(latestSpec);
            ArrayList fieldSchemaList = Lists.newArrayList();
            for (PartitionField field : latestSpec.fields()) {
                FieldSchema fieldSchema = new FieldSchema();
                fieldSchema.setName(table.getIcebergSchema().findColumnName(field.sourceId()));
                fieldSchema.setType(IcebergUtil.getPartitionTransform(field, transformParams).toSql());
                fieldSchemaList.add(fieldSchema);
            }
            return fieldSchemaList;
        }

        public static String getIcebergCatalogLocation(FeIcebergTable table) {
            if (table.getIcebergCatalog() == TIcebergCatalog.HADOOP_CATALOG) {
                return Utils.getIcebergCatalogLocation(table.getMetaStoreTable());
            }
            return table.getIcebergTableLocation();
        }

        public static String getIcebergCatalogLocation(Table msTable) {
            String location = (String)msTable.getParameters().get("iceberg.catalog_location");
            return FileSystemUtil.createFullyQualifiedPath(new Path(location)).toString();
        }

        public static TCompressionCodec getIcebergParquetCompressionCodec(Table msTable) {
            THdfsCompression codec = IcebergUtil.getIcebergParquetCompressionCodec((String)msTable.getParameters().get("write.parquet.compression-codec"));
            if (codec == null) {
                codec = IcebergTable.DEFAULT_PARQUET_COMPRESSION_CODEC;
            }
            TCompressionCodec compression = new TCompressionCodec(codec);
            if (codec == THdfsCompression.ZSTD) {
                Integer cl;
                int clevel = 3;
                String clevelTblProp = (String)msTable.getParameters().get("write.parquet.compression-level");
                if (clevelTblProp != null && (cl = Ints.tryParse((String)clevelTblProp)) != null && cl >= 1 && cl <= 22) {
                    clevel = cl;
                }
                compression.setCompression_level(clevel);
            }
            return compression;
        }

        public static long getIcebergParquetRowGroupSize(Table msTable) {
            return IcebergUtil.getIcebergParquetRowGroupSize((String)msTable.getParameters().get("write.parquet.row-group-size-bytes"));
        }

        public static long getIcebergParquetPlainPageSize(Table msTable) {
            return IcebergUtil.getIcebergParquetPageSize((String)msTable.getParameters().get("write.parquet.page-size-bytes"));
        }

        public static long getIcebergParquetDictPageSize(Table msTable) {
            return IcebergUtil.getIcebergParquetPageSize((String)msTable.getParameters().get("write.parquet.dict-size-bytes"));
        }

        public static TIcebergTable getTIcebergTable(FeIcebergTable icebergTable) {
            return Utils.getTIcebergTable(icebergTable, CatalogObject.ThriftObjectType.FULL);
        }

        public static TIcebergTable getTIcebergTable(FeIcebergTable icebergTable, CatalogObject.ThriftObjectType type) {
            TIcebergTable tIcebergTable = new TIcebergTable();
            tIcebergTable.setTable_location(icebergTable.getIcebergTableLocation());
            for (IcebergPartitionSpec partitionSpec : icebergTable.getPartitionSpecs()) {
                tIcebergTable.addToPartition_spec(partitionSpec.toThrift());
            }
            tIcebergTable.setDefault_partition_spec_id(icebergTable.getDefaultPartitionSpecId());
            if (type == CatalogObject.ThriftObjectType.FULL) {
                tIcebergTable.setContent_files(icebergTable.getContentFileStore().toThrift());
            }
            tIcebergTable.setCatalog_snapshot_id(icebergTable.snapshotId());
            tIcebergTable.setParquet_compression_codec(icebergTable.getIcebergParquetCompressionCodec());
            tIcebergTable.setParquet_row_group_size(icebergTable.getIcebergParquetRowGroupSize());
            tIcebergTable.setParquet_plain_page_size(icebergTable.getIcebergParquetPlainPageSize());
            tIcebergTable.setParquet_dict_page_size(icebergTable.getIcebergParquetDictPageSize());
            tIcebergTable.setPartition_stats(icebergTable.getIcebergPartitionStats());
            return tIcebergTable;
        }

        public static Map<String, FileDescriptor> loadFileDescMapFromThrift(Map<String, THdfsFileDesc> tFileDescMap, List<TNetworkAddress> networkAddresses, ListMap<TNetworkAddress> hostIndex) {
            HashMap<String, FileDescriptor> fileDescMap = new HashMap<String, FileDescriptor>();
            if (tFileDescMap == null) {
                return fileDescMap;
            }
            for (Map.Entry<String, THdfsFileDesc> entry : tFileDescMap.entrySet()) {
                FileDescriptor fd = FileDescriptor.fromThrift(entry.getValue());
                Preconditions.checkNotNull((Object)fd);
                if (networkAddresses == null) {
                    fileDescMap.put(entry.getKey(), fd);
                    continue;
                }
                Preconditions.checkNotNull(hostIndex);
                fileDescMap.put(entry.getKey(), fd.cloneWithNewHostIndex(networkAddresses, hostIndex));
            }
            return fileDescMap;
        }

        public static Map<Long, List<FileDescriptor>> getFilesSample(FeIcebergTable iceTbl, Iterable<? extends FileDescriptor> fileDescs, boolean filesAreSorted, long percentBytes, long minSampleBytes, long randomSeed) {
            FileDescriptor fd;
            ArrayList<? extends FeFsPartition> partitions;
            Preconditions.checkState((percentBytes >= 0L && percentBytes <= 100L ? 1 : 0) != 0);
            Preconditions.checkState((minSampleBytes >= 0L ? 1 : 0) != 0);
            ArrayList orderedFds = Lists.newArrayList(fileDescs);
            if (!filesAreSorted) {
                Collections.sort(orderedFds);
            }
            Preconditions.checkState(((partitions = new ArrayList<FeFsPartition>(iceTbl.getFeFsTable().loadAllPartitions())).size() == 1 ? 1 : 0) != 0);
            FeFsPartition part = (FeFsPartition)partitions.get(0);
            long totalBytes = 0L;
            for (FileDescriptor fd2 : orderedFds) {
                totalBytes += fd2.getFileLength();
            }
            int numFilesRemaining = orderedFds.size();
            double fracPercentBytes = (double)percentBytes / 100.0;
            long targetBytes = Math.round((double)totalBytes * fracPercentBytes);
            targetBytes = Math.max(targetBytes, minSampleBytes);
            Random rnd = new Random(randomSeed);
            ArrayList sampleFiles = Lists.newArrayList();
            for (long selectedBytes = 0L; selectedBytes < targetBytes && numFilesRemaining > 0; selectedBytes += fd.getFileLength(), --numFilesRemaining) {
                int selectedIdx = rnd.nextInt(numFilesRemaining);
                fd = (FileDescriptor)orderedFds.get(selectedIdx);
                sampleFiles.add(fd);
                orderedFds.set(selectedIdx, orderedFds.get(numFilesRemaining - 1));
            }
            HashMap<Long, List<FileDescriptor>> result = new HashMap<Long, List<FileDescriptor>>();
            result.put(part.getId(), sampleFiles);
            return result;
        }

        public static FileDescriptor getHdfsFileDescriptor(ContentFile<?> contentFile, org.apache.iceberg.Table iceApiTable, boolean requiresDataFilesInTableLocation, ListMap<TNetworkAddress> hostIndex) throws IOException {
            Path fileLoc = FileSystemUtil.createFullyQualifiedPath(new Path(contentFile.path().toString()));
            FileSystem fsForPath = FileSystemUtil.getFileSystemForPath(fileLoc);
            FileStatus fileStatus = FileSystemUtil.supportsStorageIds(fsForPath) ? Utils.createLocatedFileStatus(fileLoc, fsForPath) : Utils.createFileStatus(contentFile, fileLoc);
            return Utils.getHdfsFileDescriptor(fsForPath, fileStatus, iceApiTable, requiresDataFilesInTableLocation, hostIndex);
        }

        private static FileDescriptor getHdfsFileDescriptor(FileSystem fs, FileStatus fileStatus, org.apache.iceberg.Table iceApiTable, boolean requiresDataFilesInTableLocation, ListMap<TNetworkAddress> hostIndex) throws IOException {
            AtomicLong numUnknownDiskIds = new AtomicLong(0L);
            String absPath = null;
            Path tableLoc = new Path(iceApiTable.location());
            String relPath = FileSystemUtil.relativizePathNoThrow(fileStatus.getPath(), tableLoc);
            if (relPath == null) {
                if (requiresDataFilesInTableLocation) {
                    throw new RuntimeException(fileStatus.getPath() + " is outside of the Iceberg table location " + tableLoc);
                }
                absPath = fileStatus.getPath().toString();
            }
            if (!FileSystemUtil.supportsStorageIds(fs)) {
                return FileDescriptor.createWithNoBlocks(fileStatus, relPath, absPath);
            }
            BlockLocation[] locations = fileStatus instanceof LocatedFileStatus ? ((LocatedFileStatus)fileStatus).getBlockLocations() : fs.getFileBlockLocations(fileStatus, 0L, fileStatus.getLen());
            return FileDescriptor.create(fileStatus, relPath, locations, hostIndex, fileStatus.isEncrypted(), fileStatus.isErasureCoded(), numUnknownDiskIds, absPath);
        }

        public static Map<String, TIcebergPartitionStats> loadPartitionStats(IcebergTable table, GroupedContentFiles icebergFiles) {
            HashMap<String, TIcebergPartitionStats> nameToStats = new HashMap<String, TIcebergPartitionStats>();
            for (ContentFile<?> contentFile : icebergFiles.getAllContentFiles()) {
                String name = Utils.getPartitionKey(table, contentFile);
                nameToStats.put(name, Utils.mergePartitionStats(nameToStats, contentFile, name));
            }
            return nameToStats;
        }

        private static TIcebergPartitionStats mergePartitionStats(Map<String, TIcebergPartitionStats> partitionNameToStats, ContentFile<?> contentFile, String partitionName) {
            TIcebergPartitionStats info;
            if (partitionNameToStats.containsKey(partitionName)) {
                info = partitionNameToStats.get(partitionName);
                if (contentFile.content().equals((Object)FileContent.DATA)) {
                    info.num_rows += contentFile.recordCount();
                }
                ++info.num_files;
                info.file_size_in_bytes += contentFile.fileSizeInBytes();
            } else {
                info = new TIcebergPartitionStats();
                if (contentFile.content().equals((Object)FileContent.DATA)) {
                    info.num_rows = contentFile.recordCount();
                }
                info.num_files = 1L;
                info.file_size_in_bytes = contentFile.fileSizeInBytes();
            }
            return info;
        }

        public static String getPartitionKey(IcebergTable table, ContentFile<?> contentFile) {
            PartitionSpec spec = (PartitionSpec)table.getIcebergApiTable().specs().get(contentFile.specId());
            LinkedHashMap<String, String> fieldNameToPartitionValue = new LinkedHashMap<String, String>();
            for (int i = 0; i < spec.fields().size(); ++i) {
                Object partValue = contentFile.partition().get(i, Object.class);
                String partValueString = null;
                if (partValue != null) {
                    partValueString = partValue.toString();
                }
                fieldNameToPartitionValue.put(((PartitionField)spec.fields().get(i)).name(), partValueString);
            }
            return JSONValue.toJSONString(fieldNameToPartitionValue);
        }

        public static List<IcebergPartitionSpec> loadPartitionSpecByIceberg(FeIcebergTable table) throws ImpalaRuntimeException {
            ArrayList<IcebergPartitionSpec> ret = new ArrayList<IcebergPartitionSpec>();
            org.apache.iceberg.Table iceApiTable = table.getIcebergApiTable();
            for (PartitionSpec spec : iceApiTable.specs().values()) {
                ret.add(Utils.convertPartitionSpec(iceApiTable.schema(), spec));
            }
            return ret;
        }

        public static IcebergPartitionSpec convertPartitionSpec(Schema schema, PartitionSpec spec) throws ImpalaRuntimeException {
            ArrayList<IcebergPartitionField> fields = new ArrayList<IcebergPartitionField>();
            Map<String, Integer> transformParams = IcebergUtil.getPartitionTransformParams(spec);
            for (PartitionField field : spec.fields()) {
                fields.add(new IcebergPartitionField(field.sourceId(), field.fieldId(), spec.schema().findColumnName(field.sourceId()), field.name(), IcebergUtil.getPartitionTransform(field, transformParams), IcebergSchemaConverter.toImpalaType(field.transform().getResultType(schema.findType(field.sourceId())))));
            }
            return new IcebergPartitionSpec(spec.specId(), fields);
        }

        public static IcebergPartitionSpec getDefaultPartitionSpec(FeIcebergTable feIcebergTable) {
            List<IcebergPartitionSpec> specs = feIcebergTable.getPartitionSpecs();
            Preconditions.checkState((specs != null ? 1 : 0) != 0);
            if (specs.isEmpty()) {
                return null;
            }
            int defaultSpecId = feIcebergTable.getIcebergApiTable().spec().specId();
            Preconditions.checkState((specs.size() > defaultSpecId ? 1 : 0) != 0);
            return specs.get(defaultSpecId);
        }

        public static void updateIcebergPartitionFileFormat(FeIcebergTable icebergTable, THdfsTable hdfsTable) {
            for (Map.Entry<Long, THdfsPartition> entry : hdfsTable.getPartitions().entrySet()) {
                THdfsPartition partition = entry.getValue();
                partition.getHdfs_storage_descriptor().setFileFormat(IcebergUtil.toTHdfsFileFormat(icebergTable.getIcebergFileFormat()));
            }
        }

        public static long getRecordCountV1(org.apache.iceberg.Table icebergTable, TimeTravelSpec travelSpec) {
            Map<String, String> summary = Utils.getSnapshotSummary(icebergTable, travelSpec);
            if (summary == null) {
                return -1L;
            }
            String totalRecordsStr = summary.get("total-records");
            if (Strings.isNullOrEmpty((String)totalRecordsStr)) {
                return -1L;
            }
            try {
                return Long.parseLong(totalRecordsStr);
            }
            catch (NumberFormatException ex) {
                LOG.warn("Failed to get {} from iceberg table summary. Table name: {}, Table location: {}, Prop value: {}", new Object[]{"total-records", icebergTable.name(), icebergTable.location(), totalRecordsStr, ex});
                return -1L;
            }
        }

        public static long getRecordCountV2(FeIcebergTable table, TimeTravelSpec travelSpec) throws AnalysisException {
            if (travelSpec == null) {
                return table.getContentFileStore().getDataFilesWithoutDeletes().stream().mapToLong(file -> file.getFbFileMetadata().icebergMetadata().recordCount()).sum();
            }
            try {
                return IcebergUtil.getIcebergFiles((FeIcebergTable)table, (List<Expression>)Lists.newArrayList(), (TimeTravelSpec)travelSpec).dataFilesWithoutDeletes.stream().mapToLong(ContentFile::recordCount).sum();
            }
            catch (TableLoadingException e) {
                throw new AnalysisException("Failed to get record count of Iceberg V2 table: " + table.getFullName(), e);
            }
        }

        public static boolean hasDeleteFiles(FeIcebergTable table, TimeTravelSpec travelSpec) throws AnalysisException {
            if (travelSpec == null) {
                IcebergContentFileStore fileStore = table.getContentFileStore();
                return !fileStore.getPositionDeleteFiles().isEmpty() || !fileStore.getEqualityDeleteFiles().isEmpty();
            }
            try {
                GroupedContentFiles groupedFiles = IcebergUtil.getIcebergFiles(table, Lists.newArrayList(), travelSpec);
                return !groupedFiles.positionDeleteFiles.isEmpty() || !groupedFiles.equalityDeleteFiles.isEmpty();
            }
            catch (TableLoadingException e) {
                throw new AnalysisException("Failed to get record count of Iceberg V2 table: " + table.getFullName(), e);
            }
        }

        private static Map<String, String> getSnapshotSummary(org.apache.iceberg.Table icebergTable, TimeTravelSpec travelSpec) {
            Snapshot snapshot = Utils.getIcebergSnapshot(icebergTable, travelSpec);
            if (snapshot == null) {
                return null;
            }
            return snapshot.summary();
        }

        private static Snapshot getIcebergSnapshot(org.apache.iceberg.Table icebergTable, TimeTravelSpec travelSpec) {
            Snapshot snapshot;
            if (travelSpec == null) {
                return icebergTable.currentSnapshot();
            }
            if (travelSpec.getKind().equals((Object)TimeTravelSpec.Kind.VERSION_AS_OF)) {
                long snapshotId = travelSpec.getAsOfVersion();
                snapshot = icebergTable.snapshot(snapshotId);
                Preconditions.checkArgument((snapshot != null ? 1 : 0) != 0, (String)"Cannot find snapshot with ID %s", (long)snapshotId);
            } else {
                long timestampMillis = travelSpec.getAsOfMillis();
                long snapshotId = SnapshotUtil.snapshotIdAsOfTime((org.apache.iceberg.Table)icebergTable, (long)timestampMillis);
                snapshot = icebergTable.snapshot(snapshotId);
                Preconditions.checkArgument((snapshot != null ? 1 : 0) != 0, (String)"Cannot find snapshot with ID %s, timestampMillis %s", (long)snapshotId, (long)timestampMillis);
            }
            return snapshot;
        }

        public static boolean requiresDataFilesInTableLocation(FeIcebergTable icebergTable) {
            org.apache.iceberg.Table icebergApiTable = icebergTable.getIcebergApiTable();
            Preconditions.checkNotNull((Object)icebergApiTable);
            Map properties = icebergApiTable.properties();
            if (BackendConfig.INSTANCE.icebergAllowDatafileInTableLocationOnly()) {
                return true;
            }
            return !PropertyUtil.propertyAsBoolean((Map)properties, (String)"write.object-storage.enabled", (boolean)false) && !StringUtils.isNotEmpty((CharSequence)((CharSequence)properties.get("write.data.path"))) && !StringUtils.isNotEmpty((CharSequence)((CharSequence)properties.get("write.location-provider.impl"))) && !StringUtils.isNotEmpty((CharSequence)((CharSequence)properties.get("write.object-storage.path"))) && !StringUtils.isNotEmpty((CharSequence)((CharSequence)properties.get("write.folder-storage.path")));
        }

        public static FileStatus createLocatedFileStatus(Path path, FileSystem fs) throws IOException {
            FileStatus fileStatus = fs.getFileStatus(path);
            Preconditions.checkState((boolean)fileStatus.isFile());
            BlockLocation[] blockLocations = fs.getFileBlockLocations(fileStatus, 0L, fileStatus.getLen());
            return new LocatedFileStatus(fileStatus, blockLocations);
        }

        public static FileStatus createFileStatus(ContentFile<?> contentFile, Path path) {
            return new FileStatus(contentFile.fileSizeInBytes(), false, 0, 0L, 1L, path);
        }

        public static long getTotalNumberOfFiles(FeIcebergTable icebergTable, TimeTravelSpec travelSpec) throws ImpalaRuntimeException {
            Map<String, String> snapshotSummary = Utils.getSnapshotSummary(icebergTable.getIcebergApiTable(), travelSpec);
            if (snapshotSummary == null) {
                throw new ImpalaRuntimeException("Invalid Iceberg snapshot summary");
            }
            try {
                String totalDataFilesProp = snapshotSummary.get("total-data-files");
                String totalDeleteFilesProp = snapshotSummary.getOrDefault("total-delete-files", "0");
                long totalDataFiles = Long.parseLong(totalDataFilesProp);
                long totalDeleteFiles = Long.parseLong(totalDeleteFilesProp);
                return totalDataFiles + totalDeleteFiles;
            }
            catch (NumberFormatException e) {
                throw new ImpalaRuntimeException("Invalid Iceberg snapshot summary value");
            }
        }
    }
}

