/*
 * Decompiled with CFR 0.152.
 */
package org.apache.impala.catalog;

import com.google.common.base.Preconditions;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hbase.Cell;
import org.apache.hadoop.hbase.ClusterStatus;
import org.apache.hadoop.hbase.HBaseConfiguration;
import org.apache.hadoop.hbase.HColumnDescriptor;
import org.apache.hadoop.hbase.HConstants;
import org.apache.hadoop.hbase.HRegionInfo;
import org.apache.hadoop.hbase.HRegionLocation;
import org.apache.hadoop.hbase.KeyValue;
import org.apache.hadoop.hbase.RegionLoad;
import org.apache.hadoop.hbase.ServerLoad;
import org.apache.hadoop.hbase.TableName;
import org.apache.hadoop.hbase.client.Admin;
import org.apache.hadoop.hbase.client.Connection;
import org.apache.hadoop.hbase.client.ConnectionFactory;
import org.apache.hadoop.hbase.client.RegionLocator;
import org.apache.hadoop.hbase.client.Result;
import org.apache.hadoop.hbase.client.ResultScanner;
import org.apache.hadoop.hbase.client.Scan;
import org.apache.hadoop.hbase.io.compress.Compression;
import org.apache.hadoop.hbase.util.Bytes;
import org.apache.hadoop.hive.metastore.api.FieldSchema;
import org.apache.hadoop.hive.metastore.api.MetaException;
import org.apache.hadoop.hive.metastore.api.Table;
import org.apache.hadoop.hive.serde2.SerDeException;
import org.apache.impala.catalog.Column;
import org.apache.impala.catalog.FeCatalogUtils;
import org.apache.impala.catalog.FeTable;
import org.apache.impala.catalog.HBaseColumn;
import org.apache.impala.catalog.TableLoadingException;
import org.apache.impala.catalog.Type;
import org.apache.impala.common.Pair;
import org.apache.impala.service.BackendConfig;
import org.apache.impala.thrift.TColumn;
import org.apache.impala.thrift.THBaseTable;
import org.apache.impala.thrift.TResultSet;
import org.apache.impala.thrift.TResultSetMetadata;
import org.apache.impala.util.StatsHelper;
import org.apache.impala.util.TResultRowBuilder;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public interface FeHBaseTable
extends FeTable {
    public Pair<Long, Long> getEstimatedRowStats(byte[] var1, byte[] var2);

    public String getHBaseTableName();

    public TResultSet getTableStats();

    public HColumnDescriptor[] getColumnFamilies() throws IOException;

    public static abstract class Util {
        public static final String HBASE_STORAGE_HANDLER = "org.apache.hadoop.hive.hbase.HBaseStorageHandler";
        public static final String ROW_KEY_COLUMN_FAMILY = ":key";
        static final String DEFAULT_PREFIX = "default.";
        static final int ROW_COUNT_ESTIMATE_BATCH_SIZE = 10;
        static final Configuration HBASE_CONF = HBaseConfiguration.create();
        private static final Logger LOG = LoggerFactory.getLogger(FeHBaseTable.class);
        private static final double DELTA_FROM_AVERAGE = 0.15;
        private static final int MIN_NUM_REGIONS_TO_CHECK = 5;
        private static final String HBASE_COLUMNS_MAPPING = "hbase.columns.mapping";
        private static final String HBASE_TABLE_DEFAULT_STORAGE_TYPE = "hbase.table.default.storage.type";
        private static final String HBASE_KEY_COL = ":key";
        private static final String HBASE_TABLE_NAME = "hbase.table.name";

        public static org.apache.hadoop.hbase.client.Table getHBaseTable(String hbaseTableName) throws IOException {
            return ConnectionHolder.getConnection().getTable(TableName.valueOf((String)hbaseTableName));
        }

        static org.apache.hadoop.hbase.client.Table getHBaseTable(FeHBaseTable tbl) throws IOException {
            return Util.getHBaseTable(tbl.getHBaseTableName());
        }

        public static List<Column> loadColumns(Table msTable) throws MetaException, SerDeException {
            HBaseColumn col;
            Map serdeParams = msTable.getSd().getSerdeInfo().getParameters();
            String hbaseColumnsMapping = (String)serdeParams.get(HBASE_COLUMNS_MAPPING);
            if (hbaseColumnsMapping == null) {
                throw new MetaException("No hbase.columns.mapping defined in Serde.");
            }
            String hbaseTableDefaultStorageType = (String)msTable.getParameters().get(HBASE_TABLE_DEFAULT_STORAGE_TYPE);
            boolean tableDefaultStorageIsBinary = false;
            if (hbaseTableDefaultStorageType != null && !hbaseTableDefaultStorageType.isEmpty()) {
                if (hbaseTableDefaultStorageType.equalsIgnoreCase("binary")) {
                    tableDefaultStorageIsBinary = true;
                } else if (!hbaseTableDefaultStorageType.equalsIgnoreCase("string")) {
                    throw new SerDeException("Error: hbase.table.default.storage.type parameter must be specified as 'string' or 'binary'; '" + hbaseTableDefaultStorageType + "' is not a valid specification for this table/serde property.");
                }
            }
            List fieldSchemas = msTable.getSd().getCols();
            ArrayList<String> hbaseColumnFamilies = new ArrayList<String>();
            ArrayList<String> hbaseColumnQualifiers = new ArrayList<String>();
            ArrayList<Boolean> hbaseColumnBinaryEncodings = new ArrayList<Boolean>();
            Util.parseColumnMapping(tableDefaultStorageIsBinary, hbaseColumnsMapping, msTable.getTableName(), fieldSchemas, hbaseColumnFamilies, hbaseColumnQualifiers, hbaseColumnBinaryEncodings);
            Preconditions.checkState((hbaseColumnFamilies.size() == hbaseColumnQualifiers.size() ? 1 : 0) != 0);
            Preconditions.checkState((fieldSchemas.size() == hbaseColumnFamilies.size() ? 1 : 0) != 0);
            ArrayList<HBaseColumn> tmpCols = new ArrayList<HBaseColumn>();
            Column keyCol = null;
            for (int i = 0; i < fieldSchemas.size(); ++i) {
                FieldSchema s = (FieldSchema)fieldSchemas.get(i);
                Type t = Type.INVALID;
                try {
                    t = FeCatalogUtils.parseColumnType(s, msTable.getTableName());
                }
                catch (TableLoadingException tableLoadingException) {
                    // empty catch block
                }
                HBaseColumn col2 = new HBaseColumn(s.getName(), (String)hbaseColumnFamilies.get(i), (String)hbaseColumnQualifiers.get(i), (Boolean)hbaseColumnBinaryEncodings.get(i), t, s.getComment(), -1);
                if (col2.getColumnFamily().equals(":key")) {
                    keyCol = col2;
                }
                tmpCols.add(col2);
            }
            Preconditions.checkState((keyCol != null ? 1 : 0) != 0);
            ArrayList<Column> cols = new ArrayList<Column>();
            if (BackendConfig.INSTANCE.useHmsColumnOrderForHBaseTables()) {
                for (int i = 0; i < tmpCols.size(); ++i) {
                    col = (HBaseColumn)tmpCols.get(i);
                    col.setPosition(i);
                    cols.add(col);
                }
            } else {
                tmpCols.remove(keyCol);
                keyCol.setPosition(0);
                cols.add(keyCol);
                Collections.sort(tmpCols);
                for (int i = 0; i < tmpCols.size(); ++i) {
                    col = (HBaseColumn)tmpCols.get(i);
                    col.setPosition(i + 1);
                    cols.add(col);
                }
            }
            return cols;
        }

        static void parseColumnMapping(boolean tableDefaultStorageIsBinary, String columnsMappingSpec, String tblName, List<FieldSchema> fieldSchemas, List<String> columnFamilies, List<String> columnQualifiers, List<Boolean> colIsBinaryEncoded) throws SerDeException {
            if (columnsMappingSpec == null) {
                throw new SerDeException("Error: hbase.columns.mapping missing for this HBase table.");
            }
            if (columnsMappingSpec.equals("") || columnsMappingSpec.equals(":key")) {
                throw new SerDeException("Error: hbase.columns.mapping specifies only the HBase table row key. A valid Hive-HBase table must specify at least one additional column.");
            }
            int rowKeyIndex = -1;
            String[] columnSpecs = columnsMappingSpec.split(",");
            int fsStartIdxOffset = fieldSchemas.size() - columnSpecs.length;
            if (fsStartIdxOffset != 0 && fsStartIdxOffset != 1) {
                throw new SerDeException(String.format("Number of entries in 'hbase.columns.mapping' does not match the number of columns in the table: %d != %d (counting the key if implicit)", columnSpecs.length, fieldSchemas.size()));
            }
            for (int i = 0; i < columnSpecs.length; ++i) {
                String mappingSpec = columnSpecs[i];
                String[] mapInfo = mappingSpec.split("#");
                String colInfo = mapInfo[0].trim();
                int idxFirst = colInfo.indexOf(":");
                int idxLast = colInfo.lastIndexOf(":");
                if (idxFirst < 0 || idxFirst != idxLast) {
                    throw new SerDeException("Error: the HBase columns mapping contains a badly formed column family, column qualifier specification.");
                }
                if (colInfo.equals(":key")) {
                    Preconditions.checkState((fsStartIdxOffset == 0 ? 1 : 0) != 0);
                    rowKeyIndex = i;
                    columnFamilies.add(colInfo);
                    columnQualifiers.add(null);
                } else {
                    String[] parts = colInfo.split(":");
                    Preconditions.checkState((parts.length > 0 && parts.length <= 2 ? 1 : 0) != 0);
                    columnFamilies.add(parts[0]);
                    if (parts.length == 2) {
                        columnQualifiers.add(parts[1]);
                    } else {
                        columnQualifiers.add(null);
                    }
                }
                FieldSchema fieldSchema = fieldSchemas.get(i + fsStartIdxOffset);
                boolean supportsBinaryEncoding = Util.supportsBinaryEncoding(fieldSchema, tblName);
                if (mapInfo.length == 1) {
                    colIsBinaryEncoded.add(tableDefaultStorageIsBinary && supportsBinaryEncoding);
                    continue;
                }
                if (mapInfo.length == 2) {
                    String storageOption = mapInfo[1];
                    if (!(storageOption.equals("-") || "string".startsWith(storageOption) || "binary".startsWith(storageOption))) {
                        throw new SerDeException("Error: A column storage specification is one of the following: '-', a prefix of 'string', or a prefix of 'binary'. " + storageOption + " is not a valid storage option specification for " + fieldSchema.getName());
                    }
                    boolean isBinaryEncoded = false;
                    if ("-".equals(storageOption)) {
                        isBinaryEncoded = tableDefaultStorageIsBinary;
                    } else if ("binary".startsWith(storageOption)) {
                        isBinaryEncoded = true;
                    }
                    if (isBinaryEncoded && !supportsBinaryEncoding) {
                        LOG.warn("Column storage specification for column " + fieldSchema.getName() + " is binary but the column type " + fieldSchema.getType() + " does not support binary encoding. Fallback to string format.");
                        isBinaryEncoded = false;
                    }
                    colIsBinaryEncoded.add(isBinaryEncoded);
                    continue;
                }
                throw new SerDeException("Error: hbase.columns.mapping storage specification " + mappingSpec + " is not valid for column: " + fieldSchema.getName());
            }
            if (rowKeyIndex == -1) {
                columnFamilies.add(0, ":key");
                columnQualifiers.add(0, null);
                colIsBinaryEncoded.add(0, Util.supportsBinaryEncoding(fieldSchemas.get(0), tblName) && tableDefaultStorageIsBinary);
            }
        }

        public static Pair<Long, Long> getEstimatedRowStats(FeHBaseTable tbl, byte[] startRowKey, byte[] endRowKey) {
            Preconditions.checkNotNull((Object)startRowKey);
            Preconditions.checkNotNull((Object)endRowKey);
            if (LOG.isTraceEnabled()) {
                LOG.trace("getEstimatedRowStats for {} for key range ('{}', '{}')", new Object[]{tbl.getHBaseTableName(), Bytes.toString((byte[])startRowKey), Bytes.toString((byte[])endRowKey)});
            }
            long startTime = System.currentTimeMillis();
            boolean isCompressed = false;
            try {
                long rowCount;
                ClusterStatus clusterStatus = Util.getClusterStatus();
                HColumnDescriptor[] columnFamilies = tbl.getColumnFamilies();
                Preconditions.checkNotNull((Object)columnFamilies);
                for (HColumnDescriptor desc : columnFamilies) {
                    isCompressed |= desc.getCompression() != Compression.Algorithm.NONE;
                }
                List<HRegionLocation> locations = Util.getRegionsInRange(tbl, startRowKey, endRowKey);
                Collections.shuffle(locations);
                StatsHelper<Number> statsSize = new StatsHelper<Number>();
                long totalEstimatedRows = 0L;
                if (LOG.isTraceEnabled()) {
                    LOG.trace("Start rows sampling on " + locations.size() + " regions");
                }
                while ((statsSize.count() < 5L || statsSize.stddev() > statsSize.mean() * 0.15) && statsSize.count() < (long)locations.size()) {
                    HRegionLocation currentLocation = locations.get((int)statsSize.count());
                    Pair<Long, Long> tmp = Util.getEstimatedRowStatsForRegion(tbl, currentLocation, isCompressed, clusterStatus);
                    totalEstimatedRows += ((Long)tmp.first).longValue();
                    statsSize.addSample((Number)tmp.second);
                    if (!LOG.isTraceEnabled()) continue;
                    LOG.trace("Estimation state: totalEstimatedRows={}, statsSize.count={}, statsSize.stddev={}, statsSize.mean={}", new Object[]{totalEstimatedRows, statsSize.count(), statsSize.stddev(), statsSize.mean()});
                }
                long totalSize = 0L;
                for (HRegionLocation location : locations) {
                    totalSize += Util.getRegionSize(location, clusterStatus);
                }
                if (totalSize == 0L) {
                    rowCount = totalEstimatedRows;
                } else {
                    if (statsSize.mean() < 1.0) {
                        LOG.warn("Table {}: no data available to compute row count estimate for key range ('{}', '{}')", new Object[]{tbl.getFullName(), Bytes.toString((byte[])startRowKey), Bytes.toString((byte[])endRowKey)});
                        return new Pair<Long, Long>(-1L, -1L);
                    }
                    rowCount = (long)((double)totalSize / statsSize.mean());
                }
                long rowSize = (long)statsSize.mean();
                if (LOG.isTraceEnabled()) {
                    LOG.trace("getEstimatedRowStats results: rowCount={}, rowSize={}, timeElapsed={}ms", new Object[]{rowCount, rowSize, System.currentTimeMillis() - startTime});
                }
                return new Pair<Long, Long>(rowCount, rowSize);
            }
            catch (IOException ioe) {
                LOG.error("Error computing HBase row count estimate", (Throwable)ioe);
                return new Pair<Long, Long>(-1L, -1L);
            }
        }

        public static TResultSet getTableStats(FeHBaseTable tbl) {
            TResultSet result = new TResultSet();
            TResultSetMetadata resultSchema = new TResultSetMetadata();
            result.setSchema(resultSchema);
            resultSchema.addToColumns(new TColumn("Region Location", Type.STRING.toThrift()));
            resultSchema.addToColumns(new TColumn("Start RowKey", Type.STRING.toThrift()));
            resultSchema.addToColumns(new TColumn("Est. #Rows", Type.BIGINT.toThrift()));
            resultSchema.addToColumns(new TColumn("Size", Type.STRING.toThrift()));
            try {
                ClusterStatus clusterStatus = Util.getClusterStatus();
                long totalNumRows = 0L;
                long totalSize = 0L;
                List<HRegionLocation> regions = Util.getRegionsInRange(tbl, HConstants.EMPTY_END_ROW, HConstants.EMPTY_START_ROW);
                for (HRegionLocation region : regions) {
                    TResultRowBuilder rowBuilder = new TResultRowBuilder();
                    HRegionInfo regionInfo = region.getRegionInfo();
                    Pair<Long, Long> estRowStats = Util.getEstimatedRowStatsForRegion(tbl, region, false, clusterStatus);
                    long numRows = (Long)estRowStats.first;
                    long regionSize = Util.getRegionSize(region, clusterStatus);
                    totalNumRows += numRows;
                    totalSize += regionSize;
                    rowBuilder.add(String.valueOf(region.getHostname())).add(Bytes.toString((byte[])regionInfo.getStartKey())).add(numRows).addBytes(regionSize);
                    result.addToRows(rowBuilder.get());
                }
                if (regions.size() > 1) {
                    TResultRowBuilder rowBuilder = new TResultRowBuilder();
                    rowBuilder.add("Total").add("").add(totalNumRows).addBytes(totalSize);
                    result.addToRows(rowBuilder.get());
                }
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
            return result;
        }

        public static String getHBaseTableName(Table tbl) {
            String tableName = (String)tbl.getParameters().get(HBASE_TABLE_NAME);
            if (tableName == null) {
                tableName = (String)tbl.getSd().getSerdeInfo().getParameters().get(HBASE_TABLE_NAME);
            }
            if (tableName == null && (tableName = tbl.getDbName() + "." + tbl.getTableName()).startsWith(DEFAULT_PREFIX)) {
                tableName = tableName.substring(DEFAULT_PREFIX.length());
            }
            return tableName;
        }

        private static Pair<Long, Long> getEstimatedRowStatsForRegion(FeHBaseTable tbl, HRegionLocation location, boolean isCompressed, ClusterStatus clusterStatus) throws IOException {
            HRegionInfo info = location.getRegionInfo();
            Scan s = new Scan(info.getStartKey());
            s.setBatch(10);
            s.setMaxVersions(Short.MAX_VALUE);
            s.setCacheBlocks(false);
            s.setRaw(false);
            long currentRowSize = 0L;
            long currentRowCount = 0L;
            try (org.apache.hadoop.hbase.client.Table table = Util.getHBaseTable(tbl);
                 ResultScanner rs = table.getScanner(s);){
                for (int i = 0; i < 10; ++i) {
                    Cell[] cells;
                    Result r = rs.next();
                    if (r == null) {
                        break;
                    }
                    if (r.isEmpty()) continue;
                    ++currentRowCount;
                    for (Cell c : cells = r.rawCells()) {
                        if (c instanceof KeyValue) {
                            currentRowSize += KeyValue.getKeyValueDataStructureSize((int)c.getRowLength(), (int)c.getFamilyLength(), (int)c.getQualifierLength(), (int)c.getValueLength(), (int)c.getTagsLength());
                            continue;
                        }
                        throw new IllegalStateException("Celltype " + c.getClass().getName() + " not supported.");
                    }
                }
            }
            if (currentRowCount == 0L) {
                return new Pair<Long, Long>(0L, 0L);
            }
            long currentSize = Util.getRegionSize(location, clusterStatus);
            double bytesPerRow = (double)currentRowSize / (double)currentRowCount;
            if (currentSize == 0L) {
                return new Pair<Long, Long>(currentRowCount, (long)bytesPerRow);
            }
            long estimatedRowCount = (long)((double)(isCompressed ? 2 : 1) * ((double)currentSize / bytesPerRow));
            return new Pair<Long, Long>(estimatedRowCount, (long)bytesPerRow);
        }

        private static long getRegionSize(HRegionLocation location, ClusterStatus clusterStatus) {
            HRegionInfo info = location.getRegionInfo();
            ServerLoad serverLoad = clusterStatus.getLoad(location.getServerName());
            if (serverLoad == null) {
                LOG.error("Unable to find server load for server: " + location.getServerName() + " for location " + info.getRegionNameAsString());
                return 0L;
            }
            RegionLoad regionLoad = (RegionLoad)serverLoad.getRegionsLoad().get(info.getRegionName());
            if (regionLoad == null) {
                LOG.error("Unable to find regions load for server: " + location.getServerName() + " for location " + info.getRegionNameAsString());
                return 0L;
            }
            long megaByte = 0x100000L;
            return (long)regionLoad.getStorefileSizeMB() * 0x100000L;
        }

        public static THBaseTable getTHBaseTable(FeHBaseTable table) {
            THBaseTable tHbaseTable = new THBaseTable();
            tHbaseTable.setTableName(table.getHBaseTableName());
            for (Column c : table.getColumns()) {
                HBaseColumn hbaseCol = (HBaseColumn)c;
                tHbaseTable.addToFamilies(hbaseCol.getColumnFamily());
                if (hbaseCol.getColumnQualifier() != null) {
                    tHbaseTable.addToQualifiers(hbaseCol.getColumnQualifier());
                } else {
                    tHbaseTable.addToQualifiers("");
                }
                tHbaseTable.addToBinary_encoded(hbaseCol.isBinaryEncoded());
            }
            return tHbaseTable;
        }

        public static List<HRegionLocation> getRegionsInRange(FeHBaseTable tbl, byte[] startKey, byte[] endKey) throws IOException {
            long startTime = System.currentTimeMillis();
            try (org.apache.hadoop.hbase.client.Table hbaseTbl = Util.getHBaseTable(tbl);){
                HRegionLocation regionLocation;
                boolean endKeyIsEndOfTable = Bytes.equals((byte[])endKey, (byte[])HConstants.EMPTY_END_ROW);
                if (Bytes.compareTo((byte[])startKey, (byte[])endKey) > 0 && !endKeyIsEndOfTable) {
                    throw new IllegalArgumentException("Invalid range: " + Bytes.toStringBinary((byte[])startKey) + " > " + Bytes.toStringBinary((byte[])endKey));
                }
                ArrayList<HRegionLocation> regionList = new ArrayList<HRegionLocation>();
                byte[] currentKey = startKey;
                Connection connection = ConnectionHolder.getConnection();
                RegionLocator locator = connection.getRegionLocator(hbaseTbl.getName());
                do {
                    regionLocation = locator.getRegionLocation(currentKey, true);
                    regionList.add(regionLocation);
                } while (!Bytes.equals((byte[])(currentKey = regionLocation.getRegionInfo().getEndKey()), (byte[])HConstants.EMPTY_END_ROW) && (endKeyIsEndOfTable || Bytes.compareTo((byte[])currentKey, (byte[])endKey) < 0));
                if (LOG.isTraceEnabled()) {
                    LOG.trace("getRegionsInRange timeElapsed={}ms", (Object)(System.currentTimeMillis() - startTime));
                }
                ArrayList<HRegionLocation> arrayList = regionList;
                return arrayList;
            }
        }

        static ClusterStatus getClusterStatus() throws IOException {
            try (Admin admin = ConnectionHolder.getConnection().getAdmin();){
                ClusterStatus clusterStatus = admin.getClusterStatus();
                return clusterStatus;
            }
        }

        private static boolean supportsBinaryEncoding(FieldSchema fs, String tblName) {
            try {
                Type colType = FeCatalogUtils.parseColumnType(fs, tblName);
                return colType.isBoolean() || colType.isIntegerType() || colType.isFloatingPointType();
            }
            catch (TableLoadingException e) {
                return false;
            }
        }

        static class ConnectionHolder {
            private static Connection connection_ = null;

            ConnectionHolder() {
            }

            static synchronized Connection getConnection() throws IOException {
                if (connection_ == null || connection_.isClosed()) {
                    connection_ = ConnectionFactory.createConnection((Configuration)HBASE_CONF);
                }
                return connection_;
            }
        }
    }
}

