/*
 * Decompiled with CFR 0.152.
 */
package org.apache.impala.catalog;

import com.google.common.base.Joiner;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import javax.annotation.Nullable;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.impala.analysis.Expr;
import org.apache.impala.analysis.LiteralExpr;
import org.apache.impala.analysis.PartitionKeyValue;
import org.apache.impala.analysis.ToSqlUtils;
import org.apache.impala.catalog.Column;
import org.apache.impala.catalog.FeFsTable;
import org.apache.impala.catalog.FileDescriptor;
import org.apache.impala.catalog.HdfsFileFormat;
import org.apache.impala.catalog.HdfsStorageDescriptor;
import org.apache.impala.catalog.PrunablePartition;
import org.apache.impala.common.FileSystemUtil;
import org.apache.impala.thrift.TAccessLevel;
import org.apache.impala.thrift.TGetPartialCatalogObjectRequest;
import org.apache.impala.thrift.THdfsFileDesc;
import org.apache.impala.thrift.THdfsPartitionLocation;
import org.apache.impala.thrift.TNetworkAddress;
import org.apache.impala.thrift.TPartialPartitionInfo;
import org.apache.impala.thrift.TPartitionStats;
import org.apache.impala.util.ListMap;

public interface FeFsPartition
extends PrunablePartition {
    public String getPartitionName();

    public FeFsTable getTable();

    public ListMap<TNetworkAddress> getHostIndex();

    public FileSystemUtil.FsType getFsType();

    public List<FileDescriptor> getFileDescriptors();

    public List<FileDescriptor> getInsertFileDescriptors();

    public List<FileDescriptor> getDeleteFileDescriptors();

    public boolean hasFileDescriptors();

    public int getNumFileDescriptors();

    public String getLocation();

    public THdfsPartitionLocation getLocationAsThrift();

    public Path getLocationPath();

    default public FileSystem getFileSystem(Configuration conf) throws IOException {
        return this.getLocationPath().getFileSystem(conf);
    }

    public TAccessLevel getAccessLevel();

    public boolean isCacheable();

    public boolean isMarkedCached();

    public HdfsStorageDescriptor getInputFormatDescriptor();

    public HdfsFileFormat getFileFormat();

    @Nullable
    public TPartitionStats getPartitionStats();

    public boolean hasIncrementalStats();

    public byte[] getPartitionStatsCompressed();

    public long getSize();

    public long getNumRows();

    default public List<String> getPartitionValuesAsStrings(boolean mapNullsToHiveKey) {
        ArrayList<String> ret = new ArrayList<String>();
        for (LiteralExpr partValue : this.getPartitionValues()) {
            if (mapNullsToHiveKey) {
                ret.add(PartitionKeyValue.getPartitionKeyValueString(partValue, this.getTable().getNullPartitionKeyValue()));
                continue;
            }
            ret.add(partValue.getStringValue());
        }
        return ret;
    }

    public LiteralExpr getPartitionValue(int var1);

    public Map<String, String> getParameters();

    public long getWriteId();

    public FeFsPartition genInsertDeltaPartition();

    public FeFsPartition genDeleteDeltaPartition();

    default public TPartialPartitionInfo getDefaultPartialPartitionInfo(TGetPartialCatalogObjectRequest req) {
        TPartialPartitionInfo partInfo = new TPartialPartitionInfo(this.getId());
        if (req.table_info_selector.want_partition_names) {
            partInfo.setName(this.getPartitionName());
        }
        if (req.table_info_selector.want_partition_metadata) {
            partInfo.setHas_incremental_stats(this.hasIncrementalStats());
        }
        if (req.table_info_selector.want_partition_files) {
            partInfo.setLast_compaction_id(-1L);
            partInfo.insert_file_descriptors = new ArrayList<THdfsFileDesc>();
            partInfo.delete_file_descriptors = new ArrayList<THdfsFileDesc>();
            partInfo.file_descriptors = new ArrayList<THdfsFileDesc>();
            if (!this.getTable().isHiveAcid()) {
                for (FileDescriptor fd : this.getFileDescriptors()) {
                    partInfo.file_descriptors.add(fd.toThrift());
                }
            }
        }
        if (req.table_info_selector.want_partition_stats) {
            partInfo.setPartition_stats(this.getPartitionStatsCompressed());
        }
        partInfo.setIs_marked_cached(this.isMarkedCached());
        return partInfo;
    }

    default public String getConjunctSql() {
        ArrayList<String> partColSql = new ArrayList<String>();
        for (Column partCol : this.getTable().getClusteringColumns()) {
            partColSql.add(ToSqlUtils.getIdentSql(partCol.getName()));
        }
        ArrayList<String> conjuncts = new ArrayList<String>();
        for (int i = 0; i < partColSql.size(); ++i) {
            LiteralExpr partVal = this.getPartitionValues().get(i);
            String partValSql = partVal.toSql();
            if (Expr.IS_NULL_LITERAL.apply((Object)partVal) || partValSql.isEmpty()) {
                conjuncts.add((String)partColSql.get(i) + " IS NULL");
                continue;
            }
            conjuncts.add((String)partColSql.get(i) + "=" + partValSql);
        }
        return "(" + Joiner.on((String)" AND ").join(conjuncts) + ")";
    }
}

