/*
 * Decompiled with CFR 0.152.
 */
package org.apache.impala.catalog;

import java.util.Comparator;
import java.util.List;
import java.util.Set;
import org.apache.hadoop.hive.metastore.api.Database;
import org.apache.hadoop.hive.metastore.api.Table;
import org.apache.impala.analysis.ColumnDef;
import org.apache.impala.analysis.KuduPartitionParam;
import org.apache.impala.catalog.CatalogException;
import org.apache.impala.catalog.FeFsTable;
import org.apache.impala.catalog.FeKuduTable;
import org.apache.impala.catalog.FeTable;
import org.apache.impala.catalog.Function;
import org.apache.impala.catalog.HasName;
import org.apache.impala.common.ImpalaRuntimeException;
import org.apache.impala.thrift.TDatabase;
import org.apache.impala.thrift.TFunctionCategory;
import org.apache.impala.thrift.TImpalaTableType;
import org.apache.impala.util.PatternMatcher;

public interface FeDb
extends HasName {
    public static final Comparator<FeDb> NAME_COMPARATOR = new Comparator<FeDb>(){

        @Override
        public int compare(FeDb db1, FeDb db2) {
            return db1.getName().compareTo(db2.getName());
        }
    };

    @Override
    public String getName();

    public Database getMetaStoreDb();

    public boolean containsTable(String var1);

    public FeTable getTable(String var1);

    public FeTable getTableIfCached(String var1);

    public List<String> getAllTableNames();

    public List<String> getAllTableNames(Set<TImpalaTableType> var1);

    public boolean isSystemDb();

    public Function getFunction(Function var1, Function.CompareMode var2);

    public List<Function> getFunctions(String var1);

    public List<Function> getFunctions(TFunctionCategory var1, String var2);

    public List<Function> getFunctions(TFunctionCategory var1, PatternMatcher var2);

    public int numFunctions();

    public boolean containsFunction(String var1);

    public TDatabase toThrift();

    public FeKuduTable createKuduCtasTarget(Table var1, List<ColumnDef> var2, List<ColumnDef> var3, boolean var4, List<KuduPartitionParam> var5) throws ImpalaRuntimeException;

    public FeFsTable createFsCtasTarget(Table var1) throws CatalogException;

    public String getOwnerUser();
}

