/*
 * Decompiled with CFR 0.152.
 */
package org.apache.impala.catalog;

import com.google.common.base.Preconditions;
import com.google.common.base.Strings;
import com.google.common.primitives.Shorts;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;

public class DiskIdMapper {
    public static DiskIdMapper INSTANCE = new DiskIdMapper();
    private Map<String, Short> storageUuidToDiskId_ = new ConcurrentHashMap<String, Short>();
    private final Map<String, Short> storageIdGenerator_ = new HashMap<String, Short>();

    private DiskIdMapper() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public short getDiskId(String host, String storageUuid) {
        Preconditions.checkState((!Strings.isNullOrEmpty((String)host) ? 1 : 0) != 0);
        short diskId = -1;
        Short shortId = this.storageUuidToDiskId_.get(storageUuid);
        if (shortId != null) {
            return shortId;
        }
        Map<String, Short> map = this.storageIdGenerator_;
        synchronized (map) {
            shortId = this.storageUuidToDiskId_.get(storageUuid);
            if (shortId != null) {
                return shortId;
            }
            if (this.storageIdGenerator_.containsKey(host)) {
                try {
                    diskId = Shorts.checkedCast((long)(this.storageIdGenerator_.get(host) + 1));
                }
                catch (IllegalStateException e) {
                    Preconditions.checkState((boolean)false, (Object)"Number of hosts exceeded 32767");
                }
            } else {
                diskId = 0;
            }
            this.storageIdGenerator_.put(host, diskId);
            this.storageUuidToDiskId_.put(storageUuid, diskId);
        }
        return diskId;
    }
}

