/*
 * Decompiled with CFR 0.152.
 */
package org.apache.impala.catalog;

import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Base64;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.atomic.AtomicReference;
import java.util.concurrent.locks.ReentrantLock;
import java.util.stream.Collectors;
import org.apache.hadoop.hive.metastore.api.Database;
import org.apache.hadoop.hive.metastore.api.PrincipalType;
import org.apache.impala.analysis.ColumnDef;
import org.apache.impala.analysis.KuduPartitionParam;
import org.apache.impala.catalog.CatalogException;
import org.apache.impala.catalog.CatalogObjectCache;
import org.apache.impala.catalog.CatalogObjectImpl;
import org.apache.impala.catalog.FeDb;
import org.apache.impala.catalog.FeFsTable;
import org.apache.impala.catalog.FeKuduTable;
import org.apache.impala.catalog.Function;
import org.apache.impala.catalog.HdfsTable;
import org.apache.impala.catalog.KuduTable;
import org.apache.impala.catalog.ScalarFunction;
import org.apache.impala.catalog.Table;
import org.apache.impala.catalog.Type;
import org.apache.impala.catalog.events.InFlightEvents;
import org.apache.impala.common.ImpalaException;
import org.apache.impala.common.ImpalaRuntimeException;
import org.apache.impala.thrift.TBriefTableMeta;
import org.apache.impala.thrift.TCatalogObject;
import org.apache.impala.thrift.TCatalogObjectType;
import org.apache.impala.thrift.TDatabase;
import org.apache.impala.thrift.TDbInfoSelector;
import org.apache.impala.thrift.TFunctionBinaryType;
import org.apache.impala.thrift.TFunctionCategory;
import org.apache.impala.thrift.TGetPartialCatalogObjectRequest;
import org.apache.impala.thrift.TGetPartialCatalogObjectResponse;
import org.apache.impala.thrift.TImpalaTableType;
import org.apache.impala.thrift.TPartialDbInfo;
import org.apache.impala.util.FunctionUtils;
import org.apache.impala.util.PatternMatcher;
import org.apache.thrift.TBase;
import org.apache.thrift.TException;
import org.apache.thrift.TSerializer;
import org.apache.thrift.protocol.TCompactProtocol;
import org.apache.thrift.protocol.TProtocolFactory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Db
extends CatalogObjectImpl
implements FeDb {
    private static final Logger LOG = LoggerFactory.getLogger(Db.class);
    private final AtomicReference<TDatabase> thriftDb_ = new AtomicReference();
    public static final String FUNCTION_INDEX_PREFIX = "impala_registered_function_";
    public static final String SYS = "sys";
    private static final int HIVE_METASTORE_DB_PARAM_LIMIT_BYTES = 4000;
    private final CatalogObjectCache<Table> tableCache_;
    private final Map<String, List<Function>> functions_;
    private boolean isSystemDb_ = false;
    private final InFlightEvents inFlightEvents_ = new InFlightEvents();
    private final ReentrantLock dbLock_ = new ReentrantLock();
    private long createEventId_ = -1L;
    private volatile long lastSyncedEventId_ = -1L;
    private volatile boolean isRemoved_ = false;

    public Db(String name, Database msDb) {
        this.setMetastoreDb(name, msDb);
        this.tableCache_ = new CatalogObjectCache();
        this.functions_ = new HashMap<String, List<Function>>();
    }

    public long getCreateEventId() {
        return this.createEventId_;
    }

    public void setCreateEventId(long eventId) {
        this.createEventId_ = eventId;
        LOG.debug("createEventId_ for db: {} set to: {}", (Object)this.getName(), (Object)this.createEventId_);
        if (this.lastSyncedEventId_ < eventId) {
            this.setLastSyncedEventId(eventId);
        }
    }

    public long getLastSyncedEventId() {
        return this.lastSyncedEventId_;
    }

    public void setLastSyncedEventId(long eventId) {
        LOG.debug("lastSyncedEventId_ for db: {} set from {} to {}", new Object[]{this.getName(), this.lastSyncedEventId_, eventId});
        this.lastSyncedEventId_ = eventId;
    }

    protected boolean isRemoved() {
        return this.isRemoved_;
    }

    protected void markRemoved() {
        this.isRemoved_ = true;
    }

    public void setIsSystemDb(boolean b) {
        this.isSystemDb_ = b;
    }

    public static Db fromTDatabase(TDatabase db) {
        return new Db(db.getDb_name(), db.getMetastore_db());
    }

    private void putToHmsParameters(String k, String v) {
        Database msDb = this.thriftDb_.get().metastore_db;
        Preconditions.checkNotNull((Object)msDb);
        HashMap<String, String> hmsParams = msDb.getParameters();
        if (hmsParams == null) {
            hmsParams = new HashMap<String, String>();
        }
        hmsParams.put(k, v);
        msDb.setParameters(hmsParams);
    }

    private boolean removeFromHmsParameters(String k) {
        Database msDb = this.thriftDb_.get().metastore_db;
        Preconditions.checkNotNull((Object)msDb);
        if (msDb.getParameters() == null) {
            return false;
        }
        return msDb.getParameters().remove(k) != null;
    }

    public ReentrantLock getLock() {
        return this.dbLock_;
    }

    @Override
    public boolean isSystemDb() {
        return this.isSystemDb_;
    }

    @Override
    public TDatabase toThrift() {
        return this.thriftDb_.get();
    }

    @Override
    public String getName() {
        return this.thriftDb_.get().getDb_name();
    }

    @Override
    public TCatalogObjectType getCatalogObjectType() {
        return TCatalogObjectType.DATABASE;
    }

    public void addTable(Table table) {
        this.tableCache_.add(table);
    }

    @Override
    public List<String> getAllTableNames() {
        return this.getAllTableNames(Collections.emptySet());
    }

    @Override
    public List<String> getAllTableNames(Set<TImpalaTableType> tableTypes) {
        if (!tableTypes.isEmpty()) {
            return this.tableCache_.getValues().stream().filter(table -> tableTypes.contains((Object)table.getTableType())).map(table -> table.getName()).collect(Collectors.toList());
        }
        return Lists.newArrayList(this.tableCache_.keySet());
    }

    public List<Table> getTables() {
        return this.tableCache_.getValues();
    }

    public int getNumTables() {
        return this.tableCache_.size();
    }

    @Override
    public boolean containsTable(String tableName) {
        return this.tableCache_.contains(tableName.toLowerCase());
    }

    @Override
    public Table getTable(String tblName) {
        return this.tableCache_.get(tblName);
    }

    @Override
    public Table getTableIfCached(String tblName) {
        return this.getTable(tblName);
    }

    public Table removeTable(String tableName) {
        return this.tableCache_.remove(tableName.toLowerCase());
    }

    @Override
    public FeKuduTable createKuduCtasTarget(org.apache.hadoop.hive.metastore.api.Table msTbl, List<ColumnDef> columnDefs, List<ColumnDef> primaryKeyColumnDefs, boolean isPrimaryKeyUnique, List<KuduPartitionParam> kuduPartitionParams) throws ImpalaRuntimeException {
        return KuduTable.createCtasTarget(this, msTbl, columnDefs, isPrimaryKeyUnique, primaryKeyColumnDefs, kuduPartitionParams);
    }

    @Override
    public FeFsTable createFsCtasTarget(org.apache.hadoop.hive.metastore.api.Table msTbl) throws CatalogException {
        return HdfsTable.createCtasTarget(this, msTbl);
    }

    @Override
    public Database getMetaStoreDb() {
        return this.thriftDb_.get().getMetastore_db();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int numFunctions() {
        Map<String, List<Function>> map = this.functions_;
        synchronized (map) {
            return this.functions_.size();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean containsFunction(String name) {
        Map<String, List<Function>> map = this.functions_;
        synchronized (map) {
            return this.functions_.get(name) != null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Function getFunction(Function desc, Function.CompareMode mode) {
        Map<String, List<Function>> map = this.functions_;
        synchronized (map) {
            List<Function> fns = this.functions_.get(desc.functionName());
            if (fns == null) {
                return null;
            }
            return FunctionUtils.resolveFunction(fns, desc, mode);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Function getFunction(String signatureString) {
        Map<String, List<Function>> map = this.functions_;
        synchronized (map) {
            for (List<Function> fns : this.functions_.values()) {
                for (Function f : fns) {
                    if (!f.signatureString().equals(signatureString)) continue;
                    return f;
                }
            }
        }
        return null;
    }

    private boolean addFunctionToDbParams(Function fn) {
        Preconditions.checkState((fn.getBinaryType() != TFunctionBinaryType.BUILTIN && fn.getBinaryType() != TFunctionBinaryType.JAVA ? 1 : 0) != 0);
        try {
            TSerializer serializer = new TSerializer((TProtocolFactory)new TCompactProtocol.Factory());
            byte[] serializedFn = serializer.serialize((TBase)fn.toThrift());
            String base64Fn = Base64.getEncoder().encodeToString(serializedFn);
            String fnKey = FUNCTION_INDEX_PREFIX + fn.signatureString();
            if (base64Fn.length() > 4000) {
                throw new ImpalaRuntimeException("Serialized function size exceeded HMS 4K byte limit");
            }
            this.putToHmsParameters(fnKey, base64Fn);
        }
        catch (ImpalaException | TException e) {
            LOG.error("Error adding function " + fn.getName() + " to DB params", e);
            return false;
        }
        return true;
    }

    public boolean addFunction(Function fn) {
        boolean addToDbParams = fn.getBinaryType() == TFunctionBinaryType.NATIVE || fn.getBinaryType() == TFunctionBinaryType.IR;
        return this.addFunction(fn, addToDbParams);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean addFunction(Function fn, boolean addToDbParams) {
        Preconditions.checkState((boolean)fn.dbName().equals(this.getName()));
        Map<String, List<Function>> map = this.functions_;
        synchronized (map) {
            if (this.getFunction(fn, Function.CompareMode.IS_INDISTINGUISHABLE) != null) {
                return false;
            }
            List<Function> fns = this.functions_.get(fn.functionName());
            if (fns == null) {
                fns = new ArrayList<Function>();
                this.functions_.put(fn.functionName(), fns);
            }
            if (addToDbParams && !this.addFunctionToDbParams(fn)) {
                return false;
            }
            fns.add(fn);
            Collections.sort(fns, FunctionUtils.FUNCTION_RESOLUTION_ORDER);
            return true;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Function removeFunction(Function desc) {
        Map<String, List<Function>> map = this.functions_;
        synchronized (map) {
            Function fn = this.getFunction(desc, Function.CompareMode.IS_INDISTINGUISHABLE);
            if (fn == null) {
                return null;
            }
            List<Function> fns = this.functions_.get(desc.functionName());
            Preconditions.checkNotNull(fns);
            fns.remove(fn);
            if (fns.isEmpty()) {
                this.functions_.remove(desc.functionName());
            }
            if (fn.getBinaryType() == TFunctionBinaryType.JAVA) {
                return fn;
            }
            String fnKey = FUNCTION_INDEX_PREFIX + fn.signatureString();
            boolean removeFn = this.removeFromHmsParameters(fnKey);
            Preconditions.checkState((boolean)removeFn);
            return fn;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeAllFunctions() {
        Map<String, List<Function>> map = this.functions_;
        synchronized (map) {
            this.functions_.clear();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Function removeFunction(String signatureStr) {
        Map<String, List<Function>> map = this.functions_;
        synchronized (map) {
            Function targetFn = this.getFunction(signatureStr);
            if (targetFn != null) {
                return this.removeFunction(targetFn);
            }
        }
        return null;
    }

    public void addScalarBuiltin(String fnName, String symbol, boolean userVisible, boolean varArgs, Type retType, Type ... args) {
        this.addScalarBuiltin(fnName, symbol, userVisible, null, null, varArgs, retType, args);
    }

    public void addScalarBuiltin(String fnName, String symbol, boolean userVisible, String prepareFnSymbol, String closeFnSymbol, boolean varArgs, Type retType, Type ... args) {
        Preconditions.checkState((boolean)this.isSystemDb());
        this.addBuiltin(ScalarFunction.createBuiltin(fnName, Lists.newArrayList((Object[])args), varArgs, retType, symbol, prepareFnSymbol, closeFnSymbol, userVisible));
    }

    public void addBuiltin(Function fn) {
        Preconditions.checkState((boolean)this.isSystemDb());
        Preconditions.checkState((fn != null ? 1 : 0) != 0);
        Preconditions.checkState((this.getFunction(fn, Function.CompareMode.IS_IDENTICAL) == null ? 1 : 0) != 0);
        this.addFunction(fn, false);
    }

    public Map<String, List<Function>> getAllFunctions() {
        return this.functions_;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected List<Function> getTransientFunctions() {
        ArrayList<Function> result = new ArrayList<Function>();
        Map<String, List<Function>> map = this.functions_;
        synchronized (map) {
            for (String fnKey : this.functions_.keySet()) {
                for (Function fn : this.functions_.get(fnKey)) {
                    if (!fn.userVisible() || fn.isPersistent()) continue;
                    result.add(fn);
                }
            }
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public List<Function> getFunctions(TFunctionCategory category, PatternMatcher matcher) {
        Preconditions.checkNotNull((Object)matcher);
        ArrayList<Function> result = new ArrayList<Function>();
        Map<String, List<Function>> map = this.functions_;
        synchronized (map) {
            for (Map.Entry<String, List<Function>> fns : this.functions_.entrySet()) {
                if (!matcher.matches(fns.getKey())) continue;
                for (Function fn : fns.getValue()) {
                    if (category != null && !Function.categoryMatch(fn, category) || !fn.userVisible()) continue;
                    result.add(fn);
                }
            }
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public List<Function> getFunctions(String name) {
        Preconditions.checkNotNull((Object)name);
        Map<String, List<Function>> map = this.functions_;
        synchronized (map) {
            List<Function> candidates = this.functions_.get(name);
            if (candidates == null) {
                return new ArrayList<Function>();
            }
            return FunctionUtils.getVisibleFunctions(candidates);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public List<Function> getFunctions(TFunctionCategory category, String name) {
        Preconditions.checkNotNull((Object)((Object)category));
        Preconditions.checkNotNull((Object)name);
        Map<String, List<Function>> map = this.functions_;
        synchronized (map) {
            List<Function> candidates = this.functions_.get(name);
            if (candidates == null) {
                return new ArrayList<Function>();
            }
            return FunctionUtils.getVisibleFunctionsInCategory(candidates, category);
        }
    }

    @Override
    public void setCatalogVersion(long newVersion) {
        LOG.info("Setting the catalog version of Db@{} {} to {}", new Object[]{Integer.toHexString(this.hashCode()), this.getName(), newVersion});
        super.setCatalogVersion(newVersion);
    }

    @Override
    protected void setTCatalogObject(TCatalogObject catalogObject) {
        catalogObject.setDb(this.toThrift());
    }

    public TCatalogObject toMinimalTCatalogObject() {
        TCatalogObject min = new TCatalogObject(this.getCatalogObjectType(), this.getCatalogVersion());
        min.setLast_modified_time_ms(this.getLastLoadedTimeMs());
        min.setDb(new TDatabase(this.getName()));
        return min;
    }

    public TGetPartialCatalogObjectResponse getPartialInfo(TGetPartialCatalogObjectRequest req) {
        TDbInfoSelector selector = (TDbInfoSelector)Preconditions.checkNotNull((Object)req.db_info_selector, (Object)"no db_info_selector");
        TGetPartialCatalogObjectResponse resp = new TGetPartialCatalogObjectResponse();
        resp.setObject_version_number(this.getCatalogVersion());
        resp.setObject_loaded_time_ms(this.getLastLoadedTimeMs());
        resp.db_info = new TPartialDbInfo();
        if (selector.want_hms_database) {
            resp.db_info.hms_database = this.getMetaStoreDb().deepCopy();
        }
        if (selector.want_brief_meta_of_tables) {
            ArrayList briefTableMetaList = Lists.newArrayListWithCapacity((int)this.tableCache_.keySet().size());
            for (Table tbl : this.tableCache_.getValues()) {
                TBriefTableMeta meta = new TBriefTableMeta(tbl.getName());
                meta.setTblType(tbl.getTableType());
                meta.setComment(tbl.getTableComment());
                org.apache.hadoop.hive.metastore.api.Table msTbl = tbl.getMetaStoreTable();
                if (msTbl != null) {
                    meta.setMsType(msTbl.getTableType());
                }
                briefTableMetaList.add(meta);
            }
            resp.db_info.brief_meta_of_tables = briefTableMetaList;
        }
        if (selector.want_function_names) {
            resp.db_info.function_names = ImmutableList.copyOf(this.functions_.keySet());
        }
        return resp;
    }

    public void setMetastoreDb(String name, Database msDb) {
        Preconditions.checkNotNull((Object)name);
        Preconditions.checkNotNull((Object)msDb);
        TDatabase tDatabase = new TDatabase(name.toLowerCase());
        tDatabase.setMetastore_db(msDb);
        this.thriftDb_.set(tDatabase);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean removeFromVersionsForInflightEvents(long versionNumber) {
        InFlightEvents inFlightEvents = this.inFlightEvents_;
        synchronized (inFlightEvents) {
            return this.inFlightEvents_.remove(false, versionNumber);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean addToVersionsForInflightEvents(long versionNumber) {
        Preconditions.checkState((boolean)this.dbLock_.isHeldByCurrentThread(), (Object)("addToVersionsForInFlightEvents called without getting the db lock for " + this.getName() + " database."));
        boolean added = false;
        InFlightEvents inFlightEvents = this.inFlightEvents_;
        synchronized (inFlightEvents) {
            added = this.inFlightEvents_.add(false, versionNumber);
        }
        if (!added) {
            LOG.warn(String.format("Could not add version %s to the list of in-flight events. This could cause unnecessary database %s invalidation when the event is processed", versionNumber, this.getName()));
        }
        return added;
    }

    @Override
    public String getOwnerUser() {
        Database db = this.getMetaStoreDb();
        return db == null ? null : (db.getOwnerType() == PrincipalType.USER ? db.getOwnerName() : null);
    }

    public boolean isLockHeldByCurrentThread() {
        return this.dbLock_.isHeldByCurrentThread();
    }
}

