/*
 * Decompiled with CFR 0.152.
 */
package org.apache.impala.catalog;

import com.google.common.base.Preconditions;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import org.apache.hadoop.hive.common.ValidWriteIdList;
import org.apache.hadoop.hive.metastore.IMetaStoreClient;
import org.apache.hadoop.hive.metastore.api.FieldSchema;
import org.apache.impala.catalog.Column;
import org.apache.impala.catalog.Db;
import org.apache.impala.catalog.FeDataSourceTable;
import org.apache.impala.catalog.PrimitiveType;
import org.apache.impala.catalog.Table;
import org.apache.impala.catalog.TableLoadingException;
import org.apache.impala.catalog.Type;
import org.apache.impala.common.ImpalaRuntimeException;
import org.apache.impala.extdatasource.ApiVersion;
import org.apache.impala.extdatasource.jdbc.conf.JdbcStorageConfig;
import org.apache.impala.thrift.TCatalogObjectType;
import org.apache.impala.thrift.TColumn;
import org.apache.impala.thrift.TDataSource;
import org.apache.impala.thrift.TDataSourceTable;
import org.apache.impala.thrift.TResultSet;
import org.apache.impala.thrift.TResultSetMetadata;
import org.apache.impala.thrift.TTable;
import org.apache.impala.thrift.TTableDescriptor;
import org.apache.impala.thrift.TTableType;
import org.apache.impala.util.EventSequence;
import org.apache.impala.util.JsonUtil;
import org.apache.impala.util.TResultRowBuilder;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DataSourceTable
extends Table
implements FeDataSourceTable {
    private static final Logger LOG = LoggerFactory.getLogger(DataSourceTable.class);
    public static final String TBL_PROP_DATA_SRC_NAME = "__IMPALA_DATA_SOURCE_NAME";
    public static final String TBL_PROP_INIT_STRING = "__IMPALA_DATA_SOURCE_INIT_STRING";
    public static final String TBL_PROP_LOCATION = "__IMPALA_DATA_SOURCE_LOCATION";
    public static final String TBL_PROP_CLASS = "__IMPALA_DATA_SOURCE_CLASS";
    public static final String TBL_PROP_API_VER = "__IMPALA_DATA_SOURCE_API_VERSION";
    public static final String IMPALA_BUILTIN_JDBC_DATASOURCE = "impalajdbcdatasource";
    public static final String IMPALA_JDBC_DATA_SRC_CLASSNAME = "org.apache.impala.extdatasource.jdbc.JdbcDataSource";
    private String initString_;
    private TDataSource dataSource_;

    protected DataSourceTable(org.apache.hadoop.hive.metastore.api.Table msTable, Db db, String name, String owner) {
        super(msTable, db, name, owner);
    }

    @Override
    public TDataSource getDataSource() {
        return this.dataSource_;
    }

    @Override
    public String getInitString() {
        return this.initString_;
    }

    @Override
    public int getNumNodes() {
        return 1;
    }

    @Override
    public boolean isJdbcDataSourceTable() {
        return this.dataSource_ != null && this.dataSource_.name != null && this.dataSource_.name.equals(IMPALA_BUILTIN_JDBC_DATASOURCE);
    }

    @Override
    public TCatalogObjectType getCatalogObjectType() {
        return TCatalogObjectType.TABLE;
    }

    public static boolean isSupportedColumnType(Type colType) {
        Preconditions.checkNotNull((Object)colType);
        return DataSourceTable.isSupportedPrimitiveType(colType.getPrimitiveType());
    }

    @Override
    public long getWriteId() {
        return -1L;
    }

    @Override
    public ValidWriteIdList getValidWriteIds() {
        return null;
    }

    public static boolean isSupportedPrimitiveType(PrimitiveType primitiveType) {
        Preconditions.checkNotNull((Object)((Object)primitiveType));
        switch (primitiveType) {
            case BIGINT: 
            case INT: 
            case SMALLINT: 
            case TINYINT: 
            case DOUBLE: 
            case FLOAT: 
            case BOOLEAN: 
            case STRING: 
            case TIMESTAMP: 
            case DECIMAL: 
            case DATE: {
                return true;
            }
        }
        return false;
    }

    public static void setJdbcDataSourceProperties(Map<String, String> tblProperties) throws ImpalaRuntimeException {
        Set tblPropertyKeys = tblProperties.keySet().stream().map(String::toLowerCase).collect(Collectors.toSet());
        for (JdbcStorageConfig config : JdbcStorageConfig.values()) {
            if (!config.isRequired() || tblPropertyKeys.contains(config.getPropertyName())) continue;
            throw new ImpalaRuntimeException(String.format("Required JDBC config '%s' is not present in table properties.", config.getPropertyName()));
        }
        tblProperties.put(TBL_PROP_DATA_SRC_NAME, IMPALA_BUILTIN_JDBC_DATASOURCE);
        if (!tblPropertyKeys.contains("transactional")) {
            tblProperties.put("transactional", "false");
        }
    }

    public static boolean isRequiredJdbcParameter(String propertyName) {
        for (JdbcStorageConfig config : JdbcStorageConfig.values()) {
            if (!config.getPropertyName().equalsIgnoreCase(propertyName)) continue;
            return config.isRequired();
        }
        return false;
    }

    private void loadColumns(List<FieldSchema> fieldSchemas, IMetaStoreClient client) throws TableLoadingException {
        int pos = 0;
        for (FieldSchema s : fieldSchemas) {
            Column col = new Column(s.getName(), this.parseColumnType(s), s.getComment(), pos);
            Preconditions.checkArgument((boolean)DataSourceTable.isSupportedColumnType(col.getType()));
            this.addColumn(col);
            ++pos;
        }
    }

    @Override
    protected void loadFromThrift(TTable thriftTable) throws TableLoadingException {
        super.loadFromThrift(thriftTable);
        TDataSourceTable dataSourceTable = thriftTable.getData_source_table();
        this.initString_ = dataSourceTable.getInit_string();
        this.dataSource_ = dataSourceTable.getData_source();
    }

    @Override
    public void load(boolean reuseMetadata, IMetaStoreClient client, org.apache.hadoop.hive.metastore.api.Table msTbl, String reason, EventSequence catalogTimeline) throws TableLoadingException {
        String dataSourceName;
        Preconditions.checkNotNull((Object)msTbl);
        Table.LOADING_TABLES.incrementAndGet();
        this.msTable_ = msTbl;
        this.clearColumns();
        if (LOG.isTraceEnabled()) {
            LOG.trace("load table: " + this.db_.getName() + "." + this.name_);
        }
        if ((dataSourceName = this.getTableProperty(msTbl, TBL_PROP_DATA_SRC_NAME, null, true)).equals(IMPALA_BUILTIN_JDBC_DATASOURCE)) {
            this.dataSource_ = new TDataSource(dataSourceName, "", IMPALA_JDBC_DATA_SRC_CLASSNAME, ApiVersion.V1.name());
            HashMap<String, String> tblProperties = new HashMap<String, String>();
            for (JdbcStorageConfig config : JdbcStorageConfig.values()) {
                String propertyValue = this.getTableProperty(msTbl, config.getPropertyName(), IMPALA_BUILTIN_JDBC_DATASOURCE, false);
                if (propertyValue == null) continue;
                tblProperties.put(config.getPropertyName(), propertyValue);
            }
            try {
                this.initString_ = JsonUtil.convertPropertyMapToJSON(tblProperties);
            }
            catch (ImpalaRuntimeException e) {
                throw new TableLoadingException(e.getMessage());
            }
        } else {
            String location = this.getTableProperty(msTbl, TBL_PROP_LOCATION, dataSourceName, true);
            String className = this.getTableProperty(msTbl, TBL_PROP_CLASS, dataSourceName, true);
            String apiVersionString = this.getTableProperty(msTbl, TBL_PROP_API_VER, dataSourceName, true);
            this.dataSource_ = new TDataSource(dataSourceName, location, className, apiVersionString);
            this.initString_ = this.getTableProperty(msTbl, TBL_PROP_INIT_STRING, dataSourceName, true);
        }
        if (msTbl.getPartitionKeysSize() > 0) {
            Table.LOADING_TABLES.decrementAndGet();
            throw new TableLoadingException("Data source table cannot contain clustering columns: " + this.name_);
        }
        this.numClusteringCols_ = 0;
        try {
            List fieldSchemas = this.getMetaStoreTable().getSd().getCols();
            this.loadColumns(fieldSchemas, client);
            this.setTableStats(this.msTable_);
            this.refreshLastUsedTime();
        }
        catch (Exception e) {
            throw new TableLoadingException("Failed to load metadata for data source table: " + this.name_, e);
        }
        finally {
            Table.LOADING_TABLES.decrementAndGet();
        }
    }

    private String getTableProperty(org.apache.hadoop.hive.metastore.api.Table msTbl, String key, String dataSourceName, boolean required) throws TableLoadingException {
        String val = (String)msTbl.getParameters().get(key);
        if (val == null && required) {
            if (key.equals(TBL_PROP_DATA_SRC_NAME)) {
                throw new TableLoadingException(String.format("Failed to load table %s. Missing required metadata: %s", this.name_, key));
            }
            if (dataSourceName.equals(IMPALA_BUILTIN_JDBC_DATASOURCE)) {
                throw new TableLoadingException(String.format("Failed to load table %s stored by JDBC. Missing required metadata: %s", this.name_, key));
            }
            throw new TableLoadingException(String.format("Failed to load table %s produced by external data source %s. Missing required metadata: %s", this.name_, dataSourceName, key));
        }
        return val;
    }

    @Override
    public TResultSet getTableStats() {
        TResultSet result = new TResultSet();
        TResultSetMetadata resultSchema = new TResultSetMetadata();
        resultSchema.addToColumns(new TColumn("#Rows", Type.BIGINT.toThrift()));
        result.setSchema(resultSchema);
        TResultRowBuilder rowBuilder = new TResultRowBuilder();
        rowBuilder.add(this.tableStats_.num_rows);
        result.addToRows(rowBuilder.get());
        return result;
    }

    @Override
    public TTableDescriptor toThriftDescriptor(int tableId, Set<Long> referencedPartitions) {
        TTableDescriptor tableDesc = new TTableDescriptor(tableId, TTableType.DATA_SOURCE_TABLE, this.getTColumnDescriptors(), this.numClusteringCols_, this.name_, this.db_.getName());
        tableDesc.setDataSourceTable(this.getDataSourceTable());
        return tableDesc;
    }

    @Override
    public TTable toThrift() {
        TTable table = super.toThrift();
        table.setTable_type(TTableType.DATA_SOURCE_TABLE);
        table.setData_source_table(this.getDataSourceTable());
        return table;
    }

    private TDataSourceTable getDataSourceTable() {
        return new TDataSourceTable(this.dataSource_, this.initString_);
    }

    public static boolean isDataSourceTable(org.apache.hadoop.hive.metastore.api.Table msTbl) {
        return msTbl.getParameters().containsKey(TBL_PROP_DATA_SRC_NAME);
    }

    public static Set<String> getJdbcTblPropertyMaskKeys() {
        return new HashSet<String>(Arrays.asList(JdbcStorageConfig.DBCP_PASSWORD.getPropertyName()));
    }
}

