/*
 * Decompiled with CFR 0.152.
 */
package org.apache.impala.catalog;

import com.google.common.base.Throwables;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.FutureTask;
import org.apache.hadoop.hive.metastore.api.GetLatestCommittedCompactionInfoRequest;
import org.apache.hadoop.hive.metastore.api.GetLatestCommittedCompactionInfoResponse;
import org.apache.impala.catalog.MetaStoreClientPool;
import org.apache.thrift.TException;

public class CompactionInfoLoader {
    private static final Map<GetLatestCommittedCompactionInfoRequest, FutureTask<GetLatestCommittedCompactionInfoResponse>> requests_ = new ConcurrentHashMap<GetLatestCommittedCompactionInfoRequest, FutureTask<GetLatestCommittedCompactionInfoResponse>>();

    public static GetLatestCommittedCompactionInfoResponse getLatestCompactionInfo(MetaStoreClientPool.MetaStoreClient client, GetLatestCommittedCompactionInfoRequest request) throws TException {
        FutureTask<GetLatestCommittedCompactionInfoResponse> reqTask = new FutureTask<GetLatestCommittedCompactionInfoResponse>(() -> client.getHiveClient().getLatestCommittedCompactionInfo(request));
        FutureTask<GetLatestCommittedCompactionInfoResponse> existingTask = requests_.putIfAbsent(request, reqTask);
        if (existingTask == null) {
            reqTask.run();
        } else {
            reqTask = existingTask;
        }
        try {
            GetLatestCommittedCompactionInfoResponse getLatestCommittedCompactionInfoResponse = reqTask.get();
            return getLatestCommittedCompactionInfoResponse;
        }
        catch (Exception e) {
            Throwables.propagateIfPossible((Throwable)e.getCause(), TException.class);
            throw new RuntimeException(e);
        }
        finally {
            requests_.remove(request, reqTask);
        }
    }
}

