/*
 * Decompiled with CFR 0.152.
 */
package org.apache.impala.catalog;

import com.google.common.base.Function;
import com.google.common.base.MoreObjects;
import com.google.common.base.Preconditions;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.List;
import org.apache.hadoop.hive.metastore.api.ColumnStatisticsData;
import org.apache.hadoop.hive.metastore.api.FieldSchema;
import org.apache.impala.catalog.ColumnStats;
import org.apache.impala.catalog.HBaseColumn;
import org.apache.impala.catalog.IcebergColumn;
import org.apache.impala.catalog.IcebergStructField;
import org.apache.impala.catalog.KuduColumn;
import org.apache.impala.catalog.StructField;
import org.apache.impala.catalog.StructType;
import org.apache.impala.catalog.Type;
import org.apache.impala.common.ImpalaRuntimeException;
import org.apache.impala.thrift.TColumn;
import org.apache.impala.thrift.TColumnDescriptor;
import org.apache.impala.thrift.TColumnStats;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Column {
    private static final Logger LOG = LoggerFactory.getLogger(Column.class);
    protected final String name_;
    protected final Type type_;
    protected final String comment_;
    protected int position_;
    protected final ColumnStats stats_;

    public Column(String name, Type type, int position) {
        this(name, type, null, position);
    }

    public Column(String name, Type type, String comment, int position) {
        Preconditions.checkState((boolean)name.equals(name.toLowerCase()));
        this.name_ = name;
        this.type_ = type;
        this.comment_ = comment;
        this.position_ = position;
        this.stats_ = new ColumnStats(type);
    }

    public String getComment() {
        return this.comment_;
    }

    public String getName() {
        return this.name_;
    }

    public Type getType() {
        return this.type_;
    }

    public int getPosition() {
        return this.position_;
    }

    public void setPosition(int position) {
        this.position_ = position;
    }

    public ColumnStats getStats() {
        return this.stats_;
    }

    public boolean isVirtual() {
        return false;
    }

    public boolean updateStats(ColumnStatisticsData statsData) {
        boolean statsDataCompatibleWithColType = this.stats_.update(this.name_, this.type_, statsData);
        if (LOG.isTraceEnabled()) {
            LOG.trace("col stats: " + this.name_ + " #distinct=" + this.stats_.getNumDistinctValues());
        }
        return statsDataCompatibleWithColType;
    }

    public void updateStats(TColumnStats statsData) {
        this.stats_.update(this.type_, statsData);
    }

    public String toString() {
        return MoreObjects.toStringHelper(this.getClass()).add("name_", (Object)this.name_).add("type_", (Object)this.type_).add("comment_", (Object)this.comment_).add("stats", (Object)this.stats_).add("position_", this.position_).toString();
    }

    public static Column fromThrift(TColumn columnDesc) throws ImpalaRuntimeException {
        Column col;
        String comment = columnDesc.isSetComment() ? columnDesc.getComment() : null;
        Preconditions.checkState((boolean)columnDesc.isSetPosition());
        int position = columnDesc.getPosition();
        Type type = Type.fromThrift(columnDesc.getColumnType());
        if (columnDesc.isIs_iceberg_column()) {
            Preconditions.checkState((boolean)columnDesc.isSetIceberg_field_id());
            col = new IcebergColumn(columnDesc.getColumnName(), type, comment, position, columnDesc.getIceberg_field_id(), columnDesc.getIceberg_field_map_key_id(), columnDesc.getIceberg_field_map_value_id(), columnDesc.isIs_nullable());
        } else if (columnDesc.isIs_hbase_column()) {
            Preconditions.checkState((boolean)columnDesc.isSetColumn_family());
            Preconditions.checkState((boolean)columnDesc.isSetIs_binary());
            col = new HBaseColumn(columnDesc.getColumnName(), columnDesc.getColumn_family(), columnDesc.getColumn_qualifier(), columnDesc.isIs_binary(), type, comment, position);
        } else {
            col = columnDesc.isIs_kudu_column() ? KuduColumn.fromThrift(columnDesc, position) : new Column(columnDesc.getColumnName(), type, comment, position);
        }
        if (columnDesc.isSetCol_stats()) {
            col.updateStats(columnDesc.getCol_stats());
        }
        return col;
    }

    public TColumn toThrift() {
        TColumn colDesc = new TColumn(this.name_, this.type_.toThrift());
        if (this.comment_ != null) {
            colDesc.setComment(this.comment_);
        }
        colDesc.setPosition(this.position_);
        colDesc.setCol_stats(this.getStats().toThrift());
        return colDesc;
    }

    public TColumnDescriptor toDescriptor() {
        return new TColumnDescriptor(this.getName(), this.getType().toThrift());
    }

    public static List<FieldSchema> toFieldSchemas(List<Column> columns) {
        return Lists.transform(columns, (Function)new Function<Column, FieldSchema>(){

            public FieldSchema apply(Column column) {
                Preconditions.checkNotNull((Object)column.getType());
                return new FieldSchema(column.getName(), column.getType().toSql().toLowerCase(), column.getComment());
            }
        });
    }

    public static List<String> toColumnNames(List<Column> columns) {
        ArrayList<String> colNames = new ArrayList<String>();
        for (Column col : columns) {
            colNames.add(col.getName());
        }
        return colNames;
    }

    public static StructType columnsToStruct(List<Column> columns) {
        ArrayList fields = Lists.newArrayListWithCapacity((int)columns.size());
        for (Column col : columns) {
            if (col instanceof IcebergColumn) {
                IcebergColumn iCol = (IcebergColumn)col;
                fields.add(new IcebergStructField(iCol.getName(), iCol.getType(), iCol.getComment(), iCol.getFieldId()));
                continue;
            }
            fields.add(new StructField(col.getName(), col.getType(), col.getComment()));
        }
        return new StructType(fields);
    }
}

