/*
 * Decompiled with CFR 0.152.
 */
package org.apache.impala.catalog;

import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import com.google.common.util.concurrent.ThreadFactoryBuilder;
import java.util.LinkedList;
import java.util.List;
import java.util.Queue;
import java.util.concurrent.Callable;
import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.concurrent.locks.Condition;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.apache.hadoop.hive.metastore.api.Database;
import org.apache.hadoop.hive.metastore.api.TableMeta;
import org.apache.impala.catalog.CatalogServiceCatalog;
import org.apache.impala.catalog.Function;
import org.apache.impala.common.Pair;
import org.apache.impala.service.BackendConfig;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CatalogResetManager {
    private static final Logger LOG = LoggerFactory.getLogger(CatalogResetManager.class);
    private static final int MAX_NUM_THREADS = BackendConfig.INSTANCE.getCatalogResetMaxThreads();
    private static final int MAX_FETCH_TASK = MAX_NUM_THREADS * 2;
    private final CatalogServiceCatalog catalog_;
    private final Condition fetchMetadataCondition_;
    private final Queue<Pair<String, Future<PrefetchedDatabaseObjects>>> fetchingDbs_;
    private final Queue<String> pendingDbNames_;
    private ExecutorService executorService_ = null;

    public CatalogResetManager(CatalogServiceCatalog catalog) {
        this.catalog_ = catalog;
        this.fetchMetadataCondition_ = catalog.getLock().writeLock().newCondition();
        this.fetchingDbs_ = new ConcurrentLinkedQueue<Pair<String, Future<PrefetchedDatabaseObjects>>>();
        this.pendingDbNames_ = new LinkedList<String>();
    }

    private boolean threadIsHoldingWriteLock() {
        return this.catalog_.getLock().writeLock().isHeldByCurrentThread();
    }

    protected void beginFetch(List<String> dbNames) {
        Preconditions.checkState((boolean)this.threadIsHoldingWriteLock());
        Preconditions.checkState((!this.isActive() ? 1 : 0) != 0, (Object)"Cannot begin reset while another reset is active.");
        Preconditions.checkState((this.executorService_ == null ? 1 : 0) != 0, (Object)"Existing executor service must be stopped first.");
        this.executorService_ = Executors.newFixedThreadPool(MAX_NUM_THREADS, new ThreadFactoryBuilder().setNameFormat("DatabaseResetMonitor-%d").build());
        dbNames.stream().map(String::toLowerCase).filter(dbName -> {
            boolean isBlacklisted = this.catalog_.isBlacklistedDbInternal((String)dbName);
            if (isBlacklisted) {
                LOG.info("Skipping reset for blacklisted database: " + dbName);
            }
            return !isBlacklisted;
        }).sorted().forEachOrdered(dbName -> this.pendingDbNames_.add((String)dbName));
        this.scheduleNextFetch();
    }

    private void scheduleNextFetch() {
        while (!this.pendingDbNames_.isEmpty() && this.fetchingDbs_.size() < MAX_FETCH_TASK) {
            String dbName = this.pendingDbNames_.poll();
            Future<PrefetchedDatabaseObjects> future = this.executorService_.submit(new MetastoreFetchTask(dbName));
            this.fetchingDbs_.add(Pair.create(dbName, future));
        }
    }

    protected boolean isActive() {
        return !this.fetchingDbs_.isEmpty();
    }

    protected void stop() {
        if (this.executorService_ != null) {
            this.executorService_.shutdown();
            this.executorService_ = null;
        }
        this.pendingDbNames_.clear();
        this.fetchingDbs_.clear();
    }

    protected void signalAllWaiters() {
        Preconditions.checkState((boolean)this.threadIsHoldingWriteLock());
        this.fetchMetadataCondition_.signalAll();
    }

    protected Pair<String, Future<PrefetchedDatabaseObjects>> peekFetchingDb() {
        return this.fetchingDbs_.peek();
    }

    protected Pair<String, Future<PrefetchedDatabaseObjects>> pollFetchingDb() {
        Preconditions.checkState((boolean)this.threadIsHoldingWriteLock());
        Pair<String, Future<PrefetchedDatabaseObjects>> pair = this.fetchingDbs_.poll();
        this.scheduleNextFetch();
        if (this.fetchingDbs_.isEmpty()) {
            this.stop();
        }
        return pair;
    }

    protected List<String> allFetcingDbList() {
        Preconditions.checkState((boolean)this.threadIsHoldingWriteLock());
        return Stream.concat(this.fetchingDbs_.stream().map(Pair::getFirst), this.pendingDbNames_.stream()).collect(Collectors.toList());
    }

    protected void waitFullMetadataFetch() {
        Preconditions.checkState((boolean)this.threadIsHoldingWriteLock());
        while (this.isActive()) {
            try {
                this.fetchMetadataCondition_.await();
            }
            catch (InterruptedException interruptedException) {}
        }
    }

    protected void waitOngoingMetadataFetch(String dbName) {
        this.waitOngoingMetadataFetch((List<String>)ImmutableList.of((Object)dbName));
    }

    protected void waitOngoingMetadataFetch(List<String> dbNames) {
        Preconditions.checkState((boolean)this.threadIsHoldingWriteLock());
        List lowerDbNames = dbNames.stream().map(String::toLowerCase).sorted().collect(Collectors.toList());
        int unlockedDbs = 0;
        while (unlockedDbs < lowerDbNames.size()) {
            String lowerDbName = (String)lowerDbNames.get(unlockedDbs);
            boolean hasWait = false;
            while (this.isPendingFetch(lowerDbName)) {
                if (!hasWait) {
                    LOG.info("Waiting metadata reset for database " + lowerDbName);
                    hasWait = true;
                }
                try {
                    this.fetchMetadataCondition_.await();
                }
                catch (InterruptedException interruptedException) {}
            }
            if (hasWait && lowerDbNames.size() > 1) {
                unlockedDbs = 0;
                continue;
            }
            ++unlockedDbs;
        }
    }

    private String dbNameAtFetchQueueHead() {
        if (this.fetchingDbs_.isEmpty()) {
            return null;
        }
        Pair<String, Future<PrefetchedDatabaseObjects>> pair = this.fetchingDbs_.peek();
        if (pair == null) {
            return null;
        }
        return (String)pair.first;
    }

    protected boolean isPendingFetch(String lowerCaseDbName) {
        Preconditions.checkState((boolean)this.threadIsHoldingWriteLock());
        String fetchingDbHead = this.dbNameAtFetchQueueHead();
        return fetchingDbHead != null && lowerCaseDbName.compareTo(fetchingDbHead) >= 0;
    }

    static /* synthetic */ CatalogServiceCatalog access$000(CatalogResetManager x0) {
        return x0.catalog_;
    }

    public static class PrefetchedDatabaseObjects {
        private final Database msDb_;
        private final List<TableMeta> tableMetas_;
        private final List<Function> nativeFunctions_;
        private final List<Function> javaFunctions_;
        private final long durationMs_;

        public PrefetchedDatabaseObjects(Database msDb, List<TableMeta> tableMetas, List<Function> nativeFunctions, List<Function> javaFunctions, long durationMs) {
            this.msDb_ = msDb;
            this.nativeFunctions_ = nativeFunctions;
            this.javaFunctions_ = javaFunctions;
            this.tableMetas_ = tableMetas;
            this.durationMs_ = durationMs;
        }

        public Database getMsDb() {
            return this.msDb_;
        }

        public List<Function> getNativeFunctions() {
            return this.nativeFunctions_;
        }

        public List<Function> getJavaFunctions() {
            return this.javaFunctions_;
        }

        public List<TableMeta> getTableMetas() {
            return this.tableMetas_;
        }

        public long getDurationMs() {
            return this.durationMs_;
        }
    }

    private class MetastoreFetchTask
    implements Callable<PrefetchedDatabaseObjects> {
        private final String dbName_;

        public MetastoreFetchTask(String dbName) {
            this.dbName_ = dbName;
        }

        /*
         * Exception decompiling
         */
        @Override
        public PrefetchedDatabaseObjects call() throws Exception {
            /*
             * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
             * 
             * org.benf.cfr.reader.util.ConfusedCFRException: Started 2 blocks at once
             *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
             *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
             *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
             *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
             *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
             *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
             *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
             *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseInnerClassesPass1(ClassFile.java:923)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1035)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
             *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
             *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
             *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
             *     at org.benf.cfr.reader.Main.main(Main.java:54)
             */
            throw new IllegalStateException("Decompilation failed");
        }
    }
}

