/*
 * Decompiled with CFR 0.152.
 */
package org.apache.impala.catalog;

import java.util.concurrent.atomic.AtomicLong;
import org.apache.impala.catalog.Catalog;
import org.apache.impala.catalog.CatalogObject;
import org.apache.impala.thrift.TCatalogObject;

public abstract class CatalogObjectImpl
implements CatalogObject {
    private AtomicLong catalogVersion_ = new AtomicLong(0L);
    private long mTimeMs_ = 0L;

    protected CatalogObjectImpl() {
    }

    @Override
    public long getCatalogVersion() {
        return this.catalogVersion_.get();
    }

    @Override
    public void setCatalogVersion(long newVersion) {
        this.catalogVersion_.set(newVersion);
        this.mTimeMs_ = System.currentTimeMillis();
    }

    @Override
    public long getLastLoadedTimeMs() {
        return this.mTimeMs_;
    }

    @Override
    public void setLastLoadedTimeMs(long timeMs) {
        this.mTimeMs_ = timeMs;
    }

    @Override
    public boolean isLoaded() {
        return true;
    }

    @Override
    public String getName() {
        return "";
    }

    @Override
    public String getUniqueName() {
        return Catalog.toCatalogObjectKey(this.toTCatalogObject());
    }

    public final TCatalogObject toTCatalogObject() {
        TCatalogObject catalogObject = new TCatalogObject(this.getCatalogObjectType(), this.getCatalogVersion());
        catalogObject.setLast_modified_time_ms(this.getLastLoadedTimeMs());
        this.setTCatalogObject(catalogObject);
        return catalogObject;
    }

    protected abstract void setTCatalogObject(TCatalogObject var1);
}

