/*
 * Decompiled with CFR 0.152.
 */
package org.apache.impala.catalog;

import com.google.common.base.Preconditions;
import com.google.common.collect.Lists;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import org.apache.impala.catalog.CatalogObject;
import org.apache.impala.catalog.CatalogObjectVersionSet;

public class CatalogObjectCache<T extends CatalogObject>
implements Iterable<T> {
    private final boolean caseInsensitiveKeys_;
    private final Map<String, T> metadataCache_ = new ConcurrentHashMap<String, T>();

    public CatalogObjectCache() {
        this(true);
    }

    public CatalogObjectCache(boolean caseInsensitiveKeys) {
        this.caseInsensitiveKeys_ = caseInsensitiveKeys;
    }

    public int size() {
        return this.metadataCache_.size();
    }

    public synchronized boolean add(T catalogObject) {
        CatalogObject existingItem;
        Preconditions.checkNotNull(catalogObject);
        String key = catalogObject.getName();
        if (this.caseInsensitiveKeys_) {
            key = key.toLowerCase();
        }
        if ((existingItem = (CatalogObject)this.metadataCache_.putIfAbsent(key, catalogObject)) == null) {
            CatalogObjectVersionSet.INSTANCE.addVersion(catalogObject.getCatalogVersion());
            return true;
        }
        if (existingItem.getCatalogVersion() < catalogObject.getCatalogVersion()) {
            this.metadataCache_.put(key, catalogObject);
            CatalogObjectVersionSet.INSTANCE.updateVersions(existingItem.getCatalogVersion(), catalogObject.getCatalogVersion());
            return true;
        }
        return false;
    }

    public synchronized T remove(String name) {
        CatalogObject removedObject;
        if (this.caseInsensitiveKeys_) {
            name = name.toLowerCase();
        }
        if ((removedObject = (CatalogObject)this.metadataCache_.remove(name)) != null) {
            CatalogObjectVersionSet.INSTANCE.removeVersion(removedObject.getCatalogVersion());
        }
        return (T)removedObject;
    }

    public synchronized void clear() {
        this.metadataCache_.clear();
    }

    public Set<String> keySet() {
        return this.metadataCache_.keySet();
    }

    public List<T> getValues() {
        return Lists.newArrayList(this.metadataCache_.values());
    }

    public boolean contains(String name) {
        if (this.caseInsensitiveKeys_) {
            name = name.toLowerCase();
        }
        return this.metadataCache_.containsKey(name);
    }

    public T get(String name) {
        if (this.caseInsensitiveKeys_) {
            name = name.toLowerCase();
        }
        return (T)((CatalogObject)this.metadataCache_.get(name));
    }

    @Override
    public Iterator<T> iterator() {
        return this.metadataCache_.values().iterator();
    }
}

