/*
 * Decompiled with CFR 0.152.
 */
package org.apache.impala.catalog;

import com.google.common.base.Stopwatch;
import com.google.common.base.Strings;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.util.concurrent.ThreadFactoryBuilder;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import javax.annotation.Nullable;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hive.common.ValidTxnList;
import org.apache.hadoop.hive.common.ValidWriteIdList;
import org.apache.hadoop.hive.metastore.PartitionExpressionProxy;
import org.apache.hadoop.hive.metastore.api.ColumnStatistics;
import org.apache.hadoop.hive.metastore.api.ColumnStatisticsDesc;
import org.apache.hadoop.hive.metastore.api.ColumnStatisticsObj;
import org.apache.hadoop.hive.metastore.api.FileMetadata;
import org.apache.hadoop.hive.metastore.api.GetPartitionsByNamesRequest;
import org.apache.hadoop.hive.metastore.api.GetPartitionsByNamesResult;
import org.apache.hadoop.hive.metastore.api.GetTableRequest;
import org.apache.hadoop.hive.metastore.api.GetTableResult;
import org.apache.hadoop.hive.metastore.api.MetaException;
import org.apache.hadoop.hive.metastore.api.NoSuchObjectException;
import org.apache.hadoop.hive.metastore.api.ObjectDictionary;
import org.apache.hadoop.hive.metastore.api.Partition;
import org.apache.hadoop.hive.metastore.api.PartitionsByExprRequest;
import org.apache.hadoop.hive.metastore.api.PartitionsByExprResult;
import org.apache.hadoop.hive.metastore.api.Table;
import org.apache.hadoop.hive.metastore.utils.MetaStoreUtils;
import org.apache.impala.analysis.TableName;
import org.apache.impala.catalog.CatalogException;
import org.apache.impala.catalog.CatalogServiceCatalog;
import org.apache.impala.catalog.FileDescriptor;
import org.apache.impala.catalog.FileMetadataLoader;
import org.apache.impala.catalog.GetPartialCatalogObjectRequestBuilder;
import org.apache.impala.catalog.metastore.HmsApiNameEnum;
import org.apache.impala.common.Pair;
import org.apache.impala.compat.MetastoreShim;
import org.apache.impala.thrift.CatalogLookupStatus;
import org.apache.impala.thrift.TGetPartialCatalogObjectRequest;
import org.apache.impala.thrift.TGetPartialCatalogObjectResponse;
import org.apache.impala.thrift.THdfsFileDesc;
import org.apache.impala.thrift.TNetworkAddress;
import org.apache.impala.thrift.TPartialPartitionInfo;
import org.apache.impala.util.AcidUtils;
import org.apache.impala.util.ListMap;
import org.apache.thrift.TBase;
import org.apache.thrift.TException;
import org.apache.thrift.TSerializer;
import org.apache.thrift.protocol.TCompactProtocol;
import org.apache.thrift.protocol.TProtocolFactory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CatalogHmsAPIHelper {
    private static final Logger LOG = LoggerFactory.getLogger(CatalogHmsAPIHelper.class);
    private static final long FALLBACK_FILE_MD_TIME_WARN_THRESHOLD_MS = 100L;
    private static final ExecutorService fallbackFdLoaderPool = Executors.newFixedThreadPool(20, new ThreadFactoryBuilder().setDaemon(true).setNameFormat("HMS-Filemetadata-loader-%d").build());
    public static final String IMPALA_TNETWORK_ADDRESSES = "impala:TNetworkAddress";

    public static GetTableResult getTableReq(CatalogServiceCatalog catalog, String defaultCatalogName, GetTableRequest getTableRequest) throws CatalogException, NoSuchObjectException, MetaException {
        CatalogHmsAPIHelper.checkCatalogName(getTableRequest.getCatName(), defaultCatalogName);
        CatalogHmsAPIHelper.checkCondition(getTableRequest.getDbName() != null, "Database name is null", new Object[0]);
        CatalogHmsAPIHelper.checkCondition(getTableRequest.getTblName() != null, "Table name is null", new Object[0]);
        String dbName = getTableRequest.getDbName();
        String tblName = getTableRequest.getTblName();
        TableName tableName = new TableName(dbName, tblName);
        GetPartialCatalogObjectRequestBuilder reqBuilder = new GetPartialCatalogObjectRequestBuilder().db(dbName).tbl(tblName);
        if (getTableRequest.isGetColumnStats()) {
            CatalogHmsAPIHelper.checkCondition(getTableRequest.getEngine() != null, "Column stats are requested but engine is not set in the request.", new Object[0]);
            CatalogHmsAPIHelper.checkCondition("impala".equalsIgnoreCase(getTableRequest.getEngine()), "Unsupported engine " + getTableRequest.getEngine() + " while requesting column statistics of the table " + dbName + "." + tblName, new Object[0]);
            reqBuilder.wantStatsForAllColums();
        }
        if (getTableRequest.isGetFileMetadata()) {
            reqBuilder.wantFiles();
        }
        if (getTableRequest.isSetValidWriteIdList()) {
            reqBuilder.writeId(getTableRequest.getValidWriteIdList());
        }
        TGetPartialCatalogObjectResponse response = CatalogHmsAPIHelper.getPartialCatalogObjResponse(catalog, reqBuilder.build(), dbName, tblName, HmsApiNameEnum.GET_TABLE_REQ.apiName());
        Table retTable = response.table_info.hms_table;
        CatalogHmsAPIHelper.checkCondition(!AcidUtils.isTransactionalTable(retTable.getParameters()) || getTableRequest.isSetValidWriteIdList(), "Table " + dbName + "." + tblName + " is transactional but it was requested without providing validWriteIdList", new Object[0]);
        if (getTableRequest.isGetColumnStats()) {
            List<ColumnStatisticsObj> columnStatisticsObjList = response.table_info.column_stats;
            CatalogHmsAPIHelper.checkCondition(columnStatisticsObjList != null, "Catalog returned a null ColumnStatisticsObj for table %s", tableName);
            ColumnStatistics columnStatistics = MetastoreShim.createNewHiveColStats();
            columnStatistics.setStatsDesc(new ColumnStatisticsDesc(true, dbName, tblName));
            for (ColumnStatisticsObj colsStatsObj : columnStatisticsObjList) {
                columnStatistics.addToStatsObj(colsStatsObj);
            }
            retTable.setColStats(columnStatistics);
        }
        if (getTableRequest.isGetFileMetadata()) {
            CatalogHmsAPIHelper.checkCondition(response.table_info.partitions != null, "File metadata was not returned by catalog", new Object[0]);
            CatalogHmsAPIHelper.checkCondition(response.table_info.partitions.size() == 1, "Retrieving file-metadata for partitioned tables must use partition level fetch APIs", new Object[0]);
            FileMetadata fileMetadata = new FileMetadata();
            if (response.table_info.partitions.get((int)0).insert_file_descriptors.size() == 0) {
                for (THdfsFileDesc fd : response.table_info.partitions.get((int)0).file_descriptors) {
                    fileMetadata.addToData(fd.file_desc_data);
                }
            } else {
                for (THdfsFileDesc fd : response.table_info.partitions.get((int)0).insert_file_descriptors) {
                    fileMetadata.addToData(fd.file_desc_data);
                }
                for (THdfsFileDesc fd : response.table_info.partitions.get((int)0).delete_file_descriptors) {
                    fileMetadata.addToData(fd.file_desc_data);
                }
            }
            retTable.setFileMetadata(fileMetadata);
            retTable.setDictionary(CatalogHmsAPIHelper.getSerializedNetworkAddress(response.table_info.network_addresses));
        }
        return new GetTableResult(retTable);
    }

    private static TGetPartialCatalogObjectResponse getPartialCatalogObjResponse(CatalogServiceCatalog catalog, TGetPartialCatalogObjectRequest request, String dbName, String tblName, String mesg) throws CatalogException, NoSuchObjectException {
        TGetPartialCatalogObjectResponse response = catalog.getPartialCatalogObject(request, mesg);
        CatalogHmsAPIHelper.checkCondition(response != null, "Catalog returned a null response", new Object[0]);
        if (response.lookup_status == CatalogLookupStatus.DB_NOT_FOUND) {
            throw new NoSuchObjectException("Database " + dbName + " not found");
        }
        if (response.lookup_status == CatalogLookupStatus.TABLE_NOT_FOUND) {
            throw new NoSuchObjectException("Table " + dbName + "." + tblName + " not found");
        }
        CatalogHmsAPIHelper.checkCondition(response.lookup_status != CatalogLookupStatus.TABLE_NOT_LOADED, "Could not load table %s.%s", dbName, tblName);
        CatalogHmsAPIHelper.checkCondition(response.table_info.hms_table != null, "Catalog returned a null table for %s.%s", dbName, tblName);
        return response;
    }

    public static PartitionsByExprResult getPartitionsByExpr(CatalogServiceCatalog catalog, String defaultCatalog, PartitionsByExprRequest request, PartitionExpressionProxy expressionProxy) throws CatalogException, NoSuchObjectException, MetaException {
        CatalogHmsAPIHelper.checkCatalogName(request.getCatName(), defaultCatalog);
        CatalogHmsAPIHelper.checkCondition(request.getDbName() != null, "Database name is null", new Object[0]);
        CatalogHmsAPIHelper.checkCondition(request.getTblName() != null, "Table name is null", new Object[0]);
        String dbName = request.getDbName();
        String tblName = request.getTblName();
        TableName tableName = new TableName(dbName, tblName);
        GetPartialCatalogObjectRequestBuilder catalogReq = new GetPartialCatalogObjectRequestBuilder().db(dbName).tbl(tblName).wantPartitions();
        if (request.isSetValidWriteIdList()) {
            catalogReq.writeId(request.getValidWriteIdList());
        }
        if (request.isSetId()) {
            catalogReq.tableId(request.getId());
        }
        TGetPartialCatalogObjectResponse response = CatalogHmsAPIHelper.getPartialCatalogObjResponse(catalog, catalogReq.build(), dbName, tblName, HmsApiNameEnum.GET_PARTITION_BY_EXPR.apiName());
        CatalogHmsAPIHelper.checkCondition(response.table_info.hms_table.getPartitionKeys() != null, "%s is not a partitioned table", tableName);
        HashMap<String, TPartialPartitionInfo> partitionNameToPartInfo = new HashMap<String, TPartialPartitionInfo>();
        for (TPartialPartitionInfo partInfo : response.getTable_info().getPartitions()) {
            partitionNameToPartInfo.put(partInfo.getName(), partInfo);
        }
        ArrayList filteredPartNames = Lists.newArrayList(partitionNameToPartInfo.keySet());
        Stopwatch st = Stopwatch.createStarted();
        boolean hasUnknownPartitions = expressionProxy.filterPartitionsByExpr(response.table_info.hms_table.getPartitionKeys(), request.getExpr(), request.getDefaultPartitionName(), (List)filteredPartNames);
        LOG.info("{}/{} partitions were selected for table {} after expression evaluation. Time taken: {} msec.", new Object[]{filteredPartNames.size(), partitionNameToPartInfo.size(), tableName, st.stop().elapsed(TimeUnit.MILLISECONDS)});
        ArrayList filteredPartitions = Lists.newArrayListWithCapacity((int)filteredPartNames.size());
        for (String partName : filteredPartNames) {
            CatalogHmsAPIHelper.checkCondition(partitionNameToPartInfo.containsKey(partName), "Could not find partition id for partition name " + partName, new Object[0]);
            TPartialPartitionInfo partInfo = (TPartialPartitionInfo)partitionNameToPartInfo.get(partName);
            CatalogHmsAPIHelper.checkCondition(partInfo != null, "Catalog did not return the partition " + partName + " for table " + tableName, partName, tableName);
            filteredPartitions.add(((TPartialPartitionInfo)partitionNameToPartInfo.get(partName)).getHms_partition());
        }
        CatalogHmsAPIHelper.checkCondition(filteredPartNames.size() == filteredPartitions.size(), "Unexpected number of partitions received. Expected %s got %s", filteredPartNames.size(), filteredPartitions.size());
        PartitionsByExprResult result = new PartitionsByExprResult();
        result.setPartitions((List)filteredPartitions);
        result.setHasUnknownPartitions(hasUnknownPartitions);
        return result;
    }

    private static void checkCondition(boolean condition, String msg, Object ... args) throws CatalogException {
        if (condition) {
            return;
        }
        throw new CatalogException(String.format(msg, args));
    }

    public static void checkCatalogName(String catalogName, String defaultCatalogName) throws MetaException {
        if (catalogName == null) {
            return;
        }
        try {
            CatalogHmsAPIHelper.checkCondition(defaultCatalogName != null, "Default catalog name is null", new Object[0]);
            CatalogHmsAPIHelper.checkCondition(defaultCatalogName.equalsIgnoreCase(catalogName), "Catalog service does not support non-default catalogs. Expected %s got %s", defaultCatalogName, catalogName);
        }
        catch (CatalogException ex) {
            LOG.error(ex.getMessage(), (Throwable)ex);
            throw new MetaException(ex.getMessage());
        }
    }

    public static GetPartitionsByNamesResult getPartitionsByNames(CatalogServiceCatalog catalog, Configuration serverConf, GetPartitionsByNamesRequest request) throws CatalogException, NoSuchObjectException, MetaException {
        String catAnddbName = request.getDb_name();
        String tblName = request.getTbl_name();
        CatalogHmsAPIHelper.checkCondition(!Strings.isNullOrEmpty((String)catAnddbName), "Database name is empty or null", new Object[0]);
        CatalogHmsAPIHelper.checkCondition(!Strings.isNullOrEmpty((String)tblName), "Table name is empty or null", new Object[0]);
        String[] parsedCatDbName = MetaStoreUtils.parseDbName((String)request.getDb_name(), (Configuration)serverConf);
        CatalogHmsAPIHelper.checkCondition(parsedCatDbName.length == 2, "Unexpected error during parsing the catalog and database name %s", catAnddbName);
        CatalogHmsAPIHelper.checkCatalogName(parsedCatDbName[0], MetaStoreUtils.getDefaultCatalog((Configuration)serverConf));
        String dbName = parsedCatDbName[1];
        CatalogHmsAPIHelper.checkCondition(!request.isGet_col_stats(), "Partition level column statistics are not supported in catalog", new Object[0]);
        GetPartialCatalogObjectRequestBuilder requestBuilder = new GetPartialCatalogObjectRequestBuilder().db(dbName).tbl(tblName).wantPartitions();
        if (request.isGetFileMetadata()) {
            requestBuilder.wantFiles();
        }
        if (request.isSetValidWriteIdList()) {
            requestBuilder.writeId(request.getValidWriteIdList());
        }
        TGetPartialCatalogObjectResponse response = CatalogHmsAPIHelper.getPartialCatalogObjResponse(catalog, requestBuilder.build(), dbName, tblName, HmsApiNameEnum.GET_PARTITION_BY_NAMES.apiName());
        CatalogHmsAPIHelper.checkCondition(response.table_info.hms_table.getPartitionKeys() != null, "%s.%s is not a partitioned table", dbName, tblName);
        CatalogHmsAPIHelper.checkCondition(!request.isGetFileMetadata() || response.table_info.network_addresses != null, "Network addresses were not returned for %s.%s", dbName, tblName);
        CatalogHmsAPIHelper.checkCondition(!AcidUtils.isTransactionalTable(response.table_info.hms_table.getParameters()) || request.isSetValidWriteIdList(), "Table " + dbName + "." + tblName + " is a transactional table but partitions were requested without providing validWriteIdList", new Object[0]);
        HashSet requestedNames = new HashSet(request.getNames());
        ArrayList<Partition> retPartitions = new ArrayList<Partition>();
        for (TPartialPartitionInfo partInfo : response.getTable_info().getPartitions()) {
            if (!requestedNames.contains(partInfo.getName())) continue;
            Partition part = partInfo.getHms_partition();
            if (request.isGetFileMetadata()) {
                FileMetadata fileMetadata = new FileMetadata();
                CatalogHmsAPIHelper.checkCondition(partInfo.file_descriptors != null, "Catalog did not return file descriptors for partition %s of table %s.%s", partInfo.getName(), dbName, tblName);
                if (partInfo.insert_file_descriptors.isEmpty()) {
                    for (THdfsFileDesc fd : partInfo.file_descriptors) {
                        fileMetadata.addToData(fd.file_desc_data);
                    }
                } else {
                    for (THdfsFileDesc fd : partInfo.insert_file_descriptors) {
                        fileMetadata.addToData(fd.file_desc_data);
                    }
                    for (THdfsFileDesc fd : partInfo.delete_file_descriptors) {
                        fileMetadata.addToData(fd.file_desc_data);
                    }
                }
                part.setFileMetadata(fileMetadata);
            }
            retPartitions.add(part);
        }
        GetPartitionsByNamesResult result = new GetPartitionsByNamesResult(retPartitions);
        if (request.isGetFileMetadata()) {
            result.setDictionary(CatalogHmsAPIHelper.getSerializedNetworkAddress(response.table_info.network_addresses));
        }
        return result;
    }

    public static ObjectDictionary getSerializedNetworkAddress(List<TNetworkAddress> networkAddresses) throws CatalogException {
        CatalogHmsAPIHelper.checkCondition(networkAddresses != null, "Network addresses is null", new Object[0]);
        ObjectDictionary result = new ObjectDictionary((Map)Maps.newHashMap());
        if (networkAddresses.isEmpty()) {
            return result;
        }
        ArrayList<ByteBuffer> serializedAddresses = new ArrayList<ByteBuffer>();
        TSerializer serializer = null;
        try {
            serializer = new TSerializer((TProtocolFactory)new TCompactProtocol.Factory());
        }
        catch (TException e) {
            throw new CatalogException("Could not create serializer. " + e.getMessage());
        }
        for (TNetworkAddress networkAddress : networkAddresses) {
            byte[] serializedNetAddress;
            try {
                serializedNetAddress = serializer.serialize((TBase)networkAddress);
            }
            catch (TException tException) {
                throw new CatalogException("Could not serialize network address " + networkAddress.hostname + ":" + networkAddress.port, tException);
            }
            serializedAddresses.add(ByteBuffer.wrap(serializedNetAddress));
        }
        result.putToValues(IMPALA_TNETWORK_ADDRESSES, serializedAddresses);
        return result;
    }

    public static void loadAndSetFileMetadataFromFs(@Nullable ValidTxnList validTxnList, @Nullable ValidWriteIdList writeIdList, GetTableResult result) throws MetaException {
        try {
            Stopwatch sw = Stopwatch.createStarted();
            Table tbl = result.getTable();
            CatalogHmsAPIHelper.checkCondition(tbl != null, "Table is null", new Object[0]);
            CatalogHmsAPIHelper.checkCondition(tbl.getSd() != null && tbl.getSd().getLocation() != null, "Cannot get the location of table %s.%s", tbl.getDbName(), tbl.getTableName());
            ListMap<TNetworkAddress> hostIndex = new ListMap<TNetworkAddress>();
            FileMetadataLoader fmLoader = new FileMetadataLoader(tbl.getSd().getLocation(), true, Collections.EMPTY_LIST, hostIndex, validTxnList, writeIdList);
            boolean success = CatalogHmsAPIHelper.getFileMetadata(Arrays.asList(fmLoader));
            CatalogHmsAPIHelper.checkCondition(success, "Could not load file-metadata for table %s.%s. See catalogd log for details", tbl.getDbName(), tbl.getTableName());
            FileMetadata fileMetadata = new FileMetadata();
            for (FileDescriptor fd : fmLoader.getLoadedFds()) {
                fileMetadata.addToData(fd.toThrift().file_desc_data);
            }
            tbl.setFileMetadata(fileMetadata);
            tbl.setDictionary(CatalogHmsAPIHelper.getSerializedNetworkAddress(hostIndex.getList()));
            long timeTaken = sw.stop().elapsed(TimeUnit.MILLISECONDS);
            if (timeTaken > 100L) {
                LOG.warn("Loading the filemetadata for table {}.{} on the fallback path. Time taken: {} msec", new Object[]{tbl.getDbName(), tbl.getTableName(), timeTaken});
            } else {
                LOG.debug("Loading the filemetadata for table {}.{} on the fallback path. Time taken: {} msec", new Object[]{tbl.getDbName(), tbl.getTableName(), timeTaken});
            }
        }
        catch (Exception ex) {
            LOG.error("Unexpected error when loading filemetadata", (Throwable)ex);
            throw new MetaException("Could not load filemetadata. Cause " + ex.getMessage());
        }
    }

    public static void loadAndSetFileMetadataFromFs(@Nullable ValidTxnList txnList, @Nullable ValidWriteIdList writeIdList, GetPartitionsByNamesResult getPartsResult) throws MetaException {
        if (getPartsResult.getPartitionsSize() == 0) {
            return;
        }
        String dbName = ((Partition)getPartsResult.getPartitions().get(0)).getDbName();
        String tblName = ((Partition)getPartsResult.getPartitions().get(0)).getTableName();
        try {
            Stopwatch sw = Stopwatch.createStarted();
            HashMap<Object, FileMetadataLoader> fileMdLoaders = new HashMap<Object, FileMetadataLoader>();
            ListMap<TNetworkAddress> hostIndex = new ListMap<TNetworkAddress>();
            for (Object part : getPartsResult.getPartitions()) {
                CatalogHmsAPIHelper.checkCondition(part.getSd() != null && part.getSd().getLocation() != null, "Could not get the location for partition %s of table %s.%s", part.getValues(), part.getDbName(), part.getTableName());
                fileMdLoaders.put(part, new FileMetadataLoader(part.getSd().getLocation(), true, Collections.EMPTY_LIST, hostIndex, txnList, writeIdList));
            }
            boolean success = CatalogHmsAPIHelper.getFileMetadata(fileMdLoaders.values());
            CatalogHmsAPIHelper.checkCondition(success, "Could not load file-metadata for %s partitions of table %s.%s. See catalogd log for details", getPartsResult.getPartitionsSize(), dbName, tblName);
            for (Map.Entry entry : fileMdLoaders.entrySet()) {
                FileMetadata filemetadata = new FileMetadata();
                for (FileDescriptor fd : ((FileMetadataLoader)entry.getValue()).getLoadedFds()) {
                    filemetadata.addToData(fd.toThrift().file_desc_data);
                }
                ((Partition)entry.getKey()).setFileMetadata(filemetadata);
            }
            getPartsResult.setDictionary(CatalogHmsAPIHelper.getSerializedNetworkAddress(hostIndex.getList()));
            long timeTaken = sw.stop().elapsed(TimeUnit.MILLISECONDS);
            if (timeTaken > 100L) {
                LOG.info("Loading the file metadata for {} partitions of table {}.{} on the fallback path. Time taken: {} msec", new Object[]{getPartsResult.getPartitionsSize(), dbName, tblName, timeTaken});
            } else {
                LOG.debug("Loading the file metadata for {} partitions of table {}.{} on the fallback path. Time taken: {} msec", new Object[]{getPartsResult.getPartitionsSize(), dbName, tblName, timeTaken});
            }
        }
        catch (CatalogException ex) {
            LOG.error("Unexpected error when loading file-metadata for partitions of table {}.{}", new Object[]{dbName, tblName, ex});
            throw new MetaException("Could not load file metadata. Cause " + ex.getMessage());
        }
    }

    private static boolean getFileMetadata(Collection<FileMetadataLoader> loaders) {
        ArrayList<Pair<String, Future<Void>>> futures = new ArrayList<Pair<String, Future<Void>>>(loaders.size());
        for (FileMetadataLoader fmdLoader : loaders) {
            futures.add(new Pair<String, Future<Void>>(fmdLoader.getPartDir(), fallbackFdLoaderPool.submit(() -> {
                fmdLoader.load();
                return null;
            })));
        }
        int numberOfErrorsToLog = 100;
        int errors = 0;
        for (Pair pair : futures) {
            try {
                ((Future)pair.second).get();
            }
            catch (InterruptedException | ExecutionException e) {
                if (++errors >= numberOfErrorsToLog) continue;
                LOG.error("Could not load file-metadata for path {}", pair.first, (Object)e);
            }
        }
        if (errors > 0 && numberOfErrorsToLog - errors > 0) {
            LOG.error("{} loading errors were not logged. Only logged the first {} errors", (Object)(numberOfErrorsToLog - errors), (Object)numberOfErrorsToLog);
        }
        return errors == 0;
    }
}

