/*
 * Decompiled with CFR 0.152.
 */
package org.apache.impala.catalog;

import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import java.util.ArrayDeque;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Queue;
import java.util.SortedMap;
import java.util.TreeMap;
import org.apache.commons.lang3.StringUtils;
import org.apache.impala.catalog.Catalog;
import org.apache.impala.service.BackendConfig;
import org.apache.impala.thrift.TCatalogObject;
import org.apache.impala.thrift.TCatalogObjectType;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CatalogDeltaLog {
    private static final Logger LOG = LoggerFactory.getLogger(CatalogDeltaLog.class);
    private final int deleteLogTtl_;
    private final Queue<Long> catalogUpdateVersions_;
    private SortedMap<Long, TCatalogObject> removedCatalogObjects_;
    private Map<String, Long> latestRemovedVersions_;

    public CatalogDeltaLog() {
        this.deleteLogTtl_ = BackendConfig.INSTANCE == null ? 60 : BackendConfig.INSTANCE.getBackendCfg().catalog_delete_log_ttl;
        this.catalogUpdateVersions_ = new ArrayDeque<Long>(this.deleteLogTtl_);
        this.removedCatalogObjects_ = new TreeMap<Long, TCatalogObject>();
        this.latestRemovedVersions_ = new HashMap<String, Long>();
    }

    public synchronized void addRemovedObject(TCatalogObject catalogObject) {
        Preconditions.checkNotNull((Object)catalogObject);
        this.removedCatalogObjects_.put(catalogObject.getCatalog_version(), catalogObject);
        String key = Catalog.toCatalogObjectKey(catalogObject);
        this.latestRemovedVersions_.merge(key, catalogObject.catalog_version, Long::max);
    }

    public synchronized List<TCatalogObject> retrieveObjects(long fromVersion, long toVersion) {
        SortedMap<Long, TCatalogObject> objects = this.removedCatalogObjects_.subMap(fromVersion + 1L, toVersion + 1L);
        return ImmutableList.copyOf(objects.values());
    }

    public synchronized List<TCatalogObject> retrieveDbObjects() {
        HashMap<String, TCatalogObject> res = new HashMap<String, TCatalogObject>();
        for (TCatalogObject obj : this.removedCatalogObjects_.values()) {
            if (obj.type != TCatalogObjectType.DATABASE) continue;
            res.put(Catalog.toCatalogObjectKey(obj), obj);
        }
        return ImmutableList.copyOf(res.values());
    }

    public synchronized List<TCatalogObject> retrieveTableObjects(String dbName) {
        HashMap<String, TCatalogObject> res = new HashMap<String, TCatalogObject>();
        for (TCatalogObject obj : this.removedCatalogObjects_.values()) {
            if (obj.type != TCatalogObjectType.TABLE || !StringUtils.equals((CharSequence)dbName, (CharSequence)obj.table.db_name)) continue;
            res.put(Catalog.toCatalogObjectKey(obj), obj);
        }
        return ImmutableList.copyOf(res.values());
    }

    public synchronized void garbageCollect(long lastTopicUpdateVersion) {
        if (!this.catalogUpdateVersions_.isEmpty() && this.catalogUpdateVersions_.size() >= this.deleteLogTtl_) {
            this.garbageCollectInternal(this.catalogUpdateVersions_.poll());
        }
        this.catalogUpdateVersions_.offer(lastTopicUpdateVersion);
    }

    public void garbageCollectInternal(long catalogVersion) {
        if (!this.removedCatalogObjects_.isEmpty() && this.removedCatalogObjects_.firstKey() < catalogVersion) {
            int originalSize = this.removedCatalogObjects_.size();
            this.removedCatalogObjects_ = new TreeMap<Long, TCatalogObject>(this.removedCatalogObjects_.tailMap(catalogVersion));
            this.latestRemovedVersions_.entrySet().removeIf(e -> (Long)e.getValue() < catalogVersion);
            int numCleared = originalSize - this.removedCatalogObjects_.size();
            if (numCleared > 0) {
                LOG.info("Cleared {} removed items older than version {}", (Object)numCleared, (Object)catalogVersion);
            }
        }
    }

    public synchronized boolean wasObjectRemovedAfter(TCatalogObject catalogObject) {
        Preconditions.checkNotNull((Object)catalogObject);
        if (this.removedCatalogObjects_.isEmpty()) {
            return false;
        }
        SortedMap<Long, TCatalogObject> candidateObjects = this.removedCatalogObjects_.tailMap(catalogObject.getCatalog_version());
        for (Map.Entry<Long, TCatalogObject> entry : candidateObjects.entrySet()) {
            if (!Catalog.keyEquals(catalogObject, entry.getValue())) continue;
            return true;
        }
        return false;
    }

    public synchronized long getLatestRemovedVersion(TCatalogObject catalogObject) {
        String key = Catalog.toCatalogObjectKey(catalogObject);
        return this.latestRemovedVersions_.getOrDefault(key, 0L);
    }
}

