/*
 * Decompiled with CFR 0.152.
 */
package org.apache.impala.catalog;

import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.hadoop.hive.metastore.api.Database;
import org.apache.impala.analysis.ArithmeticExpr;
import org.apache.impala.analysis.BinaryPredicate;
import org.apache.impala.analysis.CaseExpr;
import org.apache.impala.analysis.CastExpr;
import org.apache.impala.analysis.CompoundPredicate;
import org.apache.impala.analysis.InPredicate;
import org.apache.impala.analysis.IsNullPredicate;
import org.apache.impala.analysis.LikePredicate;
import org.apache.impala.builtins.ScalarBuiltins;
import org.apache.impala.catalog.AggregateFunction;
import org.apache.impala.catalog.Db;
import org.apache.impala.catalog.PrimitiveType;
import org.apache.impala.catalog.ScalarType;
import org.apache.impala.catalog.Type;
import org.apache.impala.compat.HiveEsriGeospatialBuiltins;
import org.apache.impala.service.BackendConfig;
import org.apache.impala.thrift.TGeospatialLibrary;

public class BuiltinsDb
extends Db {
    private static final int AVG_INTERMEDIATE_SIZE = 16;
    private static final int DECIMAL_AVG_INTERMEDIATE_SIZE = 24;
    private static final int STDDEV_INTERMEDIATE_SIZE = 24;
    private static final int PC_INTERMEDIATE_SIZE = 256;
    private static final int HLL_INTERMEDIATE_SIZE = 1024;
    private static final int[] hll_intermediate_sizes = new int[]{512, 1024, 2048, 4096, 8192, 16384, 32768, 65536, 131072, 262144};
    private final Map<Type, List<AggregateFunction>> builtinNDVs_ = new HashMap<Type, List<AggregateFunction>>();
    private static final int RANK_INTERMEDIATE_SIZE = 16;
    private static Db INSTANCE;
    public static final String NAME = "_impala_builtins";
    private static final String BUILTINS_DB_COMMENT = "System database for Impala builtin functions";
    private static final Map<Type, String> SAMPLE_INIT_SYMBOL;
    private static final Map<Type, String> SAMPLE_SERIALIZE_SYMBOL;
    private static final Map<Type, String> SAMPLE_MERGE_SYMBOL;
    private static final Map<Type, String> SAMPLE_UPDATE_SYMBOL;
    private static final Map<Type, String> SAMPLE_FINALIZE_SYMBOL;
    private static final Map<Type, String> UPDATE_VAL_SYMBOL;
    private static final Map<Type, String> APPX_MEDIAN_FINALIZE_SYMBOL;
    private static final Map<Type, String> HISTOGRAM_FINALIZE_SYMBOL;
    private static final Map<Type, String> HLL_UPDATE_SYMBOL;
    private static final Map<Type, String> HLL_UPDATE_SYMBOL_WITH_PRECISION;
    private static final Map<Type, String> DS_HLL_UPDATE_SYMBOL;
    private static final Map<Type, String> DS_CPC_UPDATE_SYMBOL;
    private static final Map<Type, String> DS_THETA_UPDATE_SYMBOL;
    private static final Map<Type, String> SAMPLED_NDV_UPDATE_SYMBOL;
    private static final Map<Type, String> AGGIF_UPDATE_SYMBOL;
    private static final Map<Type, String> AGGIF_MERGE_SYMBOL;
    private static final Map<Type, String> AGGIF_FINALIZE_SYMBOL;
    private static final Map<Type, String> PC_UPDATE_SYMBOL;
    private static final Map<Type, String> PCSA_UPDATE_SYMBOL;
    private static final Map<Type, String> MIN_UPDATE_SYMBOL;
    private static final Map<Type, String> MAX_UPDATE_SYMBOL;
    private static final Map<Type, String> STDDEV_UPDATE_SYMBOL;
    private static final Map<Type, String> OFFSET_FN_INIT_SYMBOL;
    private static final Map<Type, String> OFFSET_FN_UPDATE_SYMBOL;
    private static final Map<Type, String> FIRST_VALUE_REWRITE_UPDATE_SYMBOL;
    private static final Map<Type, String> LAST_VALUE_REMOVE_SYMBOL;
    private static final Map<Type, String> LAST_VALUE_IGNORE_NULLS_INIT_SYMBOL;
    private static final Map<Type, String> LAST_VALUE_IGNORE_NULLS_UPDATE_SYMBOL;
    private static final Map<Type, String> LAST_VALUE_IGNORE_NULLS_REMOVE_SYMBOL;
    private static final Map<Type, String> LAST_VALUE_IGNORE_NULLS_GET_VALUE_SYMBOL;
    private static final Map<Type, String> LAST_VALUE_IGNORE_NULLS_FINALIZE_SYMBOL;
    private static final Map<Type, String> FIRST_VALUE_UPDATE_SYMBOL;
    private static final Map<Type, String> FIRST_VALUE_IGNORE_NULLS_UPDATE_SYMBOL;

    public static synchronized Db getInstance() {
        if (INSTANCE == null) {
            INSTANCE = new BuiltinsDb();
        }
        return INSTANCE;
    }

    public static synchronized Db getInstance(BuiltinsDbLoader loader) {
        if (INSTANCE == null) {
            INSTANCE = loader.getBuiltinsDbInstance();
        }
        return INSTANCE;
    }

    private BuiltinsDb() {
        super(NAME, BuiltinsDb.createMetastoreDb(NAME));
        this.setIsSystemDb(true);
        this.initBuiltins();
    }

    private void initBuiltins() {
        this.initAggregateBuiltins();
        ArithmeticExpr.initBuiltins(this);
        BinaryPredicate.initBuiltins(this);
        CastExpr.initBuiltins(this);
        CaseExpr.initBuiltins(this);
        CompoundPredicate.initBuiltins(this);
        InPredicate.initBuiltins(this);
        IsNullPredicate.initBuiltins(this);
        LikePredicate.initBuiltins(this);
        ScalarBuiltins.initBuiltins(this);
        if (BackendConfig.INSTANCE.getGeospatialLibrary().equals((Object)TGeospatialLibrary.HIVE_ESRI)) {
            HiveEsriGeospatialBuiltins.initBuiltins(this);
        }
    }

    private static Database createMetastoreDb(String name) {
        return new Database(name, BUILTINS_DB_COMMENT, "", Collections.emptyMap());
    }

    @Override
    public String getOwnerUser() {
        return null;
    }

    private static AggregateFunction createTemplateAggregateFunctionForNDVWith2Args(Db db, String prefix, Type t, Type hllIntermediateType) {
        return AggregateFunction.createBuiltin(db, "ndv", Lists.newArrayList((Object[])new Type[]{t, Type.INT}), Type.BIGINT, hllIntermediateType, prefix + "7HllInitEPN10impala_udf15FunctionContextEPNS1_9StringValE", prefix + HLL_UPDATE_SYMBOL_WITH_PRECISION.get(t), prefix + "8HllMergeEPN10impala_udf15FunctionContextERKNS1_9StringValEPS4_", null, prefix + "11HllFinalizeEPN10impala_udf15FunctionContextERKNS1_9StringValE", true, false, true);
    }

    private void initAggregateBuiltins() {
        String prefix = "_ZN6impala18AggregateFunctions";
        String initNullString = "_ZN6impala18AggregateFunctions14InitNullStringEPN10impala_udf15FunctionContextEPNS1_9StringValE";
        String initNull = "_ZN6impala18AggregateFunctions8InitNullEPN10impala_udf15FunctionContextEPNS1_6AnyValE";
        String stringValSerializeOrFinalize = "_ZN6impala18AggregateFunctions28StringValSerializeOrFinalizeEPN10impala_udf15FunctionContextERKNS1_9StringValE";
        String stringValGetValue = "_ZN6impala18AggregateFunctions17StringValGetValueEPN10impala_udf15FunctionContextERKNS1_9StringValE";
        BuiltinsDb db = this;
        db.addBuiltin(AggregateFunction.createBuiltin(db, "count", new ArrayList<Type>(), Type.BIGINT, Type.BIGINT, "_ZN6impala18AggregateFunctions8InitZeroIN10impala_udf9BigIntValEEEvPNS2_15FunctionContextEPT_", "_ZN6impala18AggregateFunctions15CountStarUpdateEPN10impala_udf15FunctionContextEPNS1_9BigIntValE", "_ZN6impala18AggregateFunctions10CountMergeEPN10impala_udf15FunctionContextERKNS1_9BigIntValEPS4_", null, null, "_ZN6impala18AggregateFunctions15CountStarRemoveEPN10impala_udf15FunctionContextEPNS1_9BigIntValE", null, false, true, true));
        for (Type type : Type.getSupportedTypes()) {
            if (type.isNull() || type.isScalarType(PrimitiveType.CHAR) || type.isScalarType(PrimitiveType.VARCHAR)) continue;
            db.addBuiltin(AggregateFunction.createBuiltin(db, "count", Lists.newArrayList((Object[])new Type[]{type}), Type.BIGINT, Type.BIGINT, "_ZN6impala18AggregateFunctions8InitZeroIN10impala_udf9BigIntValEEEvPNS2_15FunctionContextEPT_", "_ZN6impala18AggregateFunctions11CountUpdateEPN10impala_udf15FunctionContextERKNS1_6AnyValEPNS1_9BigIntValE", "_ZN6impala18AggregateFunctions10CountMergeEPN10impala_udf15FunctionContextERKNS1_9BigIntValEPS4_", null, null, "_ZN6impala18AggregateFunctions11CountRemoveEPN10impala_udf15FunctionContextERKNS1_6AnyValEPNS1_9BigIntValE", null, false, true, true));
            String minMaxInit = type.isStringType() ? "_ZN6impala18AggregateFunctions14InitNullStringEPN10impala_udf15FunctionContextEPNS1_9StringValE" : "_ZN6impala18AggregateFunctions8InitNullEPN10impala_udf15FunctionContextEPNS1_6AnyValE";
            String minMaxSerializeOrFinalize = type.isStringType() ? "_ZN6impala18AggregateFunctions28StringValSerializeOrFinalizeEPN10impala_udf15FunctionContextERKNS1_9StringValE" : null;
            String string = type.isStringType() ? "_ZN6impala18AggregateFunctions17StringValGetValueEPN10impala_udf15FunctionContextERKNS1_9StringValE" : null;
            db.addBuiltin(AggregateFunction.createBuiltin(db, "min", Lists.newArrayList((Object[])new Type[]{type}), type, type, minMaxInit, "_ZN6impala18AggregateFunctions" + MIN_UPDATE_SYMBOL.get(type), "_ZN6impala18AggregateFunctions" + MIN_UPDATE_SYMBOL.get(type), minMaxSerializeOrFinalize, string, null, minMaxSerializeOrFinalize, true, true, false));
            db.addBuiltin(AggregateFunction.createBuiltin(db, "max", Lists.newArrayList((Object[])new Type[]{type}), type, type, minMaxInit, "_ZN6impala18AggregateFunctions" + MAX_UPDATE_SYMBOL.get(type), "_ZN6impala18AggregateFunctions" + MAX_UPDATE_SYMBOL.get(type), minMaxSerializeOrFinalize, string, null, minMaxSerializeOrFinalize, true, true, false));
        }
        for (Type type : Type.getSupportedTypes()) {
            if (type.isNull() || type.isScalarType(PrimitiveType.CHAR) || type.isScalarType(PrimitiveType.VARCHAR) || type.isBinary()) continue;
            db.addBuiltin(AggregateFunction.createBuiltin(db, "sample", Lists.newArrayList((Object[])new Type[]{type}), Type.STRING, Type.STRING, "_ZN6impala18AggregateFunctions" + SAMPLE_INIT_SYMBOL.get(type), "_ZN6impala18AggregateFunctions" + SAMPLE_UPDATE_SYMBOL.get(type), "_ZN6impala18AggregateFunctions" + SAMPLE_MERGE_SYMBOL.get(type), "_ZN6impala18AggregateFunctions" + SAMPLE_SERIALIZE_SYMBOL.get(type), "_ZN6impala18AggregateFunctions" + SAMPLE_FINALIZE_SYMBOL.get(type), false, false, true));
            db.addBuiltin(AggregateFunction.createBuiltin(db, "appx_median", Lists.newArrayList((Object[])new Type[]{type}), type, Type.STRING, "_ZN6impala18AggregateFunctions" + SAMPLE_INIT_SYMBOL.get(type), "_ZN6impala18AggregateFunctions" + SAMPLE_UPDATE_SYMBOL.get(type), "_ZN6impala18AggregateFunctions" + SAMPLE_MERGE_SYMBOL.get(type), "_ZN6impala18AggregateFunctions" + SAMPLE_SERIALIZE_SYMBOL.get(type), "_ZN6impala18AggregateFunctions" + APPX_MEDIAN_FINALIZE_SYMBOL.get(type), false, false, true));
            db.addBuiltin(AggregateFunction.createBuiltin(db, "histogram", Lists.newArrayList((Object[])new Type[]{type}), Type.STRING, Type.STRING, "_ZN6impala18AggregateFunctions" + SAMPLE_INIT_SYMBOL.get(type), "_ZN6impala18AggregateFunctions" + SAMPLE_UPDATE_SYMBOL.get(type), "_ZN6impala18AggregateFunctions" + SAMPLE_MERGE_SYMBOL.get(type), "_ZN6impala18AggregateFunctions" + SAMPLE_SERIALIZE_SYMBOL.get(type), "_ZN6impala18AggregateFunctions" + HISTOGRAM_FINALIZE_SYMBOL.get(type), false, false, true));
            ScalarType defaultHllIntermediateType = ScalarType.createFixedUdaIntermediateType(1024);
            db.addBuiltin(AggregateFunction.createBuiltin(db, "ndv", Lists.newArrayList((Object[])new Type[]{type}), Type.BIGINT, defaultHllIntermediateType, "_ZN6impala18AggregateFunctions7HllInitEPN10impala_udf15FunctionContextEPNS1_9StringValE", "_ZN6impala18AggregateFunctions" + HLL_UPDATE_SYMBOL.get(type), "_ZN6impala18AggregateFunctions8HllMergeEPN10impala_udf15FunctionContextERKNS1_9StringValEPS4_", null, "_ZN6impala18AggregateFunctions11HllFinalizeEPN10impala_udf15FunctionContextERKNS1_9StringValE", true, false, true));
            db.addBuiltin(BuiltinsDb.createTemplateAggregateFunctionForNDVWith2Args(db, "_ZN6impala18AggregateFunctions", type, defaultHllIntermediateType));
            ArrayList<AggregateFunction> ndvList = new ArrayList<AggregateFunction>();
            for (int size : hll_intermediate_sizes) {
                ScalarType hllIntermediateType = ScalarType.createFixedUdaIntermediateType(size);
                ndvList.add(BuiltinsDb.createTemplateAggregateFunctionForNDVWith2Args(db, "_ZN6impala18AggregateFunctions", type, hllIntermediateType));
            }
            this.builtinNDVs_.put(type, ndvList);
            db.addBuiltin(AggregateFunction.createBuiltin(db, "ndv_no_finalize", Lists.newArrayList((Object[])new Type[]{type}), Type.STRING, defaultHllIntermediateType, "_ZN6impala18AggregateFunctions7HllInitEPN10impala_udf15FunctionContextEPNS1_9StringValE", "_ZN6impala18AggregateFunctions" + HLL_UPDATE_SYMBOL.get(type), "_ZN6impala18AggregateFunctions8HllMergeEPN10impala_udf15FunctionContextERKNS1_9StringValEPS4_", null, "_Z20IncrementNdvFinalizePN10impala_udf15FunctionContextERKNS_9StringValE", true, false, true));
            if (DS_HLL_UPDATE_SYMBOL.containsKey(type)) {
                db.addBuiltin(AggregateFunction.createBuiltin(db, "ds_hll_sketch_and_estimate", Lists.newArrayList((Object[])new Type[]{type}), Type.BIGINT, Type.STRING, "_ZN6impala18AggregateFunctions9DsHllInitEPN10impala_udf15FunctionContextEPNS1_9StringValE", "_ZN6impala18AggregateFunctions" + DS_HLL_UPDATE_SYMBOL.get(type), "_ZN6impala18AggregateFunctions10DsHllMergeEPN10impala_udf15FunctionContextERKNS1_9StringValEPS4_", "_ZN6impala18AggregateFunctions14DsHllSerializeEPN10impala_udf15FunctionContextERKNS1_9StringValE", "_ZN6impala18AggregateFunctions13DsHllFinalizeEPN10impala_udf15FunctionContextERKNS1_9StringValE", true, false, true));
                db.addBuiltin(AggregateFunction.createBuiltin(db, "ds_hll_sketch", Lists.newArrayList((Object[])new Type[]{type}), Type.STRING, Type.STRING, "_ZN6impala18AggregateFunctions9DsHllInitEPN10impala_udf15FunctionContextEPNS1_9StringValE", "_ZN6impala18AggregateFunctions" + DS_HLL_UPDATE_SYMBOL.get(type), "_ZN6impala18AggregateFunctions10DsHllMergeEPN10impala_udf15FunctionContextERKNS1_9StringValEPS4_", "_ZN6impala18AggregateFunctions14DsHllSerializeEPN10impala_udf15FunctionContextERKNS1_9StringValE", "_ZN6impala18AggregateFunctions19DsHllFinalizeSketchEPN10impala_udf15FunctionContextERKNS1_9StringValE", true, false, true));
            } else {
                db.addBuiltin(AggregateFunction.createUnsupportedBuiltin(db, "ds_hll_sketch_and_estimate", Lists.newArrayList((Object[])new Type[]{type}), Type.STRING, Type.STRING));
                db.addBuiltin(AggregateFunction.createUnsupportedBuiltin(db, "ds_hll_sketch", Lists.newArrayList((Object[])new Type[]{type}), Type.STRING, Type.STRING));
            }
            if (DS_CPC_UPDATE_SYMBOL.containsKey(type)) {
                db.addBuiltin(AggregateFunction.createBuiltin(db, "ds_cpc_sketch_and_estimate", Lists.newArrayList((Object[])new Type[]{type}), Type.BIGINT, Type.STRING, "_ZN6impala18AggregateFunctions9DsCpcInitEPN10impala_udf15FunctionContextEPNS1_9StringValE", "_ZN6impala18AggregateFunctions" + DS_CPC_UPDATE_SYMBOL.get(type), "_ZN6impala18AggregateFunctions10DsCpcMergeEPN10impala_udf15FunctionContextERKNS1_9StringValEPS4_", "_ZN6impala18AggregateFunctions14DsCpcSerializeEPN10impala_udf15FunctionContextERKNS1_9StringValE", "_ZN6impala18AggregateFunctions13DsCpcFinalizeEPN10impala_udf15FunctionContextERKNS1_9StringValE", true, false, true));
                db.addBuiltin(AggregateFunction.createBuiltin(db, "ds_cpc_sketch", Lists.newArrayList((Object[])new Type[]{type}), Type.STRING, Type.STRING, "_ZN6impala18AggregateFunctions9DsCpcInitEPN10impala_udf15FunctionContextEPNS1_9StringValE", "_ZN6impala18AggregateFunctions" + DS_CPC_UPDATE_SYMBOL.get(type), "_ZN6impala18AggregateFunctions10DsCpcMergeEPN10impala_udf15FunctionContextERKNS1_9StringValEPS4_", "_ZN6impala18AggregateFunctions14DsCpcSerializeEPN10impala_udf15FunctionContextERKNS1_9StringValE", "_ZN6impala18AggregateFunctions19DsCpcFinalizeSketchEPN10impala_udf15FunctionContextERKNS1_9StringValE", true, false, true));
            } else {
                db.addBuiltin(AggregateFunction.createUnsupportedBuiltin(db, "ds_cpc_sketch_and_estimate", Lists.newArrayList((Object[])new Type[]{type}), Type.STRING, Type.STRING));
                db.addBuiltin(AggregateFunction.createUnsupportedBuiltin(db, "ds_cpc_sketch", Lists.newArrayList((Object[])new Type[]{type}), Type.STRING, Type.STRING));
            }
            if (DS_THETA_UPDATE_SYMBOL.containsKey(type)) {
                db.addBuiltin(AggregateFunction.createBuiltin(db, "ds_theta_sketch_and_estimate", Lists.newArrayList((Object[])new Type[]{type}), Type.BIGINT, Type.STRING, "_ZN6impala18AggregateFunctions11DsThetaInitEPN10impala_udf15FunctionContextEPNS1_9StringValE", "_ZN6impala18AggregateFunctions" + DS_THETA_UPDATE_SYMBOL.get(type), "_ZN6impala18AggregateFunctions12DsThetaMergeEPN10impala_udf15FunctionContextERKNS1_9StringValEPS4_", "_ZN6impala18AggregateFunctions16DsThetaSerializeEPN10impala_udf15FunctionContextERKNS1_9StringValE", "_ZN6impala18AggregateFunctions15DsThetaFinalizeEPN10impala_udf15FunctionContextERKNS1_9StringValE", true, false, true));
                db.addBuiltin(AggregateFunction.createBuiltin(db, "ds_theta_sketch", Lists.newArrayList((Object[])new Type[]{type}), Type.STRING, Type.STRING, "_ZN6impala18AggregateFunctions11DsThetaInitEPN10impala_udf15FunctionContextEPNS1_9StringValE", "_ZN6impala18AggregateFunctions" + DS_THETA_UPDATE_SYMBOL.get(type), "_ZN6impala18AggregateFunctions12DsThetaMergeEPN10impala_udf15FunctionContextERKNS1_9StringValEPS4_", "_ZN6impala18AggregateFunctions16DsThetaSerializeEPN10impala_udf15FunctionContextERKNS1_9StringValE", "_ZN6impala18AggregateFunctions21DsThetaFinalizeSketchEPN10impala_udf15FunctionContextERKNS1_9StringValE", true, false, true));
            } else {
                db.addBuiltin(AggregateFunction.createUnsupportedBuiltin(db, "ds_theta_sketch_and_estimate", Lists.newArrayList((Object[])new Type[]{type}), Type.STRING, Type.STRING));
                db.addBuiltin(AggregateFunction.createUnsupportedBuiltin(db, "ds_theta_sketch", Lists.newArrayList((Object[])new Type[]{type}), Type.STRING, Type.STRING));
            }
            int n = 32;
            int size = 16 + n * 1032;
            ScalarType sampledIntermediateType = ScalarType.createFixedUdaIntermediateType(size);
            db.addBuiltin(AggregateFunction.createBuiltin(db, "sampled_ndv", Lists.newArrayList((Object[])new Type[]{type, Type.DOUBLE}), Type.BIGINT, sampledIntermediateType, "_ZN6impala18AggregateFunctions14SampledNdvInitEPN10impala_udf15FunctionContextEPNS1_9StringValE", "_ZN6impala18AggregateFunctions" + SAMPLED_NDV_UPDATE_SYMBOL.get(type), "_ZN6impala18AggregateFunctions15SampledNdvMergeEPN10impala_udf15FunctionContextERKNS1_9StringValEPS4_", null, "_ZN6impala18AggregateFunctions18SampledNdvFinalizeEPN10impala_udf15FunctionContextERKNS1_9StringValE", true, false, true));
            db.addBuiltin(AggregateFunction.createBuiltin(db, "aggif", Lists.newArrayList((Object[])new Type[]{ScalarType.BOOLEAN, type}), type, type, "_ZN6impala18AggregateFunctions8InitNullEPN10impala_udf15FunctionContextEPNS1_6AnyValE", "_ZN6impala18AggregateFunctions" + AGGIF_UPDATE_SYMBOL.get(type), "_ZN6impala18AggregateFunctions" + AGGIF_MERGE_SYMBOL.get(type), null, "_ZN6impala18AggregateFunctions" + AGGIF_FINALIZE_SYMBOL.get(type), true, false, true));
            ScalarType pcIntermediateType = ScalarType.createFixedUdaIntermediateType(256);
            db.addBuiltin(AggregateFunction.createBuiltin(db, "distinctpc", Lists.newArrayList((Object[])new Type[]{type}), Type.BIGINT, pcIntermediateType, "_ZN6impala18AggregateFunctions6PcInitEPN10impala_udf15FunctionContextEPNS1_9StringValE", "_ZN6impala18AggregateFunctions" + PC_UPDATE_SYMBOL.get(type), "_ZN6impala18AggregateFunctions7PcMergeEPN10impala_udf15FunctionContextERKNS1_9StringValEPS4_", null, "_ZN6impala18AggregateFunctions10PcFinalizeEPN10impala_udf15FunctionContextERKNS1_9StringValE", false, false, true));
            db.addBuiltin(AggregateFunction.createBuiltin(db, "distinctpcsa", Lists.newArrayList((Object[])new Type[]{type}), Type.BIGINT, pcIntermediateType, "_ZN6impala18AggregateFunctions6PcInitEPN10impala_udf15FunctionContextEPNS1_9StringValE", "_ZN6impala18AggregateFunctions" + PCSA_UPDATE_SYMBOL.get(type), "_ZN6impala18AggregateFunctions7PcMergeEPN10impala_udf15FunctionContextERKNS1_9StringValEPS4_", null, "_ZN6impala18AggregateFunctions12PcsaFinalizeEPN10impala_udf15FunctionContextERKNS1_9StringValE", false, false, true));
            if (!STDDEV_UPDATE_SYMBOL.containsKey(type)) continue;
            ScalarType stddevIntermediateType = ScalarType.createFixedUdaIntermediateType(24);
            db.addBuiltin(AggregateFunction.createBuiltin(db, "stddev", Lists.newArrayList((Object[])new Type[]{type}), Type.DOUBLE, stddevIntermediateType, "_ZN6impala18AggregateFunctions12KnuthVarInitEPN10impala_udf15FunctionContextEPNS1_9StringValE", "_ZN6impala18AggregateFunctions" + STDDEV_UPDATE_SYMBOL.get(type), "_ZN6impala18AggregateFunctions13KnuthVarMergeEPN10impala_udf15FunctionContextERKNS1_9StringValEPS4_", null, "_ZN6impala18AggregateFunctions19KnuthStddevFinalizeEPN10impala_udf15FunctionContextERKNS1_9StringValE", false, false, false));
            db.addBuiltin(AggregateFunction.createBuiltin(db, "stddev_samp", Lists.newArrayList((Object[])new Type[]{type}), Type.DOUBLE, stddevIntermediateType, "_ZN6impala18AggregateFunctions12KnuthVarInitEPN10impala_udf15FunctionContextEPNS1_9StringValE", "_ZN6impala18AggregateFunctions" + STDDEV_UPDATE_SYMBOL.get(type), "_ZN6impala18AggregateFunctions13KnuthVarMergeEPN10impala_udf15FunctionContextERKNS1_9StringValEPS4_", null, "_ZN6impala18AggregateFunctions19KnuthStddevFinalizeEPN10impala_udf15FunctionContextERKNS1_9StringValE", false, false, false));
            db.addBuiltin(AggregateFunction.createBuiltin(db, "stddev_pop", Lists.newArrayList((Object[])new Type[]{type}), Type.DOUBLE, stddevIntermediateType, "_ZN6impala18AggregateFunctions12KnuthVarInitEPN10impala_udf15FunctionContextEPNS1_9StringValE", "_ZN6impala18AggregateFunctions" + STDDEV_UPDATE_SYMBOL.get(type), "_ZN6impala18AggregateFunctions13KnuthVarMergeEPN10impala_udf15FunctionContextERKNS1_9StringValEPS4_", null, "_ZN6impala18AggregateFunctions22KnuthStddevPopFinalizeEPN10impala_udf15FunctionContextERKNS1_9StringValE", false, false, false));
            db.addBuiltin(AggregateFunction.createBuiltin(db, "variance", Lists.newArrayList((Object[])new Type[]{type}), Type.DOUBLE, stddevIntermediateType, "_ZN6impala18AggregateFunctions12KnuthVarInitEPN10impala_udf15FunctionContextEPNS1_9StringValE", "_ZN6impala18AggregateFunctions" + STDDEV_UPDATE_SYMBOL.get(type), "_ZN6impala18AggregateFunctions13KnuthVarMergeEPN10impala_udf15FunctionContextERKNS1_9StringValEPS4_", null, "_ZN6impala18AggregateFunctions16KnuthVarFinalizeEPN10impala_udf15FunctionContextERKNS1_9StringValE", false, false, false));
            db.addBuiltin(AggregateFunction.createBuiltin(db, "variance_samp", Lists.newArrayList((Object[])new Type[]{type}), Type.DOUBLE, stddevIntermediateType, "_ZN6impala18AggregateFunctions12KnuthVarInitEPN10impala_udf15FunctionContextEPNS1_9StringValE", "_ZN6impala18AggregateFunctions" + STDDEV_UPDATE_SYMBOL.get(type), "_ZN6impala18AggregateFunctions13KnuthVarMergeEPN10impala_udf15FunctionContextERKNS1_9StringValEPS4_", null, "_ZN6impala18AggregateFunctions16KnuthVarFinalizeEPN10impala_udf15FunctionContextERKNS1_9StringValE", false, false, false));
            db.addBuiltin(AggregateFunction.createBuiltin(db, "var_samp", Lists.newArrayList((Object[])new Type[]{type}), Type.DOUBLE, stddevIntermediateType, "_ZN6impala18AggregateFunctions12KnuthVarInitEPN10impala_udf15FunctionContextEPNS1_9StringValE", "_ZN6impala18AggregateFunctions" + STDDEV_UPDATE_SYMBOL.get(type), "_ZN6impala18AggregateFunctions13KnuthVarMergeEPN10impala_udf15FunctionContextERKNS1_9StringValEPS4_", null, "_ZN6impala18AggregateFunctions16KnuthVarFinalizeEPN10impala_udf15FunctionContextERKNS1_9StringValE", false, false, false));
            db.addBuiltin(AggregateFunction.createBuiltin(db, "variance_pop", Lists.newArrayList((Object[])new Type[]{type}), Type.DOUBLE, stddevIntermediateType, "_ZN6impala18AggregateFunctions12KnuthVarInitEPN10impala_udf15FunctionContextEPNS1_9StringValE", "_ZN6impala18AggregateFunctions" + STDDEV_UPDATE_SYMBOL.get(type), "_ZN6impala18AggregateFunctions13KnuthVarMergeEPN10impala_udf15FunctionContextERKNS1_9StringValEPS4_", null, "_ZN6impala18AggregateFunctions19KnuthVarPopFinalizeEPN10impala_udf15FunctionContextERKNS1_9StringValE", false, false, false));
            db.addBuiltin(AggregateFunction.createBuiltin(db, "var_pop", Lists.newArrayList((Object[])new Type[]{type}), Type.DOUBLE, stddevIntermediateType, "_ZN6impala18AggregateFunctions12KnuthVarInitEPN10impala_udf15FunctionContextEPNS1_9StringValE", "_ZN6impala18AggregateFunctions" + STDDEV_UPDATE_SYMBOL.get(type), "_ZN6impala18AggregateFunctions13KnuthVarMergeEPN10impala_udf15FunctionContextERKNS1_9StringValEPS4_", null, "_ZN6impala18AggregateFunctions19KnuthVarPopFinalizeEPN10impala_udf15FunctionContextERKNS1_9StringValE", false, false, false));
        }
        db.addBuiltin(AggregateFunction.createBuiltin(db, "sum", Lists.newArrayList((Object[])new Type[]{Type.BIGINT}), Type.BIGINT, Type.BIGINT, "_ZN6impala18AggregateFunctions8InitNullEPN10impala_udf15FunctionContextEPNS1_6AnyValE", "_ZN6impala18AggregateFunctions9SumUpdateIN10impala_udf9BigIntValES3_EEvPNS2_15FunctionContextERKT_PT0_", "_ZN6impala18AggregateFunctions9SumUpdateIN10impala_udf9BigIntValES3_EEvPNS2_15FunctionContextERKT_PT0_", null, null, "_ZN6impala18AggregateFunctions9SumRemoveIN10impala_udf9BigIntValES3_EEvPNS2_15FunctionContextERKT_PT0_", null, false, true, false));
        db.addBuiltin(AggregateFunction.createBuiltin(db, "sum", Lists.newArrayList((Object[])new Type[]{Type.DOUBLE}), Type.DOUBLE, Type.DOUBLE, "_ZN6impala18AggregateFunctions8InitNullEPN10impala_udf15FunctionContextEPNS1_6AnyValE", "_ZN6impala18AggregateFunctions9SumUpdateIN10impala_udf9DoubleValES3_EEvPNS2_15FunctionContextERKT_PT0_", "_ZN6impala18AggregateFunctions9SumUpdateIN10impala_udf9DoubleValES3_EEvPNS2_15FunctionContextERKT_PT0_", null, null, "_ZN6impala18AggregateFunctions9SumRemoveIN10impala_udf9DoubleValES3_EEvPNS2_15FunctionContextERKT_PT0_", null, false, true, false));
        db.addBuiltin(AggregateFunction.createBuiltin(db, "sum", Lists.newArrayList((Object[])new Type[]{Type.DECIMAL}), Type.DECIMAL, Type.DECIMAL, "_ZN6impala18AggregateFunctions8InitNullEPN10impala_udf15FunctionContextEPNS1_6AnyValE", "_ZN6impala18AggregateFunctions16SumDecimalUpdateEPN10impala_udf15FunctionContextERKNS1_10DecimalValEPS4_", "_ZN6impala18AggregateFunctions15SumDecimalMergeEPN10impala_udf15FunctionContextERKNS1_10DecimalValEPS4_", null, null, "_ZN6impala18AggregateFunctions16SumDecimalRemoveEPN10impala_udf15FunctionContextERKNS1_10DecimalValEPS4_", null, false, true, false));
        db.addBuiltin(AggregateFunction.createBuiltin(db, "sum_init_zero", Lists.newArrayList((Object[])new Type[]{Type.BIGINT}), Type.BIGINT, Type.BIGINT, "_ZN6impala18AggregateFunctions8InitZeroIN10impala_udf9BigIntValEEEvPNS2_15FunctionContextEPT_", "_ZN6impala18AggregateFunctions9SumUpdateIN10impala_udf9BigIntValES3_EEvPNS2_15FunctionContextERKT_PT0_", "_ZN6impala18AggregateFunctions9SumUpdateIN10impala_udf9BigIntValES3_EEvPNS2_15FunctionContextERKT_PT0_", null, null, "_ZN6impala18AggregateFunctions9SumRemoveIN10impala_udf9BigIntValES3_EEvPNS2_15FunctionContextERKT_PT0_", null, false, true, true));
        db.addBuiltin(AggregateFunction.createBuiltin(db, "corr", Lists.newArrayList((Object[])new Type[]{Type.DOUBLE, Type.DOUBLE}), Type.DOUBLE, Type.STRING, "_ZN6impala18AggregateFunctions8CorrInitEPN10impala_udf15FunctionContextEPNS1_9StringValE", "_ZN6impala18AggregateFunctions10CorrUpdateEPN10impala_udf15FunctionContextERKNS1_9DoubleValES6_PNS1_9StringValE", "_ZN6impala18AggregateFunctions9CorrMergeEPN10impala_udf15FunctionContextERKNS1_9StringValEPS4_", "_ZN6impala18AggregateFunctions28StringValSerializeOrFinalizeEPN10impala_udf15FunctionContextERKNS1_9StringValE", "_ZN6impala18AggregateFunctions12CorrGetValueEPN10impala_udf15FunctionContextERKNS1_9StringValE", "_ZN6impala18AggregateFunctions10CorrRemoveEPN10impala_udf15FunctionContextERKNS1_9DoubleValES6_PNS1_9StringValE", "_ZN6impala18AggregateFunctions12CorrFinalizeEPN10impala_udf15FunctionContextERKNS1_9StringValE", false, true, false));
        db.addBuiltin(AggregateFunction.createBuiltin(db, "corr", Lists.newArrayList((Object[])new Type[]{Type.TIMESTAMP, Type.TIMESTAMP}), Type.DOUBLE, Type.STRING, "_ZN6impala18AggregateFunctions8CorrInitEPN10impala_udf15FunctionContextEPNS1_9StringValE", "_ZN6impala18AggregateFunctions19TimestampCorrUpdateEPN10impala_udf15FunctionContextERKNS1_12TimestampValES6_PNS1_9StringValE", "_ZN6impala18AggregateFunctions9CorrMergeEPN10impala_udf15FunctionContextERKNS1_9StringValEPS4_", "_ZN6impala18AggregateFunctions28StringValSerializeOrFinalizeEPN10impala_udf15FunctionContextERKNS1_9StringValE", "_ZN6impala18AggregateFunctions12CorrGetValueEPN10impala_udf15FunctionContextERKNS1_9StringValE", "_ZN6impala18AggregateFunctions19TimestampCorrRemoveEPN10impala_udf15FunctionContextERKNS1_12TimestampValES6_PNS1_9StringValE", "_ZN6impala18AggregateFunctions12CorrFinalizeEPN10impala_udf15FunctionContextERKNS1_9StringValE", false, true, false));
        db.addBuiltin(AggregateFunction.createBuiltin(db, "regr_count", Lists.newArrayList((Object[])new Type[]{Type.DOUBLE, Type.DOUBLE}), Type.BIGINT, Type.BIGINT, "_ZN6impala18AggregateFunctions8InitZeroIN10impala_udf9BigIntValEEEvPNS2_15FunctionContextEPT_", "_ZN6impala18AggregateFunctions15RegrCountUpdateEPN10impala_udf15FunctionContextERKNS1_9DoubleValES6_PNS1_9BigIntValE", "_ZN6impala18AggregateFunctions10CountMergeEPN10impala_udf15FunctionContextERKNS1_9BigIntValEPS4_", null, null, "_ZN6impala18AggregateFunctions15RegrCountRemoveEPN10impala_udf15FunctionContextERKNS1_9DoubleValES6_PNS1_9BigIntValE", null, false, true, true));
        db.addBuiltin(AggregateFunction.createBuiltin(db, "regr_count", Lists.newArrayList((Object[])new Type[]{Type.TIMESTAMP, Type.TIMESTAMP}), Type.BIGINT, Type.BIGINT, "_ZN6impala18AggregateFunctions8InitZeroIN10impala_udf9BigIntValEEEvPNS2_15FunctionContextEPT_", "_ZN6impala18AggregateFunctions24TimestampRegrCountUpdateEPN10impala_udf15FunctionContextERKNS1_12TimestampValES6_PNS1_9BigIntValE", "_ZN6impala18AggregateFunctions10CountMergeEPN10impala_udf15FunctionContextERKNS1_9BigIntValEPS4_", null, null, "_ZN6impala18AggregateFunctions24TimestampRegrCountRemoveEPN10impala_udf15FunctionContextERKNS1_12TimestampValES6_PNS1_9BigIntValE", null, false, true, true));
        db.addBuiltin(AggregateFunction.createBuiltin(db, "regr_r2", Lists.newArrayList((Object[])new Type[]{Type.DOUBLE, Type.DOUBLE}), Type.DOUBLE, Type.STRING, "_ZN6impala18AggregateFunctions8CorrInitEPN10impala_udf15FunctionContextEPNS1_9StringValE", "_ZN6impala18AggregateFunctions10CorrUpdateEPN10impala_udf15FunctionContextERKNS1_9DoubleValES6_PNS1_9StringValE", "_ZN6impala18AggregateFunctions9CorrMergeEPN10impala_udf15FunctionContextERKNS1_9StringValEPS4_", "_ZN6impala18AggregateFunctions28StringValSerializeOrFinalizeEPN10impala_udf15FunctionContextERKNS1_9StringValE", "_ZN6impala18AggregateFunctions15Regr_r2GetValueEPN10impala_udf15FunctionContextERKNS1_9StringValE", "_ZN6impala18AggregateFunctions10CorrRemoveEPN10impala_udf15FunctionContextERKNS1_9DoubleValES6_PNS1_9StringValE", "_ZN6impala18AggregateFunctions15Regr_r2FinalizeEPN10impala_udf15FunctionContextERKNS1_9StringValE", false, true, false));
        db.addBuiltin(AggregateFunction.createBuiltin(db, "regr_r2", Lists.newArrayList((Object[])new Type[]{Type.TIMESTAMP, Type.TIMESTAMP}), Type.DOUBLE, Type.STRING, "_ZN6impala18AggregateFunctions8CorrInitEPN10impala_udf15FunctionContextEPNS1_9StringValE", "_ZN6impala18AggregateFunctions19TimestampCorrUpdateEPN10impala_udf15FunctionContextERKNS1_12TimestampValES6_PNS1_9StringValE", "_ZN6impala18AggregateFunctions9CorrMergeEPN10impala_udf15FunctionContextERKNS1_9StringValEPS4_", "_ZN6impala18AggregateFunctions28StringValSerializeOrFinalizeEPN10impala_udf15FunctionContextERKNS1_9StringValE", "_ZN6impala18AggregateFunctions15Regr_r2GetValueEPN10impala_udf15FunctionContextERKNS1_9StringValE", "_ZN6impala18AggregateFunctions19TimestampCorrRemoveEPN10impala_udf15FunctionContextERKNS1_12TimestampValES6_PNS1_9StringValE", "_ZN6impala18AggregateFunctions15Regr_r2FinalizeEPN10impala_udf15FunctionContextERKNS1_9StringValE", false, true, false));
        db.addBuiltin(AggregateFunction.createBuiltin(db, "regr_slope", Lists.newArrayList((Object[])new Type[]{Type.DOUBLE, Type.DOUBLE}), Type.DOUBLE, Type.STRING, "_ZN6impala18AggregateFunctions13RegrSlopeInitEPN10impala_udf15FunctionContextEPNS1_9StringValE", "_ZN6impala18AggregateFunctions15RegrSlopeUpdateEPN10impala_udf15FunctionContextERKNS1_9DoubleValES6_PNS1_9StringValE", "_ZN6impala18AggregateFunctions14RegrSlopeMergeEPN10impala_udf15FunctionContextERKNS1_9StringValEPS4_", "_ZN6impala18AggregateFunctions28StringValSerializeOrFinalizeEPN10impala_udf15FunctionContextERKNS1_9StringValE", "_ZN6impala18AggregateFunctions17RegrSlopeGetValueEPN10impala_udf15FunctionContextERKNS1_9StringValE", "_ZN6impala18AggregateFunctions15RegrSlopeRemoveEPN10impala_udf15FunctionContextERKNS1_9DoubleValES6_PNS1_9StringValE", "_ZN6impala18AggregateFunctions17RegrSlopeFinalizeEPN10impala_udf15FunctionContextERKNS1_9StringValE", false, true, false));
        db.addBuiltin(AggregateFunction.createBuiltin(db, "regr_slope", Lists.newArrayList((Object[])new Type[]{Type.TIMESTAMP, Type.TIMESTAMP}), Type.DOUBLE, Type.STRING, "_ZN6impala18AggregateFunctions13RegrSlopeInitEPN10impala_udf15FunctionContextEPNS1_9StringValE", "_ZN6impala18AggregateFunctions24TimestampRegrSlopeUpdateEPN10impala_udf15FunctionContextERKNS1_12TimestampValES6_PNS1_9StringValE", "_ZN6impala18AggregateFunctions14RegrSlopeMergeEPN10impala_udf15FunctionContextERKNS1_9StringValEPS4_", "_ZN6impala18AggregateFunctions28StringValSerializeOrFinalizeEPN10impala_udf15FunctionContextERKNS1_9StringValE", "_ZN6impala18AggregateFunctions17RegrSlopeGetValueEPN10impala_udf15FunctionContextERKNS1_9StringValE", "_ZN6impala18AggregateFunctions24TimestampRegrSlopeRemoveEPN10impala_udf15FunctionContextERKNS1_12TimestampValES6_PNS1_9StringValE", "_ZN6impala18AggregateFunctions17RegrSlopeFinalizeEPN10impala_udf15FunctionContextERKNS1_9StringValE", false, true, false));
        db.addBuiltin(AggregateFunction.createBuiltin(db, "regr_intercept", Lists.newArrayList((Object[])new Type[]{Type.DOUBLE, Type.DOUBLE}), Type.DOUBLE, Type.STRING, "_ZN6impala18AggregateFunctions13RegrSlopeInitEPN10impala_udf15FunctionContextEPNS1_9StringValE", "_ZN6impala18AggregateFunctions15RegrSlopeUpdateEPN10impala_udf15FunctionContextERKNS1_9DoubleValES6_PNS1_9StringValE", "_ZN6impala18AggregateFunctions14RegrSlopeMergeEPN10impala_udf15FunctionContextERKNS1_9StringValEPS4_", "_ZN6impala18AggregateFunctions28StringValSerializeOrFinalizeEPN10impala_udf15FunctionContextERKNS1_9StringValE", "_ZN6impala18AggregateFunctions21RegrInterceptGetValueEPN10impala_udf15FunctionContextERKNS1_9StringValE", "_ZN6impala18AggregateFunctions15RegrSlopeRemoveEPN10impala_udf15FunctionContextERKNS1_9DoubleValES6_PNS1_9StringValE", "_ZN6impala18AggregateFunctions21RegrInterceptFinalizeEPN10impala_udf15FunctionContextERKNS1_9StringValE", false, true, false));
        db.addBuiltin(AggregateFunction.createBuiltin(db, "regr_intercept", Lists.newArrayList((Object[])new Type[]{Type.TIMESTAMP, Type.TIMESTAMP}), Type.DOUBLE, Type.STRING, "_ZN6impala18AggregateFunctions13RegrSlopeInitEPN10impala_udf15FunctionContextEPNS1_9StringValE", "_ZN6impala18AggregateFunctions24TimestampRegrSlopeUpdateEPN10impala_udf15FunctionContextERKNS1_12TimestampValES6_PNS1_9StringValE", "_ZN6impala18AggregateFunctions14RegrSlopeMergeEPN10impala_udf15FunctionContextERKNS1_9StringValEPS4_", "_ZN6impala18AggregateFunctions28StringValSerializeOrFinalizeEPN10impala_udf15FunctionContextERKNS1_9StringValE", "_ZN6impala18AggregateFunctions21RegrInterceptGetValueEPN10impala_udf15FunctionContextERKNS1_9StringValE", "_ZN6impala18AggregateFunctions24TimestampRegrSlopeRemoveEPN10impala_udf15FunctionContextERKNS1_12TimestampValES6_PNS1_9StringValE", "_ZN6impala18AggregateFunctions21RegrInterceptFinalizeEPN10impala_udf15FunctionContextERKNS1_9StringValE", false, true, false));
        db.addBuiltin(AggregateFunction.createBuiltin(db, "covar_samp", Lists.newArrayList((Object[])new Type[]{Type.DOUBLE, Type.DOUBLE}), Type.DOUBLE, Type.STRING, "_ZN6impala18AggregateFunctions9CovarInitEPN10impala_udf15FunctionContextEPNS1_9StringValE", "_ZN6impala18AggregateFunctions11CovarUpdateEPN10impala_udf15FunctionContextERKNS1_9DoubleValES6_PNS1_9StringValE", "_ZN6impala18AggregateFunctions10CovarMergeEPN10impala_udf15FunctionContextERKNS1_9StringValEPS4_", "_ZN6impala18AggregateFunctions28StringValSerializeOrFinalizeEPN10impala_udf15FunctionContextERKNS1_9StringValE", "_ZN6impala18AggregateFunctions19CovarSampleGetValueEPN10impala_udf15FunctionContextERKNS1_9StringValE", "_ZN6impala18AggregateFunctions11CovarRemoveEPN10impala_udf15FunctionContextERKNS1_9DoubleValES6_PNS1_9StringValE", "_ZN6impala18AggregateFunctions19CovarSampleFinalizeEPN10impala_udf15FunctionContextERKNS1_9StringValE", false, true, false));
        db.addBuiltin(AggregateFunction.createBuiltin(db, "covar_samp", Lists.newArrayList((Object[])new Type[]{Type.TIMESTAMP, Type.TIMESTAMP}), Type.DOUBLE, Type.STRING, "_ZN6impala18AggregateFunctions9CovarInitEPN10impala_udf15FunctionContextEPNS1_9StringValE", "_ZN6impala18AggregateFunctions20TimestampCovarUpdateEPN10impala_udf15FunctionContextERKNS1_12TimestampValES6_PNS1_9StringValE", "_ZN6impala18AggregateFunctions10CovarMergeEPN10impala_udf15FunctionContextERKNS1_9StringValEPS4_", "_ZN6impala18AggregateFunctions28StringValSerializeOrFinalizeEPN10impala_udf15FunctionContextERKNS1_9StringValE", "_ZN6impala18AggregateFunctions19CovarSampleGetValueEPN10impala_udf15FunctionContextERKNS1_9StringValE", "_ZN6impala18AggregateFunctions20TimestampCovarRemoveEPN10impala_udf15FunctionContextERKNS1_12TimestampValES6_PNS1_9StringValE", "_ZN6impala18AggregateFunctions19CovarSampleFinalizeEPN10impala_udf15FunctionContextERKNS1_9StringValE", false, true, false));
        db.addBuiltin(AggregateFunction.createBuiltin(db, "covar_pop", Lists.newArrayList((Object[])new Type[]{Type.DOUBLE, Type.DOUBLE}), Type.DOUBLE, Type.STRING, "_ZN6impala18AggregateFunctions9CovarInitEPN10impala_udf15FunctionContextEPNS1_9StringValE", "_ZN6impala18AggregateFunctions11CovarUpdateEPN10impala_udf15FunctionContextERKNS1_9DoubleValES6_PNS1_9StringValE", "_ZN6impala18AggregateFunctions10CovarMergeEPN10impala_udf15FunctionContextERKNS1_9StringValEPS4_", "_ZN6impala18AggregateFunctions28StringValSerializeOrFinalizeEPN10impala_udf15FunctionContextERKNS1_9StringValE", "_ZN6impala18AggregateFunctions23CovarPopulationGetValueEPN10impala_udf15FunctionContextERKNS1_9StringValE", "_ZN6impala18AggregateFunctions11CovarRemoveEPN10impala_udf15FunctionContextERKNS1_9DoubleValES6_PNS1_9StringValE", "_ZN6impala18AggregateFunctions23CovarPopulationFinalizeEPN10impala_udf15FunctionContextERKNS1_9StringValE", false, true, false));
        db.addBuiltin(AggregateFunction.createBuiltin(db, "covar_pop", Lists.newArrayList((Object[])new Type[]{Type.TIMESTAMP, Type.TIMESTAMP}), Type.DOUBLE, Type.STRING, "_ZN6impala18AggregateFunctions9CovarInitEPN10impala_udf15FunctionContextEPNS1_9StringValE", "_ZN6impala18AggregateFunctions20TimestampCovarUpdateEPN10impala_udf15FunctionContextERKNS1_12TimestampValES6_PNS1_9StringValE", "_ZN6impala18AggregateFunctions10CovarMergeEPN10impala_udf15FunctionContextERKNS1_9StringValEPS4_", "_ZN6impala18AggregateFunctions28StringValSerializeOrFinalizeEPN10impala_udf15FunctionContextERKNS1_9StringValE", "_ZN6impala18AggregateFunctions23CovarPopulationGetValueEPN10impala_udf15FunctionContextERKNS1_9StringValE", "_ZN6impala18AggregateFunctions20TimestampCovarRemoveEPN10impala_udf15FunctionContextERKNS1_12TimestampValES6_PNS1_9StringValE", "_ZN6impala18AggregateFunctions23CovarPopulationFinalizeEPN10impala_udf15FunctionContextERKNS1_9StringValE", false, true, false));
        ScalarType avgIntermediateType = ScalarType.createFixedUdaIntermediateType(16);
        ScalarType scalarType = ScalarType.createFixedUdaIntermediateType(24);
        db.addBuiltin(AggregateFunction.createBuiltin(db, "avg", Lists.newArrayList((Object[])new Type[]{Type.BIGINT}), Type.DOUBLE, avgIntermediateType, "_ZN6impala18AggregateFunctions7AvgInitEPN10impala_udf15FunctionContextEPNS1_9StringValE", "_ZN6impala18AggregateFunctions9AvgUpdateIN10impala_udf9BigIntValEEEvPNS2_15FunctionContextERKT_PNS2_9StringValE", "_ZN6impala18AggregateFunctions8AvgMergeEPN10impala_udf15FunctionContextERKNS1_9StringValEPS4_", null, "_ZN6impala18AggregateFunctions11AvgGetValueEPN10impala_udf15FunctionContextERKNS1_9StringValE", "_ZN6impala18AggregateFunctions9AvgRemoveIN10impala_udf9BigIntValEEEvPNS2_15FunctionContextERKT_PNS2_9StringValE", "_ZN6impala18AggregateFunctions11AvgFinalizeEPN10impala_udf15FunctionContextERKNS1_9StringValE", false, true, false));
        db.addBuiltin(AggregateFunction.createBuiltin(db, "avg", Lists.newArrayList((Object[])new Type[]{Type.DOUBLE}), Type.DOUBLE, avgIntermediateType, "_ZN6impala18AggregateFunctions7AvgInitEPN10impala_udf15FunctionContextEPNS1_9StringValE", "_ZN6impala18AggregateFunctions9AvgUpdateIN10impala_udf9DoubleValEEEvPNS2_15FunctionContextERKT_PNS2_9StringValE", "_ZN6impala18AggregateFunctions8AvgMergeEPN10impala_udf15FunctionContextERKNS1_9StringValEPS4_", null, "_ZN6impala18AggregateFunctions11AvgGetValueEPN10impala_udf15FunctionContextERKNS1_9StringValE", "_ZN6impala18AggregateFunctions9AvgRemoveIN10impala_udf9DoubleValEEEvPNS2_15FunctionContextERKT_PNS2_9StringValE", "_ZN6impala18AggregateFunctions11AvgFinalizeEPN10impala_udf15FunctionContextERKNS1_9StringValE", false, true, false));
        db.addBuiltin(AggregateFunction.createBuiltin(db, "avg", Lists.newArrayList((Object[])new Type[]{Type.DECIMAL}), Type.DECIMAL, scalarType, "_ZN6impala18AggregateFunctions14DecimalAvgInitEPN10impala_udf15FunctionContextEPNS1_9StringValE", "_ZN6impala18AggregateFunctions16DecimalAvgUpdateEPN10impala_udf15FunctionContextERKNS1_10DecimalValEPNS1_9StringValE", "_ZN6impala18AggregateFunctions15DecimalAvgMergeEPN10impala_udf15FunctionContextERKNS1_9StringValEPS4_", null, "_ZN6impala18AggregateFunctions18DecimalAvgGetValueEPN10impala_udf15FunctionContextERKNS1_9StringValE", "_ZN6impala18AggregateFunctions16DecimalAvgRemoveEPN10impala_udf15FunctionContextERKNS1_10DecimalValEPNS1_9StringValE", "_ZN6impala18AggregateFunctions18DecimalAvgFinalizeEPN10impala_udf15FunctionContextERKNS1_9StringValE", false, true, false));
        db.addBuiltin(AggregateFunction.createBuiltin(db, "avg", Lists.newArrayList((Object[])new Type[]{Type.TIMESTAMP}), Type.TIMESTAMP, avgIntermediateType, "_ZN6impala18AggregateFunctions7AvgInitEPN10impala_udf15FunctionContextEPNS1_9StringValE", "_ZN6impala18AggregateFunctions18TimestampAvgUpdateEPN10impala_udf15FunctionContextERKNS1_12TimestampValEPNS1_9StringValE", "_ZN6impala18AggregateFunctions8AvgMergeEPN10impala_udf15FunctionContextERKNS1_9StringValEPS4_", null, "_ZN6impala18AggregateFunctions20TimestampAvgGetValueEPN10impala_udf15FunctionContextERKNS1_9StringValE", "_ZN6impala18AggregateFunctions18TimestampAvgRemoveEPN10impala_udf15FunctionContextERKNS1_12TimestampValEPNS1_9StringValE", "_ZN6impala18AggregateFunctions20TimestampAvgFinalizeEPN10impala_udf15FunctionContextERKNS1_9StringValE", false, true, false));
        db.addBuiltin(AggregateFunction.createBuiltin(db, "group_concat", Lists.newArrayList((Object[])new Type[]{Type.STRING}), Type.STRING, Type.STRING, "_ZN6impala18AggregateFunctions14InitNullStringEPN10impala_udf15FunctionContextEPNS1_9StringValE", "_ZN6impala18AggregateFunctions18StringConcatUpdateEPN10impala_udf15FunctionContextERKNS1_9StringValEPS4_", "_ZN6impala18AggregateFunctions17StringConcatMergeEPN10impala_udf15FunctionContextERKNS1_9StringValEPS4_", "_ZN6impala18AggregateFunctions28StringValSerializeOrFinalizeEPN10impala_udf15FunctionContextERKNS1_9StringValE", "_ZN6impala18AggregateFunctions20StringConcatFinalizeEPN10impala_udf15FunctionContextERKNS1_9StringValE", false, false, false));
        db.addBuiltin(AggregateFunction.createBuiltin(db, "group_concat", Lists.newArrayList((Object[])new Type[]{Type.STRING, Type.STRING}), Type.STRING, Type.STRING, "_ZN6impala18AggregateFunctions14InitNullStringEPN10impala_udf15FunctionContextEPNS1_9StringValE", "_ZN6impala18AggregateFunctions18StringConcatUpdateEPN10impala_udf15FunctionContextERKNS1_9StringValES6_PS4_", "_ZN6impala18AggregateFunctions17StringConcatMergeEPN10impala_udf15FunctionContextERKNS1_9StringValEPS4_", "_ZN6impala18AggregateFunctions28StringValSerializeOrFinalizeEPN10impala_udf15FunctionContextERKNS1_9StringValE", "_ZN6impala18AggregateFunctions20StringConcatFinalizeEPN10impala_udf15FunctionContextERKNS1_9StringValE", false, false, false));
        ScalarType rankIntermediateType = ScalarType.createFixedUdaIntermediateType(16);
        db.addBuiltin(AggregateFunction.createAnalyticBuiltin(db, "rank", Lists.newArrayList(), Type.BIGINT, rankIntermediateType, "_ZN6impala18AggregateFunctions8RankInitEPN10impala_udf15FunctionContextEPNS1_9StringValE", "_ZN6impala18AggregateFunctions10RankUpdateEPN10impala_udf15FunctionContextEPNS1_9StringValE", null, "_ZN6impala18AggregateFunctions12RankGetValueEPN10impala_udf15FunctionContextERNS1_9StringValE", "_ZN6impala18AggregateFunctions12RankFinalizeEPN10impala_udf15FunctionContextERNS1_9StringValE"));
        db.addBuiltin(AggregateFunction.createAnalyticBuiltin(db, "dense_rank", Lists.newArrayList(), Type.BIGINT, rankIntermediateType, "_ZN6impala18AggregateFunctions8RankInitEPN10impala_udf15FunctionContextEPNS1_9StringValE", "_ZN6impala18AggregateFunctions15DenseRankUpdateEPN10impala_udf15FunctionContextEPNS1_9StringValE", null, "_ZN6impala18AggregateFunctions17DenseRankGetValueEPN10impala_udf15FunctionContextERNS1_9StringValE", "_ZN6impala18AggregateFunctions12RankFinalizeEPN10impala_udf15FunctionContextERNS1_9StringValE"));
        db.addBuiltin(AggregateFunction.createAnalyticBuiltin(db, "row_number", new ArrayList<Type>(), Type.BIGINT, Type.BIGINT, "_ZN6impala18AggregateFunctions8InitZeroIN10impala_udf9BigIntValEEEvPNS2_15FunctionContextEPT_", "_ZN6impala18AggregateFunctions15CountStarUpdateEPN10impala_udf15FunctionContextEPNS1_9BigIntValE", "_ZN6impala18AggregateFunctions10CountMergeEPN10impala_udf15FunctionContextERKNS1_9BigIntValEPS4_", null, null));
        db.addBuiltin(AggregateFunction.createBuiltin(db, "ds_kll_sketch", Lists.newArrayList((Object[])new Type[]{Type.FLOAT}), Type.STRING, Type.STRING, "_ZN6impala18AggregateFunctions9DsKllInitEPN10impala_udf15FunctionContextEPNS1_9StringValE", "_ZN6impala18AggregateFunctions11DsKllUpdateEPN10impala_udf15FunctionContextERKNS1_8FloatValEPNS1_9StringValE", "_ZN6impala18AggregateFunctions10DsKllMergeEPN10impala_udf15FunctionContextERKNS1_9StringValEPS4_", "_ZN6impala18AggregateFunctions14DsKllSerializeEPN10impala_udf15FunctionContextERKNS1_9StringValE", "_ZN6impala18AggregateFunctions19DsKllFinalizeSketchEPN10impala_udf15FunctionContextERKNS1_9StringValE", true, false, true));
        db.addBuiltin(AggregateFunction.createBuiltin(db, "ds_kll_union", Lists.newArrayList((Object[])new Type[]{Type.STRING}), Type.STRING, Type.STRING, "_ZN6impala18AggregateFunctions14DsKllUnionInitEPN10impala_udf15FunctionContextEPNS1_9StringValE", "_ZN6impala18AggregateFunctions16DsKllUnionUpdateEPN10impala_udf15FunctionContextERKNS1_9StringValEPS4_", "_ZN6impala18AggregateFunctions15DsKllUnionMergeEPN10impala_udf15FunctionContextERKNS1_9StringValEPS4_", "_ZN6impala18AggregateFunctions19DsKllUnionSerializeEPN10impala_udf15FunctionContextERKNS1_9StringValE", "_ZN6impala18AggregateFunctions18DsKllUnionFinalizeEPN10impala_udf15FunctionContextERKNS1_9StringValE", true, false, true));
        db.addBuiltin(AggregateFunction.createAnalyticBuiltin(db, "percent_rank", Lists.newArrayList(), Type.DOUBLE, Type.STRING));
        db.addBuiltin(AggregateFunction.createAnalyticBuiltin(db, "cume_dist", Lists.newArrayList(), Type.DOUBLE, Type.STRING));
        db.addBuiltin(AggregateFunction.createAnalyticBuiltin(db, "ntile", Lists.newArrayList((Object[])new Type[]{Type.BIGINT}), Type.BIGINT, Type.STRING));
        db.addBuiltin(AggregateFunction.createBuiltin(db, "ds_hll_union", Lists.newArrayList((Object[])new Type[]{Type.STRING}), Type.STRING, Type.STRING, "_ZN6impala18AggregateFunctions14DsHllUnionInitEPN10impala_udf15FunctionContextEPNS1_9StringValE", "_ZN6impala18AggregateFunctions16DsHllUnionUpdateEPN10impala_udf15FunctionContextERKNS1_9StringValEPS4_", "_ZN6impala18AggregateFunctions15DsHllUnionMergeEPN10impala_udf15FunctionContextERKNS1_9StringValEPS4_", "_ZN6impala18AggregateFunctions19DsHllUnionSerializeEPN10impala_udf15FunctionContextERKNS1_9StringValE", "_ZN6impala18AggregateFunctions18DsHllUnionFinalizeEPN10impala_udf15FunctionContextERKNS1_9StringValE", true, false, true));
        db.addBuiltin(AggregateFunction.createBuiltin(db, "ds_cpc_union", Lists.newArrayList((Object[])new Type[]{Type.STRING}), Type.STRING, Type.STRING, "_ZN6impala18AggregateFunctions14DsCpcUnionInitEPN10impala_udf15FunctionContextEPNS1_9StringValE", "_ZN6impala18AggregateFunctions16DsCpcUnionUpdateEPN10impala_udf15FunctionContextERKNS1_9StringValEPS4_", "_ZN6impala18AggregateFunctions15DsCpcUnionMergeEPN10impala_udf15FunctionContextERKNS1_9StringValEPS4_", "_ZN6impala18AggregateFunctions19DsCpcUnionSerializeEPN10impala_udf15FunctionContextERKNS1_9StringValE", "_ZN6impala18AggregateFunctions18DsCpcUnionFinalizeEPN10impala_udf15FunctionContextERKNS1_9StringValE", true, false, true));
        db.addBuiltin(AggregateFunction.createBuiltin(db, "ds_theta_union", Lists.newArrayList((Object[])new Type[]{Type.STRING}), Type.STRING, Type.STRING, "_ZN6impala18AggregateFunctions16DsThetaUnionInitEPN10impala_udf15FunctionContextEPNS1_9StringValE", "_ZN6impala18AggregateFunctions18DsThetaUnionUpdateEPN10impala_udf15FunctionContextERKNS1_9StringValEPS4_", "_ZN6impala18AggregateFunctions17DsThetaUnionMergeEPN10impala_udf15FunctionContextERKNS1_9StringValEPS4_", "_ZN6impala18AggregateFunctions21DsThetaUnionSerializeEPN10impala_udf15FunctionContextERKNS1_9StringValE", "_ZN6impala18AggregateFunctions20DsThetaUnionFinalizeEPN10impala_udf15FunctionContextERKNS1_9StringValE", true, false, true));
        db.addBuiltin(AggregateFunction.createBuiltin(db, "ds_theta_intersect", Lists.newArrayList((Object[])new Type[]{Type.STRING}), Type.STRING, Type.STRING, "_ZN6impala18AggregateFunctions20DsThetaIntersectInitEPN10impala_udf15FunctionContextEPNS1_9StringValE", "_ZN6impala18AggregateFunctions22DsThetaIntersectUpdateEPN10impala_udf15FunctionContextERKNS1_9StringValEPS4_", "_ZN6impala18AggregateFunctions21DsThetaIntersectMergeEPN10impala_udf15FunctionContextERKNS1_9StringValEPS4_", "_ZN6impala18AggregateFunctions25DsThetaIntersectSerializeEPN10impala_udf15FunctionContextERKNS1_9StringValE", "_ZN6impala18AggregateFunctions24DsThetaIntersectFinalizeEPN10impala_udf15FunctionContextERKNS1_9StringValE", true, false, true));
        for (Type type : Type.getSupportedTypes()) {
            if (type.isNull() || type.isScalarType(PrimitiveType.CHAR) || type.isScalarType(PrimitiveType.VARCHAR) || type.isBinary()) continue;
            db.addBuiltin(AggregateFunction.createAnalyticBuiltin(db, "first_value", Lists.newArrayList((Object[])new Type[]{type}), type, type, type.isStringType() ? "_ZN6impala18AggregateFunctions14InitNullStringEPN10impala_udf15FunctionContextEPNS1_9StringValE" : "_ZN6impala18AggregateFunctions8InitNullEPN10impala_udf15FunctionContextEPNS1_6AnyValE", "_ZN6impala18AggregateFunctions" + FIRST_VALUE_UPDATE_SYMBOL.get(type), null, type == Type.STRING ? "_ZN6impala18AggregateFunctions17StringValGetValueEPN10impala_udf15FunctionContextERKNS1_9StringValE" : null, type == Type.STRING ? "_ZN6impala18AggregateFunctions28StringValSerializeOrFinalizeEPN10impala_udf15FunctionContextERKNS1_9StringValE" : null));
            db.addBuiltin(AggregateFunction.createAnalyticBuiltin(db, "first_value_rewrite", Lists.newArrayList((Object[])new Type[]{type, Type.BIGINT}), type, type, type.isStringType() ? "_ZN6impala18AggregateFunctions14InitNullStringEPN10impala_udf15FunctionContextEPNS1_9StringValE" : "_ZN6impala18AggregateFunctions8InitNullEPN10impala_udf15FunctionContextEPNS1_6AnyValE", "_ZN6impala18AggregateFunctions" + FIRST_VALUE_REWRITE_UPDATE_SYMBOL.get(type), null, type == Type.STRING ? "_ZN6impala18AggregateFunctions17StringValGetValueEPN10impala_udf15FunctionContextERKNS1_9StringValE" : null, type == Type.STRING ? "_ZN6impala18AggregateFunctions28StringValSerializeOrFinalizeEPN10impala_udf15FunctionContextERKNS1_9StringValE" : null, false));
            db.addBuiltin(AggregateFunction.createAnalyticBuiltin(db, "first_value_ignore_nulls", Lists.newArrayList((Object[])new Type[]{type}), type, type, type.isStringType() ? "_ZN6impala18AggregateFunctions14InitNullStringEPN10impala_udf15FunctionContextEPNS1_9StringValE" : "_ZN6impala18AggregateFunctions8InitNullEPN10impala_udf15FunctionContextEPNS1_6AnyValE", "_ZN6impala18AggregateFunctions" + FIRST_VALUE_IGNORE_NULLS_UPDATE_SYMBOL.get(type), null, type == Type.STRING ? "_ZN6impala18AggregateFunctions17StringValGetValueEPN10impala_udf15FunctionContextERKNS1_9StringValE" : null, type == Type.STRING ? "_ZN6impala18AggregateFunctions28StringValSerializeOrFinalizeEPN10impala_udf15FunctionContextERKNS1_9StringValE" : null, false));
            db.addBuiltin(AggregateFunction.createAnalyticBuiltin(db, "last_value", Lists.newArrayList((Object[])new Type[]{type}), type, type, type.isStringType() ? "_ZN6impala18AggregateFunctions14InitNullStringEPN10impala_udf15FunctionContextEPNS1_9StringValE" : "_ZN6impala18AggregateFunctions8InitNullEPN10impala_udf15FunctionContextEPNS1_6AnyValE", "_ZN6impala18AggregateFunctions" + UPDATE_VAL_SYMBOL.get(type), "_ZN6impala18AggregateFunctions" + LAST_VALUE_REMOVE_SYMBOL.get(type), type == Type.STRING ? "_ZN6impala18AggregateFunctions17StringValGetValueEPN10impala_udf15FunctionContextERKNS1_9StringValE" : null, type == Type.STRING ? "_ZN6impala18AggregateFunctions28StringValSerializeOrFinalizeEPN10impala_udf15FunctionContextERKNS1_9StringValE" : null));
            db.addBuiltin(AggregateFunction.createAnalyticBuiltin(db, "last_value_ignore_nulls", Lists.newArrayList((Object[])new Type[]{type}), type, Type.STRING, "_ZN6impala18AggregateFunctions" + LAST_VALUE_IGNORE_NULLS_INIT_SYMBOL.get(type), "_ZN6impala18AggregateFunctions" + LAST_VALUE_IGNORE_NULLS_UPDATE_SYMBOL.get(type), "_ZN6impala18AggregateFunctions" + LAST_VALUE_IGNORE_NULLS_REMOVE_SYMBOL.get(type), "_ZN6impala18AggregateFunctions" + LAST_VALUE_IGNORE_NULLS_GET_VALUE_SYMBOL.get(type), "_ZN6impala18AggregateFunctions" + LAST_VALUE_IGNORE_NULLS_FINALIZE_SYMBOL.get(type), false));
            db.addBuiltin(AggregateFunction.createAnalyticBuiltin(db, "lag", Lists.newArrayList((Object[])new Type[]{type, Type.BIGINT, type}), type, type, "_ZN6impala18AggregateFunctions" + OFFSET_FN_INIT_SYMBOL.get(type), "_ZN6impala18AggregateFunctions" + OFFSET_FN_UPDATE_SYMBOL.get(type), null, type == Type.STRING ? "_ZN6impala18AggregateFunctions17StringValGetValueEPN10impala_udf15FunctionContextERKNS1_9StringValE" : null, type == Type.STRING ? "_ZN6impala18AggregateFunctions28StringValSerializeOrFinalizeEPN10impala_udf15FunctionContextERKNS1_9StringValE" : null));
            db.addBuiltin(AggregateFunction.createAnalyticBuiltin(db, "lead", Lists.newArrayList((Object[])new Type[]{type, Type.BIGINT, type}), type, type, "_ZN6impala18AggregateFunctions" + OFFSET_FN_INIT_SYMBOL.get(type), "_ZN6impala18AggregateFunctions" + OFFSET_FN_UPDATE_SYMBOL.get(type), null, type == Type.STRING ? "_ZN6impala18AggregateFunctions17StringValGetValueEPN10impala_udf15FunctionContextERKNS1_9StringValE" : null, type == Type.STRING ? "_ZN6impala18AggregateFunctions28StringValSerializeOrFinalizeEPN10impala_udf15FunctionContextERKNS1_9StringValE" : null));
            db.addBuiltin(AggregateFunction.createAnalyticBuiltin(db, "lag", Lists.newArrayList((Object[])new Type[]{type}), type, type));
            db.addBuiltin(AggregateFunction.createAnalyticBuiltin(db, "lag", Lists.newArrayList((Object[])new Type[]{type, Type.BIGINT}), type, type));
            db.addBuiltin(AggregateFunction.createAnalyticBuiltin(db, "lead", Lists.newArrayList((Object[])new Type[]{type}), type, type));
            db.addBuiltin(AggregateFunction.createAnalyticBuiltin(db, "lead", Lists.newArrayList((Object[])new Type[]{type, Type.BIGINT}), type, type));
        }
        db.addBuiltin(AggregateFunction.createRewrittenBuiltin(db, "grouping_id", Collections.emptyList(), Type.BIGINT, true, false, true));
        for (Type type : Type.getSupportedTypes()) {
            db.addBuiltin(AggregateFunction.createRewrittenBuiltin(db, "grouping", Lists.newArrayList((Object[])new Type[]{type}), Type.TINYINT, true, false, true));
        }
    }

    public AggregateFunction resolveNdvIntermediateType(AggregateFunction func, int length) {
        Preconditions.checkState((func.getNumArgs() >= 1 ? 1 : 0) != 0);
        List<AggregateFunction> list = this.builtinNDVs_.get(func.getArgs()[0]);
        for (AggregateFunction aggF : list) {
            ScalarType sType = (ScalarType)aggF.getIntermediateType();
            if (sType.getLength() != length) continue;
            return aggF;
        }
        return null;
    }

    static {
        SAMPLE_INIT_SYMBOL = ImmutableMap.builder().put((Object)Type.BOOLEAN, (Object)"19ReservoirSampleInitIN10impala_udf10BooleanValEEEvPNS2_15FunctionContextEPNS2_9StringValE").put((Object)Type.TINYINT, (Object)"19ReservoirSampleInitIN10impala_udf10TinyIntValEEEvPNS2_15FunctionContextEPNS2_9StringValE").put((Object)Type.SMALLINT, (Object)"19ReservoirSampleInitIN10impala_udf11SmallIntValEEEvPNS2_15FunctionContextEPNS2_9StringValE").put((Object)Type.INT, (Object)"19ReservoirSampleInitIN10impala_udf6IntValEEEvPNS2_15FunctionContextEPNS2_9StringValE").put((Object)Type.BIGINT, (Object)"19ReservoirSampleInitIN10impala_udf9BigIntValEEEvPNS2_15FunctionContextEPNS2_9StringValE").put((Object)Type.FLOAT, (Object)"19ReservoirSampleInitIN10impala_udf8FloatValEEEvPNS2_15FunctionContextEPNS2_9StringValE").put((Object)Type.DOUBLE, (Object)"19ReservoirSampleInitIN10impala_udf9DoubleValEEEvPNS2_15FunctionContextEPNS2_9StringValE").put((Object)Type.STRING, (Object)"19ReservoirSampleInitIN10impala_udf9StringValEEEvPNS2_15FunctionContextEPS3_").put((Object)Type.TIMESTAMP, (Object)"19ReservoirSampleInitIN10impala_udf12TimestampValEEEvPNS2_15FunctionContextEPNS2_9StringValE").put((Object)Type.DECIMAL, (Object)"19ReservoirSampleInitIN10impala_udf10DecimalValEEEvPNS2_15FunctionContextEPNS2_9StringValE").put((Object)Type.DATE, (Object)"19ReservoirSampleInitIN10impala_udf7DateValEEEvPNS2_15FunctionContextEPNS2_9StringValE").build();
        SAMPLE_SERIALIZE_SYMBOL = ImmutableMap.builder().put((Object)Type.BOOLEAN, (Object)"24ReservoirSampleSerializeIN10impala_udf10BooleanValEEENS2_9StringValEPNS2_15FunctionContextERKS4_").put((Object)Type.TINYINT, (Object)"24ReservoirSampleSerializeIN10impala_udf10TinyIntValEEENS2_9StringValEPNS2_15FunctionContextERKS4_").put((Object)Type.SMALLINT, (Object)"24ReservoirSampleSerializeIN10impala_udf11SmallIntValEEENS2_9StringValEPNS2_15FunctionContextERKS4_").put((Object)Type.INT, (Object)"24ReservoirSampleSerializeIN10impala_udf6IntValEEENS2_9StringValEPNS2_15FunctionContextERKS4_").put((Object)Type.BIGINT, (Object)"24ReservoirSampleSerializeIN10impala_udf9BigIntValEEENS2_9StringValEPNS2_15FunctionContextERKS4_").put((Object)Type.FLOAT, (Object)"24ReservoirSampleSerializeIN10impala_udf8FloatValEEENS2_9StringValEPNS2_15FunctionContextERKS4_").put((Object)Type.DOUBLE, (Object)"24ReservoirSampleSerializeIN10impala_udf9DoubleValEEENS2_9StringValEPNS2_15FunctionContextERKS4_").put((Object)Type.STRING, (Object)"24ReservoirSampleSerializeIN10impala_udf9StringValEEES3_PNS2_15FunctionContextERKS3_").put((Object)Type.TIMESTAMP, (Object)"24ReservoirSampleSerializeIN10impala_udf12TimestampValEEENS2_9StringValEPNS2_15FunctionContextERKS4_").put((Object)Type.DECIMAL, (Object)"24ReservoirSampleSerializeIN10impala_udf10DecimalValEEENS2_9StringValEPNS2_15FunctionContextERKS4_").put((Object)Type.DATE, (Object)"24ReservoirSampleSerializeIN10impala_udf7DateValEEENS2_9StringValEPNS2_15FunctionContextERKS4_").build();
        SAMPLE_MERGE_SYMBOL = ImmutableMap.builder().put((Object)Type.BOOLEAN, (Object)"20ReservoirSampleMergeIN10impala_udf10BooleanValEEEvPNS2_15FunctionContextERKNS2_9StringValEPS6_").put((Object)Type.TINYINT, (Object)"20ReservoirSampleMergeIN10impala_udf10TinyIntValEEEvPNS2_15FunctionContextERKNS2_9StringValEPS6_").put((Object)Type.SMALLINT, (Object)"20ReservoirSampleMergeIN10impala_udf11SmallIntValEEEvPNS2_15FunctionContextERKNS2_9StringValEPS6_").put((Object)Type.INT, (Object)"20ReservoirSampleMergeIN10impala_udf6IntValEEEvPNS2_15FunctionContextERKNS2_9StringValEPS6_").put((Object)Type.BIGINT, (Object)"20ReservoirSampleMergeIN10impala_udf9BigIntValEEEvPNS2_15FunctionContextERKNS2_9StringValEPS6_").put((Object)Type.FLOAT, (Object)"20ReservoirSampleMergeIN10impala_udf8FloatValEEEvPNS2_15FunctionContextERKNS2_9StringValEPS6_").put((Object)Type.DOUBLE, (Object)"20ReservoirSampleMergeIN10impala_udf9DoubleValEEEvPNS2_15FunctionContextERKNS2_9StringValEPS6_").put((Object)Type.STRING, (Object)"20ReservoirSampleMergeIN10impala_udf9StringValEEEvPNS2_15FunctionContextERKS3_PS3_").put((Object)Type.TIMESTAMP, (Object)"20ReservoirSampleMergeIN10impala_udf12TimestampValEEEvPNS2_15FunctionContextERKNS2_9StringValEPS6_").put((Object)Type.DECIMAL, (Object)"20ReservoirSampleMergeIN10impala_udf10DecimalValEEEvPNS2_15FunctionContextERKNS2_9StringValEPS6_").put((Object)Type.DATE, (Object)"20ReservoirSampleMergeIN10impala_udf7DateValEEEvPNS2_15FunctionContextERKNS2_9StringValEPS6_").build();
        SAMPLE_UPDATE_SYMBOL = ImmutableMap.builder().put((Object)Type.BOOLEAN, (Object)"21ReservoirSampleUpdateIN10impala_udf10BooleanValEEEvPNS2_15FunctionContextERKT_PNS2_9StringValE").put((Object)Type.TINYINT, (Object)"21ReservoirSampleUpdateIN10impala_udf10TinyIntValEEEvPNS2_15FunctionContextERKT_PNS2_9StringValE").put((Object)Type.SMALLINT, (Object)"21ReservoirSampleUpdateIN10impala_udf11SmallIntValEEEvPNS2_15FunctionContextERKT_PNS2_9StringValE").put((Object)Type.INT, (Object)"21ReservoirSampleUpdateIN10impala_udf6IntValEEEvPNS2_15FunctionContextERKT_PNS2_9StringValE").put((Object)Type.BIGINT, (Object)"21ReservoirSampleUpdateIN10impala_udf9BigIntValEEEvPNS2_15FunctionContextERKT_PNS2_9StringValE").put((Object)Type.FLOAT, (Object)"21ReservoirSampleUpdateIN10impala_udf8FloatValEEEvPNS2_15FunctionContextERKT_PNS2_9StringValE").put((Object)Type.DOUBLE, (Object)"21ReservoirSampleUpdateIN10impala_udf9DoubleValEEEvPNS2_15FunctionContextERKT_PNS2_9StringValE").put((Object)Type.STRING, (Object)"21ReservoirSampleUpdateIN10impala_udf9StringValEEEvPNS2_15FunctionContextERKT_PS3_").put((Object)Type.TIMESTAMP, (Object)"21ReservoirSampleUpdateIN10impala_udf12TimestampValEEEvPNS2_15FunctionContextERKT_PNS2_9StringValE").put((Object)Type.DECIMAL, (Object)"21ReservoirSampleUpdateIN10impala_udf10DecimalValEEEvPNS2_15FunctionContextERKT_PNS2_9StringValE").put((Object)Type.DATE, (Object)"21ReservoirSampleUpdateIN10impala_udf7DateValEEEvPNS2_15FunctionContextERKT_PNS2_9StringValE").build();
        SAMPLE_FINALIZE_SYMBOL = ImmutableMap.builder().put((Object)Type.BOOLEAN, (Object)"23ReservoirSampleFinalizeIN10impala_udf10BooleanValEEENS2_9StringValEPNS2_15FunctionContextERKS4_").put((Object)Type.TINYINT, (Object)"23ReservoirSampleFinalizeIN10impala_udf10TinyIntValEEENS2_9StringValEPNS2_15FunctionContextERKS4_").put((Object)Type.SMALLINT, (Object)"23ReservoirSampleFinalizeIN10impala_udf11SmallIntValEEENS2_9StringValEPNS2_15FunctionContextERKS4_").put((Object)Type.INT, (Object)"23ReservoirSampleFinalizeIN10impala_udf6IntValEEENS2_9StringValEPNS2_15FunctionContextERKS4_").put((Object)Type.BIGINT, (Object)"23ReservoirSampleFinalizeIN10impala_udf9BigIntValEEENS2_9StringValEPNS2_15FunctionContextERKS4_").put((Object)Type.FLOAT, (Object)"23ReservoirSampleFinalizeIN10impala_udf8FloatValEEENS2_9StringValEPNS2_15FunctionContextERKS4_").put((Object)Type.DOUBLE, (Object)"23ReservoirSampleFinalizeIN10impala_udf9DoubleValEEENS2_9StringValEPNS2_15FunctionContextERKS4_").put((Object)Type.STRING, (Object)"23ReservoirSampleFinalizeIN10impala_udf9StringValEEES3_PNS2_15FunctionContextERKS3_").put((Object)Type.TIMESTAMP, (Object)"23ReservoirSampleFinalizeIN10impala_udf12TimestampValEEENS2_9StringValEPNS2_15FunctionContextERKS4_").put((Object)Type.DECIMAL, (Object)"23ReservoirSampleFinalizeIN10impala_udf10DecimalValEEENS2_9StringValEPNS2_15FunctionContextERKS4_").put((Object)Type.DATE, (Object)"23ReservoirSampleFinalizeIN10impala_udf7DateValEEENS2_9StringValEPNS2_15FunctionContextERKS4_").build();
        UPDATE_VAL_SYMBOL = ImmutableMap.builder().put((Object)Type.BOOLEAN, (Object)"9UpdateValIN10impala_udf10BooleanValEEEvPNS2_15FunctionContextERKT_PS6_").put((Object)Type.DATE, (Object)"9UpdateValIN10impala_udf7DateValEEEvPNS2_15FunctionContextERKT_PS6_").put((Object)Type.DECIMAL, (Object)"9UpdateValIN10impala_udf10DecimalValEEEvPNS2_15FunctionContextERKT_PS6_").put((Object)Type.TINYINT, (Object)"9UpdateValIN10impala_udf10TinyIntValEEEvPNS2_15FunctionContextERKT_PS6_").put((Object)Type.SMALLINT, (Object)"9UpdateValIN10impala_udf11SmallIntValEEEvPNS2_15FunctionContextERKT_PS6_").put((Object)Type.TIMESTAMP, (Object)"9UpdateValIN10impala_udf12TimestampValEEEvPNS2_15FunctionContextERKT_PS6_").put((Object)Type.INT, (Object)"9UpdateValIN10impala_udf6IntValEEEvPNS2_15FunctionContextERKT_PS6_").put((Object)Type.FLOAT, (Object)"9UpdateValIN10impala_udf8FloatValEEEvPNS2_15FunctionContextERKT_PS6_").put((Object)Type.BIGINT, (Object)"9UpdateValIN10impala_udf9BigIntValEEEvPNS2_15FunctionContextERKT_PS6_").put((Object)Type.DOUBLE, (Object)"9UpdateValIN10impala_udf9DoubleValEEEvPNS2_15FunctionContextERKT_PS6_").put((Object)Type.STRING, (Object)"9UpdateValIN10impala_udf9StringValEEEvPNS2_15FunctionContextERKT_PS6_").build();
        APPX_MEDIAN_FINALIZE_SYMBOL = ImmutableMap.builder().put((Object)Type.BOOLEAN, (Object)"18AppxMedianFinalizeIN10impala_udf10BooleanValEEET_PNS2_15FunctionContextERKNS2_9StringValE").put((Object)Type.DATE, (Object)"18AppxMedianFinalizeIN10impala_udf7DateValEEET_PNS2_15FunctionContextERKNS2_9StringValE").put((Object)Type.DECIMAL, (Object)"18AppxMedianFinalizeIN10impala_udf10DecimalValEEET_PNS2_15FunctionContextERKNS2_9StringValE").put((Object)Type.TINYINT, (Object)"18AppxMedianFinalizeIN10impala_udf10TinyIntValEEET_PNS2_15FunctionContextERKNS2_9StringValE").put((Object)Type.SMALLINT, (Object)"18AppxMedianFinalizeIN10impala_udf11SmallIntValEEET_PNS2_15FunctionContextERKNS2_9StringValE").put((Object)Type.TIMESTAMP, (Object)"18AppxMedianFinalizeIN10impala_udf12TimestampValEEET_PNS2_15FunctionContextERKNS2_9StringValE").put((Object)Type.INT, (Object)"18AppxMedianFinalizeIN10impala_udf6IntValEEET_PNS2_15FunctionContextERKNS2_9StringValE").put((Object)Type.FLOAT, (Object)"18AppxMedianFinalizeIN10impala_udf8FloatValEEET_PNS2_15FunctionContextERKNS2_9StringValE").put((Object)Type.BIGINT, (Object)"18AppxMedianFinalizeIN10impala_udf9BigIntValEEET_PNS2_15FunctionContextERKNS2_9StringValE").put((Object)Type.DOUBLE, (Object)"18AppxMedianFinalizeIN10impala_udf9DoubleValEEET_PNS2_15FunctionContextERKNS2_9StringValE").put((Object)Type.STRING, (Object)"18AppxMedianFinalizeIN10impala_udf9StringValEEET_PNS2_15FunctionContextERKS3_").build();
        HISTOGRAM_FINALIZE_SYMBOL = ImmutableMap.builder().put((Object)Type.BOOLEAN, (Object)"17HistogramFinalizeIN10impala_udf10BooleanValEEENS2_9StringValEPNS2_15FunctionContextERKS4_").put((Object)Type.TINYINT, (Object)"17HistogramFinalizeIN10impala_udf10TinyIntValEEENS2_9StringValEPNS2_15FunctionContextERKS4_").put((Object)Type.SMALLINT, (Object)"17HistogramFinalizeIN10impala_udf11SmallIntValEEENS2_9StringValEPNS2_15FunctionContextERKS4_").put((Object)Type.INT, (Object)"17HistogramFinalizeIN10impala_udf6IntValEEENS2_9StringValEPNS2_15FunctionContextERKS4_").put((Object)Type.BIGINT, (Object)"17HistogramFinalizeIN10impala_udf9BigIntValEEENS2_9StringValEPNS2_15FunctionContextERKS4_").put((Object)Type.FLOAT, (Object)"17HistogramFinalizeIN10impala_udf8FloatValEEENS2_9StringValEPNS2_15FunctionContextERKS4_").put((Object)Type.DOUBLE, (Object)"17HistogramFinalizeIN10impala_udf9DoubleValEEENS2_9StringValEPNS2_15FunctionContextERKS4_").put((Object)Type.STRING, (Object)"17HistogramFinalizeIN10impala_udf9StringValEEES3_PNS2_15FunctionContextERKS3_").put((Object)Type.TIMESTAMP, (Object)"17HistogramFinalizeIN10impala_udf12TimestampValEEENS2_9StringValEPNS2_15FunctionContextERKS4_").put((Object)Type.DECIMAL, (Object)"17HistogramFinalizeIN10impala_udf10DecimalValEEENS2_9StringValEPNS2_15FunctionContextERKS4_").put((Object)Type.DATE, (Object)"17HistogramFinalizeIN10impala_udf7DateValEEENS2_9StringValEPNS2_15FunctionContextERKS4_").build();
        HLL_UPDATE_SYMBOL = ImmutableMap.builder().put((Object)Type.BOOLEAN, (Object)"9HllUpdateIN10impala_udf10BooleanValEEEvPNS2_15FunctionContextERKT_PNS2_9StringValE").put((Object)Type.TINYINT, (Object)"9HllUpdateIN10impala_udf10TinyIntValEEEvPNS2_15FunctionContextERKT_PNS2_9StringValE").put((Object)Type.SMALLINT, (Object)"9HllUpdateIN10impala_udf11SmallIntValEEEvPNS2_15FunctionContextERKT_PNS2_9StringValE").put((Object)Type.INT, (Object)"9HllUpdateIN10impala_udf6IntValEEEvPNS2_15FunctionContextERKT_PNS2_9StringValE").put((Object)Type.BIGINT, (Object)"9HllUpdateIN10impala_udf9BigIntValEEEvPNS2_15FunctionContextERKT_PNS2_9StringValE").put((Object)Type.FLOAT, (Object)"9HllUpdateIN10impala_udf8FloatValEEEvPNS2_15FunctionContextERKT_PNS2_9StringValE").put((Object)Type.DOUBLE, (Object)"9HllUpdateIN10impala_udf9DoubleValEEEvPNS2_15FunctionContextERKT_PNS2_9StringValE").put((Object)Type.STRING, (Object)"9HllUpdateIN10impala_udf9StringValEEEvPNS2_15FunctionContextERKT_PS3_").put((Object)Type.TIMESTAMP, (Object)"9HllUpdateIN10impala_udf12TimestampValEEEvPNS2_15FunctionContextERKT_PNS2_9StringValE").put((Object)Type.DECIMAL, (Object)"9HllUpdateIN10impala_udf10DecimalValEEEvPNS2_15FunctionContextERKT_PNS2_9StringValE").put((Object)Type.DATE, (Object)"9HllUpdateIN10impala_udf7DateValEEEvPNS2_15FunctionContextERKT_PNS2_9StringValE").build();
        HLL_UPDATE_SYMBOL_WITH_PRECISION = ImmutableMap.builder().put((Object)Type.BOOLEAN, (Object)"9HllUpdateIN10impala_udf10BooleanValEEEvPNS2_15FunctionContextERKT_RKNS2_6IntValEPNS2_9StringValE").put((Object)Type.TINYINT, (Object)"9HllUpdateIN10impala_udf10TinyIntValEEEvPNS2_15FunctionContextERKT_RKNS2_6IntValEPNS2_9StringValE").put((Object)Type.SMALLINT, (Object)"9HllUpdateIN10impala_udf11SmallIntValEEEvPNS2_15FunctionContextERKT_RKNS2_6IntValEPNS2_9StringValE").put((Object)Type.INT, (Object)"9HllUpdateIN10impala_udf6IntValEEEvPNS2_15FunctionContextERKT_RKS3_PNS2_9StringValE").put((Object)Type.BIGINT, (Object)"9HllUpdateIN10impala_udf9BigIntValEEEvPNS2_15FunctionContextERKT_RKNS2_6IntValEPNS2_9StringValE").put((Object)Type.FLOAT, (Object)"9HllUpdateIN10impala_udf8FloatValEEEvPNS2_15FunctionContextERKT_RKNS2_6IntValEPNS2_9StringValE").put((Object)Type.DOUBLE, (Object)"9HllUpdateIN10impala_udf9DoubleValEEEvPNS2_15FunctionContextERKT_RKNS2_6IntValEPNS2_9StringValE").put((Object)Type.STRING, (Object)"9HllUpdateIN10impala_udf9StringValEEEvPNS2_15FunctionContextERKT_RKNS2_6IntValEPS3_").put((Object)Type.TIMESTAMP, (Object)"9HllUpdateIN10impala_udf12TimestampValEEEvPNS2_15FunctionContextERKT_RKNS2_6IntValEPNS2_9StringValE").put((Object)Type.DECIMAL, (Object)"9HllUpdateIN10impala_udf10DecimalValEEEvPNS2_15FunctionContextERKT_RKNS2_6IntValEPNS2_9StringValE").put((Object)Type.DATE, (Object)"9HllUpdateIN10impala_udf7DateValEEEvPNS2_15FunctionContextERKT_RKNS2_6IntValEPNS2_9StringValE").build();
        DS_HLL_UPDATE_SYMBOL = ImmutableMap.builder().put((Object)Type.TINYINT, (Object)"11DsHllUpdateIN10impala_udf10TinyIntValEEEvPNS2_15FunctionContextERKT_PNS2_9StringValE").put((Object)Type.INT, (Object)"11DsHllUpdateIN10impala_udf6IntValEEEvPNS2_15FunctionContextERKT_PNS2_9StringValE").put((Object)Type.BIGINT, (Object)"11DsHllUpdateIN10impala_udf9BigIntValEEEvPNS2_15FunctionContextERKT_PNS2_9StringValE").put((Object)Type.FLOAT, (Object)"11DsHllUpdateIN10impala_udf8FloatValEEEvPNS2_15FunctionContextERKT_PNS2_9StringValE").put((Object)Type.DOUBLE, (Object)"11DsHllUpdateIN10impala_udf9DoubleValEEEvPNS2_15FunctionContextERKT_PNS2_9StringValE").put((Object)Type.STRING, (Object)"11DsHllUpdateIN10impala_udf9StringValEEEvPNS2_15FunctionContextERKT_PS3_").build();
        DS_CPC_UPDATE_SYMBOL = ImmutableMap.builder().put((Object)Type.TINYINT, (Object)"11DsCpcUpdateIN10impala_udf10TinyIntValEEEvPNS2_15FunctionContextERKT_PNS2_9StringValE").put((Object)Type.INT, (Object)"11DsCpcUpdateIN10impala_udf6IntValEEEvPNS2_15FunctionContextERKT_PNS2_9StringValE").put((Object)Type.BIGINT, (Object)"11DsCpcUpdateIN10impala_udf9BigIntValEEEvPNS2_15FunctionContextERKT_PNS2_9StringValE").put((Object)Type.FLOAT, (Object)"11DsCpcUpdateIN10impala_udf8FloatValEEEvPNS2_15FunctionContextERKT_PNS2_9StringValE").put((Object)Type.DOUBLE, (Object)"11DsCpcUpdateIN10impala_udf9DoubleValEEEvPNS2_15FunctionContextERKT_PNS2_9StringValE").put((Object)Type.STRING, (Object)"11DsCpcUpdateIN10impala_udf9StringValEEEvPNS2_15FunctionContextERKT_PS3_").build();
        DS_THETA_UPDATE_SYMBOL = ImmutableMap.builder().put((Object)Type.TINYINT, (Object)"13DsThetaUpdateIN10impala_udf10TinyIntValEEEvPNS2_15FunctionContextERKT_PNS2_9StringValE").put((Object)Type.INT, (Object)"13DsThetaUpdateIN10impala_udf6IntValEEEvPNS2_15FunctionContextERKT_PNS2_9StringValE").put((Object)Type.BIGINT, (Object)"13DsThetaUpdateIN10impala_udf9BigIntValEEEvPNS2_15FunctionContextERKT_PNS2_9StringValE").put((Object)Type.FLOAT, (Object)"13DsThetaUpdateIN10impala_udf8FloatValEEEvPNS2_15FunctionContextERKT_PNS2_9StringValE").put((Object)Type.DOUBLE, (Object)"13DsThetaUpdateIN10impala_udf9DoubleValEEEvPNS2_15FunctionContextERKT_PNS2_9StringValE").put((Object)Type.STRING, (Object)"13DsThetaUpdateIN10impala_udf9StringValEEEvPNS2_15FunctionContextERKT_PS3_").build();
        SAMPLED_NDV_UPDATE_SYMBOL = ImmutableMap.builder().put((Object)Type.BOOLEAN, (Object)"16SampledNdvUpdateIN10impala_udf10BooleanValEEEvPNS2_15FunctionContextERKT_RKNS2_9DoubleValEPNS2_9StringValE").put((Object)Type.TINYINT, (Object)"16SampledNdvUpdateIN10impala_udf10TinyIntValEEEvPNS2_15FunctionContextERKT_RKNS2_9DoubleValEPNS2_9StringValE").put((Object)Type.SMALLINT, (Object)"16SampledNdvUpdateIN10impala_udf11SmallIntValEEEvPNS2_15FunctionContextERKT_RKNS2_9DoubleValEPNS2_9StringValE").put((Object)Type.INT, (Object)"16SampledNdvUpdateIN10impala_udf6IntValEEEvPNS2_15FunctionContextERKT_RKNS2_9DoubleValEPNS2_9StringValE").put((Object)Type.BIGINT, (Object)"16SampledNdvUpdateIN10impala_udf9BigIntValEEEvPNS2_15FunctionContextERKT_RKNS2_9DoubleValEPNS2_9StringValE").put((Object)Type.FLOAT, (Object)"16SampledNdvUpdateIN10impala_udf8FloatValEEEvPNS2_15FunctionContextERKT_RKNS2_9DoubleValEPNS2_9StringValE").put((Object)Type.DOUBLE, (Object)"16SampledNdvUpdateIN10impala_udf9DoubleValEEEvPNS2_15FunctionContextERKT_RKS3_PNS2_9StringValE").put((Object)Type.STRING, (Object)"16SampledNdvUpdateIN10impala_udf9StringValEEEvPNS2_15FunctionContextERKT_RKNS2_9DoubleValEPS3_").put((Object)Type.TIMESTAMP, (Object)"16SampledNdvUpdateIN10impala_udf12TimestampValEEEvPNS2_15FunctionContextERKT_RKNS2_9DoubleValEPNS2_9StringValE").put((Object)Type.DECIMAL, (Object)"16SampledNdvUpdateIN10impala_udf10DecimalValEEEvPNS2_15FunctionContextERKT_RKNS2_9DoubleValEPNS2_9StringValE").put((Object)Type.DATE, (Object)"16SampledNdvUpdateIN10impala_udf7DateValEEEvPNS2_15FunctionContextERKT_RKNS2_9DoubleValEPNS2_9StringValE").build();
        AGGIF_UPDATE_SYMBOL = ImmutableMap.builder().put((Object)Type.BOOLEAN, (Object)"11AggIfUpdateIN10impala_udf10BooleanValEEEvPNS2_15FunctionContextERKS3_RKT_PS8_").put((Object)Type.TINYINT, (Object)"11AggIfUpdateIN10impala_udf10TinyIntValEEEvPNS2_15FunctionContextERKNS2_10BooleanValERKT_PS9_").put((Object)Type.SMALLINT, (Object)"11AggIfUpdateIN10impala_udf11SmallIntValEEEvPNS2_15FunctionContextERKNS2_10BooleanValERKT_PS9_").put((Object)Type.INT, (Object)"11AggIfUpdateIN10impala_udf6IntValEEEvPNS2_15FunctionContextERKNS2_10BooleanValERKT_PS9_").put((Object)Type.BIGINT, (Object)"11AggIfUpdateIN10impala_udf9BigIntValEEEvPNS2_15FunctionContextERKNS2_10BooleanValERKT_PS9_").put((Object)Type.FLOAT, (Object)"11AggIfUpdateIN10impala_udf8FloatValEEEvPNS2_15FunctionContextERKNS2_10BooleanValERKT_PS9_").put((Object)Type.DOUBLE, (Object)"11AggIfUpdateIN10impala_udf9DoubleValEEEvPNS2_15FunctionContextERKNS2_10BooleanValERKT_PS9_").put((Object)Type.STRING, (Object)"11AggIfUpdateIN10impala_udf9StringValEEEvPNS2_15FunctionContextERKNS2_10BooleanValERKT_PS9_").put((Object)Type.TIMESTAMP, (Object)"11AggIfUpdateIN10impala_udf12TimestampValEEEvPNS2_15FunctionContextERKNS2_10BooleanValERKT_PS9_").put((Object)Type.DECIMAL, (Object)"11AggIfUpdateIN10impala_udf10DecimalValEEEvPNS2_15FunctionContextERKNS2_10BooleanValERKT_PS9_").put((Object)Type.DATE, (Object)"11AggIfUpdateIN10impala_udf7DateValEEEvPNS2_15FunctionContextERKNS2_10BooleanValERKT_PS9_").build();
        AGGIF_MERGE_SYMBOL = ImmutableMap.builder().put((Object)Type.BOOLEAN, (Object)"10AggIfMergeIN10impala_udf10BooleanValEEEvPNS2_15FunctionContextERKT_PS6_").put((Object)Type.TINYINT, (Object)"10AggIfMergeIN10impala_udf10TinyIntValEEEvPNS2_15FunctionContextERKT_PS6_").put((Object)Type.SMALLINT, (Object)"10AggIfMergeIN10impala_udf11SmallIntValEEEvPNS2_15FunctionContextERKT_PS6_").put((Object)Type.INT, (Object)"10AggIfMergeIN10impala_udf6IntValEEEvPNS2_15FunctionContextERKT_PS6_").put((Object)Type.BIGINT, (Object)"10AggIfMergeIN10impala_udf9BigIntValEEEvPNS2_15FunctionContextERKT_PS6_").put((Object)Type.FLOAT, (Object)"10AggIfMergeIN10impala_udf8FloatValEEEvPNS2_15FunctionContextERKT_PS6_").put((Object)Type.DOUBLE, (Object)"10AggIfMergeIN10impala_udf9DoubleValEEEvPNS2_15FunctionContextERKT_PS6_").put((Object)Type.STRING, (Object)"10AggIfMergeIN10impala_udf9StringValEEEvPNS2_15FunctionContextERKT_PS6_").put((Object)Type.TIMESTAMP, (Object)"10AggIfMergeIN10impala_udf12TimestampValEEEvPNS2_15FunctionContextERKT_PS6_").put((Object)Type.DECIMAL, (Object)"10AggIfMergeIN10impala_udf10DecimalValEEEvPNS2_15FunctionContextERKT_PS6_").put((Object)Type.DATE, (Object)"10AggIfMergeIN10impala_udf7DateValEEEvPNS2_15FunctionContextERKT_PS6_").build();
        AGGIF_FINALIZE_SYMBOL = ImmutableMap.builder().put((Object)Type.BOOLEAN, (Object)"13AggIfFinalizeIN10impala_udf10BooleanValEEET_PNS2_15FunctionContextERKS4_").put((Object)Type.TINYINT, (Object)"13AggIfFinalizeIN10impala_udf10TinyIntValEEET_PNS2_15FunctionContextERKS4_").put((Object)Type.SMALLINT, (Object)"13AggIfFinalizeIN10impala_udf11SmallIntValEEET_PNS2_15FunctionContextERKS4_").put((Object)Type.INT, (Object)"13AggIfFinalizeIN10impala_udf6IntValEEET_PNS2_15FunctionContextERKS4_").put((Object)Type.BIGINT, (Object)"13AggIfFinalizeIN10impala_udf9BigIntValEEET_PNS2_15FunctionContextERKS4_").put((Object)Type.FLOAT, (Object)"13AggIfFinalizeIN10impala_udf8FloatValEEET_PNS2_15FunctionContextERKS4_").put((Object)Type.DOUBLE, (Object)"13AggIfFinalizeIN10impala_udf9DoubleValEEET_PNS2_15FunctionContextERKS4_").put((Object)Type.STRING, (Object)"13AggIfFinalizeIN10impala_udf9StringValEEET_PNS2_15FunctionContextERKS4_").put((Object)Type.TIMESTAMP, (Object)"13AggIfFinalizeIN10impala_udf12TimestampValEEET_PNS2_15FunctionContextERKS4_").put((Object)Type.DECIMAL, (Object)"13AggIfFinalizeIN10impala_udf10DecimalValEEET_PNS2_15FunctionContextERKS4_").put((Object)Type.DATE, (Object)"13AggIfFinalizeIN10impala_udf7DateValEEET_PNS2_15FunctionContextERKS4_").build();
        PC_UPDATE_SYMBOL = ImmutableMap.builder().put((Object)Type.BOOLEAN, (Object)"8PcUpdateIN10impala_udf10BooleanValEEEvPNS2_15FunctionContextERKT_PNS2_9StringValE").put((Object)Type.TINYINT, (Object)"8PcUpdateIN10impala_udf10TinyIntValEEEvPNS2_15FunctionContextERKT_PNS2_9StringValE").put((Object)Type.SMALLINT, (Object)"8PcUpdateIN10impala_udf11SmallIntValEEEvPNS2_15FunctionContextERKT_PNS2_9StringValE").put((Object)Type.INT, (Object)"8PcUpdateIN10impala_udf6IntValEEEvPNS2_15FunctionContextERKT_PNS2_9StringValE").put((Object)Type.BIGINT, (Object)"8PcUpdateIN10impala_udf9BigIntValEEEvPNS2_15FunctionContextERKT_PNS2_9StringValE").put((Object)Type.FLOAT, (Object)"8PcUpdateIN10impala_udf8FloatValEEEvPNS2_15FunctionContextERKT_PNS2_9StringValE").put((Object)Type.DOUBLE, (Object)"8PcUpdateIN10impala_udf9DoubleValEEEvPNS2_15FunctionContextERKT_PNS2_9StringValE").put((Object)Type.STRING, (Object)"8PcUpdateIN10impala_udf9StringValEEEvPNS2_15FunctionContextERKT_PS3_").put((Object)Type.TIMESTAMP, (Object)"8PcUpdateIN10impala_udf12TimestampValEEEvPNS2_15FunctionContextERKT_PNS2_9StringValE").put((Object)Type.DECIMAL, (Object)"8PcUpdateIN10impala_udf10DecimalValEEEvPNS2_15FunctionContextERKT_PNS2_9StringValE").put((Object)Type.DATE, (Object)"8PcUpdateIN10impala_udf7DateValEEEvPNS2_15FunctionContextERKT_PNS2_9StringValE").build();
        PCSA_UPDATE_SYMBOL = ImmutableMap.builder().put((Object)Type.BOOLEAN, (Object)"10PcsaUpdateIN10impala_udf10BooleanValEEEvPNS2_15FunctionContextERKT_PNS2_9StringValE").put((Object)Type.TINYINT, (Object)"10PcsaUpdateIN10impala_udf10TinyIntValEEEvPNS2_15FunctionContextERKT_PNS2_9StringValE").put((Object)Type.SMALLINT, (Object)"10PcsaUpdateIN10impala_udf11SmallIntValEEEvPNS2_15FunctionContextERKT_PNS2_9StringValE").put((Object)Type.INT, (Object)"10PcsaUpdateIN10impala_udf6IntValEEEvPNS2_15FunctionContextERKT_PNS2_9StringValE").put((Object)Type.BIGINT, (Object)"10PcsaUpdateIN10impala_udf9BigIntValEEEvPNS2_15FunctionContextERKT_PNS2_9StringValE").put((Object)Type.FLOAT, (Object)"10PcsaUpdateIN10impala_udf8FloatValEEEvPNS2_15FunctionContextERKT_PNS2_9StringValE").put((Object)Type.DOUBLE, (Object)"10PcsaUpdateIN10impala_udf9DoubleValEEEvPNS2_15FunctionContextERKT_PNS2_9StringValE").put((Object)Type.STRING, (Object)"10PcsaUpdateIN10impala_udf9StringValEEEvPNS2_15FunctionContextERKT_PS3_").put((Object)Type.TIMESTAMP, (Object)"10PcsaUpdateIN10impala_udf12TimestampValEEEvPNS2_15FunctionContextERKT_PNS2_9StringValE").put((Object)Type.DECIMAL, (Object)"10PcsaUpdateIN10impala_udf10DecimalValEEEvPNS2_15FunctionContextERKT_PNS2_9StringValE").put((Object)Type.DATE, (Object)"10PcsaUpdateIN10impala_udf7DateValEEEvPNS2_15FunctionContextERKT_PNS2_9StringValE").build();
        MIN_UPDATE_SYMBOL = ImmutableMap.builder().put((Object)Type.BOOLEAN, (Object)"3MinIN10impala_udf10BooleanValEEEvPNS2_15FunctionContextERKT_PS6_").put((Object)Type.TINYINT, (Object)"3MinIN10impala_udf10TinyIntValEEEvPNS2_15FunctionContextERKT_PS6_").put((Object)Type.SMALLINT, (Object)"3MinIN10impala_udf11SmallIntValEEEvPNS2_15FunctionContextERKT_PS6_").put((Object)Type.INT, (Object)"3MinIN10impala_udf6IntValEEEvPNS2_15FunctionContextERKT_PS6_").put((Object)Type.BIGINT, (Object)"3MinIN10impala_udf9BigIntValEEEvPNS2_15FunctionContextERKT_PS6_").put((Object)Type.FLOAT, (Object)"3MinIN10impala_udf8FloatValEEEvPNS2_15FunctionContextERKT_PS6_").put((Object)Type.DOUBLE, (Object)"3MinIN10impala_udf9DoubleValEEEvPNS2_15FunctionContextERKT_PS6_").put((Object)Type.STRING, (Object)"3MinIN10impala_udf9StringValEEEvPNS2_15FunctionContextERKT_PS6_").put((Object)Type.BINARY, (Object)"3MinIN10impala_udf9StringValEEEvPNS2_15FunctionContextERKT_PS6_").put((Object)Type.TIMESTAMP, (Object)"3MinIN10impala_udf12TimestampValEEEvPNS2_15FunctionContextERKT_PS6_").put((Object)Type.DECIMAL, (Object)"3MinIN10impala_udf10DecimalValEEEvPNS2_15FunctionContextERKT_PS6_").put((Object)Type.DATE, (Object)"3MinIN10impala_udf7DateValEEEvPNS2_15FunctionContextERKT_PS6_").build();
        MAX_UPDATE_SYMBOL = ImmutableMap.builder().put((Object)Type.BOOLEAN, (Object)"3MaxIN10impala_udf10BooleanValEEEvPNS2_15FunctionContextERKT_PS6_").put((Object)Type.TINYINT, (Object)"3MaxIN10impala_udf10TinyIntValEEEvPNS2_15FunctionContextERKT_PS6_").put((Object)Type.SMALLINT, (Object)"3MaxIN10impala_udf11SmallIntValEEEvPNS2_15FunctionContextERKT_PS6_").put((Object)Type.INT, (Object)"3MaxIN10impala_udf6IntValEEEvPNS2_15FunctionContextERKT_PS6_").put((Object)Type.BIGINT, (Object)"3MaxIN10impala_udf9BigIntValEEEvPNS2_15FunctionContextERKT_PS6_").put((Object)Type.FLOAT, (Object)"3MaxIN10impala_udf8FloatValEEEvPNS2_15FunctionContextERKT_PS6_").put((Object)Type.DOUBLE, (Object)"3MaxIN10impala_udf9DoubleValEEEvPNS2_15FunctionContextERKT_PS6_").put((Object)Type.STRING, (Object)"3MaxIN10impala_udf9StringValEEEvPNS2_15FunctionContextERKT_PS6_").put((Object)Type.BINARY, (Object)"3MaxIN10impala_udf9StringValEEEvPNS2_15FunctionContextERKT_PS6_").put((Object)Type.TIMESTAMP, (Object)"3MaxIN10impala_udf12TimestampValEEEvPNS2_15FunctionContextERKT_PS6_").put((Object)Type.DECIMAL, (Object)"3MaxIN10impala_udf10DecimalValEEEvPNS2_15FunctionContextERKT_PS6_").put((Object)Type.DATE, (Object)"3MaxIN10impala_udf7DateValEEEvPNS2_15FunctionContextERKT_PS6_").build();
        STDDEV_UPDATE_SYMBOL = ImmutableMap.builder().put((Object)Type.TINYINT, (Object)"14KnuthVarUpdateIN10impala_udf10TinyIntValEEEvPNS2_15FunctionContextERKT_PNS2_9StringValE").put((Object)Type.SMALLINT, (Object)"14KnuthVarUpdateIN10impala_udf11SmallIntValEEEvPNS2_15FunctionContextERKT_PNS2_9StringValE").put((Object)Type.INT, (Object)"14KnuthVarUpdateIN10impala_udf6IntValEEEvPNS2_15FunctionContextERKT_PNS2_9StringValE").put((Object)Type.BIGINT, (Object)"14KnuthVarUpdateIN10impala_udf9BigIntValEEEvPNS2_15FunctionContextERKT_PNS2_9StringValE").put((Object)Type.FLOAT, (Object)"14KnuthVarUpdateIN10impala_udf8FloatValEEEvPNS2_15FunctionContextERKT_PNS2_9StringValE").put((Object)Type.DOUBLE, (Object)"14KnuthVarUpdateIN10impala_udf9DoubleValEEEvPNS2_15FunctionContextERKT_PNS2_9StringValE").build();
        OFFSET_FN_INIT_SYMBOL = ImmutableMap.builder().put((Object)Type.BOOLEAN, (Object)"12OffsetFnInitIN10impala_udf10BooleanValEEEvPNS2_15FunctionContextEPT_").put((Object)Type.DATE, (Object)"12OffsetFnInitIN10impala_udf7DateValEEEvPNS2_15FunctionContextEPT_").put((Object)Type.DECIMAL, (Object)"12OffsetFnInitIN10impala_udf10DecimalValEEEvPNS2_15FunctionContextEPT_").put((Object)Type.TINYINT, (Object)"12OffsetFnInitIN10impala_udf10TinyIntValEEEvPNS2_15FunctionContextEPT_").put((Object)Type.SMALLINT, (Object)"12OffsetFnInitIN10impala_udf11SmallIntValEEEvPNS2_15FunctionContextEPT_").put((Object)Type.TIMESTAMP, (Object)"12OffsetFnInitIN10impala_udf12TimestampValEEEvPNS2_15FunctionContextEPT_").put((Object)Type.INT, (Object)"12OffsetFnInitIN10impala_udf6IntValEEEvPNS2_15FunctionContextEPT_").put((Object)Type.FLOAT, (Object)"12OffsetFnInitIN10impala_udf8FloatValEEEvPNS2_15FunctionContextEPT_").put((Object)Type.BIGINT, (Object)"12OffsetFnInitIN10impala_udf9BigIntValEEEvPNS2_15FunctionContextEPT_").put((Object)Type.DOUBLE, (Object)"12OffsetFnInitIN10impala_udf9DoubleValEEEvPNS2_15FunctionContextEPT_").put((Object)Type.STRING, (Object)"12OffsetFnInitIN10impala_udf9StringValEEEvPNS2_15FunctionContextEPT_").build();
        OFFSET_FN_UPDATE_SYMBOL = ImmutableMap.builder().put((Object)Type.BOOLEAN, (Object)"14OffsetFnUpdateIN10impala_udf10BooleanValEEEvPNS2_15FunctionContextERKT_RKNS2_9BigIntValES8_PS6_").put((Object)Type.DATE, (Object)"14OffsetFnUpdateIN10impala_udf7DateValEEEvPNS2_15FunctionContextERKT_RKNS2_9BigIntValES8_PS6_").put((Object)Type.DECIMAL, (Object)"14OffsetFnUpdateIN10impala_udf10DecimalValEEEvPNS2_15FunctionContextERKT_RKNS2_9BigIntValES8_PS6_").put((Object)Type.TINYINT, (Object)"14OffsetFnUpdateIN10impala_udf10TinyIntValEEEvPNS2_15FunctionContextERKT_RKNS2_9BigIntValES8_PS6_").put((Object)Type.SMALLINT, (Object)"14OffsetFnUpdateIN10impala_udf11SmallIntValEEEvPNS2_15FunctionContextERKT_RKNS2_9BigIntValES8_PS6_").put((Object)Type.TIMESTAMP, (Object)"14OffsetFnUpdateIN10impala_udf12TimestampValEEEvPNS2_15FunctionContextERKT_RKNS2_9BigIntValES8_PS6_").put((Object)Type.INT, (Object)"14OffsetFnUpdateIN10impala_udf6IntValEEEvPNS2_15FunctionContextERKT_RKNS2_9BigIntValES8_PS6_").put((Object)Type.FLOAT, (Object)"14OffsetFnUpdateIN10impala_udf8FloatValEEEvPNS2_15FunctionContextERKT_RKNS2_9BigIntValES8_PS6_").put((Object)Type.BIGINT, (Object)"14OffsetFnUpdateIN10impala_udf9BigIntValEEEvPNS2_15FunctionContextERKT_RKS3_S8_PS6_").put((Object)Type.DOUBLE, (Object)"14OffsetFnUpdateIN10impala_udf9DoubleValEEEvPNS2_15FunctionContextERKT_RKNS2_9BigIntValES8_PS6_").put((Object)Type.STRING, (Object)"14OffsetFnUpdateIN10impala_udf9StringValEEEvPNS2_15FunctionContextERKT_RKNS2_9BigIntValES8_PS6_").build();
        FIRST_VALUE_REWRITE_UPDATE_SYMBOL = ImmutableMap.builder().put((Object)Type.BOOLEAN, (Object)"21FirstValRewriteUpdateIN10impala_udf10BooleanValEEEvPNS2_15FunctionContextERKT_RKNS2_9BigIntValEPS6_").put((Object)Type.DATE, (Object)"21FirstValRewriteUpdateIN10impala_udf7DateValEEEvPNS2_15FunctionContextERKT_RKNS2_9BigIntValEPS6_").put((Object)Type.DECIMAL, (Object)"21FirstValRewriteUpdateIN10impala_udf10DecimalValEEEvPNS2_15FunctionContextERKT_RKNS2_9BigIntValEPS6_").put((Object)Type.TINYINT, (Object)"21FirstValRewriteUpdateIN10impala_udf10TinyIntValEEEvPNS2_15FunctionContextERKT_RKNS2_9BigIntValEPS6_").put((Object)Type.SMALLINT, (Object)"21FirstValRewriteUpdateIN10impala_udf11SmallIntValEEEvPNS2_15FunctionContextERKT_RKNS2_9BigIntValEPS6_").put((Object)Type.TIMESTAMP, (Object)"21FirstValRewriteUpdateIN10impala_udf12TimestampValEEEvPNS2_15FunctionContextERKT_RKNS2_9BigIntValEPS6_").put((Object)Type.INT, (Object)"21FirstValRewriteUpdateIN10impala_udf6IntValEEEvPNS2_15FunctionContextERKT_RKNS2_9BigIntValEPS6_").put((Object)Type.FLOAT, (Object)"21FirstValRewriteUpdateIN10impala_udf8FloatValEEEvPNS2_15FunctionContextERKT_RKNS2_9BigIntValEPS6_").put((Object)Type.BIGINT, (Object)"21FirstValRewriteUpdateIN10impala_udf9BigIntValEEEvPNS2_15FunctionContextERKT_RKS3_PS6_").put((Object)Type.DOUBLE, (Object)"21FirstValRewriteUpdateIN10impala_udf9DoubleValEEEvPNS2_15FunctionContextERKT_RKNS2_9BigIntValEPS6_").put((Object)Type.STRING, (Object)"21FirstValRewriteUpdateIN10impala_udf9StringValEEEvPNS2_15FunctionContextERKT_RKNS2_9BigIntValEPS6_").build();
        LAST_VALUE_REMOVE_SYMBOL = ImmutableMap.builder().put((Object)Type.BOOLEAN, (Object)"13LastValRemoveIN10impala_udf10BooleanValEEEvPNS2_15FunctionContextERKT_PS6_").put((Object)Type.DATE, (Object)"13LastValRemoveIN10impala_udf7DateValEEEvPNS2_15FunctionContextERKT_PS6_").put((Object)Type.DECIMAL, (Object)"13LastValRemoveIN10impala_udf10DecimalValEEEvPNS2_15FunctionContextERKT_PS6_").put((Object)Type.TINYINT, (Object)"13LastValRemoveIN10impala_udf10TinyIntValEEEvPNS2_15FunctionContextERKT_PS6_").put((Object)Type.SMALLINT, (Object)"13LastValRemoveIN10impala_udf11SmallIntValEEEvPNS2_15FunctionContextERKT_PS6_").put((Object)Type.TIMESTAMP, (Object)"13LastValRemoveIN10impala_udf12TimestampValEEEvPNS2_15FunctionContextERKT_PS6_").put((Object)Type.INT, (Object)"13LastValRemoveIN10impala_udf6IntValEEEvPNS2_15FunctionContextERKT_PS6_").put((Object)Type.FLOAT, (Object)"13LastValRemoveIN10impala_udf8FloatValEEEvPNS2_15FunctionContextERKT_PS6_").put((Object)Type.BIGINT, (Object)"13LastValRemoveIN10impala_udf9BigIntValEEEvPNS2_15FunctionContextERKT_PS6_").put((Object)Type.DOUBLE, (Object)"13LastValRemoveIN10impala_udf9DoubleValEEEvPNS2_15FunctionContextERKT_PS6_").put((Object)Type.STRING, (Object)"13LastValRemoveIN10impala_udf9StringValEEEvPNS2_15FunctionContextERKT_PS6_").build();
        LAST_VALUE_IGNORE_NULLS_INIT_SYMBOL = ImmutableMap.builder().put((Object)Type.BOOLEAN, (Object)"22LastValIgnoreNullsInitIN10impala_udf10BooleanValEEEvPNS2_15FunctionContextEPNS2_9StringValE").put((Object)Type.TINYINT, (Object)"22LastValIgnoreNullsInitIN10impala_udf10TinyIntValEEEvPNS2_15FunctionContextEPNS2_9StringValE").put((Object)Type.SMALLINT, (Object)"22LastValIgnoreNullsInitIN10impala_udf11SmallIntValEEEvPNS2_15FunctionContextEPNS2_9StringValE").put((Object)Type.INT, (Object)"22LastValIgnoreNullsInitIN10impala_udf6IntValEEEvPNS2_15FunctionContextEPNS2_9StringValE").put((Object)Type.BIGINT, (Object)"22LastValIgnoreNullsInitIN10impala_udf9BigIntValEEEvPNS2_15FunctionContextEPNS2_9StringValE").put((Object)Type.FLOAT, (Object)"22LastValIgnoreNullsInitIN10impala_udf8FloatValEEEvPNS2_15FunctionContextEPNS2_9StringValE").put((Object)Type.DOUBLE, (Object)"22LastValIgnoreNullsInitIN10impala_udf9DoubleValEEEvPNS2_15FunctionContextEPNS2_9StringValE").put((Object)Type.STRING, (Object)"22LastValIgnoreNullsInitIN10impala_udf9StringValEEEvPNS2_15FunctionContextEPS3_").put((Object)Type.TIMESTAMP, (Object)"22LastValIgnoreNullsInitIN10impala_udf12TimestampValEEEvPNS2_15FunctionContextEPNS2_9StringValE").put((Object)Type.DECIMAL, (Object)"22LastValIgnoreNullsInitIN10impala_udf10DecimalValEEEvPNS2_15FunctionContextEPNS2_9StringValE").put((Object)Type.DATE, (Object)"22LastValIgnoreNullsInitIN10impala_udf7DateValEEEvPNS2_15FunctionContextEPNS2_9StringValE").build();
        LAST_VALUE_IGNORE_NULLS_UPDATE_SYMBOL = ImmutableMap.builder().put((Object)Type.BOOLEAN, (Object)"24LastValIgnoreNullsUpdateIN10impala_udf10BooleanValEEEvPNS2_15FunctionContextERKT_PNS2_9StringValE").put((Object)Type.DATE, (Object)"24LastValIgnoreNullsUpdateIN10impala_udf7DateValEEEvPNS2_15FunctionContextERKT_PNS2_9StringValE").put((Object)Type.DECIMAL, (Object)"24LastValIgnoreNullsUpdateIN10impala_udf10DecimalValEEEvPNS2_15FunctionContextERKT_PNS2_9StringValE").put((Object)Type.TINYINT, (Object)"24LastValIgnoreNullsUpdateIN10impala_udf10TinyIntValEEEvPNS2_15FunctionContextERKT_PNS2_9StringValE").put((Object)Type.SMALLINT, (Object)"24LastValIgnoreNullsUpdateIN10impala_udf11SmallIntValEEEvPNS2_15FunctionContextERKT_PNS2_9StringValE").put((Object)Type.TIMESTAMP, (Object)"24LastValIgnoreNullsUpdateIN10impala_udf12TimestampValEEEvPNS2_15FunctionContextERKT_PNS2_9StringValE").put((Object)Type.INT, (Object)"24LastValIgnoreNullsUpdateIN10impala_udf6IntValEEEvPNS2_15FunctionContextERKT_PNS2_9StringValE").put((Object)Type.FLOAT, (Object)"24LastValIgnoreNullsUpdateIN10impala_udf8FloatValEEEvPNS2_15FunctionContextERKT_PNS2_9StringValE").put((Object)Type.BIGINT, (Object)"24LastValIgnoreNullsUpdateIN10impala_udf9BigIntValEEEvPNS2_15FunctionContextERKT_PNS2_9StringValE").put((Object)Type.DOUBLE, (Object)"24LastValIgnoreNullsUpdateIN10impala_udf9DoubleValEEEvPNS2_15FunctionContextERKT_PNS2_9StringValE").put((Object)Type.STRING, (Object)"24LastValIgnoreNullsUpdateIN10impala_udf9StringValEEEvPNS2_15FunctionContextERKT_PS3_").build();
        LAST_VALUE_IGNORE_NULLS_REMOVE_SYMBOL = ImmutableMap.builder().put((Object)Type.BOOLEAN, (Object)"24LastValIgnoreNullsRemoveIN10impala_udf10BooleanValEEEvPNS2_15FunctionContextERKT_PNS2_9StringValE").put((Object)Type.DATE, (Object)"24LastValIgnoreNullsRemoveIN10impala_udf7DateValEEEvPNS2_15FunctionContextERKT_PNS2_9StringValE").put((Object)Type.DECIMAL, (Object)"24LastValIgnoreNullsRemoveIN10impala_udf10DecimalValEEEvPNS2_15FunctionContextERKT_PNS2_9StringValE").put((Object)Type.TINYINT, (Object)"24LastValIgnoreNullsRemoveIN10impala_udf10TinyIntValEEEvPNS2_15FunctionContextERKT_PNS2_9StringValE").put((Object)Type.SMALLINT, (Object)"24LastValIgnoreNullsRemoveIN10impala_udf11SmallIntValEEEvPNS2_15FunctionContextERKT_PNS2_9StringValE").put((Object)Type.TIMESTAMP, (Object)"24LastValIgnoreNullsRemoveIN10impala_udf12TimestampValEEEvPNS2_15FunctionContextERKT_PNS2_9StringValE").put((Object)Type.INT, (Object)"24LastValIgnoreNullsRemoveIN10impala_udf6IntValEEEvPNS2_15FunctionContextERKT_PNS2_9StringValE").put((Object)Type.FLOAT, (Object)"24LastValIgnoreNullsRemoveIN10impala_udf8FloatValEEEvPNS2_15FunctionContextERKT_PNS2_9StringValE").put((Object)Type.BIGINT, (Object)"24LastValIgnoreNullsRemoveIN10impala_udf9BigIntValEEEvPNS2_15FunctionContextERKT_PNS2_9StringValE").put((Object)Type.DOUBLE, (Object)"24LastValIgnoreNullsRemoveIN10impala_udf9DoubleValEEEvPNS2_15FunctionContextERKT_PNS2_9StringValE").put((Object)Type.STRING, (Object)"24LastValIgnoreNullsRemoveIN10impala_udf9StringValEEEvPNS2_15FunctionContextERKT_PS3_").build();
        LAST_VALUE_IGNORE_NULLS_GET_VALUE_SYMBOL = ImmutableMap.builder().put((Object)Type.BOOLEAN, (Object)"26LastValIgnoreNullsGetValueIN10impala_udf10BooleanValEEET_PNS2_15FunctionContextERKNS2_9StringValE").put((Object)Type.TINYINT, (Object)"26LastValIgnoreNullsGetValueIN10impala_udf10TinyIntValEEET_PNS2_15FunctionContextERKNS2_9StringValE").put((Object)Type.SMALLINT, (Object)"26LastValIgnoreNullsGetValueIN10impala_udf11SmallIntValEEET_PNS2_15FunctionContextERKNS2_9StringValE").put((Object)Type.INT, (Object)"26LastValIgnoreNullsGetValueIN10impala_udf6IntValEEET_PNS2_15FunctionContextERKNS2_9StringValE").put((Object)Type.BIGINT, (Object)"26LastValIgnoreNullsGetValueIN10impala_udf9BigIntValEEET_PNS2_15FunctionContextERKNS2_9StringValE").put((Object)Type.FLOAT, (Object)"26LastValIgnoreNullsGetValueIN10impala_udf8FloatValEEET_PNS2_15FunctionContextERKNS2_9StringValE").put((Object)Type.DOUBLE, (Object)"26LastValIgnoreNullsGetValueIN10impala_udf9DoubleValEEET_PNS2_15FunctionContextERKNS2_9StringValE").put((Object)Type.STRING, (Object)"26LastValIgnoreNullsGetValueIN10impala_udf9StringValEEET_PNS2_15FunctionContextERKS3_").put((Object)Type.TIMESTAMP, (Object)"26LastValIgnoreNullsGetValueIN10impala_udf12TimestampValEEET_PNS2_15FunctionContextERKNS2_9StringValE").put((Object)Type.DECIMAL, (Object)"26LastValIgnoreNullsGetValueIN10impala_udf10DecimalValEEET_PNS2_15FunctionContextERKNS2_9StringValE").put((Object)Type.DATE, (Object)"26LastValIgnoreNullsGetValueIN10impala_udf7DateValEEET_PNS2_15FunctionContextERKNS2_9StringValE").build();
        LAST_VALUE_IGNORE_NULLS_FINALIZE_SYMBOL = ImmutableMap.builder().put((Object)Type.BOOLEAN, (Object)"26LastValIgnoreNullsFinalizeIN10impala_udf10BooleanValEEET_PNS2_15FunctionContextERKNS2_9StringValE").put((Object)Type.TINYINT, (Object)"26LastValIgnoreNullsFinalizeIN10impala_udf10TinyIntValEEET_PNS2_15FunctionContextERKNS2_9StringValE").put((Object)Type.SMALLINT, (Object)"26LastValIgnoreNullsFinalizeIN10impala_udf11SmallIntValEEET_PNS2_15FunctionContextERKNS2_9StringValE").put((Object)Type.INT, (Object)"26LastValIgnoreNullsFinalizeIN10impala_udf6IntValEEET_PNS2_15FunctionContextERKNS2_9StringValE").put((Object)Type.BIGINT, (Object)"26LastValIgnoreNullsFinalizeIN10impala_udf9BigIntValEEET_PNS2_15FunctionContextERKNS2_9StringValE").put((Object)Type.FLOAT, (Object)"26LastValIgnoreNullsFinalizeIN10impala_udf8FloatValEEET_PNS2_15FunctionContextERKNS2_9StringValE").put((Object)Type.DOUBLE, (Object)"26LastValIgnoreNullsFinalizeIN10impala_udf9DoubleValEEET_PNS2_15FunctionContextERKNS2_9StringValE").put((Object)Type.STRING, (Object)"26LastValIgnoreNullsFinalizeIN10impala_udf9StringValEEET_PNS2_15FunctionContextERKS3_").put((Object)Type.TIMESTAMP, (Object)"26LastValIgnoreNullsFinalizeIN10impala_udf12TimestampValEEET_PNS2_15FunctionContextERKNS2_9StringValE").put((Object)Type.DECIMAL, (Object)"26LastValIgnoreNullsFinalizeIN10impala_udf10DecimalValEEET_PNS2_15FunctionContextERKNS2_9StringValE").put((Object)Type.DATE, (Object)"26LastValIgnoreNullsFinalizeIN10impala_udf7DateValEEET_PNS2_15FunctionContextERKNS2_9StringValE").build();
        FIRST_VALUE_UPDATE_SYMBOL = ImmutableMap.builder().put((Object)Type.BOOLEAN, (Object)"14FirstValUpdateIN10impala_udf10BooleanValEEEvPNS2_15FunctionContextERKT_PS6_").put((Object)Type.DATE, (Object)"14FirstValUpdateIN10impala_udf7DateValEEEvPNS2_15FunctionContextERKT_PS6_").put((Object)Type.DECIMAL, (Object)"14FirstValUpdateIN10impala_udf10DecimalValEEEvPNS2_15FunctionContextERKT_PS6_").put((Object)Type.TINYINT, (Object)"14FirstValUpdateIN10impala_udf10TinyIntValEEEvPNS2_15FunctionContextERKT_PS6_").put((Object)Type.SMALLINT, (Object)"14FirstValUpdateIN10impala_udf11SmallIntValEEEvPNS2_15FunctionContextERKT_PS6_").put((Object)Type.TIMESTAMP, (Object)"14FirstValUpdateIN10impala_udf12TimestampValEEEvPNS2_15FunctionContextERKT_PS6_").put((Object)Type.INT, (Object)"14FirstValUpdateIN10impala_udf6IntValEEEvPNS2_15FunctionContextERKT_PS6_").put((Object)Type.FLOAT, (Object)"14FirstValUpdateIN10impala_udf8FloatValEEEvPNS2_15FunctionContextERKT_PS6_").put((Object)Type.BIGINT, (Object)"14FirstValUpdateIN10impala_udf9BigIntValEEEvPNS2_15FunctionContextERKT_PS6_").put((Object)Type.DOUBLE, (Object)"14FirstValUpdateIN10impala_udf9DoubleValEEEvPNS2_15FunctionContextERKT_PS6_").put((Object)Type.STRING, (Object)"14FirstValUpdateIN10impala_udf9StringValEEEvPNS2_15FunctionContextERKT_PS6_").build();
        FIRST_VALUE_IGNORE_NULLS_UPDATE_SYMBOL = ImmutableMap.builder().put((Object)Type.BOOLEAN, (Object)"25FirstValIgnoreNullsUpdateIN10impala_udf10BooleanValEEEvPNS2_15FunctionContextERKT_PS6_").put((Object)Type.DATE, (Object)"25FirstValIgnoreNullsUpdateIN10impala_udf7DateValEEEvPNS2_15FunctionContextERKT_PS6_").put((Object)Type.DECIMAL, (Object)"25FirstValIgnoreNullsUpdateIN10impala_udf10DecimalValEEEvPNS2_15FunctionContextERKT_PS6_").put((Object)Type.TINYINT, (Object)"25FirstValIgnoreNullsUpdateIN10impala_udf10TinyIntValEEEvPNS2_15FunctionContextERKT_PS6_").put((Object)Type.SMALLINT, (Object)"25FirstValIgnoreNullsUpdateIN10impala_udf11SmallIntValEEEvPNS2_15FunctionContextERKT_PS6_").put((Object)Type.TIMESTAMP, (Object)"25FirstValIgnoreNullsUpdateIN10impala_udf12TimestampValEEEvPNS2_15FunctionContextERKT_PS6_").put((Object)Type.INT, (Object)"25FirstValIgnoreNullsUpdateIN10impala_udf6IntValEEEvPNS2_15FunctionContextERKT_PS6_").put((Object)Type.FLOAT, (Object)"25FirstValIgnoreNullsUpdateIN10impala_udf8FloatValEEEvPNS2_15FunctionContextERKT_PS6_").put((Object)Type.BIGINT, (Object)"25FirstValIgnoreNullsUpdateIN10impala_udf9BigIntValEEEvPNS2_15FunctionContextERKT_PS6_").put((Object)Type.DOUBLE, (Object)"25FirstValIgnoreNullsUpdateIN10impala_udf9DoubleValEEEvPNS2_15FunctionContextERKT_PS6_").put((Object)Type.STRING, (Object)"25FirstValIgnoreNullsUpdateIN10impala_udf9StringValEEEvPNS2_15FunctionContextERKT_PS6_").build();
    }

    public static interface BuiltinsDbLoader {
        public Db getBuiltinsDbInstance();
    }
}

