/*
 * Decompiled with CFR 0.152.
 */
package org.apache.impala.catalog;

import com.google.common.base.Preconditions;
import org.apache.impala.catalog.CatalogInterners;
import org.apache.impala.thrift.TNetworkAddress;

public class BlockReplica {
    private final boolean isCached_;
    private final short hostIdx_;

    public BlockReplica(short hostIdx, boolean isCached) {
        this.hostIdx_ = hostIdx;
        this.isCached_ = isCached;
    }

    public static TNetworkAddress parseLocation(String location) {
        Preconditions.checkNotNull((Object)location);
        String[] ip_port = location.split(":");
        if (ip_port.length != 2) {
            return null;
        }
        try {
            return CatalogInterners.internNetworkAddress(new TNetworkAddress(ip_port[0], Integer.parseInt(ip_port[1])));
        }
        catch (NumberFormatException e) {
            return null;
        }
    }

    public boolean isCached() {
        return this.isCached_;
    }

    public short getHostIdx() {
        return this.hostIdx_;
    }
}

