/*
 * Decompiled with CFR 0.152.
 */
package org.apache.impala.authorization.ranger;

import com.google.common.annotations.VisibleForTesting;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.Function;
import java.util.function.Supplier;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.hadoop.hive.metastore.api.PrincipalType;
import org.apache.impala.authorization.AuthorizationDelta;
import org.apache.impala.authorization.AuthorizationManager;
import org.apache.impala.authorization.Privilege;
import org.apache.impala.authorization.User;
import org.apache.impala.authorization.ranger.RangerBufferAuditHandler;
import org.apache.impala.authorization.ranger.RangerImpalaPlugin;
import org.apache.impala.authorization.ranger.RangerUtil;
import org.apache.impala.catalog.AuthzCacheInvalidation;
import org.apache.impala.catalog.CatalogServiceCatalog;
import org.apache.impala.common.ImpalaException;
import org.apache.impala.common.InternalException;
import org.apache.impala.common.Pair;
import org.apache.impala.service.BackendConfig;
import org.apache.impala.thrift.TCatalogServiceRequestHeader;
import org.apache.impala.thrift.TCreateDropRoleParams;
import org.apache.impala.thrift.TDdlExecResponse;
import org.apache.impala.thrift.TGrantRevokePrivParams;
import org.apache.impala.thrift.TGrantRevokeRoleParams;
import org.apache.impala.thrift.TPrivilege;
import org.apache.impala.thrift.TPrivilegeLevel;
import org.apache.impala.thrift.TResultSet;
import org.apache.impala.thrift.TShowGrantPrincipalParams;
import org.apache.impala.thrift.TShowRolesParams;
import org.apache.impala.thrift.TShowRolesResult;
import org.apache.impala.util.ClassUtil;
import org.apache.ranger.plugin.model.RangerRole;
import org.apache.ranger.plugin.util.GrantRevokeRequest;
import org.apache.ranger.plugin.util.GrantRevokeRoleRequest;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RangerCatalogdAuthorizationManager
implements AuthorizationManager {
    private static final Logger LOG = LoggerFactory.getLogger(RangerCatalogdAuthorizationManager.class);
    private static final String AUTHZ_CACHE_INVALIDATION_MARKER = "ranger";
    private final Supplier<RangerImpalaPlugin> plugin_;
    private final CatalogServiceCatalog catalog_;

    public RangerCatalogdAuthorizationManager(Supplier<RangerImpalaPlugin> pluginSupplier, CatalogServiceCatalog catalog) {
        this.plugin_ = pluginSupplier;
        this.catalog_ = catalog;
    }

    @Override
    public void createRole(User requestingUser, TCreateDropRoleParams params, TDdlExecResponse response) throws ImpalaException {
        RangerRole role = new RangerRole();
        role.setName(params.getRole_name());
        role.setCreatedByUser(requestingUser.getShortName());
        try {
            this.plugin_.get().createRole(role, null);
        }
        catch (Exception e) {
            LOG.error("Error creating role {} by user {} in Ranger.", (Object)params.getRole_name(), (Object)requestingUser.getShortName());
            throw new InternalException("Error creating role " + params.getRole_name() + " by user " + requestingUser.getShortName() + " in Ranger. Ranger error message: " + e.getMessage());
        }
        this.refreshAuthorization(response);
    }

    @Override
    public void dropRole(User requestingUser, TCreateDropRoleParams params, TDdlExecResponse response) throws ImpalaException {
        try {
            RangerUtil.validateRangerAdmin(this.plugin_.get(), requestingUser.getShortName());
            this.plugin_.get().dropRole(requestingUser.getShortName(), params.getRole_name(), null);
        }
        catch (Exception e) {
            LOG.error("Error dropping role {} by user {} in Ranger.", (Object)params.getRole_name(), (Object)requestingUser.getShortName());
            throw new InternalException("Error dropping role " + params.getRole_name() + " by user " + requestingUser.getShortName() + " in Ranger. Ranger error message: " + e.getMessage());
        }
        this.refreshAuthorization(response);
    }

    @Override
    public TShowRolesResult getRoles(TShowRolesParams params) throws ImpalaException {
        throw new UnsupportedOperationException(String.format("%s is not supported in Catalogd", ClassUtil.getMethodName()));
    }

    @Override
    public void grantRoleToGroup(User requestingUser, TGrantRevokeRoleParams params, TDdlExecResponse response) throws ImpalaException {
        GrantRevokeRoleRequest request = RangerCatalogdAuthorizationManager.createGrantRevokeRoleRequest(requestingUser.getShortName(), new HashSet<String>(params.getRole_names()), new HashSet<String>(params.getGroup_names()));
        try {
            this.plugin_.get().revokeRole(request, null);
            this.plugin_.get().grantRole(request, null);
        }
        catch (Exception e) {
            Pattern pattern = Pattern.compile(".*doesn't have permissions.*");
            Matcher matcher = pattern.matcher(e.getMessage());
            if (matcher.matches()) {
                LOG.error("Error granting role {} to group {} by user {} in Ranger. Ranger error message: HTTP 400 Error: User doesn't have permissions to grant role " + params.getRole_names().get(0), new Object[]{params.getRole_names().get(0), params.getGroup_names().get(0), requestingUser.getShortName()});
                throw new InternalException("Error granting role " + params.getRole_names().get(0) + " to group " + params.getGroup_names().get(0) + " by user " + requestingUser.getShortName() + " in Ranger. Ranger error message: HTTP 400 Error: User doesn't have permissions to grant role " + params.getRole_names().get(0));
            }
            LOG.error("Error granting role {} to group {} by user {} in Ranger. Ranger error message: " + e.getMessage(), new Object[]{params.getRole_names().get(0), params.getGroup_names().get(0), requestingUser.getShortName()});
            throw new InternalException("Error granting role " + params.getRole_names().get(0) + " to group " + params.getGroup_names().get(0) + " by user " + requestingUser.getShortName() + " in Ranger. Ranger error message: " + e.getMessage());
        }
        this.refreshAuthorization(response);
    }

    @Override
    public void revokeRoleFromGroup(User requestingUser, TGrantRevokeRoleParams params, TDdlExecResponse response) throws ImpalaException {
        GrantRevokeRoleRequest request = RangerCatalogdAuthorizationManager.createGrantRevokeRoleRequest(requestingUser.getShortName(), new HashSet<String>(params.getRole_names()), new HashSet<String>(params.getGroup_names()));
        try {
            this.plugin_.get().revokeRole(request, null);
        }
        catch (Exception e) {
            LOG.error("Error revoking role {} from group {} by user {} in Ranger. Ranger error message: " + e.getMessage(), new Object[]{params.getRole_names().get(0), params.getGroup_names().get(0), requestingUser.getShortName()});
            throw new InternalException("Error revoking role " + params.getRole_names().get(0) + " from group " + params.getGroup_names().get(0) + " by user " + requestingUser.getShortName() + " in Ranger. Ranger error message: " + e.getMessage());
        }
        this.refreshAuthorization(response);
    }

    @Override
    public void grantPrivilegeToRole(TCatalogServiceRequestHeader header, TGrantRevokePrivParams params, TDdlExecResponse response) throws ImpalaException {
        List<GrantRevokeRequest> requests = RangerCatalogdAuthorizationManager.createGrantRevokeRequests(new User(header.getRequesting_user()).getShortName(), true, null, Collections.emptyList(), Collections.singletonList(params.getPrincipal_name()), this.plugin_.get().getClusterName(), header.getClient_ip(), params.getPrivileges(), params.getOwner_name());
        this.grantPrivilege(requests, header.getRedacted_sql_stmt(), header.getClient_ip());
        this.refreshAuthorization(response);
    }

    @Override
    public void revokePrivilegeFromRole(TCatalogServiceRequestHeader header, TGrantRevokePrivParams params, TDdlExecResponse response) throws ImpalaException {
        List<GrantRevokeRequest> requests = RangerCatalogdAuthorizationManager.createGrantRevokeRequests(new User(header.getRequesting_user()).getShortName(), false, null, Collections.emptyList(), Collections.singletonList(params.getPrincipal_name()), this.plugin_.get().getClusterName(), header.getClient_ip(), params.getPrivileges(), params.getOwner_name());
        this.revokePrivilege(requests, header.getRedacted_sql_stmt(), header.getClient_ip());
        this.refreshAuthorization(response);
    }

    @Override
    public void grantPrivilegeToUser(TCatalogServiceRequestHeader header, TGrantRevokePrivParams params, TDdlExecResponse response) throws ImpalaException {
        List<GrantRevokeRequest> requests = RangerCatalogdAuthorizationManager.createGrantRevokeRequests(new User(header.getRequesting_user()).getShortName(), true, params.getPrincipal_name(), Collections.emptyList(), Collections.emptyList(), this.plugin_.get().getClusterName(), header.getClient_ip(), params.getPrivileges(), params.getOwner_name());
        this.grantPrivilege(requests, header.getRedacted_sql_stmt(), header.getClient_ip());
        this.refreshAuthorization(response);
    }

    @Override
    public void revokePrivilegeFromUser(TCatalogServiceRequestHeader header, TGrantRevokePrivParams params, TDdlExecResponse response) throws ImpalaException {
        List<GrantRevokeRequest> requests = RangerCatalogdAuthorizationManager.createGrantRevokeRequests(new User(header.getRequesting_user()).getShortName(), false, params.getPrincipal_name(), Collections.emptyList(), Collections.emptyList(), this.plugin_.get().getClusterName(), header.getClient_ip(), params.getPrivileges(), params.getOwner_name());
        this.revokePrivilege(requests, header.getRedacted_sql_stmt(), header.getClient_ip());
        this.refreshAuthorization(response);
    }

    @Override
    public void grantPrivilegeToGroup(TCatalogServiceRequestHeader header, TGrantRevokePrivParams params, TDdlExecResponse response) throws ImpalaException {
        List<GrantRevokeRequest> requests = RangerCatalogdAuthorizationManager.createGrantRevokeRequests(new User(header.getRequesting_user()).getShortName(), true, null, Collections.singletonList(params.getPrincipal_name()), Collections.emptyList(), this.plugin_.get().getClusterName(), header.getClient_ip(), params.getPrivileges(), params.getOwner_name());
        this.grantPrivilege(requests, header.getRedacted_sql_stmt(), header.getClient_ip());
        this.refreshAuthorization(response);
    }

    @Override
    public void revokePrivilegeFromGroup(TCatalogServiceRequestHeader header, TGrantRevokePrivParams params, TDdlExecResponse response) throws ImpalaException {
        List<GrantRevokeRequest> requests = RangerCatalogdAuthorizationManager.createGrantRevokeRequests(new User(header.getRequesting_user()).getShortName(), false, null, Collections.singletonList(params.getPrincipal_name()), Collections.emptyList(), this.plugin_.get().getClusterName(), header.getClient_ip(), params.getPrivileges(), params.getOwner_name());
        this.revokePrivilege(requests, header.getRedacted_sql_stmt(), header.getClient_ip());
        this.refreshAuthorization(response);
    }

    @VisibleForTesting
    public void grantPrivilege(List<GrantRevokeRequest> requests, String sqlStmt, String clientIp) throws ImpalaException {
        long startTime = System.currentTimeMillis();
        try {
            for (GrantRevokeRequest request : requests) {
                RangerBufferAuditHandler.AutoFlush auditHandler = RangerBufferAuditHandler.autoFlush(sqlStmt, this.plugin_.get().getClusterName(), clientIp);
                Throwable throwable = null;
                try {
                    this.plugin_.get().grantAccess(request, auditHandler);
                }
                catch (Throwable throwable2) {
                    throwable = throwable2;
                    throw throwable2;
                }
                finally {
                    if (auditHandler == null) continue;
                    if (throwable != null) {
                        try {
                            auditHandler.close();
                        }
                        catch (Throwable throwable3) {
                            throwable.addSuppressed(throwable3);
                        }
                        continue;
                    }
                    auditHandler.close();
                }
            }
        }
        catch (Exception e) {
            LOG.error("Error granting a privilege in Ranger: ", (Throwable)e);
            throw new InternalException("Error granting a privilege in Ranger. Ranger error message: " + e.getMessage());
        }
        finally {
            LOG.debug("Handling granting privilege(s) took {} ms", (Object)(System.currentTimeMillis() - startTime));
        }
    }

    @VisibleForTesting
    public void revokePrivilege(List<GrantRevokeRequest> requests, String sqlStmt, String clientIp) throws ImpalaException {
        long startTime = System.currentTimeMillis();
        try {
            for (GrantRevokeRequest request : requests) {
                RangerBufferAuditHandler.AutoFlush auditHandler = RangerBufferAuditHandler.autoFlush(sqlStmt, this.plugin_.get().getClusterName(), clientIp);
                Throwable throwable = null;
                try {
                    this.plugin_.get().revokeAccess(request, auditHandler);
                }
                catch (Throwable throwable2) {
                    throwable = throwable2;
                    throw throwable2;
                }
                finally {
                    if (auditHandler == null) continue;
                    if (throwable != null) {
                        try {
                            auditHandler.close();
                        }
                        catch (Throwable throwable3) {
                            throwable.addSuppressed(throwable3);
                        }
                        continue;
                    }
                    auditHandler.close();
                }
            }
        }
        catch (Exception e) {
            LOG.error("Error revoking a privilege in Ranger: ", (Throwable)e);
            throw new InternalException("Error revoking a privilege in Ranger. Ranger error message: " + e.getMessage());
        }
        finally {
            LOG.debug("Handling revoking privilege(s) took {} ms", (Object)(System.currentTimeMillis() - startTime));
        }
    }

    @Override
    public TResultSet getPrivileges(TShowGrantPrincipalParams params) throws ImpalaException {
        throw new UnsupportedOperationException(String.format("%s is not supported in Catalogd", ClassUtil.getMethodName()));
    }

    @Override
    public void updateDatabaseOwnerPrivilege(String serverName, String databaseName, String oldOwner, PrincipalType oldOwnerType, String newOwner, PrincipalType newOwnerType, TDdlExecResponse response) throws ImpalaException {
    }

    @Override
    public void updateTableOwnerPrivilege(String serverName, String databaseName, String tableName, String oldOwner, PrincipalType oldOwnerType, String newOwner, PrincipalType newOwnerType, TDdlExecResponse response) throws ImpalaException {
    }

    @Override
    public AuthorizationDelta refreshAuthorization(boolean resetVersions) {
        AuthorizationDelta authzDelta = new AuthorizationDelta();
        AuthzCacheInvalidation authzCacheInvalidation = this.catalog_.incrementAuthzCacheInvalidationVersion(AUTHZ_CACHE_INVALIDATION_MARKER);
        authzDelta.addCatalogObjectAdded(authzCacheInvalidation.toTCatalogObject());
        return authzDelta;
    }

    private void refreshAuthorization(TDdlExecResponse response) {
        AuthorizationDelta authzDelta = this.refreshAuthorization(false);
        response.result.setUpdated_catalog_objects(authzDelta.getCatalogObjectsAdded());
    }

    public static List<GrantRevokeRequest> createGrantRevokeRequests(String grantor, boolean isGrant, String user, List<String> groups, List<String> roles, String clusterName, String clientIp, List<TPrivilege> privileges, String resourceOwner) {
        ArrayList<GrantRevokeRequest> requests = new ArrayList<GrantRevokeRequest>();
        for (TPrivilege p : privileges) {
            Function<Map, GrantRevokeRequest> createRequest = resource -> RangerCatalogdAuthorizationManager.createGrantRevokeRequest(grantor, user, groups, roles, clusterName, p.has_grant_opt, isGrant, p.privilege_level, resource, resourceOwner, clientIp);
            if (p.getColumn_name() != null || p.getTable_name() != null) {
                requests.add(createRequest.apply(RangerUtil.createColumnResource(p)));
                continue;
            }
            if (p.getUri() != null) {
                requests.add(createRequest.apply(RangerUtil.createUriResource(p)));
                continue;
            }
            if (p.getFn_name() != null) {
                requests.add(createRequest.apply(RangerUtil.createFunctionResource(p)));
                continue;
            }
            if (p.getDb_name() != null) {
                requests.add(createRequest.apply(RangerUtil.createColumnResource(p)));
                requests.add(createRequest.apply(RangerUtil.createFunctionResource(p)));
                continue;
            }
            if (p.getStorage_url() != null || p.getStorage_type() != null) {
                requests.add(createRequest.apply(RangerUtil.createStorageHandlerUriResource(p)));
                continue;
            }
            requests.add(createRequest.apply(RangerUtil.createColumnResource(p)));
            requests.add(createRequest.apply(RangerUtil.createFunctionResource(p)));
            requests.add(createRequest.apply(RangerUtil.createUriResource(p)));
            requests.add(createRequest.apply(RangerUtil.createStorageHandlerUriResource(p)));
        }
        return BackendConfig.INSTANCE.consolidateGrantRevokeRequests() ? RangerCatalogdAuthorizationManager.consolidateGrantRevokeRequests(requests) : requests;
    }

    private static GrantRevokeRequest createGrantRevokeRequest(String grantor, String user, List<String> groups, List<String> roles, String clusterName, boolean withGrantOpt, boolean isGrant, TPrivilegeLevel level, Map<String, String> resource, String resourceOwner, String clientIp) {
        GrantRevokeRequest request = new GrantRevokeRequest();
        request.setGrantor(grantor);
        request.setGrantorGroups(RangerUtil.getGroups(grantor));
        if (user != null) {
            request.getUsers().add(user);
        }
        if (!groups.isEmpty()) {
            request.getGroups().addAll(groups);
        }
        if (!roles.isEmpty()) {
            request.getRoles().addAll(roles);
        }
        request.setDelegateAdmin(Boolean.valueOf(isGrant && withGrantOpt));
        request.setEnableAudit(Boolean.TRUE);
        request.setReplaceExistingPermissions(Boolean.FALSE);
        request.setClusterName(clusterName);
        request.setResource(resource);
        if (resourceOwner != null) {
            request.setOwnerUser(resourceOwner);
        }
        request.setClientIPAddress(clientIp);
        if (isGrant || !withGrantOpt) {
            if (resource.containsKey("storage-type")) {
                if (level == TPrivilegeLevel.ALL || level == TPrivilegeLevel.OWNER || level == TPrivilegeLevel.RWSTORAGE) {
                    request.getAccessTypes().add(Privilege.RWSTORAGE.name().toLowerCase());
                }
            } else if (level == TPrivilegeLevel.INSERT) {
                request.getAccessTypes().add("update");
            } else if (level != TPrivilegeLevel.RWSTORAGE) {
                request.getAccessTypes().add(level.name().toLowerCase());
            }
        }
        return request;
    }

    private static List<GrantRevokeRequest> consolidateGrantRevokeRequests(List<GrantRevokeRequest> requests) {
        LinkedList<GrantRevokeRequest> combinedRequests = new LinkedList<GrantRevokeRequest>();
        HashMap<Pair<String, String>, GrantRevokeRequest> consolidatedColumnRequests = new HashMap<Pair<String, String>, GrantRevokeRequest>();
        LinkedList<GrantRevokeRequest> unconsolidatedRequests = new LinkedList<GrantRevokeRequest>();
        for (GrantRevokeRequest request : requests) {
            Map resource = request.getResource();
            String column = (String)resource.get("column");
            if (column != null && !column.equals("*")) {
                String table;
                String database = (String)resource.get("database");
                Pair<String, String> key = new Pair<String, String>(database, table = (String)resource.get("table"));
                if (!consolidatedColumnRequests.containsKey(key)) {
                    consolidatedColumnRequests.put(key, request);
                    continue;
                }
                Map consolidatedResource = ((GrantRevokeRequest)consolidatedColumnRequests.get(key)).getResource();
                String consolidatedColumns = (String)consolidatedResource.get("column");
                consolidatedResource.put("column", consolidatedColumns + "," + column);
                continue;
            }
            unconsolidatedRequests.add(request);
        }
        combinedRequests.addAll(consolidatedColumnRequests.values());
        combinedRequests.addAll(unconsolidatedRequests);
        return combinedRequests;
    }

    private static GrantRevokeRoleRequest createGrantRevokeRoleRequest(String grantor, Set<String> targetRoleNames, Set<String> groupNames) {
        GrantRevokeRoleRequest request = new GrantRevokeRoleRequest();
        request.setGrantor(grantor);
        request.setTargetRoles(targetRoleNames);
        request.setGroups(groupNames);
        return request;
    }
}

