/*
 * Decompiled with CFR 0.152.
 */
package org.apache.impala.authorization.ranger;

import com.google.common.base.Preconditions;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import org.apache.ranger.audit.model.AuthzAuditEvent;
import org.apache.ranger.plugin.audit.RangerDefaultAuditHandler;
import org.apache.ranger.plugin.policyengine.RangerAccessRequest;
import org.apache.ranger.plugin.policyengine.RangerAccessResource;
import org.apache.ranger.plugin.policyengine.RangerAccessResult;
import org.apache.ranger.plugin.policyengine.RangerAccessResultProcessor;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RangerBufferAuditHandler
implements RangerAccessResultProcessor {
    private static final Logger LOG = LoggerFactory.getLogger(RangerBufferAuditHandler.class);
    public static final String ACCESS_TYPE_ROWFILTER = "row_filter";
    private final RangerDefaultAuditHandler auditHandler_ = new RangerDefaultAuditHandler();
    private final List<AuthzAuditEvent> auditEvents_ = new ArrayList<AuthzAuditEvent>();
    private final String sqlStmt_;
    private final String clusterName_;
    private final String clientIp_;

    public RangerBufferAuditHandler() {
        this("", "", "");
    }

    public RangerBufferAuditHandler(String sqlStmt, String clusterName, String clientIp) {
        this.sqlStmt_ = (String)Preconditions.checkNotNull((Object)sqlStmt);
        this.clusterName_ = (String)Preconditions.checkNotNull((Object)clusterName);
        this.clientIp_ = (String)Preconditions.checkNotNull((Object)clientIp);
    }

    public RangerBufferAuditHandler(RangerBufferAuditHandler auditHandler) {
        Preconditions.checkNotNull((Object)auditHandler);
        this.sqlStmt_ = (String)Preconditions.checkNotNull((Object)auditHandler.getSqlStmt());
        this.clusterName_ = (String)Preconditions.checkNotNull((Object)auditHandler.getClusterName());
        this.clientIp_ = (String)Preconditions.checkNotNull((Object)auditHandler.getClientIp());
    }

    public String getSqlStmt() {
        return this.sqlStmt_;
    }

    public String getClusterName() {
        return this.clusterName_;
    }

    public String getClientIp() {
        return this.clientIp_;
    }

    public static AutoFlush autoFlush(String sqlStmt, String clusterName, String clientIp) {
        return new AutoFlush(sqlStmt, clusterName, clientIp);
    }

    public void processResult(RangerAccessResult result) {
        this.processResults(Collections.singletonList(result));
    }

    public void processResults(Collection<RangerAccessResult> results) {
        this.auditEvents_.addAll(this.createAuditEvents(results));
    }

    public void flush() {
        Optional<AuthzAuditEvent> firstFailure = this.auditEvents_.stream().filter(evt -> evt.getAccessResult() == 0).findFirst();
        if (firstFailure.isPresent()) {
            this.auditEvents_.clear();
            this.auditEvents_.add(firstFailure.get());
        }
        this.auditEvents_.forEach(event -> this.auditHandler_.logAuthzAudit(event));
    }

    private AuthzAuditEvent createAuditEvent(RangerAccessResult result) {
        RangerAccessRequest request = result.getAccessRequest();
        RangerAccessResource resource = request.getResource();
        String resourceType = resource != null ? resource.getLeafName() : null;
        AuthzAuditEvent auditEvent = this.auditHandler_.getAuthzEvents(result);
        int policyType = result.getPolicyType();
        if (policyType == 1 && result.isMaskEnabled()) {
            auditEvent.setAccessType(result.getMaskType().toLowerCase());
        } else if (policyType == 2) {
            auditEvent.setAccessType(ACCESS_TYPE_ROWFILTER);
        } else {
            auditEvent.setAccessType(request.getAccessType().toUpperCase());
        }
        auditEvent.setRequestData(this.sqlStmt_);
        auditEvent.setClientIP(this.clientIp_);
        auditEvent.setClusterName(this.clusterName_);
        auditEvent.setResourcePath(resource != null ? resource.getAsString() : null);
        if (resourceType != null) {
            auditEvent.setResourceType("@" + resourceType);
        }
        return auditEvent;
    }

    private List<AuthzAuditEvent> createAuditEvents(Collection<RangerAccessResult> results) {
        ArrayList<AuthzAuditEvent> auditEvents = new ArrayList<AuthzAuditEvent>();
        for (RangerAccessResult result : results) {
            if (!result.getIsAudited()) continue;
            auditEvents.add(this.createAuditEvent(result));
        }
        return auditEvents;
    }

    protected List<AuthzAuditEvent> getAuthzEvents() {
        return this.auditEvents_;
    }

    public static class AutoFlush
    extends RangerBufferAuditHandler
    implements AutoCloseable {
        public AutoFlush(String sqlStmt, String clusterName, String clientIp) {
            super(sqlStmt, clusterName, clientIp);
        }

        @Override
        public void close() {
            super.flush();
        }
    }
}

