/*
 * Decompiled with CFR 0.152.
 */
package org.apache.impala.authorization.ranger;

import com.google.common.base.Preconditions;
import java.util.Arrays;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import javax.annotation.Nullable;
import org.apache.impala.authorization.AuthorizationContext;
import org.apache.impala.authorization.ranger.RangerBufferAuditHandler;
import org.apache.impala.authorization.ranger.RangerImpalaPlugin;
import org.apache.impala.thrift.TSessionState;
import org.apache.impala.util.EventSequence;
import org.apache.ranger.audit.model.AuthzAuditEvent;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RangerAuthorizationContext
extends AuthorizationContext {
    private static final Logger LOG = LoggerFactory.getLogger(RangerAuthorizationContext.class);
    private final TSessionState sessionState_;
    @Nullable
    private RangerBufferAuditHandler auditHandler_;
    private Map<String, AuthzAuditEvent> deduplicatedAuditEvents_;

    public RangerAuthorizationContext(TSessionState sessionState, Optional<EventSequence> timeline) {
        super(timeline);
        this.sessionState_ = sessionState;
        this.deduplicatedAuditEvents_ = new LinkedHashMap<String, AuthzAuditEvent>();
    }

    public void setAuditHandler(RangerBufferAuditHandler auditHandler) {
        this.auditHandler_ = (RangerBufferAuditHandler)Preconditions.checkNotNull((Object)auditHandler);
    }

    public RangerBufferAuditHandler getAuditHandler() {
        return this.auditHandler_;
    }

    public void stashTableMaskingAuditEvents(RangerImpalaPlugin plugin) {
        Set<String> legalEventTypes = plugin.getUnfilteredMaskNames(Arrays.asList("MASK_NONE"));
        legalEventTypes.add("row_filter".toUpperCase());
        for (AuthzAuditEvent event : this.auditHandler_.getAuthzEvents()) {
            Preconditions.checkState((boolean)legalEventTypes.contains(event.getAccessType().toUpperCase()), (String)"Illegal event access type: %s. Should be one of %s. Event details: %s", (Object)event.getAccessType(), legalEventTypes, (Object)event);
            this.deduplicatedAuditEvents_.put(event.getEventKey(), event);
        }
        this.auditHandler_.getAuthzEvents().clear();
    }

    public void consolidateAuthzEvents() {
        LinkedHashMap<String, AuthzAuditEvent> consolidatedEvents = new LinkedHashMap<String, AuthzAuditEvent>();
        LinkedList<AuthzAuditEvent> unconsolidatedEvents = new LinkedList<AuthzAuditEvent>();
        for (AuthzAuditEvent event : this.auditHandler_.getAuthzEvents()) {
            String resourceType = event.getResourceType();
            if ("@column".equals(resourceType)) {
                String[] parsedNames = event.getResourcePath().split("/", 3);
                if (parsedNames.length < 3) {
                    LOG.error("The column resource path " + event.getResourcePath() + " could not be parsed into the form of <database name>/<table name>/<column name>.");
                    continue;
                }
                long policyId = event.getPolicyId();
                String databaseName = parsedNames[0];
                String tableName = parsedNames[1];
                String columnName = parsedNames[2];
                String accessType = event.getAccessType();
                String key = policyId + "/" + databaseName + "/" + tableName + "/" + accessType;
                if (!consolidatedEvents.containsKey(key)) {
                    consolidatedEvents.put(key, event);
                    continue;
                }
                AuthzAuditEvent consolidatedEvent = (AuthzAuditEvent)consolidatedEvents.get(key);
                consolidatedEvent.setResourcePath(consolidatedEvent.getResourcePath() + "," + columnName);
                consolidatedEvents.put(key, consolidatedEvent);
                continue;
            }
            unconsolidatedEvents.add(event);
        }
        this.auditHandler_.getAuthzEvents().clear();
        this.auditHandler_.getAuthzEvents().addAll(unconsolidatedEvents);
        this.auditHandler_.getAuthzEvents().addAll(consolidatedEvents.values());
    }

    public void applyDeduplicatedAuthzEvents() {
        this.auditHandler_.getAuthzEvents().addAll(this.deduplicatedAuditEvents_.values());
    }

    public TSessionState getSessionState() {
        return this.sessionState_;
    }
}

