/*
 * Decompiled with CFR 0.152.
 */
package org.apache.impala.authorization;

import com.google.common.base.Preconditions;
import com.google.common.collect.Sets;
import java.util.EnumSet;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.apache.hadoop.hive.metastore.api.Table;
import org.apache.impala.authorization.Authorizable;
import org.apache.impala.authorization.AuthorizableFactory;
import org.apache.impala.authorization.Privilege;
import org.apache.impala.authorization.PrivilegeRequest;
import org.apache.impala.catalog.FeDb;
import org.apache.impala.catalog.FeTable;
import org.apache.impala.catalog.View;
import org.apache.impala.catalog.local.LocalView;
import org.apache.impala.common.RuntimeEnv;

public class PrivilegeRequestBuilder {
    private final AuthorizableFactory authzFactory_;
    private Authorizable authorizable_;
    private Privilege privilege_;
    private EnumSet<Privilege> privilegeSet_;
    private boolean grantOption_ = false;

    public PrivilegeRequestBuilder(AuthorizableFactory authzFactory) {
        Preconditions.checkNotNull((Object)authzFactory);
        this.authzFactory_ = authzFactory;
    }

    public PrivilegeRequestBuilder onFunction(String dbName, String fnName) {
        Preconditions.checkState((this.authorizable_ == null ? 1 : 0) != 0);
        this.authorizable_ = this.authzFactory_.newFunction(dbName, fnName);
        return this;
    }

    public PrivilegeRequestBuilder onUri(String uriName) {
        Preconditions.checkState((this.authorizable_ == null ? 1 : 0) != 0);
        this.authorizable_ = this.authzFactory_.newUri(uriName);
        return this;
    }

    public PrivilegeRequestBuilder onStorageHandlerUri(String storageType, String storageUri) {
        Preconditions.checkState((this.authorizable_ == null ? 1 : 0) != 0);
        this.authorizable_ = this.authzFactory_.newStorageHandlerUri(storageType, storageUri);
        return this;
    }

    public static boolean isViewCreatedByNonSuperuser(FeTable table) {
        if (!(table instanceof View) && !(table instanceof LocalView) || RuntimeEnv.INSTANCE.isTestEnv()) {
            return false;
        }
        Table view = table.getMetaStoreTable();
        Preconditions.checkNotNull((Object)view);
        Map parameters = view.getParameters();
        return parameters != null && parameters.get("Authorized") != null && ((String)parameters.get("Authorized")).equalsIgnoreCase("false");
    }

    public PrivilegeRequestBuilder onTable(FeTable table) {
        Preconditions.checkNotNull((Object)table);
        String dbName = (String)Preconditions.checkNotNull((Object)table.getTableName().getDb());
        String tblName = (String)Preconditions.checkNotNull((Object)table.getTableName().getTbl());
        return this.onTable(dbName, tblName, table.getOwnerUser());
    }

    public PrivilegeRequestBuilder onTable(String dbName, String tableName, String ownerUser) {
        Preconditions.checkState((this.authorizable_ == null ? 1 : 0) != 0);
        this.authorizable_ = this.authzFactory_.newTable(dbName.toLowerCase(), tableName.toLowerCase(), ownerUser);
        return this;
    }

    public PrivilegeRequestBuilder onTableUnknownOwner(String dbName, String tableName) {
        return this.onTable(dbName, tableName, null);
    }

    public PrivilegeRequestBuilder onServer(String serverName) {
        Preconditions.checkState((this.authorizable_ == null ? 1 : 0) != 0);
        this.authorizable_ = this.authzFactory_.newServer(serverName);
        return this;
    }

    public PrivilegeRequestBuilder onDb(FeDb db) {
        Preconditions.checkState((this.authorizable_ == null ? 1 : 0) != 0);
        Preconditions.checkNotNull((Object)db);
        return this.onDb(db.getName(), db.getMetaStoreDb().getOwnerName());
    }

    public PrivilegeRequestBuilder onDb(String dbName, String ownerUser) {
        Preconditions.checkState((this.authorizable_ == null ? 1 : 0) != 0);
        this.authorizable_ = this.authzFactory_.newDatabase(dbName, ownerUser);
        return this;
    }

    public PrivilegeRequestBuilder onColumn(String dbName, String tableName, String columnName, String tblOwnerUser) {
        Preconditions.checkState((this.authorizable_ == null ? 1 : 0) != 0);
        this.authorizable_ = this.authzFactory_.newColumnInTable(dbName, tableName, columnName, tblOwnerUser);
        return this;
    }

    public PrivilegeRequestBuilder onAnyColumn(String dbName, String tableName, String tblOwnerUser) {
        Preconditions.checkState((this.authorizable_ == null ? 1 : 0) != 0);
        this.authorizable_ = this.authzFactory_.newColumnInTable(dbName, tableName, tblOwnerUser);
        return this;
    }

    public PrivilegeRequestBuilder onAnyColumn(String dbName, String dbOwnerUser) {
        Preconditions.checkState((this.authorizable_ == null ? 1 : 0) != 0);
        this.authorizable_ = this.authzFactory_.newColumnAllTbls(dbName, dbOwnerUser);
        return this;
    }

    public PrivilegeRequestBuilder allOf(Privilege privilege) {
        this.privilege_ = privilege;
        return this;
    }

    public PrivilegeRequestBuilder anyOf(EnumSet<Privilege> privileges) {
        this.privilegeSet_ = privileges;
        return this;
    }

    public PrivilegeRequestBuilder all() {
        this.privilege_ = Privilege.ALL;
        return this;
    }

    public PrivilegeRequestBuilder rwstorage() {
        this.privilege_ = Privilege.RWSTORAGE;
        return this;
    }

    public PrivilegeRequestBuilder any() {
        this.privilege_ = Privilege.ANY;
        return this;
    }

    public PrivilegeRequestBuilder grantOption() {
        this.grantOption_ = true;
        return this;
    }

    public PrivilegeRequest build() {
        Preconditions.checkNotNull((Object)this.authorizable_);
        Preconditions.checkNotNull((Object)((Object)this.privilege_));
        return new PrivilegeRequest(this.authorizable_, this.privilege_, this.grantOption_);
    }

    public Set<PrivilegeRequest> buildSet() {
        Preconditions.checkNotNull((Object)this.authorizable_);
        Preconditions.checkNotNull(this.privilegeSet_);
        HashSet privileges = Sets.newHashSet();
        for (Privilege p : this.privilegeSet_) {
            privileges.add(new PrivilegeRequest(this.authorizable_, p, this.grantOption_));
        }
        return privileges;
    }
}

