/*
 * Decompiled with CFR 0.152.
 */
package org.apache.impala.authorization;

import com.google.common.base.Preconditions;
import java.util.Objects;
import org.apache.impala.authorization.Authorizable;
import org.apache.impala.authorization.Privilege;

public class PrivilegeRequest {
    private final Authorizable authorizable_;
    private final Privilege privilege_;
    private final boolean grantOption_;

    PrivilegeRequest(Authorizable authorizable, Privilege privilege, boolean grantOption) {
        Preconditions.checkNotNull((Object)authorizable);
        Preconditions.checkNotNull((Object)((Object)privilege));
        this.authorizable_ = authorizable;
        this.privilege_ = privilege;
        this.grantOption_ = grantOption;
    }

    public String getName() {
        return this.authorizable_.getName();
    }

    public Privilege getPrivilege() {
        return this.privilege_;
    }

    public Authorizable getAuthorizable() {
        return this.authorizable_;
    }

    public boolean hasGrantOption() {
        return this.grantOption_;
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.authorizable_, this.privilege_, this.grantOption_});
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        PrivilegeRequest that = (PrivilegeRequest)o;
        return this.grantOption_ == that.grantOption_ && Objects.equals(this.authorizable_, that.authorizable_) && this.privilege_ == that.privilege_;
    }
}

