/*
 * Decompiled with CFR 0.152.
 */
package org.apache.impala.authorization;

import com.google.common.base.Preconditions;
import java.util.EnumSet;
import org.apache.impala.service.BackendConfig;

public enum Privilege {
    SELECT,
    INSERT,
    REFRESH,
    ALTER,
    DROP,
    CREATE,
    ALL,
    RWSTORAGE,
    OWNER,
    VIEW_METADATA(true),
    ANY(true);

    private EnumSet<Privilege> implied_;
    private final boolean anyOf_;

    private Privilege() {
        this.anyOf_ = false;
    }

    private Privilege(boolean anyOf) {
        this.anyOf_ = anyOf;
    }

    public boolean hasAnyOf() {
        return this.anyOf_;
    }

    public EnumSet<Privilege> getImpliedPrivileges() {
        return this.implied_;
    }

    public boolean impliesUpdate() {
        boolean considerCatalogCacheOp = !BackendConfig.INSTANCE.allowCatalogCacheOpFromMaskedUsers();
        return this == ALTER || this == DROP || this == CREATE || this == INSERT || this == REFRESH && considerCatalogCacheOp || this == ALL;
    }

    static {
        Privilege.ALL.implied_ = EnumSet.of(ALL);
        Privilege.OWNER.implied_ = EnumSet.of(OWNER);
        Privilege.ALTER.implied_ = EnumSet.of(ALTER);
        Privilege.DROP.implied_ = EnumSet.of(DROP);
        Privilege.CREATE.implied_ = EnumSet.of(CREATE);
        Privilege.INSERT.implied_ = EnumSet.of(INSERT);
        Privilege.SELECT.implied_ = EnumSet.of(SELECT);
        Privilege.REFRESH.implied_ = EnumSet.of(REFRESH);
        Privilege.RWSTORAGE.implied_ = EnumSet.of(RWSTORAGE);
        Privilege.VIEW_METADATA.implied_ = EnumSet.of(INSERT, SELECT, REFRESH);
        Privilege.ANY.implied_ = EnumSet.of(ALL, new Privilege[]{OWNER, ALTER, DROP, CREATE, INSERT, SELECT, REFRESH});
        for (Privilege privilege : Privilege.values()) {
            Preconditions.checkNotNull(privilege.implied_);
        }
    }
}

