/*
 * Decompiled with CFR 0.152.
 */
package org.apache.impala.authorization;

import com.google.common.base.Preconditions;
import org.apache.impala.authorization.Authorizable;
import org.apache.impala.authorization.AuthorizableColumn;
import org.apache.impala.authorization.AuthorizableDb;
import org.apache.impala.authorization.AuthorizableFactory;
import org.apache.impala.authorization.AuthorizableFn;
import org.apache.impala.authorization.AuthorizableServer;
import org.apache.impala.authorization.AuthorizableStorageHandlerUri;
import org.apache.impala.authorization.AuthorizableTable;
import org.apache.impala.authorization.AuthorizableUri;

public class DefaultAuthorizableFactory
implements AuthorizableFactory {
    public static final String ALL = "*";

    @Override
    public Authorizable newServer(String serverName) {
        return new AuthorizableServer(serverName);
    }

    @Override
    public Authorizable newDatabase(String dbName, String ownerUser) {
        Preconditions.checkNotNull((Object)dbName);
        return new AuthorizableDb(dbName, ownerUser);
    }

    @Override
    public Authorizable newTable(String dbName, String tableName, String ownerUser) {
        Preconditions.checkNotNull((Object)dbName);
        Preconditions.checkNotNull((Object)tableName);
        return new AuthorizableTable(dbName, tableName, ownerUser);
    }

    @Override
    public Authorizable newColumnAllTbls(String dbName, String dbOwnerUser) {
        Preconditions.checkNotNull((Object)dbName);
        return new AuthorizableColumn(dbName, ALL, ALL, dbOwnerUser);
    }

    @Override
    public Authorizable newColumnInTable(String dbName, String tableName, String tblOwnerUser) {
        Preconditions.checkNotNull((Object)dbName);
        Preconditions.checkNotNull((Object)tableName);
        return new AuthorizableColumn(dbName, tableName, ALL, tblOwnerUser);
    }

    @Override
    public Authorizable newColumnInTable(String dbName, String tableName, String columnName, String tblOwnerUser) {
        Preconditions.checkNotNull((Object)dbName);
        Preconditions.checkNotNull((Object)tableName);
        Preconditions.checkNotNull((Object)columnName);
        return new AuthorizableColumn(dbName, tableName, columnName, tblOwnerUser);
    }

    @Override
    public Authorizable newUri(String uri) {
        Preconditions.checkNotNull((Object)uri);
        return new AuthorizableUri(uri);
    }

    @Override
    public Authorizable newFunction(String dbName, String fnName) {
        Preconditions.checkNotNull((Object)dbName);
        Preconditions.checkNotNull((Object)fnName);
        return new AuthorizableFn(dbName, fnName);
    }

    @Override
    public Authorizable newStorageHandlerUri(String storageType, String storageUri) {
        Preconditions.checkNotNull((Object)storageType);
        Preconditions.checkNotNull((Object)storageUri);
        return new AuthorizableStorageHandlerUri(storageType, storageUri);
    }
}

